<?php
global $service_url, $optician_id, $shops, $opticianService, $siteInfo, $siteId, $practitioners, $slots, $selected_shop;
require_once( __DIR__. '/common.php');
include_once(__DIR__."/my-optician-wsdl-service/MyOpticianWsdlService.php");
require_once(__DIR__."/my-optician-wsdl-service/GlobalLoader.php");
$current_step=4;
$appointment_slot = $_POST['hidden_appointment_slot'];
$optician_id = $_POST['hidden_optician_id'];
$shop = $_POST['hidden_shop_name'];
$prefered_staff = $_POST['hidden_preferred_staff'];
$practitioner_name = $_POST['hidden_practitioner_name'];

$appointment_type = isset($_POST["appointment_type"]) ? $_POST["appointment_type"] : '';
$firstname = $_POST["firstname"];
$lastname = $_POST["lastname"];
$email = $_POST["email"];
$mobile_number = $_POST["mobile_number"];
$dob = $_POST["dob"];
$postcode = $_POST["postcode"];
$existing_patient = isset($_POST["existing_patient"]) ? 1 : 0;
$comments = $_POST["comments"];
// Split the appointment details
list($date, $startTime, $endTime) = explode(" ", $appointment_slot);

$dateObj = DateTime::createFromFormat('d/m/Y', $date);
$startTimeObj = DateTime::createFromFormat('d/m/Y H:i', $date . ' ' . $startTime);
$endTimeObj = DateTime::createFromFormat('d/m/Y H:i', $date . ' ' . $endTime);

$appointmentDetails = new AppointmentDetails();
$appointmentDetails->setAppointmentType(isset($appointment_type) ? $appointment_type : '');
$appointmentDetails->setName(isset($firstname, $lastname) ? $firstname . ' ' . $lastname : '');
$appointmentDetails->setExisting(isset($existing_patient) ? $existing_patient : '');
$appointmentDetails->setEmail(isset($email) ? $email : '');
$appointmentDetails->setDob(isset($dob) ? $dob : '');
$appointmentDetails->setPhone(isset($mobile_number) ? $mobile_number : '');
$appointmentDetails->setPostcode(isset($postcode) ? $postcode : '');
$appointmentDetails->setComments(isset($comments) ? $comments : '');
if($prefered_staff=="YES")
	$appointmentDetails->setPractitioner(isset($practitioner_name) ? $practitioner_name : '');

$opticianService = new MyOpticianWsdlService($service_url, $optician_id);
$siteInfo = $opticianService->getSiteInfo($optician_id, $password);

$globalLoader = new GlobalLoader($optician_id);
$globalLoader->loadGlobalSelectedShop($siteInfo->getSite(), $siteInfo->getPassword(), $siteInfo);

$appointment_result = $opticianService->postNewAppointment($siteInfo->getSite(), $appointment_slot, $appointmentDetails, $shop, $siteInfo);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, maximum-scale=1, initial-scale=1, user-scalable=0">
    <meta name="keywords" content="">
    <meta name="description" content="">
    <meta name="author" content="">
    <title>myoptician</title>
    <!--Favicon -->
    <link rel="shortcut icon" type="image/png" href="images/favicon-icon.png" />
   
    <!--Main Stylesheet-->
    <link rel="stylesheet" type="text/css" href="css/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <link rel="stylesheet" type="text/css" href="css/responsive.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
</head>

<body>
<?php include_once(__DIR__ . '/header.php'); ?>
<?php if($appointment_result) : ?>
	<div class="success">
		<div class="sitecontainer">
				<div class="successinner">
					 <h5>Your appointment booking is complete.</h5>
				</div>
		 	<div class="successbooking">
				<div class="inner-confirmation-details">
					<div class="item itemlogo">
						<img src="<?= $siteInfo->getOpticianLogo() ?>" alt="">
					</div>
					<div class="box">
						<h6>Your Appointment</h6>
						<div class="item">
						<h4>Your Appointment Details</h4>
						<p><?= $dateObj->format('l, F j, Y') ?><br><span><?= $startTimeObj->format('g:i A') ?> - <?= $endTimeObj->format('g:i A') ?></span> </p>
						</div>
						<div class="item">
							<b><?= isset($selected_shop) ? $selected_shop->getName() : '' ?></b>
							<br><?= isset($selected_shop) ? $selected_shop->getAddress() : '' ?>
							<br><span><?= isset($selected_shop) ? $selected_shop->getPhone() : '' ?></span></br>
						<!-- <p>Unit 3 Calthorpe Grn, Acle, Norwich NR13 3QL<br><span>01493 234381</span></p> -->
						</div>
						<div class="item">
							<?php if(isset($practitioner_name) && !empty($practitioner_name)): ?>
								<br/><h4>Preferred Optician</h4>
								<span><?=  $practitioner_name  ?></span></br>
							<?php else: ?>
								<br/><h4>Optician</h4>
								<span><?=  'No preference'  ?></span></br>
							<?php endif ?>
						</div>
					</div>
				 </div>
			</div>
		</div>
	</div>
<?php else : ?>
	<div class="failure">
		<div class="sitecontainer">
			<div class="failureinner">
				<h5>
					Sorry! We could not complete you appointment booking. <br>
					Please try again later...
				</h5>
			</div>
			<div class="failurebooking">
				<div class="inner-confirmation-details">
					<div class="item">
					<img src="<?= $siteInfo->getOpticianLogo() ?>" alt="">
					</div>
					<div class="box">
						<h6>Your Appointment</h6>
						<div class="item">
						<h4>Your Appointment Details</h4>
						<p><?= $dateObj->format('l, F j, Y') ?><br><span><?= $startTimeObj->format('g:i A') ?> - <?= $endTimeObj->format('g:i A') ?></span> </p>
						</div>
						<div class="item">
							<b><?= isset($selected_shop) ? $selected_shop->getName() : '' ?></b>
							<br><?= isset($selected_shop) ? $selected_shop->getAddress() : '' ?>
							<br><span><?= isset($selected_shop) ? $selected_shop->getPhone() : '' ?></span></br>
						<!-- <p>Unit 3 Calthorpe Grn, Acle, Norwich NR13 3QL<br><span>01493 234381</span></p> -->
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php endif; ?>

	<script src="js/jquery-3.6.4.min.js"></script>
	<script src="js/bootstrap.min.js"></script>

<?php include_once(__DIR__ . '/footer.php'); ?>
</body>
</html>



