<?php
include_once __DIR__ . '/../models/UserModel.php';

class SessionManagementService {
    public function __construct() {
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
    }

    public function login($userModel) {
        //TODO: store usermodel in session to get the details in further pages
        $_SESSION['username'] = $userModel->getUsername();
        $_SESSION['password'] = $userModel->getPassword();
        $this->setUserModel($userModel);
    }

    public function getUserModel() {
        return isset($_SESSION['usermodel']) ? unserialize($_SESSION['usermodel']) : null;
    }

    public function setUserModel($userModel){
        $_SESSION['usermodel'] = serialize($userModel);
    }

    public function logout() {
        session_unset();
        session_destroy();
    }

    public function isLoggedIn() {
        return isset($_SESSION['username']);
    }

    public function getUsername() {
        return $_SESSION['username'] ?? null;
    }
}
?>
