//! moment.js
//! version : 2.14.1
//! authors : Tim Wood, Iskren Chernev, Moment.js contributors
//! license : MIT
//! momentjs.com
!function(a,b){"object"==typeof exports&&"undefined"!=typeof module?module.exports=b():"function"==typeof define&&define.amd?define(b):a.moment=b()}(this,function(){"use strict";function a(){return je.apply(null,arguments)}
// This is done to register the method called with moment()
// without creating circular dependencies.
function b(a){je=a}function c(a){return a instanceof Array||"[object Array]"===Object.prototype.toString.call(a)}function d(a){return"[object Object]"===Object.prototype.toString.call(a)}function e(a){var b;for(b in a)
// even if its not own property I'd still call it non-empty
return!1;return!0}function f(a){return a instanceof Date||"[object Date]"===Object.prototype.toString.call(a)}function g(a,b){var c,d=[];for(c=0;c<a.length;++c)d.push(b(a[c],c));return d}function h(a,b){return Object.prototype.hasOwnProperty.call(a,b)}function i(a,b){for(var c in b)h(b,c)&&(a[c]=b[c]);return h(b,"toString")&&(a.toString=b.toString),h(b,"valueOf")&&(a.valueOf=b.valueOf),a}function j(a,b,c,d){return qb(a,b,c,d,!0).utc()}function k(){
// We need to deep clone this object.
return{empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],meridiem:null}}function l(a){return null==a._pf&&(a._pf=k()),a._pf}function m(a){if(null==a._isValid){var b=l(a),c=ke.call(b.parsedDateParts,function(a){return null!=a});a._isValid=!isNaN(a._d.getTime())&&b.overflow<0&&!b.empty&&!b.invalidMonth&&!b.invalidWeekday&&!b.nullInput&&!b.invalidFormat&&!b.userInvalidated&&(!b.meridiem||b.meridiem&&c),a._strict&&(a._isValid=a._isValid&&0===b.charsLeftOver&&0===b.unusedTokens.length&&void 0===b.bigHour)}return a._isValid}function n(a){var b=j(NaN);return null!=a?i(l(b),a):l(b).userInvalidated=!0,b}function o(a){return void 0===a}function p(a,b){var c,d,e;if(o(b._isAMomentObject)||(a._isAMomentObject=b._isAMomentObject),o(b._i)||(a._i=b._i),o(b._f)||(a._f=b._f),o(b._l)||(a._l=b._l),o(b._strict)||(a._strict=b._strict),o(b._tzm)||(a._tzm=b._tzm),o(b._isUTC)||(a._isUTC=b._isUTC),o(b._offset)||(a._offset=b._offset),o(b._pf)||(a._pf=l(b)),o(b._locale)||(a._locale=b._locale),le.length>0)for(c in le)d=le[c],e=b[d],o(e)||(a[d]=e);return a}
// Moment prototype object
function q(b){p(this,b),this._d=new Date(null!=b._d?b._d.getTime():NaN),me===!1&&(me=!0,a.updateOffset(this),me=!1)}function r(a){return a instanceof q||null!=a&&null!=a._isAMomentObject}function s(a){return 0>a?Math.ceil(a)||0:Math.floor(a)}function t(a){var b=+a,c=0;return 0!==b&&isFinite(b)&&(c=s(b)),c}
// compare two arrays, return the number of differences
function u(a,b,c){var d,e=Math.min(a.length,b.length),f=Math.abs(a.length-b.length),g=0;for(d=0;e>d;d++)(c&&a[d]!==b[d]||!c&&t(a[d])!==t(b[d]))&&g++;return g+f}function v(b){a.suppressDeprecationWarnings===!1&&"undefined"!=typeof console&&console.warn&&console.warn("Deprecation warning: "+b)}function w(b,c){var d=!0;return i(function(){return null!=a.deprecationHandler&&a.deprecationHandler(null,b),d&&(v(b+"\nArguments: "+Array.prototype.slice.call(arguments).join(", ")+"\n"+(new Error).stack),d=!1),c.apply(this,arguments)},c)}function x(b,c){null!=a.deprecationHandler&&a.deprecationHandler(b,c),ne[b]||(v(c),ne[b]=!0)}function y(a){return a instanceof Function||"[object Function]"===Object.prototype.toString.call(a)}function z(a){var b,c;for(c in a)b=a[c],y(b)?this[c]=b:this["_"+c]=b;this._config=a,
// Lenient ordinal parsing accepts just a number in addition to
// number + (possibly) stuff coming from _ordinalParseLenient.
this._ordinalParseLenient=new RegExp(this._ordinalParse.source+"|"+/\d{1,2}/.source)}function A(a,b){var c,e=i({},a);for(c in b)h(b,c)&&(d(a[c])&&d(b[c])?(e[c]={},i(e[c],a[c]),i(e[c],b[c])):null!=b[c]?e[c]=b[c]:delete e[c]);for(c in a)h(a,c)&&!h(b,c)&&d(a[c])&&(
// make sure changes to properties don't modify parent config
e[c]=i({},e[c]));return e}function B(a){null!=a&&this.set(a)}function C(a,b,c){var d=this._calendar[a]||this._calendar.sameElse;return y(d)?d.call(b,c):d}function D(a){var b=this._longDateFormat[a],c=this._longDateFormat[a.toUpperCase()];return b||!c?b:(this._longDateFormat[a]=c.replace(/MMMM|MM|DD|dddd/g,function(a){return a.slice(1)}),this._longDateFormat[a])}function E(){return this._invalidDate}function F(a){return this._ordinal.replace("%d",a)}function G(a,b,c,d){var e=this._relativeTime[c];return y(e)?e(a,b,c,d):e.replace(/%d/i,a)}function H(a,b){var c=this._relativeTime[a>0?"future":"past"];return y(c)?c(b):c.replace(/%s/i,b)}function I(a,b){var c=a.toLowerCase();we[c]=we[c+"s"]=we[b]=a}function J(a){return"string"==typeof a?we[a]||we[a.toLowerCase()]:void 0}function K(a){var b,c,d={};for(c in a)h(a,c)&&(b=J(c),b&&(d[b]=a[c]));return d}function L(a,b){xe[a]=b}function M(a){var b=[];for(var c in a)b.push({unit:c,priority:xe[c]});return b.sort(function(a,b){return a.priority-b.priority}),b}function N(b,c){return function(d){return null!=d?(P(this,b,d),a.updateOffset(this,c),this):O(this,b)}}function O(a,b){return a.isValid()?a._d["get"+(a._isUTC?"UTC":"")+b]():NaN}function P(a,b,c){a.isValid()&&a._d["set"+(a._isUTC?"UTC":"")+b](c)}
// MOMENTS
function Q(a){return a=J(a),y(this[a])?this[a]():this}function R(a,b){if("object"==typeof a){a=K(a);for(var c=M(a),d=0;d<c.length;d++)this[c[d].unit](a[c[d].unit])}else if(a=J(a),y(this[a]))return this[a](b);return this}function S(a,b,c){var d=""+Math.abs(a),e=b-d.length,f=a>=0;return(f?c?"+":"":"-")+Math.pow(10,Math.max(0,e)).toString().substr(1)+d}
// token:    'M'
// padded:   ['MM', 2]
// ordinal:  'Mo'
// callback: function () { this.month() + 1 }
function T(a,b,c,d){var e=d;"string"==typeof d&&(e=function(){return this[d]()}),a&&(Be[a]=e),b&&(Be[b[0]]=function(){return S(e.apply(this,arguments),b[1],b[2])}),c&&(Be[c]=function(){return this.localeData().ordinal(e.apply(this,arguments),a)})}function U(a){return a.match(/\[[\s\S]/)?a.replace(/^\[|\]$/g,""):a.replace(/\\/g,"")}function V(a){var b,c,d=a.match(ye);for(b=0,c=d.length;c>b;b++)Be[d[b]]?d[b]=Be[d[b]]:d[b]=U(d[b]);return function(b){var e,f="";for(e=0;c>e;e++)f+=d[e]instanceof Function?d[e].call(b,a):d[e];return f}}
// format date using native date object
function W(a,b){return a.isValid()?(b=X(b,a.localeData()),Ae[b]=Ae[b]||V(b),Ae[b](a)):a.localeData().invalidDate()}function X(a,b){function c(a){return b.longDateFormat(a)||a}var d=5;for(ze.lastIndex=0;d>=0&&ze.test(a);)a=a.replace(ze,c),ze.lastIndex=0,d-=1;return a}function Y(a,b,c){Te[a]=y(b)?b:function(a,d){return a&&c?c:b}}function Z(a,b){return h(Te,a)?Te[a](b._strict,b._locale):new RegExp($(a))}
// Code from http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript
function $(a){return _(a.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(a,b,c,d,e){return b||c||d||e}))}function _(a){return a.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}function aa(a,b){var c,d=b;for("string"==typeof a&&(a=[a]),"number"==typeof b&&(d=function(a,c){c[b]=t(a)}),c=0;c<a.length;c++)Ue[a[c]]=d}function ba(a,b){aa(a,function(a,c,d,e){d._w=d._w||{},b(a,d._w,d,e)})}function ca(a,b,c){null!=b&&h(Ue,a)&&Ue[a](b,c._a,c,a)}function da(a,b){return new Date(Date.UTC(a,b+1,0)).getUTCDate()}function ea(a,b){return c(this._months)?this._months[a.month()]:this._months[(this._months.isFormat||cf).test(b)?"format":"standalone"][a.month()]}function fa(a,b){return c(this._monthsShort)?this._monthsShort[a.month()]:this._monthsShort[cf.test(b)?"format":"standalone"][a.month()]}function ga(a,b,c){var d,e,f,g=a.toLocaleLowerCase();if(!this._monthsParse)for(
// this is not used
this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],d=0;12>d;++d)f=j([2e3,d]),this._shortMonthsParse[d]=this.monthsShort(f,"").toLocaleLowerCase(),this._longMonthsParse[d]=this.months(f,"").toLocaleLowerCase();return c?"MMM"===b?(e=pe.call(this._shortMonthsParse,g),-1!==e?e:null):(e=pe.call(this._longMonthsParse,g),-1!==e?e:null):"MMM"===b?(e=pe.call(this._shortMonthsParse,g),-1!==e?e:(e=pe.call(this._longMonthsParse,g),-1!==e?e:null)):(e=pe.call(this._longMonthsParse,g),-1!==e?e:(e=pe.call(this._shortMonthsParse,g),-1!==e?e:null))}function ha(a,b,c){var d,e,f;if(this._monthsParseExact)return ga.call(this,a,b,c);
// TODO: add sorting
// Sorting makes sure if one month (or abbr) is a prefix of another
// see sorting in computeMonthsParse
for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),d=0;12>d;d++){
// test the regex
if(e=j([2e3,d]),c&&!this._longMonthsParse[d]&&(this._longMonthsParse[d]=new RegExp("^"+this.months(e,"").replace(".","")+"$","i"),this._shortMonthsParse[d]=new RegExp("^"+this.monthsShort(e,"").replace(".","")+"$","i")),c||this._monthsParse[d]||(f="^"+this.months(e,"")+"|^"+this.monthsShort(e,""),this._monthsParse[d]=new RegExp(f.replace(".",""),"i")),c&&"MMMM"===b&&this._longMonthsParse[d].test(a))return d;if(c&&"MMM"===b&&this._shortMonthsParse[d].test(a))return d;if(!c&&this._monthsParse[d].test(a))return d}}
// MOMENTS
function ia(a,b){var c;if(!a.isValid())
// No op
return a;if("string"==typeof b)if(/^\d+$/.test(b))b=t(b);else
// TODO: Another silent failure?
if(b=a.localeData().monthsParse(b),"number"!=typeof b)return a;return c=Math.min(a.date(),da(a.year(),b)),a._d["set"+(a._isUTC?"UTC":"")+"Month"](b,c),a}function ja(b){return null!=b?(ia(this,b),a.updateOffset(this,!0),this):O(this,"Month")}function ka(){return da(this.year(),this.month())}function la(a){return this._monthsParseExact?(h(this,"_monthsRegex")||na.call(this),a?this._monthsShortStrictRegex:this._monthsShortRegex):(h(this,"_monthsShortRegex")||(this._monthsShortRegex=ff),this._monthsShortStrictRegex&&a?this._monthsShortStrictRegex:this._monthsShortRegex)}function ma(a){return this._monthsParseExact?(h(this,"_monthsRegex")||na.call(this),a?this._monthsStrictRegex:this._monthsRegex):(h(this,"_monthsRegex")||(this._monthsRegex=gf),this._monthsStrictRegex&&a?this._monthsStrictRegex:this._monthsRegex)}function na(){function a(a,b){return b.length-a.length}var b,c,d=[],e=[],f=[];for(b=0;12>b;b++)c=j([2e3,b]),d.push(this.monthsShort(c,"")),e.push(this.months(c,"")),f.push(this.months(c,"")),f.push(this.monthsShort(c,""));for(
// Sorting makes sure if one month (or abbr) is a prefix of another it
// will match the longer piece.
d.sort(a),e.sort(a),f.sort(a),b=0;12>b;b++)d[b]=_(d[b]),e[b]=_(e[b]);for(b=0;24>b;b++)f[b]=_(f[b]);this._monthsRegex=new RegExp("^("+f.join("|")+")","i"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp("^("+e.join("|")+")","i"),this._monthsShortStrictRegex=new RegExp("^("+d.join("|")+")","i")}
// HELPERS
function oa(a){return pa(a)?366:365}function pa(a){return a%4===0&&a%100!==0||a%400===0}function qa(){return pa(this.year())}function ra(a,b,c,d,e,f,g){
//can't just apply() to create a date:
//http://stackoverflow.com/questions/181348/instantiating-a-javascript-object-by-calling-prototype-constructor-apply
var h=new Date(a,b,c,d,e,f,g);
//the date constructor remaps years 0-99 to 1900-1999
return 100>a&&a>=0&&isFinite(h.getFullYear())&&h.setFullYear(a),h}function sa(a){var b=new Date(Date.UTC.apply(null,arguments));
//the Date.UTC function remaps years 0-99 to 1900-1999
return 100>a&&a>=0&&isFinite(b.getUTCFullYear())&&b.setUTCFullYear(a),b}
// start-of-first-week - start-of-year
function ta(a,b,c){var// first-week day -- which january is always in the first week (4 for iso, 1 for other)
d=7+b-c,
// first-week day local weekday -- which local weekday is fwd
e=(7+sa(a,0,d).getUTCDay()-b)%7;return-e+d-1}
//http://en.wikipedia.org/wiki/ISO_week_date#Calculating_a_date_given_the_year.2C_week_number_and_weekday
function ua(a,b,c,d,e){var f,g,h=(7+c-d)%7,i=ta(a,d,e),j=1+7*(b-1)+h+i;return 0>=j?(f=a-1,g=oa(f)+j):j>oa(a)?(f=a+1,g=j-oa(a)):(f=a,g=j),{year:f,dayOfYear:g}}function va(a,b,c){var d,e,f=ta(a.year(),b,c),g=Math.floor((a.dayOfYear()-f-1)/7)+1;return 1>g?(e=a.year()-1,d=g+wa(e,b,c)):g>wa(a.year(),b,c)?(d=g-wa(a.year(),b,c),e=a.year()+1):(e=a.year(),d=g),{week:d,year:e}}function wa(a,b,c){var d=ta(a,b,c),e=ta(a+1,b,c);return(oa(a)-d+e)/7}
// HELPERS
// LOCALES
function xa(a){return va(a,this._week.dow,this._week.doy).week}function ya(){return this._week.dow}function za(){return this._week.doy}
// MOMENTS
function Aa(a){var b=this.localeData().week(this);return null==a?b:this.add(7*(a-b),"d")}function Ba(a){var b=va(this,1,4).week;return null==a?b:this.add(7*(a-b),"d")}
// HELPERS
function Ca(a,b){return"string"!=typeof a?a:isNaN(a)?(a=b.weekdaysParse(a),"number"==typeof a?a:null):parseInt(a,10)}function Da(a,b){return"string"==typeof a?b.weekdaysParse(a)%7||7:isNaN(a)?null:a}function Ea(a,b){return c(this._weekdays)?this._weekdays[a.day()]:this._weekdays[this._weekdays.isFormat.test(b)?"format":"standalone"][a.day()]}function Fa(a){return this._weekdaysShort[a.day()]}function Ga(a){return this._weekdaysMin[a.day()]}function Ha(a,b,c){var d,e,f,g=a.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],d=0;7>d;++d)f=j([2e3,1]).day(d),this._minWeekdaysParse[d]=this.weekdaysMin(f,"").toLocaleLowerCase(),this._shortWeekdaysParse[d]=this.weekdaysShort(f,"").toLocaleLowerCase(),this._weekdaysParse[d]=this.weekdays(f,"").toLocaleLowerCase();return c?"dddd"===b?(e=pe.call(this._weekdaysParse,g),-1!==e?e:null):"ddd"===b?(e=pe.call(this._shortWeekdaysParse,g),-1!==e?e:null):(e=pe.call(this._minWeekdaysParse,g),-1!==e?e:null):"dddd"===b?(e=pe.call(this._weekdaysParse,g),-1!==e?e:(e=pe.call(this._shortWeekdaysParse,g),-1!==e?e:(e=pe.call(this._minWeekdaysParse,g),-1!==e?e:null))):"ddd"===b?(e=pe.call(this._shortWeekdaysParse,g),-1!==e?e:(e=pe.call(this._weekdaysParse,g),-1!==e?e:(e=pe.call(this._minWeekdaysParse,g),-1!==e?e:null))):(e=pe.call(this._minWeekdaysParse,g),-1!==e?e:(e=pe.call(this._weekdaysParse,g),-1!==e?e:(e=pe.call(this._shortWeekdaysParse,g),-1!==e?e:null)))}function Ia(a,b,c){var d,e,f;if(this._weekdaysParseExact)return Ha.call(this,a,b,c);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),d=0;7>d;d++){
// test the regex
if(e=j([2e3,1]).day(d),c&&!this._fullWeekdaysParse[d]&&(this._fullWeekdaysParse[d]=new RegExp("^"+this.weekdays(e,"").replace(".",".?")+"$","i"),this._shortWeekdaysParse[d]=new RegExp("^"+this.weekdaysShort(e,"").replace(".",".?")+"$","i"),this._minWeekdaysParse[d]=new RegExp("^"+this.weekdaysMin(e,"").replace(".",".?")+"$","i")),this._weekdaysParse[d]||(f="^"+this.weekdays(e,"")+"|^"+this.weekdaysShort(e,"")+"|^"+this.weekdaysMin(e,""),this._weekdaysParse[d]=new RegExp(f.replace(".",""),"i")),c&&"dddd"===b&&this._fullWeekdaysParse[d].test(a))return d;if(c&&"ddd"===b&&this._shortWeekdaysParse[d].test(a))return d;if(c&&"dd"===b&&this._minWeekdaysParse[d].test(a))return d;if(!c&&this._weekdaysParse[d].test(a))return d}}
// MOMENTS
function Ja(a){if(!this.isValid())return null!=a?this:NaN;var b=this._isUTC?this._d.getUTCDay():this._d.getDay();return null!=a?(a=Ca(a,this.localeData()),this.add(a-b,"d")):b}function Ka(a){if(!this.isValid())return null!=a?this:NaN;var b=(this.day()+7-this.localeData()._week.dow)%7;return null==a?b:this.add(a-b,"d")}function La(a){if(!this.isValid())return null!=a?this:NaN;
// behaves the same as moment#day except
// as a getter, returns 7 instead of 0 (1-7 range instead of 0-6)
// as a setter, sunday should belong to the previous week.
if(null!=a){var b=Da(a,this.localeData());return this.day(this.day()%7?b:b-7)}return this.day()||7}function Ma(a){return this._weekdaysParseExact?(h(this,"_weekdaysRegex")||Pa.call(this),a?this._weekdaysStrictRegex:this._weekdaysRegex):(h(this,"_weekdaysRegex")||(this._weekdaysRegex=nf),this._weekdaysStrictRegex&&a?this._weekdaysStrictRegex:this._weekdaysRegex)}function Na(a){return this._weekdaysParseExact?(h(this,"_weekdaysRegex")||Pa.call(this),a?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(h(this,"_weekdaysShortRegex")||(this._weekdaysShortRegex=of),this._weekdaysShortStrictRegex&&a?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)}function Oa(a){return this._weekdaysParseExact?(h(this,"_weekdaysRegex")||Pa.call(this),a?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(h(this,"_weekdaysMinRegex")||(this._weekdaysMinRegex=pf),this._weekdaysMinStrictRegex&&a?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)}function Pa(){function a(a,b){return b.length-a.length}var b,c,d,e,f,g=[],h=[],i=[],k=[];for(b=0;7>b;b++)c=j([2e3,1]).day(b),d=this.weekdaysMin(c,""),e=this.weekdaysShort(c,""),f=this.weekdays(c,""),g.push(d),h.push(e),i.push(f),k.push(d),k.push(e),k.push(f);for(
// Sorting makes sure if one weekday (or abbr) is a prefix of another it
// will match the longer piece.
g.sort(a),h.sort(a),i.sort(a),k.sort(a),b=0;7>b;b++)h[b]=_(h[b]),i[b]=_(i[b]),k[b]=_(k[b]);this._weekdaysRegex=new RegExp("^("+k.join("|")+")","i"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp("^("+i.join("|")+")","i"),this._weekdaysShortStrictRegex=new RegExp("^("+h.join("|")+")","i"),this._weekdaysMinStrictRegex=new RegExp("^("+g.join("|")+")","i")}
// FORMATTING
function Qa(){return this.hours()%12||12}function Ra(){return this.hours()||24}function Sa(a,b){T(a,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),b)})}
// PARSING
function Ta(a,b){return b._meridiemParse}
// LOCALES
function Ua(a){
// IE8 Quirks Mode & IE7 Standards Mode do not allow accessing strings like arrays
// Using charAt should be more compatible.
return"p"===(a+"").toLowerCase().charAt(0)}function Va(a,b,c){return a>11?c?"pm":"PM":c?"am":"AM"}function Wa(a){return a?a.toLowerCase().replace("_","-"):a}
// pick the locale from the array
// try ['en-au', 'en-gb'] as 'en-au', 'en-gb', 'en', as in move through the list trying each
// substring from most specific to least, but move to the next array item if it's a more specific variant than the current root
function Xa(a){for(var b,c,d,e,f=0;f<a.length;){for(e=Wa(a[f]).split("-"),b=e.length,c=Wa(a[f+1]),c=c?c.split("-"):null;b>0;){if(d=Ya(e.slice(0,b).join("-")))return d;if(c&&c.length>=b&&u(e,c,!0)>=b-1)
//the next array item is better than a shallower substring of this one
break;b--}f++}return null}function Ya(a){var b=null;
// TODO: Find a better way to register and load all the locales in Node
if(!uf[a]&&"undefined"!=typeof module&&module&&module.exports)try{b=qf._abbr,require("./locale/"+a),
// because defineLocale currently also sets the global locale, we
// want to undo that for lazy loaded locales
Za(b)}catch(c){}return uf[a]}
// This function will load locale and then set the global locale.  If
// no arguments are passed in, it will simply return the current global
// locale key.
function Za(a,b){var c;
// moment.duration._locale = moment._locale = data;
return a&&(c=o(b)?ab(a):$a(a,b),c&&(qf=c)),qf._abbr}function $a(a,b){if(null!==b){var c=tf;
// treat as if there is no base config
// backwards compat for now: also set the locale
return b.abbr=a,null!=uf[a]?(x("defineLocaleOverride","use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."),c=uf[a]._config):null!=b.parentLocale&&(null!=uf[b.parentLocale]?c=uf[b.parentLocale]._config:x("parentLocaleUndefined","specified parentLocale is not defined yet. See http://momentjs.com/guides/#/warnings/parent-locale/")),uf[a]=new B(A(c,b)),Za(a),uf[a]}
// useful for testing
return delete uf[a],null}function _a(a,b){if(null!=b){var c,d=tf;
// MERGE
null!=uf[a]&&(d=uf[a]._config),b=A(d,b),c=new B(b),c.parentLocale=uf[a],uf[a]=c,
// backwards compat for now: also set the locale
Za(a)}else
// pass null for config to unupdate, useful for tests
null!=uf[a]&&(null!=uf[a].parentLocale?uf[a]=uf[a].parentLocale:null!=uf[a]&&delete uf[a]);return uf[a]}
// returns locale data
function ab(a){var b;if(a&&a._locale&&a._locale._abbr&&(a=a._locale._abbr),!a)return qf;if(!c(a)){if(b=Ya(a))return b;a=[a]}return Xa(a)}function bb(){return oe(uf)}function cb(a){var b,c=a._a;return c&&-2===l(a).overflow&&(b=c[We]<0||c[We]>11?We:c[Xe]<1||c[Xe]>da(c[Ve],c[We])?Xe:c[Ye]<0||c[Ye]>24||24===c[Ye]&&(0!==c[Ze]||0!==c[$e]||0!==c[_e])?Ye:c[Ze]<0||c[Ze]>59?Ze:c[$e]<0||c[$e]>59?$e:c[_e]<0||c[_e]>999?_e:-1,l(a)._overflowDayOfYear&&(Ve>b||b>Xe)&&(b=Xe),l(a)._overflowWeeks&&-1===b&&(b=af),l(a)._overflowWeekday&&-1===b&&(b=bf),l(a).overflow=b),a}
// date from iso format
function db(a){var b,c,d,e,f,g,h=a._i,i=vf.exec(h)||wf.exec(h);if(i){for(l(a).iso=!0,b=0,c=yf.length;c>b;b++)if(yf[b][1].exec(i[1])){e=yf[b][0],d=yf[b][2]!==!1;break}if(null==e)return void(a._isValid=!1);if(i[3]){for(b=0,c=zf.length;c>b;b++)if(zf[b][1].exec(i[3])){
// match[2] should be 'T' or space
f=(i[2]||" ")+zf[b][0];break}if(null==f)return void(a._isValid=!1)}if(!d&&null!=f)return void(a._isValid=!1);if(i[4]){if(!xf.exec(i[4]))return void(a._isValid=!1);g="Z"}a._f=e+(f||"")+(g||""),jb(a)}else a._isValid=!1}
// date from iso format or fallback
function eb(b){var c=Af.exec(b._i);return null!==c?void(b._d=new Date(+c[1])):(db(b),void(b._isValid===!1&&(delete b._isValid,a.createFromInputFallback(b))))}
// Pick the first defined of two or three arguments.
function fb(a,b,c){return null!=a?a:null!=b?b:c}function gb(b){
// hooks is actually the exported moment object
var c=new Date(a.now());return b._useUTC?[c.getUTCFullYear(),c.getUTCMonth(),c.getUTCDate()]:[c.getFullYear(),c.getMonth(),c.getDate()]}
// convert an array to a date.
// the array should mirror the parameters below
// note: all values past the year are optional and will default to the lowest possible value.
// [year, month, day , hour, minute, second, millisecond]
function hb(a){var b,c,d,e,f=[];if(!a._d){
// Default to current date.
// * if no year, month, day of month are given, default to today
// * if day of month is given, default month and year
// * if month is given, default only year
// * if year is given, don't default anything
for(d=gb(a),a._w&&null==a._a[Xe]&&null==a._a[We]&&ib(a),a._dayOfYear&&(e=fb(a._a[Ve],d[Ve]),a._dayOfYear>oa(e)&&(l(a)._overflowDayOfYear=!0),c=sa(e,0,a._dayOfYear),a._a[We]=c.getUTCMonth(),a._a[Xe]=c.getUTCDate()),b=0;3>b&&null==a._a[b];++b)a._a[b]=f[b]=d[b];
// Zero out whatever was not defaulted, including time
for(;7>b;b++)a._a[b]=f[b]=null==a._a[b]?2===b?1:0:a._a[b];
// Check for 24:00:00.000
24===a._a[Ye]&&0===a._a[Ze]&&0===a._a[$e]&&0===a._a[_e]&&(a._nextDay=!0,a._a[Ye]=0),a._d=(a._useUTC?sa:ra).apply(null,f),
// Apply timezone offset from input. The actual utcOffset can be changed
// with parseZone.
null!=a._tzm&&a._d.setUTCMinutes(a._d.getUTCMinutes()-a._tzm),a._nextDay&&(a._a[Ye]=24)}}function ib(a){var b,c,d,e,f,g,h,i;b=a._w,null!=b.GG||null!=b.W||null!=b.E?(f=1,g=4,c=fb(b.GG,a._a[Ve],va(rb(),1,4).year),d=fb(b.W,1),e=fb(b.E,1),(1>e||e>7)&&(i=!0)):(f=a._locale._week.dow,g=a._locale._week.doy,c=fb(b.gg,a._a[Ve],va(rb(),f,g).year),d=fb(b.w,1),null!=b.d?(e=b.d,(0>e||e>6)&&(i=!0)):null!=b.e?(e=b.e+f,(b.e<0||b.e>6)&&(i=!0)):e=f),1>d||d>wa(c,f,g)?l(a)._overflowWeeks=!0:null!=i?l(a)._overflowWeekday=!0:(h=ua(c,d,e,f,g),a._a[Ve]=h.year,a._dayOfYear=h.dayOfYear)}
// date from string and format string
function jb(b){
// TODO: Move this to another part of the creation flow to prevent circular deps
if(b._f===a.ISO_8601)return void db(b);b._a=[],l(b).empty=!0;
// This array is used to make a Date, either with `new Date` or `Date.UTC`
var c,d,e,f,g,h=""+b._i,i=h.length,j=0;for(e=X(b._f,b._locale).match(ye)||[],c=0;c<e.length;c++)f=e[c],d=(h.match(Z(f,b))||[])[0],d&&(g=h.substr(0,h.indexOf(d)),g.length>0&&l(b).unusedInput.push(g),h=h.slice(h.indexOf(d)+d.length),j+=d.length),Be[f]?(d?l(b).empty=!1:l(b).unusedTokens.push(f),ca(f,d,b)):b._strict&&!d&&l(b).unusedTokens.push(f);
// add remaining unparsed input length to the string
l(b).charsLeftOver=i-j,h.length>0&&l(b).unusedInput.push(h),
// clear _12h flag if hour is <= 12
b._a[Ye]<=12&&l(b).bigHour===!0&&b._a[Ye]>0&&(l(b).bigHour=void 0),l(b).parsedDateParts=b._a.slice(0),l(b).meridiem=b._meridiem,
// handle meridiem
b._a[Ye]=kb(b._locale,b._a[Ye],b._meridiem),hb(b),cb(b)}function kb(a,b,c){var d;
// Fallback
return null==c?b:null!=a.meridiemHour?a.meridiemHour(b,c):null!=a.isPM?(d=a.isPM(c),d&&12>b&&(b+=12),d||12!==b||(b=0),b):b}
// date from string and array of format strings
function lb(a){var b,c,d,e,f;if(0===a._f.length)return l(a).invalidFormat=!0,void(a._d=new Date(NaN));for(e=0;e<a._f.length;e++)f=0,b=p({},a),null!=a._useUTC&&(b._useUTC=a._useUTC),b._f=a._f[e],jb(b),m(b)&&(f+=l(b).charsLeftOver,f+=10*l(b).unusedTokens.length,l(b).score=f,(null==d||d>f)&&(d=f,c=b));i(a,c||b)}function mb(a){if(!a._d){var b=K(a._i);a._a=g([b.year,b.month,b.day||b.date,b.hour,b.minute,b.second,b.millisecond],function(a){return a&&parseInt(a,10)}),hb(a)}}function nb(a){var b=new q(cb(ob(a)));
// Adding is smart enough around DST
return b._nextDay&&(b.add(1,"d"),b._nextDay=void 0),b}function ob(a){var b=a._i,d=a._f;return a._locale=a._locale||ab(a._l),null===b||void 0===d&&""===b?n({nullInput:!0}):("string"==typeof b&&(a._i=b=a._locale.preparse(b)),r(b)?new q(cb(b)):(c(d)?lb(a):f(b)?a._d=b:d?jb(a):pb(a),m(a)||(a._d=null),a))}function pb(b){var d=b._i;void 0===d?b._d=new Date(a.now()):f(d)?b._d=new Date(d.valueOf()):"string"==typeof d?eb(b):c(d)?(b._a=g(d.slice(0),function(a){return parseInt(a,10)}),hb(b)):"object"==typeof d?mb(b):"number"==typeof d?
// from milliseconds
b._d=new Date(d):a.createFromInputFallback(b)}function qb(a,b,f,g,h){var i={};
// object construction must be done this way.
// https://github.com/moment/moment/issues/1423
return"boolean"==typeof f&&(g=f,f=void 0),(d(a)&&e(a)||c(a)&&0===a.length)&&(a=void 0),i._isAMomentObject=!0,i._useUTC=i._isUTC=h,i._l=f,i._i=a,i._f=b,i._strict=g,nb(i)}function rb(a,b,c,d){return qb(a,b,c,d,!1)}
// Pick a moment m from moments so that m[fn](other) is true for all
// other. This relies on the function fn to be transitive.
//
// moments should either be an array of moment objects or an array, whose
// first element is an array of moment objects.
function sb(a,b){var d,e;if(1===b.length&&c(b[0])&&(b=b[0]),!b.length)return rb();for(d=b[0],e=1;e<b.length;++e)b[e].isValid()&&!b[e][a](d)||(d=b[e]);return d}
// TODO: Use [].sort instead?
function tb(){var a=[].slice.call(arguments,0);return sb("isBefore",a)}function ub(){var a=[].slice.call(arguments,0);return sb("isAfter",a)}function vb(a){var b=K(a),c=b.year||0,d=b.quarter||0,e=b.month||0,f=b.week||0,g=b.day||0,h=b.hour||0,i=b.minute||0,j=b.second||0,k=b.millisecond||0;
// representation for dateAddRemove
this._milliseconds=+k+1e3*j+// 1000
6e4*i+// 1000 * 60
1e3*h*60*60,//using 1000 * 60 * 60 instead of 36e5 to avoid floating point rounding errors https://github.com/moment/moment/issues/2978
// Because of dateAddRemove treats 24 hours as different from a
// day when working around DST, we need to store them separately
this._days=+g+7*f,
// It is impossible translate months into days without knowing
// which months you are are talking about, so we have to store
// it separately.
this._months=+e+3*d+12*c,this._data={},this._locale=ab(),this._bubble()}function wb(a){return a instanceof vb}
// FORMATTING
function xb(a,b){T(a,0,0,function(){var a=this.utcOffset(),c="+";return 0>a&&(a=-a,c="-"),c+S(~~(a/60),2)+b+S(~~a%60,2)})}function yb(a,b){var c=(b||"").match(a)||[],d=c[c.length-1]||[],e=(d+"").match(Ef)||["-",0,0],f=+(60*e[1])+t(e[2]);return"+"===e[0]?f:-f}
// Return a moment from input, that is local/utc/zone equivalent to model.
function zb(b,c){var d,e;
// Use low-level api, because this fn is low-level api.
return c._isUTC?(d=c.clone(),e=(r(b)||f(b)?b.valueOf():rb(b).valueOf())-d.valueOf(),d._d.setTime(d._d.valueOf()+e),a.updateOffset(d,!1),d):rb(b).local()}function Ab(a){
// On Firefox.24 Date#getTimezoneOffset returns a floating point.
// https://github.com/moment/moment/pull/1871
return 15*-Math.round(a._d.getTimezoneOffset()/15)}
// MOMENTS
// keepLocalTime = true means only change the timezone, without
// affecting the local hour. So 5:31:26 +0300 --[utcOffset(2, true)]-->
// 5:31:26 +0200 It is possible that 5:31:26 doesn't exist with offset
// +0200, so we adjust the time as needed, to be valid.
//
// Keeping the time actually adds/subtracts (one hour)
// from the actual represented time. That is why we call updateOffset
// a second time. In case it wants us to change the offset again
// _changeInProgress == true case, then we have to adjust, because
// there is no such time in the given timezone.
function Bb(b,c){var d,e=this._offset||0;return this.isValid()?null!=b?("string"==typeof b?b=yb(Qe,b):Math.abs(b)<16&&(b=60*b),!this._isUTC&&c&&(d=Ab(this)),this._offset=b,this._isUTC=!0,null!=d&&this.add(d,"m"),e!==b&&(!c||this._changeInProgress?Sb(this,Mb(b-e,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,a.updateOffset(this,!0),this._changeInProgress=null)),this):this._isUTC?e:Ab(this):null!=b?this:NaN}function Cb(a,b){return null!=a?("string"!=typeof a&&(a=-a),this.utcOffset(a,b),this):-this.utcOffset()}function Db(a){return this.utcOffset(0,a)}function Eb(a){return this._isUTC&&(this.utcOffset(0,a),this._isUTC=!1,a&&this.subtract(Ab(this),"m")),this}function Fb(){return this._tzm?this.utcOffset(this._tzm):"string"==typeof this._i&&this.utcOffset(yb(Pe,this._i)),this}function Gb(a){return this.isValid()?(a=a?rb(a).utcOffset():0,(this.utcOffset()-a)%60===0):!1}function Hb(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()}function Ib(){if(!o(this._isDSTShifted))return this._isDSTShifted;var a={};if(p(a,this),a=ob(a),a._a){var b=a._isUTC?j(a._a):rb(a._a);this._isDSTShifted=this.isValid()&&u(a._a,b.toArray())>0}else this._isDSTShifted=!1;return this._isDSTShifted}function Jb(){return this.isValid()?!this._isUTC:!1}function Kb(){return this.isValid()?this._isUTC:!1}function Lb(){return this.isValid()?this._isUTC&&0===this._offset:!1}function Mb(a,b){var c,d,e,f=a,
// matching against regexp is expensive, do it on demand
g=null;// checks for null or undefined
return wb(a)?f={ms:a._milliseconds,d:a._days,M:a._months}:"number"==typeof a?(f={},b?f[b]=a:f.milliseconds=a):(g=Ff.exec(a))?(c="-"===g[1]?-1:1,f={y:0,d:t(g[Xe])*c,h:t(g[Ye])*c,m:t(g[Ze])*c,s:t(g[$e])*c,ms:t(g[_e])*c}):(g=Gf.exec(a))?(c="-"===g[1]?-1:1,f={y:Nb(g[2],c),M:Nb(g[3],c),w:Nb(g[4],c),d:Nb(g[5],c),h:Nb(g[6],c),m:Nb(g[7],c),s:Nb(g[8],c)}):null==f?f={}:"object"==typeof f&&("from"in f||"to"in f)&&(e=Pb(rb(f.from),rb(f.to)),f={},f.ms=e.milliseconds,f.M=e.months),d=new vb(f),wb(a)&&h(a,"_locale")&&(d._locale=a._locale),d}function Nb(a,b){
// We'd normally use ~~inp for this, but unfortunately it also
// converts floats to ints.
// inp may be undefined, so careful calling replace on it.
var c=a&&parseFloat(a.replace(",","."));
// apply sign while we're at it
return(isNaN(c)?0:c)*b}function Ob(a,b){var c={milliseconds:0,months:0};return c.months=b.month()-a.month()+12*(b.year()-a.year()),a.clone().add(c.months,"M").isAfter(b)&&--c.months,c.milliseconds=+b-+a.clone().add(c.months,"M"),c}function Pb(a,b){var c;return a.isValid()&&b.isValid()?(b=zb(b,a),a.isBefore(b)?c=Ob(a,b):(c=Ob(b,a),c.milliseconds=-c.milliseconds,c.months=-c.months),c):{milliseconds:0,months:0}}function Qb(a){return 0>a?-1*Math.round(-1*a):Math.round(a)}
// TODO: remove 'name' arg after deprecation is removed
function Rb(a,b){return function(c,d){var e,f;
//invert the arguments, but complain about it
return null===d||isNaN(+d)||(x(b,"moment()."+b+"(period, number) is deprecated. Please use moment()."+b+"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."),f=c,c=d,d=f),c="string"==typeof c?+c:c,e=Mb(c,d),Sb(this,e,a),this}}function Sb(b,c,d,e){var f=c._milliseconds,g=Qb(c._days),h=Qb(c._months);b.isValid()&&(e=null==e?!0:e,f&&b._d.setTime(b._d.valueOf()+f*d),g&&P(b,"Date",O(b,"Date")+g*d),h&&ia(b,O(b,"Month")+h*d),e&&a.updateOffset(b,g||h))}function Tb(a,b){var c=a.diff(b,"days",!0);return-6>c?"sameElse":-1>c?"lastWeek":0>c?"lastDay":1>c?"sameDay":2>c?"nextDay":7>c?"nextWeek":"sameElse"}function Ub(b,c){
// We want to compare the start of today, vs this.
// Getting start-of-today depends on whether we're local/utc/offset or not.
var d=b||rb(),e=zb(d,this).startOf("day"),f=a.calendarFormat(this,e)||"sameElse",g=c&&(y(c[f])?c[f].call(this,d):c[f]);return this.format(g||this.localeData().calendar(f,this,rb(d)))}function Vb(){return new q(this)}function Wb(a,b){var c=r(a)?a:rb(a);return this.isValid()&&c.isValid()?(b=J(o(b)?"millisecond":b),"millisecond"===b?this.valueOf()>c.valueOf():c.valueOf()<this.clone().startOf(b).valueOf()):!1}function Xb(a,b){var c=r(a)?a:rb(a);return this.isValid()&&c.isValid()?(b=J(o(b)?"millisecond":b),"millisecond"===b?this.valueOf()<c.valueOf():this.clone().endOf(b).valueOf()<c.valueOf()):!1}function Yb(a,b,c,d){return d=d||"()",("("===d[0]?this.isAfter(a,c):!this.isBefore(a,c))&&(")"===d[1]?this.isBefore(b,c):!this.isAfter(b,c))}function Zb(a,b){var c,d=r(a)?a:rb(a);return this.isValid()&&d.isValid()?(b=J(b||"millisecond"),"millisecond"===b?this.valueOf()===d.valueOf():(c=d.valueOf(),this.clone().startOf(b).valueOf()<=c&&c<=this.clone().endOf(b).valueOf())):!1}function $b(a,b){return this.isSame(a,b)||this.isAfter(a,b)}function _b(a,b){return this.isSame(a,b)||this.isBefore(a,b)}function ac(a,b,c){var d,e,f,g;// 1000
// 1000 * 60
// 1000 * 60 * 60
// 1000 * 60 * 60 * 24, negate dst
// 1000 * 60 * 60 * 24 * 7, negate dst
return this.isValid()?(d=zb(a,this),d.isValid()?(e=6e4*(d.utcOffset()-this.utcOffset()),b=J(b),"year"===b||"month"===b||"quarter"===b?(g=bc(this,d),"quarter"===b?g/=3:"year"===b&&(g/=12)):(f=this-d,g="second"===b?f/1e3:"minute"===b?f/6e4:"hour"===b?f/36e5:"day"===b?(f-e)/864e5:"week"===b?(f-e)/6048e5:f),c?g:s(g)):NaN):NaN}function bc(a,b){
// difference in months
var c,d,e=12*(b.year()-a.year())+(b.month()-a.month()),
// b is in (anchor - 1 month, anchor + 1 month)
f=a.clone().add(e,"months");
//check for negative zero, return zero if negative zero
// linear across the month
// linear across the month
return 0>b-f?(c=a.clone().add(e-1,"months"),d=(b-f)/(f-c)):(c=a.clone().add(e+1,"months"),d=(b-f)/(c-f)),-(e+d)||0}function cc(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")}function dc(){var a=this.clone().utc();return 0<a.year()&&a.year()<=9999?y(Date.prototype.toISOString)?this.toDate().toISOString():W(a,"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]"):W(a,"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]")}function ec(b){b||(b=this.isUtc()?a.defaultFormatUtc:a.defaultFormat);var c=W(this,b);return this.localeData().postformat(c)}function fc(a,b){return this.isValid()&&(r(a)&&a.isValid()||rb(a).isValid())?Mb({to:this,from:a}).locale(this.locale()).humanize(!b):this.localeData().invalidDate()}function gc(a){return this.from(rb(),a)}function hc(a,b){return this.isValid()&&(r(a)&&a.isValid()||rb(a).isValid())?Mb({from:this,to:a}).locale(this.locale()).humanize(!b):this.localeData().invalidDate()}function ic(a){return this.to(rb(),a)}
// If passed a locale key, it will set the locale for this
// instance.  Otherwise, it will return the locale configuration
// variables for this instance.
function jc(a){var b;return void 0===a?this._locale._abbr:(b=ab(a),null!=b&&(this._locale=b),this)}function kc(){return this._locale}function lc(a){
// the following switch intentionally omits break keywords
// to utilize falling through the cases.
switch(a=J(a)){case"year":this.month(0);/* falls through */
case"quarter":case"month":this.date(1);/* falls through */
case"week":case"isoWeek":case"day":case"date":this.hours(0);/* falls through */
case"hour":this.minutes(0);/* falls through */
case"minute":this.seconds(0);/* falls through */
case"second":this.milliseconds(0)}
// weeks are a special case
// quarters are also special
return"week"===a&&this.weekday(0),"isoWeek"===a&&this.isoWeekday(1),"quarter"===a&&this.month(3*Math.floor(this.month()/3)),this}function mc(a){
// 'date' is an alias for 'day', so it should be considered as such.
return a=J(a),void 0===a||"millisecond"===a?this:("date"===a&&(a="day"),this.startOf(a).add(1,"isoWeek"===a?"week":a).subtract(1,"ms"))}function nc(){return this._d.valueOf()-6e4*(this._offset||0)}function oc(){return Math.floor(this.valueOf()/1e3)}function pc(){return new Date(this.valueOf())}function qc(){var a=this;return[a.year(),a.month(),a.date(),a.hour(),a.minute(),a.second(),a.millisecond()]}function rc(){var a=this;return{years:a.year(),months:a.month(),date:a.date(),hours:a.hours(),minutes:a.minutes(),seconds:a.seconds(),milliseconds:a.milliseconds()}}function sc(){
// new Date(NaN).toJSON() === null
return this.isValid()?this.toISOString():null}function tc(){return m(this)}function uc(){return i({},l(this))}function vc(){return l(this).overflow}function wc(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}}function xc(a,b){T(0,[a,a.length],0,b)}
// MOMENTS
function yc(a){return Cc.call(this,a,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)}function zc(a){return Cc.call(this,a,this.isoWeek(),this.isoWeekday(),1,4)}function Ac(){return wa(this.year(),1,4)}function Bc(){var a=this.localeData()._week;return wa(this.year(),a.dow,a.doy)}function Cc(a,b,c,d,e){var f;return null==a?va(this,d,e).year:(f=wa(a,d,e),b>f&&(b=f),Dc.call(this,a,b,c,d,e))}function Dc(a,b,c,d,e){var f=ua(a,b,c,d,e),g=sa(f.year,0,f.dayOfYear);return this.year(g.getUTCFullYear()),this.month(g.getUTCMonth()),this.date(g.getUTCDate()),this}
// MOMENTS
function Ec(a){return null==a?Math.ceil((this.month()+1)/3):this.month(3*(a-1)+this.month()%3)}
// HELPERS
// MOMENTS
function Fc(a){var b=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/864e5)+1;return null==a?b:this.add(a-b,"d")}function Gc(a,b){b[_e]=t(1e3*("0."+a))}
// MOMENTS
function Hc(){return this._isUTC?"UTC":""}function Ic(){return this._isUTC?"Coordinated Universal Time":""}function Jc(a){return rb(1e3*a)}function Kc(){return rb.apply(null,arguments).parseZone()}function Lc(a){return a}function Mc(a,b,c,d){var e=ab(),f=j().set(d,b);return e[c](f,a)}function Nc(a,b,c){if("number"==typeof a&&(b=a,a=void 0),a=a||"",null!=b)return Mc(a,b,c,"month");var d,e=[];for(d=0;12>d;d++)e[d]=Mc(a,d,c,"month");return e}
// ()
// (5)
// (fmt, 5)
// (fmt)
// (true)
// (true, 5)
// (true, fmt, 5)
// (true, fmt)
function Oc(a,b,c,d){"boolean"==typeof a?("number"==typeof b&&(c=b,b=void 0),b=b||""):(b=a,c=b,a=!1,"number"==typeof b&&(c=b,b=void 0),b=b||"");var e=ab(),f=a?e._week.dow:0;if(null!=c)return Mc(b,(c+f)%7,d,"day");var g,h=[];for(g=0;7>g;g++)h[g]=Mc(b,(g+f)%7,d,"day");return h}function Pc(a,b){return Nc(a,b,"months")}function Qc(a,b){return Nc(a,b,"monthsShort")}function Rc(a,b,c){return Oc(a,b,c,"weekdays")}function Sc(a,b,c){return Oc(a,b,c,"weekdaysShort")}function Tc(a,b,c){return Oc(a,b,c,"weekdaysMin")}function Uc(){var a=this._data;return this._milliseconds=Sf(this._milliseconds),this._days=Sf(this._days),this._months=Sf(this._months),a.milliseconds=Sf(a.milliseconds),a.seconds=Sf(a.seconds),a.minutes=Sf(a.minutes),a.hours=Sf(a.hours),a.months=Sf(a.months),a.years=Sf(a.years),this}function Vc(a,b,c,d){var e=Mb(b,c);return a._milliseconds+=d*e._milliseconds,a._days+=d*e._days,a._months+=d*e._months,a._bubble()}
// supports only 2.0-style add(1, 's') or add(duration)
function Wc(a,b){return Vc(this,a,b,1)}
// supports only 2.0-style subtract(1, 's') or subtract(duration)
function Xc(a,b){return Vc(this,a,b,-1)}function Yc(a){return 0>a?Math.floor(a):Math.ceil(a)}function Zc(){var a,b,c,d,e,f=this._milliseconds,g=this._days,h=this._months,i=this._data;
// if we have a mix of positive and negative values, bubble down first
// check: https://github.com/moment/moment/issues/2166
// The following code bubbles up values, see the tests for
// examples of what that means.
// convert days to months
// 12 months -> 1 year
return f>=0&&g>=0&&h>=0||0>=f&&0>=g&&0>=h||(f+=864e5*Yc(_c(h)+g),g=0,h=0),i.milliseconds=f%1e3,a=s(f/1e3),i.seconds=a%60,b=s(a/60),i.minutes=b%60,c=s(b/60),i.hours=c%24,g+=s(c/24),e=s($c(g)),h+=e,g-=Yc(_c(e)),d=s(h/12),h%=12,i.days=g,i.months=h,i.years=d,this}function $c(a){
// 400 years have 146097 days (taking into account leap year rules)
// 400 years have 12 months === 4800
return 4800*a/146097}function _c(a){
// the reverse of daysToMonths
return 146097*a/4800}function ad(a){var b,c,d=this._milliseconds;if(a=J(a),"month"===a||"year"===a)return b=this._days+d/864e5,c=this._months+$c(b),"month"===a?c:c/12;switch(b=this._days+Math.round(_c(this._months)),a){case"week":return b/7+d/6048e5;case"day":return b+d/864e5;case"hour":return 24*b+d/36e5;case"minute":return 1440*b+d/6e4;case"second":return 86400*b+d/1e3;
// Math.floor prevents floating point math errors here
case"millisecond":return Math.floor(864e5*b)+d;default:throw new Error("Unknown unit "+a)}}
// TODO: Use this.as('ms')?
function bd(){return this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*t(this._months/12)}function cd(a){return function(){return this.as(a)}}function dd(a){return a=J(a),this[a+"s"]()}function ed(a){return function(){return this._data[a]}}function fd(){return s(this.days()/7)}
// helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize
function gd(a,b,c,d,e){return e.relativeTime(b||1,!!c,a,d)}function hd(a,b,c){var d=Mb(a).abs(),e=gg(d.as("s")),f=gg(d.as("m")),g=gg(d.as("h")),h=gg(d.as("d")),i=gg(d.as("M")),j=gg(d.as("y")),k=e<hg.s&&["s",e]||1>=f&&["m"]||f<hg.m&&["mm",f]||1>=g&&["h"]||g<hg.h&&["hh",g]||1>=h&&["d"]||h<hg.d&&["dd",h]||1>=i&&["M"]||i<hg.M&&["MM",i]||1>=j&&["y"]||["yy",j];return k[2]=b,k[3]=+a>0,k[4]=c,gd.apply(null,k)}
// This function allows you to set the rounding function for relative time strings
function id(a){return void 0===a?gg:"function"==typeof a?(gg=a,!0):!1}
// This function allows you to set a threshold for relative time strings
function jd(a,b){return void 0===hg[a]?!1:void 0===b?hg[a]:(hg[a]=b,!0)}function kd(a){var b=this.localeData(),c=hd(this,!a,b);return a&&(c=b.pastFuture(+this,c)),b.postformat(c)}function ld(){
// for ISO strings we do not use the normal bubbling rules:
//  * milliseconds bubble up until they become hours
//  * days do not bubble at all
//  * months bubble up until they become years
// This is because there is no context-free conversion between hours and days
// (think of clock changes)
// and also not between days and months (28-31 days per month)
var a,b,c,d=ig(this._milliseconds)/1e3,e=ig(this._days),f=ig(this._months);a=s(d/60),b=s(a/60),d%=60,a%=60,c=s(f/12),f%=12;
// inspired by https://github.com/dordille/moment-isoduration/blob/master/moment.isoduration.js
var g=c,h=f,i=e,j=b,k=a,l=d,m=this.asSeconds();return m?(0>m?"-":"")+"P"+(g?g+"Y":"")+(h?h+"M":"")+(i?i+"D":"")+(j||k||l?"T":"")+(j?j+"H":"")+(k?k+"M":"")+(l?l+"S":""):"P0D"}function md(a,b){var c=a.split("_");return b%10===1&&b%100!==11?c[0]:b%10>=2&&4>=b%10&&(10>b%100||b%100>=20)?c[1]:c[2]}function nd(a,b,c){var d={mm:b?"Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½ÃÂ°_Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘â€¹_Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½":"Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’_Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘â€¹_Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½",hh:b?"ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½ÃÂ°_ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹_ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½":"ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’_ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘â€¹_ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½",dd:"ÃÂ´ÃÂ·ÃÂµÃÂ½Ã‘Å’_ÃÂ´ÃÂ½Ã‘â€“_ÃÂ´ÃÂ·Ã‘â€˜ÃÂ½",MM:"ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ _ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ Ã‘â€¹_ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ ÃÂ°Ã‘Å¾",yy:"ÃÂ³ÃÂ¾ÃÂ´_ÃÂ³ÃÂ°ÃÂ´Ã‘â€¹_ÃÂ³ÃÂ°ÃÂ´ÃÂ¾Ã‘Å¾"};return"m"===c?b?"Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½ÃÂ°":"Ã‘â€¦ÃÂ²Ã‘â€“ÃÂ»Ã‘â€“ÃÂ½Ã‘Æ’":"h"===c?b?"ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½ÃÂ°":"ÃÂ³ÃÂ°ÃÂ´ÃÂ·Ã‘â€“ÃÂ½Ã‘Æ’":a+" "+md(d[c],+a)}function od(a,b,c){var d={mm:"munutenn",MM:"miz",dd:"devezh"};return a+" "+rd(d[c],a)}function pd(a){switch(qd(a)){case 1:case 3:case 4:case 5:case 9:return a+" bloaz";default:return a+" vloaz"}}function qd(a){return a>9?qd(a%10):a}function rd(a,b){return 2===b?sd(a):a}function sd(a){var b={m:"v",b:"v",d:"z"};return void 0===b[a.charAt(0)]?a:b[a.charAt(0)]+a.substring(1)}function td(a,b,c){var d=a+" ";switch(c){case"m":return b?"jedna minuta":"jedne minute";case"mm":return d+=1===a?"minuta":2===a||3===a||4===a?"minute":"minuta";case"h":return b?"jedan sat":"jednog sata";case"hh":return d+=1===a?"sat":2===a||3===a||4===a?"sata":"sati";case"dd":return d+=1===a?"dan":"dana";case"MM":return d+=1===a?"mjesec":2===a||3===a||4===a?"mjeseca":"mjeseci";case"yy":return d+=1===a?"godina":2===a||3===a||4===a?"godine":"godina"}}function ud(a){return a>1&&5>a&&1!==~~(a/10)}function vd(a,b,c,d){var e=a+" ";switch(c){case"s":// a few seconds / in a few seconds / a few seconds ago
return b||d?"pÃƒÂ¡r sekund":"pÃƒÂ¡r sekundami";case"m":// a minute / in a minute / a minute ago
return b?"minuta":d?"minutu":"minutou";case"mm":// 9 minutes / in 9 minutes / 9 minutes ago
// 9 minutes / in 9 minutes / 9 minutes ago
return b||d?e+(ud(a)?"minuty":"minut"):e+"minutami";break;case"h":// an hour / in an hour / an hour ago
return b?"hodina":d?"hodinu":"hodinou";case"hh":// 9 hours / in 9 hours / 9 hours ago
// 9 hours / in 9 hours / 9 hours ago
return b||d?e+(ud(a)?"hodiny":"hodin"):e+"hodinami";break;case"d":// a day / in a day / a day ago
return b||d?"den":"dnem";case"dd":// 9 days / in 9 days / 9 days ago
// 9 days / in 9 days / 9 days ago
return b||d?e+(ud(a)?"dny":"dnÃƒÂ­"):e+"dny";break;case"M":// a month / in a month / a month ago
return b||d?"mÃ„â€ºsÃƒÂ­c":"mÃ„â€ºsÃƒÂ­cem";case"MM":// 9 months / in 9 months / 9 months ago
// 9 months / in 9 months / 9 months ago
return b||d?e+(ud(a)?"mÃ„â€ºsÃƒÂ­ce":"mÃ„â€ºsÃƒÂ­cÃ…Â¯"):e+"mÃ„â€ºsÃƒÂ­ci";break;case"y":// a year / in a year / a year ago
return b||d?"rok":"rokem";case"yy":// 9 years / in 9 years / 9 years ago
// 9 years / in 9 years / 9 years ago
return b||d?e+(ud(a)?"roky":"let"):e+"lety"}}function wd(a,b,c,d){var e={m:["eine Minute","einer Minute"],h:["eine Stunde","einer Stunde"],d:["ein Tag","einem Tag"],dd:[a+" Tage",a+" Tagen"],M:["ein Monat","einem Monat"],MM:[a+" Monate",a+" Monaten"],y:["ein Jahr","einem Jahr"],yy:[a+" Jahre",a+" Jahren"]};return b?e[c][0]:e[c][1]}function xd(a,b,c,d){var e={m:["eine Minute","einer Minute"],h:["eine Stunde","einer Stunde"],d:["ein Tag","einem Tag"],dd:[a+" Tage",a+" Tagen"],M:["ein Monat","einem Monat"],MM:[a+" Monate",a+" Monaten"],y:["ein Jahr","einem Jahr"],yy:[a+" Jahre",a+" Jahren"]};return b?e[c][0]:e[c][1]}function yd(a,b,c,d){var e={s:["mÃƒÂµne sekundi","mÃƒÂµni sekund","paar sekundit"],m:["ÃƒÂ¼he minuti","ÃƒÂ¼ks minut"],mm:[a+" minuti",a+" minutit"],h:["ÃƒÂ¼he tunni","tund aega","ÃƒÂ¼ks tund"],hh:[a+" tunni",a+" tundi"],d:["ÃƒÂ¼he pÃƒÂ¤eva","ÃƒÂ¼ks pÃƒÂ¤ev"],M:["kuu aja","kuu aega","ÃƒÂ¼ks kuu"],MM:[a+" kuu",a+" kuud"],y:["ÃƒÂ¼he aasta","aasta","ÃƒÂ¼ks aasta"],yy:[a+" aasta",a+" aastat"]};return b?e[c][2]?e[c][2]:e[c][1]:d?e[c][0]:e[c][1]}function zd(a,b,c,d){var e="";switch(c){case"s":return d?"muutaman sekunnin":"muutama sekunti";case"m":return d?"minuutin":"minuutti";case"mm":e=d?"minuutin":"minuuttia";break;case"h":return d?"tunnin":"tunti";case"hh":e=d?"tunnin":"tuntia";break;case"d":return d?"pÃƒÂ¤ivÃƒÂ¤n":"pÃƒÂ¤ivÃƒÂ¤";case"dd":e=d?"pÃƒÂ¤ivÃƒÂ¤n":"pÃƒÂ¤ivÃƒÂ¤ÃƒÂ¤";break;case"M":return d?"kuukauden":"kuukausi";case"MM":e=d?"kuukauden":"kuukautta";break;case"y":return d?"vuoden":"vuosi";case"yy":e=d?"vuoden":"vuotta"}return e=Ad(a,d)+" "+e}function Ad(a,b){return 10>a?b?Jg[a]:Ig[a]:a}function Bd(a,b,c){var d=a+" ";switch(c){case"m":return b?"jedna minuta":"jedne minute";case"mm":return d+=1===a?"minuta":2===a||3===a||4===a?"minute":"minuta";case"h":return b?"jedan sat":"jednog sata";case"hh":return d+=1===a?"sat":2===a||3===a||4===a?"sata":"sati";case"dd":return d+=1===a?"dan":"dana";case"MM":return d+=1===a?"mjesec":2===a||3===a||4===a?"mjeseca":"mjeseci";case"yy":return d+=1===a?"godina":2===a||3===a||4===a?"godine":"godina"}}function Cd(a,b,c,d){var e=a;switch(c){case"s":return d||b?"nÃƒÂ©hÃƒÂ¡ny mÃƒÂ¡sodperc":"nÃƒÂ©hÃƒÂ¡ny mÃƒÂ¡sodperce";case"m":return"egy"+(d||b?" perc":" perce");case"mm":return e+(d||b?" perc":" perce");case"h":return"egy"+(d||b?" ÃƒÂ³ra":" ÃƒÂ³rÃƒÂ¡ja");case"hh":return e+(d||b?" ÃƒÂ³ra":" ÃƒÂ³rÃƒÂ¡ja");case"d":return"egy"+(d||b?" nap":" napja");case"dd":return e+(d||b?" nap":" napja");case"M":return"egy"+(d||b?" hÃƒÂ³nap":" hÃƒÂ³napja");case"MM":return e+(d||b?" hÃƒÂ³nap":" hÃƒÂ³napja");case"y":return"egy"+(d||b?" ÃƒÂ©v":" ÃƒÂ©ve");case"yy":return e+(d||b?" ÃƒÂ©v":" ÃƒÂ©ve")}return""}function Dd(a){return(a?"":"[mÃƒÂºlt] ")+"["+Tg[this.day()]+"] LT[-kor]"}function Ed(a){return a%100===11?!0:a%10!==1}function Fd(a,b,c,d){var e=a+" ";switch(c){case"s":return b||d?"nokkrar sekÃƒÂºndur":"nokkrum sekÃƒÂºndum";case"m":return b?"mÃƒÂ­nÃƒÂºta":"mÃƒÂ­nÃƒÂºtu";case"mm":return Ed(a)?e+(b||d?"mÃƒÂ­nÃƒÂºtur":"mÃƒÂ­nÃƒÂºtum"):b?e+"mÃƒÂ­nÃƒÂºta":e+"mÃƒÂ­nÃƒÂºtu";case"hh":return Ed(a)?e+(b||d?"klukkustundir":"klukkustundum"):e+"klukkustund";case"d":return b?"dagur":d?"dag":"degi";case"dd":return Ed(a)?b?e+"dagar":e+(d?"daga":"dÃƒÂ¶gum"):b?e+"dagur":e+(d?"dag":"degi");case"M":return b?"mÃƒÂ¡nuÃƒÂ°ur":d?"mÃƒÂ¡nuÃƒÂ°":"mÃƒÂ¡nuÃƒÂ°i";case"MM":return Ed(a)?b?e+"mÃƒÂ¡nuÃƒÂ°ir":e+(d?"mÃƒÂ¡nuÃƒÂ°i":"mÃƒÂ¡nuÃƒÂ°um"):b?e+"mÃƒÂ¡nuÃƒÂ°ur":e+(d?"mÃƒÂ¡nuÃƒÂ°":"mÃƒÂ¡nuÃƒÂ°i");case"y":return b||d?"ÃƒÂ¡r":"ÃƒÂ¡ri";case"yy":return Ed(a)?e+(b||d?"ÃƒÂ¡r":"ÃƒÂ¡rum"):e+(b||d?"ÃƒÂ¡r":"ÃƒÂ¡ri")}}function Gd(a,b,c,d){var e={m:["eng Minutt","enger Minutt"],h:["eng Stonn","enger Stonn"],d:["een Dag","engem Dag"],M:["ee Mount","engem Mount"],y:["ee Joer","engem Joer"]};return b?e[c][0]:e[c][1]}function Hd(a){var b=a.substr(0,a.indexOf(" "));return Jd(b)?"a "+a:"an "+a}function Id(a){var b=a.substr(0,a.indexOf(" "));return Jd(b)?"viru "+a:"virun "+a}/**
     * Returns true if the word before the given number loses the '-n' ending.
     * e.g. 'an 10 Deeg' but 'a 5 Deeg'
     *
     * @param number {integer}
     * @returns {boolean}
     */
function Jd(a){if(a=parseInt(a,10),isNaN(a))return!1;if(0>a)
// Negative Number --> always true
return!0;if(10>a)
// Only 1 digit
return a>=4&&7>=a;if(100>a){
// 2 digits
var b=a%10,c=a/10;return Jd(0===b?c:b)}if(1e4>a){
// 3 or 4 digits --> recursively check first digit
for(;a>=10;)a/=10;return Jd(a)}
// Anything larger than 4 digits: recursively check first n-3 digits
return a/=1e3,Jd(a)}function Kd(a,b,c,d){return b?"kelios sekundÃ„â€”s":d?"keliÃ…Â³ sekundÃ…Â¾iÃ…Â³":"kelias sekundes"}function Ld(a,b,c,d){return b?Nd(c)[0]:d?Nd(c)[1]:Nd(c)[2]}function Md(a){return a%10===0||a>10&&20>a}function Nd(a){return Wg[a].split("_")}function Od(a,b,c,d){var e=a+" ";return 1===a?e+Ld(a,b,c[0],d):b?e+(Md(a)?Nd(c)[1]:Nd(c)[0]):d?e+Nd(c)[1]:e+(Md(a)?Nd(c)[1]:Nd(c)[2])}/**
     * @param withoutSuffix boolean true = a length of time; false = before/after a period of time.
     */
function Pd(a,b,c){return c?b%10===1&&b%100!==11?a[2]:a[3]:b%10===1&&b%100!==11?a[0]:a[1]}function Qd(a,b,c){return a+" "+Pd(Xg[c],a,b)}function Rd(a,b,c){return Pd(Xg[c],a,b)}function Sd(a,b){return b?"daÃ…Â¾as sekundes":"daÃ…Â¾Ã„Âm sekundÃ„â€œm"}function Td(a,b,c,d){var e="";if(b)switch(c){case"s":e="Ã Â¤â€¢Ã Â¤Â¾Ã Â¤Â¹Ã Â¥â‚¬ Ã Â¤Â¸Ã Â¥â€¡Ã Â¤â€¢Ã Â¤â€šÃ Â¤Â¦";break;case"m":e="Ã Â¤ÂÃ Â¤â€¢ Ã Â¤Â®Ã Â¤Â¿Ã Â¤Â¨Ã Â¤Â¿Ã Â¤Å¸";break;case"mm":e="%d Ã Â¤Â®Ã Â¤Â¿Ã Â¤Â¨Ã Â¤Â¿Ã Â¤Å¸Ã Â¥â€¡";break;case"h":e="Ã Â¤ÂÃ Â¤â€¢ Ã Â¤Â¤Ã Â¤Â¾Ã Â¤Â¸";break;case"hh":e="%d Ã Â¤Â¤Ã Â¤Â¾Ã Â¤Â¸";break;case"d":e="Ã Â¤ÂÃ Â¤â€¢ Ã Â¤Â¦Ã Â¤Â¿Ã Â¤ÂµÃ Â¤Â¸";break;case"dd":e="%d Ã Â¤Â¦Ã Â¤Â¿Ã Â¤ÂµÃ Â¤Â¸";break;case"M":e="Ã Â¤ÂÃ Â¤â€¢ Ã Â¤Â®Ã Â¤Â¹Ã Â¤Â¿Ã Â¤Â¨Ã Â¤Â¾";break;case"MM":e="%d Ã Â¤Â®Ã Â¤Â¹Ã Â¤Â¿Ã Â¤Â¨Ã Â¥â€¡";break;case"y":e="Ã Â¤ÂÃ Â¤â€¢ Ã Â¤ÂµÃ Â¤Â°Ã Â¥ÂÃ Â¤Â·";break;case"yy":e="%d Ã Â¤ÂµÃ Â¤Â°Ã Â¥ÂÃ Â¤Â·Ã Â¥â€¡"}else switch(c){case"s":e="Ã Â¤â€¢Ã Â¤Â¾Ã Â¤Â¹Ã Â¥â‚¬ Ã Â¤Â¸Ã Â¥â€¡Ã Â¤â€¢Ã Â¤â€šÃ Â¤Â¦Ã Â¤Â¾Ã Â¤â€š";break;case"m":e="Ã Â¤ÂÃ Â¤â€¢Ã Â¤Â¾ Ã Â¤Â®Ã Â¤Â¿Ã Â¤Â¨Ã Â¤Â¿Ã Â¤Å¸Ã Â¤Â¾";break;case"mm":e="%d Ã Â¤Â®Ã Â¤Â¿Ã Â¤Â¨Ã Â¤Â¿Ã Â¤Å¸Ã Â¤Â¾Ã Â¤â€š";break;case"h":e="Ã Â¤ÂÃ Â¤â€¢Ã Â¤Â¾ Ã Â¤Â¤Ã Â¤Â¾Ã Â¤Â¸Ã Â¤Â¾";break;case"hh":e="%d Ã Â¤Â¤Ã Â¤Â¾Ã Â¤Â¸Ã Â¤Â¾Ã Â¤â€š";break;case"d":e="Ã Â¤ÂÃ Â¤â€¢Ã Â¤Â¾ Ã Â¤Â¦Ã Â¤Â¿Ã Â¤ÂµÃ Â¤Â¸Ã Â¤Â¾";break;case"dd":e="%d Ã Â¤Â¦Ã Â¤Â¿Ã Â¤ÂµÃ Â¤Â¸Ã Â¤Â¾Ã Â¤â€š";break;case"M":e="Ã Â¤ÂÃ Â¤â€¢Ã Â¤Â¾ Ã Â¤Â®Ã Â¤Â¹Ã Â¤Â¿Ã Â¤Â¨Ã Â¥ÂÃ Â¤Â¯Ã Â¤Â¾";break;case"MM":e="%d Ã Â¤Â®Ã Â¤Â¹Ã Â¤Â¿Ã Â¤Â¨Ã Â¥ÂÃ Â¤Â¯Ã Â¤Â¾Ã Â¤â€š";break;case"y":e="Ã Â¤ÂÃ Â¤â€¢Ã Â¤Â¾ Ã Â¤ÂµÃ Â¤Â°Ã Â¥ÂÃ Â¤Â·Ã Â¤Â¾";break;case"yy":e="%d Ã Â¤ÂµÃ Â¤Â°Ã Â¥ÂÃ Â¤Â·Ã Â¤Â¾Ã Â¤â€š"}return e.replace(/%d/i,a)}function Ud(a){return 5>a%10&&a%10>1&&~~(a/10)%10!==1}function Vd(a,b,c){var d=a+" ";switch(c){case"m":return b?"minuta":"minutÃ„â„¢";case"mm":return d+(Ud(a)?"minuty":"minut");case"h":return b?"godzina":"godzinÃ„â„¢";case"hh":return d+(Ud(a)?"godziny":"godzin");case"MM":return d+(Ud(a)?"miesiÃ„â€¦ce":"miesiÃ„â„¢cy");case"yy":return d+(Ud(a)?"lata":"lat")}}function Wd(a,b,c){var d={mm:"minute",hh:"ore",dd:"zile",MM:"luni",yy:"ani"},e=" ";return(a%100>=20||a>=100&&a%100===0)&&(e=" de "),a+e+d[c]}function Xd(a,b){var c=a.split("_");return b%10===1&&b%100!==11?c[0]:b%10>=2&&4>=b%10&&(10>b%100||b%100>=20)?c[1]:c[2]}function Yd(a,b,c){var d={mm:b?"ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€šÃÂ°_ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€šÃ‘â€¹_ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€š":"ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€šÃ‘Æ’_ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€šÃ‘â€¹_ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€š",hh:"Ã‘â€¡ÃÂ°Ã‘Â_Ã‘â€¡ÃÂ°Ã‘ÂÃÂ°_Ã‘â€¡ÃÂ°Ã‘ÂÃÂ¾ÃÂ²",dd:"ÃÂ´ÃÂµÃÂ½Ã‘Å’_ÃÂ´ÃÂ½Ã‘Â_ÃÂ´ÃÂ½ÃÂµÃÂ¹",MM:"ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ _ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ ÃÂ°_ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ ÃÂµÃÂ²",yy:"ÃÂ³ÃÂ¾ÃÂ´_ÃÂ³ÃÂ¾ÃÂ´ÃÂ°_ÃÂ»ÃÂµÃ‘â€š"};return"m"===c?b?"ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€šÃÂ°":"ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€šÃ‘Æ’":a+" "+Xd(d[c],+a)}function Zd(a){return a>1&&5>a}function $d(a,b,c,d){var e=a+" ";switch(c){case"s":// a few seconds / in a few seconds / a few seconds ago
return b||d?"pÃƒÂ¡r sekÃƒÂºnd":"pÃƒÂ¡r sekundami";case"m":// a minute / in a minute / a minute ago
return b?"minÃƒÂºta":d?"minÃƒÂºtu":"minÃƒÂºtou";case"mm":// 9 minutes / in 9 minutes / 9 minutes ago
// 9 minutes / in 9 minutes / 9 minutes ago
return b||d?e+(Zd(a)?"minÃƒÂºty":"minÃƒÂºt"):e+"minÃƒÂºtami";break;case"h":// an hour / in an hour / an hour ago
return b?"hodina":d?"hodinu":"hodinou";case"hh":// 9 hours / in 9 hours / 9 hours ago
// 9 hours / in 9 hours / 9 hours ago
return b||d?e+(Zd(a)?"hodiny":"hodÃƒÂ­n"):e+"hodinami";break;case"d":// a day / in a day / a day ago
return b||d?"deÃ…Ë†":"dÃ…Ë†om";case"dd":// 9 days / in 9 days / 9 days ago
// 9 days / in 9 days / 9 days ago
return b||d?e+(Zd(a)?"dni":"dnÃƒÂ­"):e+"dÃ…Ë†ami";break;case"M":// a month / in a month / a month ago
return b||d?"mesiac":"mesiacom";case"MM":// 9 months / in 9 months / 9 months ago
// 9 months / in 9 months / 9 months ago
return b||d?e+(Zd(a)?"mesiace":"mesiacov"):e+"mesiacmi";break;case"y":// a year / in a year / a year ago
return b||d?"rok":"rokom";case"yy":// 9 years / in 9 years / 9 years ago
// 9 years / in 9 years / 9 years ago
return b||d?e+(Zd(a)?"roky":"rokov"):e+"rokmi"}}function _d(a,b,c,d){var e=a+" ";switch(c){case"s":return b||d?"nekaj sekund":"nekaj sekundami";case"m":return b?"ena minuta":"eno minuto";case"mm":return e+=1===a?b?"minuta":"minuto":2===a?b||d?"minuti":"minutama":5>a?b||d?"minute":"minutami":b||d?"minut":"minutami";case"h":return b?"ena ura":"eno uro";case"hh":return e+=1===a?b?"ura":"uro":2===a?b||d?"uri":"urama":5>a?b||d?"ure":"urami":b||d?"ur":"urami";case"d":return b||d?"en dan":"enim dnem";case"dd":return e+=1===a?b||d?"dan":"dnem":2===a?b||d?"dni":"dnevoma":b||d?"dni":"dnevi";case"M":return b||d?"en mesec":"enim mesecem";case"MM":return e+=1===a?b||d?"mesec":"mesecem":2===a?b||d?"meseca":"mesecema":5>a?b||d?"mesece":"meseci":b||d?"mesecev":"meseci";case"y":return b||d?"eno leto":"enim letom";case"yy":return e+=1===a?b||d?"leto":"letom":2===a?b||d?"leti":"letoma":5>a?b||d?"leta":"leti":b||d?"let":"leti"}}function ae(a){var b=a;return b=-1!==a.indexOf("jaj")?b.slice(0,-3)+"leS":-1!==a.indexOf("jar")?b.slice(0,-3)+"waQ":-1!==a.indexOf("DIS")?b.slice(0,-3)+"nem":b+" pIq"}function be(a){var b=a;return b=-1!==a.indexOf("jaj")?b.slice(0,-3)+"HuÃ¢â‚¬â„¢":-1!==a.indexOf("jar")?b.slice(0,-3)+"wen":-1!==a.indexOf("DIS")?b.slice(0,-3)+"ben":b+" ret"}function ce(a,b,c,d){var e=de(a);switch(c){case"mm":return e+" tup";case"hh":return e+" rep";case"dd":return e+" jaj";case"MM":return e+" jar";case"yy":return e+" DIS"}}function de(a){var b=Math.floor(a%1e3/100),c=Math.floor(a%100/10),d=a%10,e="";return b>0&&(e+=qh[b]+"vatlh"),c>0&&(e+=(""!==e?" ":"")+qh[c]+"maH"),d>0&&(e+=(""!==e?" ":"")+qh[d]),""===e?"pagh":e}function ee(a,b,c,d){var e={s:["viensas secunds","'iensas secunds"],m:["'n mÃƒÂ­ut","'iens mÃƒÂ­ut"],mm:[a+" mÃƒÂ­uts",""+a+" mÃƒÂ­uts"],h:["'n ÃƒÂ¾ora","'iensa ÃƒÂ¾ora"],hh:[a+" ÃƒÂ¾oras",""+a+" ÃƒÂ¾oras"],d:["'n ziua","'iensa ziua"],dd:[a+" ziuas",""+a+" ziuas"],M:["'n mes","'iens mes"],MM:[a+" mesen",""+a+" mesen"],y:["'n ar","'iens ar"],yy:[a+" ars",""+a+" ars"]};return d?e[c][0]:b?e[c][0]:e[c][1]}function fe(a,b){var c=a.split("_");return b%10===1&&b%100!==11?c[0]:b%10>=2&&4>=b%10&&(10>b%100||b%100>=20)?c[1]:c[2]}function ge(a,b,c){var d={mm:b?"Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ°_Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ¸_Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½":"Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½Ã‘Æ’_Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ¸_Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½",hh:b?"ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ°_ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ¸_ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½":"ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’_ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ¸_ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½",dd:"ÃÂ´ÃÂµÃÂ½Ã‘Å’_ÃÂ´ÃÂ½Ã‘â€“_ÃÂ´ÃÂ½Ã‘â€“ÃÂ²",MM:"ÃÂ¼Ã‘â€“Ã‘ÂÃ‘ÂÃ‘â€ Ã‘Å’_ÃÂ¼Ã‘â€“Ã‘ÂÃ‘ÂÃ‘â€ Ã‘â€“_ÃÂ¼Ã‘â€“Ã‘ÂÃ‘ÂÃ‘â€ Ã‘â€“ÃÂ²",yy:"Ã‘â‚¬Ã‘â€“ÃÂº_Ã‘â‚¬ÃÂ¾ÃÂºÃÂ¸_Ã‘â‚¬ÃÂ¾ÃÂºÃ‘â€“ÃÂ²"};return"m"===c?b?"Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½ÃÂ°":"Ã‘â€¦ÃÂ²ÃÂ¸ÃÂ»ÃÂ¸ÃÂ½Ã‘Æ’":"h"===c?b?"ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ°":"ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’":a+" "+fe(d[c],+a)}function he(a,b){var c={nominative:"ÃÂ½ÃÂµÃÂ´Ã‘â€“ÃÂ»Ã‘Â_ÃÂ¿ÃÂ¾ÃÂ½ÃÂµÃÂ´Ã‘â€“ÃÂ»ÃÂ¾ÃÂº_ÃÂ²Ã‘â€“ÃÂ²Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ¾ÃÂº_Ã‘ÂÃÂµÃ‘â‚¬ÃÂµÃÂ´ÃÂ°_Ã‘â€¡ÃÂµÃ‘â€šÃÂ²ÃÂµÃ‘â‚¬_ÃÂ¿Ã¢â‚¬â„¢Ã‘ÂÃ‘â€šÃÂ½ÃÂ¸Ã‘â€ Ã‘Â_Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃÂ°".split("_"),accusative:"ÃÂ½ÃÂµÃÂ´Ã‘â€“ÃÂ»Ã‘Å½_ÃÂ¿ÃÂ¾ÃÂ½ÃÂµÃÂ´Ã‘â€“ÃÂ»ÃÂ¾ÃÂº_ÃÂ²Ã‘â€“ÃÂ²Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ¾ÃÂº_Ã‘ÂÃÂµÃ‘â‚¬ÃÂµÃÂ´Ã‘Æ’_Ã‘â€¡ÃÂµÃ‘â€šÃÂ²ÃÂµÃ‘â‚¬_ÃÂ¿Ã¢â‚¬â„¢Ã‘ÂÃ‘â€šÃÂ½ÃÂ¸Ã‘â€ Ã‘Å½_Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃ‘Æ’".split("_"),genitive:"ÃÂ½ÃÂµÃÂ´Ã‘â€“ÃÂ»Ã‘â€“_ÃÂ¿ÃÂ¾ÃÂ½ÃÂµÃÂ´Ã‘â€“ÃÂ»ÃÂºÃÂ°_ÃÂ²Ã‘â€“ÃÂ²Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂºÃÂ°_Ã‘ÂÃÂµÃ‘â‚¬ÃÂµÃÂ´ÃÂ¸_Ã‘â€¡ÃÂµÃ‘â€šÃÂ²ÃÂµÃ‘â‚¬ÃÂ³ÃÂ°_ÃÂ¿Ã¢â‚¬â„¢Ã‘ÂÃ‘â€šÃÂ½ÃÂ¸Ã‘â€ Ã‘â€“_Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃÂ¸".split("_")},d=/(\[[Ãâ€™ÃÂ²ÃÂ£Ã‘Æ’]\]) ?dddd/.test(b)?"accusative":/\[?(?:ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’ÃÂ»ÃÂ¾Ã‘â€”|ÃÂ½ÃÂ°Ã‘ÂÃ‘â€šÃ‘Æ’ÃÂ¿ÃÂ½ÃÂ¾Ã‘â€”)? ?\] ?dddd/.test(b)?"genitive":"nominative";return c[d][a.day()]}function ie(a){return function(){return a+"ÃÂ¾"+(11===this.hours()?"ÃÂ±":"")+"] LT"}}var je,ke;ke=Array.prototype.some?Array.prototype.some:function(a){for(var b=Object(this),c=b.length>>>0,d=0;c>d;d++)if(d in b&&a.call(this,b[d],d,b))return!0;return!1};
// Plugins that add properties should also add the key here (null value),
// so we can properly clone ourselves.
var le=a.momentProperties=[],me=!1,ne={};a.suppressDeprecationWarnings=!1,a.deprecationHandler=null;var oe;oe=Object.keys?Object.keys:function(a){var b,c=[];for(b in a)h(a,b)&&c.push(b);return c};var pe,qe={sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},re={LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"},se="Invalid date",te="%d",ue=/\d{1,2}/,ve={future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},we={},xe={},ye=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,ze=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,Ae={},Be={},Ce=/\d/,De=/\d\d/,Ee=/\d{3}/,Fe=/\d{4}/,Ge=/[+-]?\d{6}/,He=/\d\d?/,Ie=/\d\d\d\d?/,Je=/\d\d\d\d\d\d?/,Ke=/\d{1,3}/,Le=/\d{1,4}/,Me=/[+-]?\d{1,6}/,Ne=/\d+/,Oe=/[+-]?\d+/,Pe=/Z|[+-]\d\d:?\d\d/gi,Qe=/Z|[+-]\d\d(?::?\d\d)?/gi,Re=/[+-]?\d+(\.\d{1,3})?/,Se=/[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i,Te={},Ue={},Ve=0,We=1,Xe=2,Ye=3,Ze=4,$e=5,_e=6,af=7,bf=8;pe=Array.prototype.indexOf?Array.prototype.indexOf:function(a){
// I know
var b;for(b=0;b<this.length;++b)if(this[b]===a)return b;return-1},T("M",["MM",2],"Mo",function(){return this.month()+1}),T("MMM",0,0,function(a){return this.localeData().monthsShort(this,a)}),T("MMMM",0,0,function(a){return this.localeData().months(this,a)}),I("month","M"),L("month",8),Y("M",He),Y("MM",He,De),Y("MMM",function(a,b){return b.monthsShortRegex(a)}),Y("MMMM",function(a,b){return b.monthsRegex(a)}),aa(["M","MM"],function(a,b){b[We]=t(a)-1}),aa(["MMM","MMMM"],function(a,b,c,d){var e=c._locale.monthsParse(a,d,c._strict);null!=e?b[We]=e:l(c).invalidMonth=a});
// LOCALES
var cf=/D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/,df="January_February_March_April_May_June_July_August_September_October_November_December".split("_"),ef="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),ff=Se,gf=Se;
// FORMATTING
T("Y",0,0,function(){var a=this.year();return 9999>=a?""+a:"+"+a}),T(0,["YY",2],0,function(){return this.year()%100}),T(0,["YYYY",4],0,"year"),T(0,["YYYYY",5],0,"year"),T(0,["YYYYYY",6,!0],0,"year"),
// ALIASES
I("year","y"),
// PRIORITIES
L("year",1),
// PARSING
Y("Y",Oe),Y("YY",He,De),Y("YYYY",Le,Fe),Y("YYYYY",Me,Ge),Y("YYYYYY",Me,Ge),aa(["YYYYY","YYYYYY"],Ve),aa("YYYY",function(b,c){c[Ve]=2===b.length?a.parseTwoDigitYear(b):t(b)}),aa("YY",function(b,c){c[Ve]=a.parseTwoDigitYear(b)}),aa("Y",function(a,b){b[Ve]=parseInt(a,10)}),
// HOOKS
a.parseTwoDigitYear=function(a){return t(a)+(t(a)>68?1900:2e3)};
// MOMENTS
var hf=N("FullYear",!0);
// FORMATTING
T("w",["ww",2],"wo","week"),T("W",["WW",2],"Wo","isoWeek"),
// ALIASES
I("week","w"),I("isoWeek","W"),
// PRIORITIES
L("week",5),L("isoWeek",5),
// PARSING
Y("w",He),Y("ww",He,De),Y("W",He),Y("WW",He,De),ba(["w","ww","W","WW"],function(a,b,c,d){b[d.substr(0,1)]=t(a)});var jf={dow:0,// Sunday is the first day of the week.
doy:6};
// FORMATTING
T("d",0,"do","day"),T("dd",0,0,function(a){return this.localeData().weekdaysMin(this,a)}),T("ddd",0,0,function(a){return this.localeData().weekdaysShort(this,a)}),T("dddd",0,0,function(a){return this.localeData().weekdays(this,a)}),T("e",0,0,"weekday"),T("E",0,0,"isoWeekday"),
// ALIASES
I("day","d"),I("weekday","e"),I("isoWeekday","E"),
// PRIORITY
L("day",11),L("weekday",11),L("isoWeekday",11),
// PARSING
Y("d",He),Y("e",He),Y("E",He),Y("dd",function(a,b){return b.weekdaysMinRegex(a)}),Y("ddd",function(a,b){return b.weekdaysShortRegex(a)}),Y("dddd",function(a,b){return b.weekdaysRegex(a)}),ba(["dd","ddd","dddd"],function(a,b,c,d){var e=c._locale.weekdaysParse(a,d,c._strict);
// if we didn't get a weekday name, mark the date as invalid
null!=e?b.d=e:l(c).invalidWeekday=a}),ba(["d","e","E"],function(a,b,c,d){b[d]=t(a)});
// LOCALES
var kf="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),lf="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),mf="Su_Mo_Tu_We_Th_Fr_Sa".split("_"),nf=Se,of=Se,pf=Se;T("H",["HH",2],0,"hour"),T("h",["hh",2],0,Qa),T("k",["kk",2],0,Ra),T("hmm",0,0,function(){return""+Qa.apply(this)+S(this.minutes(),2)}),T("hmmss",0,0,function(){return""+Qa.apply(this)+S(this.minutes(),2)+S(this.seconds(),2)}),T("Hmm",0,0,function(){return""+this.hours()+S(this.minutes(),2)}),T("Hmmss",0,0,function(){return""+this.hours()+S(this.minutes(),2)+S(this.seconds(),2)}),Sa("a",!0),Sa("A",!1),
// ALIASES
I("hour","h"),
// PRIORITY
L("hour",13),Y("a",Ta),Y("A",Ta),Y("H",He),Y("h",He),Y("HH",He,De),Y("hh",He,De),Y("hmm",Ie),Y("hmmss",Je),Y("Hmm",Ie),Y("Hmmss",Je),aa(["H","HH"],Ye),aa(["a","A"],function(a,b,c){c._isPm=c._locale.isPM(a),c._meridiem=a}),aa(["h","hh"],function(a,b,c){b[Ye]=t(a),l(c).bigHour=!0}),aa("hmm",function(a,b,c){var d=a.length-2;b[Ye]=t(a.substr(0,d)),b[Ze]=t(a.substr(d)),l(c).bigHour=!0}),aa("hmmss",function(a,b,c){var d=a.length-4,e=a.length-2;b[Ye]=t(a.substr(0,d)),b[Ze]=t(a.substr(d,2)),b[$e]=t(a.substr(e)),l(c).bigHour=!0}),aa("Hmm",function(a,b,c){var d=a.length-2;b[Ye]=t(a.substr(0,d)),b[Ze]=t(a.substr(d))}),aa("Hmmss",function(a,b,c){var d=a.length-4,e=a.length-2;b[Ye]=t(a.substr(0,d)),b[Ze]=t(a.substr(d,2)),b[$e]=t(a.substr(e))});var qf,rf=/[ap]\.?m?\.?/i,sf=N("Hours",!0),tf={calendar:qe,longDateFormat:re,invalidDate:se,ordinal:te,ordinalParse:ue,relativeTime:ve,months:df,monthsShort:ef,week:jf,weekdays:kf,weekdaysMin:mf,weekdaysShort:lf,meridiemParse:rf},uf={},vf=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?/,wf=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?/,xf=/Z|[+-]\d\d(?::?\d\d)?/,yf=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,!1],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,!1],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],
// YYYYMM is NOT allowed by the standard
["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,!1],["YYYYDDD",/\d{7}/]],zf=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],Af=/^\/?Date\((\-?\d+)/i;a.createFromInputFallback=w("moment construction falls back to js Date. This is discouraged and will be removed in upcoming major release. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",function(a){a._d=new Date(a._i+(a._useUTC?" UTC":""))}),
// constant that refers to the ISO standard
a.ISO_8601=function(){};var Bf=w("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var a=rb.apply(null,arguments);return this.isValid()&&a.isValid()?this>a?this:a:n()}),Cf=w("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var a=rb.apply(null,arguments);return this.isValid()&&a.isValid()?a>this?this:a:n()}),Df=function(){return Date.now?Date.now():+new Date};xb("Z",":"),xb("ZZ",""),
// PARSING
Y("Z",Qe),Y("ZZ",Qe),aa(["Z","ZZ"],function(a,b,c){c._useUTC=!0,c._tzm=yb(Qe,a)});
// HELPERS
// timezone chunker
// '+10:00' > ['10',  '00']
// '-1530'  > ['-15', '30']
var Ef=/([\+\-]|\d\d)/gi;
// HOOKS
// This function will be called whenever a moment is mutated.
// It is intended to keep the offset in sync with the timezone.
a.updateOffset=function(){};
// ASP.NET json date format regex
var Ff=/^(\-)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)\.?(\d{3})?\d*)?$/,Gf=/^(-)?P(?:(-?[0-9,.]*)Y)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)W)?(?:(-?[0-9,.]*)D)?(?:T(?:(-?[0-9,.]*)H)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)S)?)?$/;Mb.fn=vb.prototype;var Hf=Rb(1,"add"),If=Rb(-1,"subtract");a.defaultFormat="YYYY-MM-DDTHH:mm:ssZ",a.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";var Jf=w("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",function(a){return void 0===a?this.localeData():this.locale(a)});
// FORMATTING
T(0,["gg",2],0,function(){return this.weekYear()%100}),T(0,["GG",2],0,function(){return this.isoWeekYear()%100}),xc("gggg","weekYear"),xc("ggggg","weekYear"),xc("GGGG","isoWeekYear"),xc("GGGGG","isoWeekYear"),
// ALIASES
I("weekYear","gg"),I("isoWeekYear","GG"),
// PRIORITY
L("weekYear",1),L("isoWeekYear",1),
// PARSING
Y("G",Oe),Y("g",Oe),Y("GG",He,De),Y("gg",He,De),Y("GGGG",Le,Fe),Y("gggg",Le,Fe),Y("GGGGG",Me,Ge),Y("ggggg",Me,Ge),ba(["gggg","ggggg","GGGG","GGGGG"],function(a,b,c,d){b[d.substr(0,2)]=t(a)}),ba(["gg","GG"],function(b,c,d,e){c[e]=a.parseTwoDigitYear(b)}),
// FORMATTING
T("Q",0,"Qo","quarter"),
// ALIASES
I("quarter","Q"),
// PRIORITY
L("quarter",7),
// PARSING
Y("Q",Ce),aa("Q",function(a,b){b[We]=3*(t(a)-1)}),
// FORMATTING
T("D",["DD",2],"Do","date"),
// ALIASES
I("date","D"),
// PRIOROITY
L("date",9),
// PARSING
Y("D",He),Y("DD",He,De),Y("Do",function(a,b){return a?b._ordinalParse:b._ordinalParseLenient}),aa(["D","DD"],Xe),aa("Do",function(a,b){b[Xe]=t(a.match(He)[0],10)});
// MOMENTS
var Kf=N("Date",!0);
// FORMATTING
T("DDD",["DDDD",3],"DDDo","dayOfYear"),
// ALIASES
I("dayOfYear","DDD"),
// PRIORITY
L("dayOfYear",4),
// PARSING
Y("DDD",Ke),Y("DDDD",Ee),aa(["DDD","DDDD"],function(a,b,c){c._dayOfYear=t(a)}),
// FORMATTING
T("m",["mm",2],0,"minute"),
// ALIASES
I("minute","m"),
// PRIORITY
L("minute",14),
// PARSING
Y("m",He),Y("mm",He,De),aa(["m","mm"],Ze);
// MOMENTS
var Lf=N("Minutes",!1);
// FORMATTING
T("s",["ss",2],0,"second"),
// ALIASES
I("second","s"),
// PRIORITY
L("second",15),
// PARSING
Y("s",He),Y("ss",He,De),aa(["s","ss"],$e);
// MOMENTS
var Mf=N("Seconds",!1);
// FORMATTING
T("S",0,0,function(){return~~(this.millisecond()/100)}),T(0,["SS",2],0,function(){return~~(this.millisecond()/10)}),T(0,["SSS",3],0,"millisecond"),T(0,["SSSS",4],0,function(){return 10*this.millisecond()}),T(0,["SSSSS",5],0,function(){return 100*this.millisecond()}),T(0,["SSSSSS",6],0,function(){return 1e3*this.millisecond()}),T(0,["SSSSSSS",7],0,function(){return 1e4*this.millisecond()}),T(0,["SSSSSSSS",8],0,function(){return 1e5*this.millisecond()}),T(0,["SSSSSSSSS",9],0,function(){return 1e6*this.millisecond()}),
// ALIASES
I("millisecond","ms"),
// PRIORITY
L("millisecond",16),
// PARSING
Y("S",Ke,Ce),Y("SS",Ke,De),Y("SSS",Ke,Ee);var Nf;for(Nf="SSSS";Nf.length<=9;Nf+="S")Y(Nf,Ne);for(Nf="S";Nf.length<=9;Nf+="S")aa(Nf,Gc);
// MOMENTS
var Of=N("Milliseconds",!1);
// FORMATTING
T("z",0,0,"zoneAbbr"),T("zz",0,0,"zoneName");var Pf=q.prototype;Pf.add=Hf,Pf.calendar=Ub,Pf.clone=Vb,Pf.diff=ac,Pf.endOf=mc,Pf.format=ec,Pf.from=fc,Pf.fromNow=gc,Pf.to=hc,Pf.toNow=ic,Pf.get=Q,Pf.invalidAt=vc,Pf.isAfter=Wb,Pf.isBefore=Xb,Pf.isBetween=Yb,Pf.isSame=Zb,Pf.isSameOrAfter=$b,Pf.isSameOrBefore=_b,Pf.isValid=tc,Pf.lang=Jf,Pf.locale=jc,Pf.localeData=kc,Pf.max=Cf,Pf.min=Bf,Pf.parsingFlags=uc,Pf.set=R,Pf.startOf=lc,Pf.subtract=If,Pf.toArray=qc,Pf.toObject=rc,Pf.toDate=pc,Pf.toISOString=dc,Pf.toJSON=sc,Pf.toString=cc,Pf.unix=oc,Pf.valueOf=nc,Pf.creationData=wc,
// Year
Pf.year=hf,Pf.isLeapYear=qa,
// Week Year
Pf.weekYear=yc,Pf.isoWeekYear=zc,
// Quarter
Pf.quarter=Pf.quarters=Ec,
// Month
Pf.month=ja,Pf.daysInMonth=ka,
// Week
Pf.week=Pf.weeks=Aa,Pf.isoWeek=Pf.isoWeeks=Ba,Pf.weeksInYear=Bc,Pf.isoWeeksInYear=Ac,
// Day
Pf.date=Kf,Pf.day=Pf.days=Ja,Pf.weekday=Ka,Pf.isoWeekday=La,Pf.dayOfYear=Fc,
// Hour
Pf.hour=Pf.hours=sf,
// Minute
Pf.minute=Pf.minutes=Lf,
// Second
Pf.second=Pf.seconds=Mf,
// Millisecond
Pf.millisecond=Pf.milliseconds=Of,
// Offset
Pf.utcOffset=Bb,Pf.utc=Db,Pf.local=Eb,Pf.parseZone=Fb,Pf.hasAlignedHourOffset=Gb,Pf.isDST=Hb,Pf.isLocal=Jb,Pf.isUtcOffset=Kb,Pf.isUtc=Lb,Pf.isUTC=Lb,
// Timezone
Pf.zoneAbbr=Hc,Pf.zoneName=Ic,
// Deprecations
Pf.dates=w("dates accessor is deprecated. Use date instead.",Kf),Pf.months=w("months accessor is deprecated. Use month instead",ja),Pf.years=w("years accessor is deprecated. Use year instead",hf),Pf.zone=w("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",Cb),Pf.isDSTShifted=w("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",Ib);var Qf=Pf,Rf=B.prototype;Rf.calendar=C,Rf.longDateFormat=D,Rf.invalidDate=E,Rf.ordinal=F,Rf.preparse=Lc,Rf.postformat=Lc,Rf.relativeTime=G,Rf.pastFuture=H,Rf.set=z,
// Month
Rf.months=ea,Rf.monthsShort=fa,Rf.monthsParse=ha,Rf.monthsRegex=ma,Rf.monthsShortRegex=la,
// Week
Rf.week=xa,Rf.firstDayOfYear=za,Rf.firstDayOfWeek=ya,
// Day of Week
Rf.weekdays=Ea,Rf.weekdaysMin=Ga,Rf.weekdaysShort=Fa,Rf.weekdaysParse=Ia,Rf.weekdaysRegex=Ma,Rf.weekdaysShortRegex=Na,Rf.weekdaysMinRegex=Oa,
// Hours
Rf.isPM=Ua,Rf.meridiem=Va,Za("en",{ordinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(a){var b=a%10,c=1===t(a%100/10)?"th":1===b?"st":2===b?"nd":3===b?"rd":"th";return a+c}}),
// Side effect imports
a.lang=w("moment.lang is deprecated. Use moment.locale instead.",Za),a.langData=w("moment.langData is deprecated. Use moment.localeData instead.",ab);var Sf=Math.abs,Tf=cd("ms"),Uf=cd("s"),Vf=cd("m"),Wf=cd("h"),Xf=cd("d"),Yf=cd("w"),Zf=cd("M"),$f=cd("y"),_f=ed("milliseconds"),ag=ed("seconds"),bg=ed("minutes"),cg=ed("hours"),dg=ed("days"),eg=ed("months"),fg=ed("years"),gg=Math.round,hg={s:45,// seconds to minute
m:45,// minutes to hour
h:22,// hours to day
d:26,// days to month
M:11},ig=Math.abs,jg=vb.prototype;jg.abs=Uc,jg.add=Wc,jg.subtract=Xc,jg.as=ad,jg.asMilliseconds=Tf,jg.asSeconds=Uf,jg.asMinutes=Vf,jg.asHours=Wf,jg.asDays=Xf,jg.asWeeks=Yf,jg.asMonths=Zf,jg.asYears=$f,jg.valueOf=bd,jg._bubble=Zc,jg.get=dd,jg.milliseconds=_f,jg.seconds=ag,jg.minutes=bg,jg.hours=cg,jg.days=dg,jg.weeks=fd,jg.months=eg,jg.years=fg,jg.humanize=kd,jg.toISOString=ld,jg.toString=ld,jg.toJSON=ld,jg.locale=jc,jg.localeData=kc,
// Deprecations
jg.toIsoString=w("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",ld),jg.lang=Jf,
// Side effect imports
// FORMATTING
T("X",0,0,"unix"),T("x",0,0,"valueOf"),
// PARSING
Y("x",Oe),Y("X",Re),aa("X",function(a,b,c){c._d=new Date(1e3*parseFloat(a,10))}),aa("x",function(a,b,c){c._d=new Date(t(a))}),a.version="2.14.1",b(rb),a.fn=Qf,a.min=tb,a.max=ub,a.now=Df,a.utc=j,a.unix=Jc,a.months=Pc,a.isDate=f,a.locale=Za,a.invalid=n,a.duration=Mb,a.isMoment=r,a.weekdays=Rc,a.parseZone=Kc,a.localeData=ab,a.isDuration=wb,a.monthsShort=Qc,a.weekdaysMin=Tc,a.defineLocale=$a,a.updateLocale=_a,a.locales=bb,a.weekdaysShort=Sc,a.normalizeUnits=J,a.relativeTimeRounding=id,a.relativeTimeThreshold=jd,a.calendarFormat=Tb,a.prototype=Qf;var kg=a,lg=(kg.defineLocale("af",{months:"Januarie_Februarie_Maart_April_Mei_Junie_Julie_Augustus_September_Oktober_November_Desember".split("_"),monthsShort:"Jan_Feb_Mrt_Apr_Mei_Jun_Jul_Aug_Sep_Okt_Nov_Des".split("_"),weekdays:"Sondag_Maandag_Dinsdag_Woensdag_Donderdag_Vrydag_Saterdag".split("_"),weekdaysShort:"Son_Maa_Din_Woe_Don_Vry_Sat".split("_"),weekdaysMin:"So_Ma_Di_Wo_Do_Vr_Sa".split("_"),meridiemParse:/vm|nm/i,isPM:function(a){return/^nm$/i.test(a)},meridiem:function(a,b,c){return 12>a?c?"vm":"VM":c?"nm":"NM"},longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Vandag om] LT",nextDay:"[MÃƒÂ´re om] LT",nextWeek:"dddd [om] LT",lastDay:"[Gister om] LT",lastWeek:"[Laas] dddd [om] LT",sameElse:"L"},relativeTime:{future:"oor %s",past:"%s gelede",s:"'n paar sekondes",m:"'n minuut",mm:"%d minute",h:"'n uur",hh:"%d ure",d:"'n dag",dd:"%d dae",M:"'n maand",MM:"%d maande",y:"'n jaar",yy:"%d jaar"},ordinalParse:/\d{1,2}(ste|de)/,ordinal:function(a){return a+(1===a||8===a||a>=20?"ste":"de")},week:{dow:1,// Maandag is die eerste dag van die week.
doy:4}}),kg.defineLocale("ar-ma",{months:"Ã™Å Ã™â€ Ã˜Â§Ã™Å Ã˜Â±_Ã™ÂÃ˜Â¨Ã˜Â±Ã˜Â§Ã™Å Ã˜Â±_Ã™â€¦Ã˜Â§Ã˜Â±Ã˜Â³_Ã˜Â£Ã˜Â¨Ã˜Â±Ã™Å Ã™â€ž_Ã™â€¦Ã˜Â§Ã™Å _Ã™Å Ã™Ë†Ã™â€ Ã™Å Ã™Ë†_Ã™Å Ã™Ë†Ã™â€žÃ™Å Ã™Ë†Ã˜Â²_Ã˜ÂºÃ˜Â´Ã˜Âª_Ã˜Â´Ã˜ÂªÃ™â€ Ã˜Â¨Ã˜Â±_Ã˜Â£Ã™Æ’Ã˜ÂªÃ™Ë†Ã˜Â¨Ã˜Â±_Ã™â€ Ã™Ë†Ã™â€ Ã˜Â¨Ã˜Â±_Ã˜Â¯Ã˜Â¬Ã™â€ Ã˜Â¨Ã˜Â±".split("_"),monthsShort:"Ã™Å Ã™â€ Ã˜Â§Ã™Å Ã˜Â±_Ã™ÂÃ˜Â¨Ã˜Â±Ã˜Â§Ã™Å Ã˜Â±_Ã™â€¦Ã˜Â§Ã˜Â±Ã˜Â³_Ã˜Â£Ã˜Â¨Ã˜Â±Ã™Å Ã™â€ž_Ã™â€¦Ã˜Â§Ã™Å _Ã™Å Ã™Ë†Ã™â€ Ã™Å Ã™Ë†_Ã™Å Ã™Ë†Ã™â€žÃ™Å Ã™Ë†Ã˜Â²_Ã˜ÂºÃ˜Â´Ã˜Âª_Ã˜Â´Ã˜ÂªÃ™â€ Ã˜Â¨Ã˜Â±_Ã˜Â£Ã™Æ’Ã˜ÂªÃ™Ë†Ã˜Â¨Ã˜Â±_Ã™â€ Ã™Ë†Ã™â€ Ã˜Â¨Ã˜Â±_Ã˜Â¯Ã˜Â¬Ã™â€ Ã˜Â¨Ã˜Â±".split("_"),weekdays:"Ã˜Â§Ã™â€žÃ˜Â£Ã˜Â­Ã˜Â¯_Ã˜Â§Ã™â€žÃ˜Â¥Ã˜ÂªÃ™â€ Ã™Å Ã™â€ _Ã˜Â§Ã™â€žÃ˜Â«Ã™â€žÃ˜Â§Ã˜Â«Ã˜Â§Ã˜Â¡_Ã˜Â§Ã™â€žÃ˜Â£Ã˜Â±Ã˜Â¨Ã˜Â¹Ã˜Â§Ã˜Â¡_Ã˜Â§Ã™â€žÃ˜Â®Ã™â€¦Ã™Å Ã˜Â³_Ã˜Â§Ã™â€žÃ˜Â¬Ã™â€¦Ã˜Â¹Ã˜Â©_Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â¨Ã˜Âª".split("_"),weekdaysShort:"Ã˜Â§Ã˜Â­Ã˜Â¯_Ã˜Â§Ã˜ÂªÃ™â€ Ã™Å Ã™â€ _Ã˜Â«Ã™â€žÃ˜Â§Ã˜Â«Ã˜Â§Ã˜Â¡_Ã˜Â§Ã˜Â±Ã˜Â¨Ã˜Â¹Ã˜Â§Ã˜Â¡_Ã˜Â®Ã™â€¦Ã™Å Ã˜Â³_Ã˜Â¬Ã™â€¦Ã˜Â¹Ã˜Â©_Ã˜Â³Ã˜Â¨Ã˜Âª".split("_"),weekdaysMin:"Ã˜Â­_Ã™â€ _Ã˜Â«_Ã˜Â±_Ã˜Â®_Ã˜Â¬_Ã˜Â³".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Ã˜Â§Ã™â€žÃ™Å Ã™Ë†Ã™â€¦ Ã˜Â¹Ã™â€žÃ™â€° Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",nextDay:"[Ã˜ÂºÃ˜Â¯Ã˜Â§ Ã˜Â¹Ã™â€žÃ™â€° Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",nextWeek:"dddd [Ã˜Â¹Ã™â€žÃ™â€° Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",lastDay:"[Ã˜Â£Ã™â€¦Ã˜Â³ Ã˜Â¹Ã™â€žÃ™â€° Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",lastWeek:"dddd [Ã˜Â¹Ã™â€žÃ™â€° Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",sameElse:"L"},relativeTime:{future:"Ã™ÂÃ™Å  %s",past:"Ã™â€¦Ã™â€ Ã˜Â° %s",s:"Ã˜Â«Ã™Ë†Ã˜Â§Ã™â€ ",m:"Ã˜Â¯Ã™â€šÃ™Å Ã™â€šÃ˜Â©",mm:"%d Ã˜Â¯Ã™â€šÃ˜Â§Ã˜Â¦Ã™â€š",h:"Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©",hh:"%d Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Â§Ã˜Âª",d:"Ã™Å Ã™Ë†Ã™â€¦",dd:"%d Ã˜Â£Ã™Å Ã˜Â§Ã™â€¦",M:"Ã˜Â´Ã™â€¡Ã˜Â±",MM:"%d Ã˜Â£Ã˜Â´Ã™â€¡Ã˜Â±",y:"Ã˜Â³Ã™â€ Ã˜Â©",yy:"%d Ã˜Â³Ã™â€ Ã™Ë†Ã˜Â§Ã˜Âª"},week:{dow:6,// Saturday is the first day of the week.
doy:12}}),{1:"Ã™Â¡",2:"Ã™Â¢",3:"Ã™Â£",4:"Ã™Â¤",5:"Ã™Â¥",6:"Ã™Â¦",7:"Ã™Â§",8:"Ã™Â¨",9:"Ã™Â©",0:"Ã™ "}),mg={"Ã™Â¡":"1","Ã™Â¢":"2","Ã™Â£":"3","Ã™Â¤":"4","Ã™Â¥":"5","Ã™Â¦":"6","Ã™Â§":"7","Ã™Â¨":"8","Ã™Â©":"9","Ã™ ":"0"},ng=(kg.defineLocale("ar-sa",{months:"Ã™Å Ã™â€ Ã˜Â§Ã™Å Ã˜Â±_Ã™ÂÃ˜Â¨Ã˜Â±Ã˜Â§Ã™Å Ã˜Â±_Ã™â€¦Ã˜Â§Ã˜Â±Ã˜Â³_Ã˜Â£Ã˜Â¨Ã˜Â±Ã™Å Ã™â€ž_Ã™â€¦Ã˜Â§Ã™Å Ã™Ë†_Ã™Å Ã™Ë†Ã™â€ Ã™Å Ã™Ë†_Ã™Å Ã™Ë†Ã™â€žÃ™Å Ã™Ë†_Ã˜Â£Ã˜ÂºÃ˜Â³Ã˜Â·Ã˜Â³_Ã˜Â³Ã˜Â¨Ã˜ÂªÃ™â€¦Ã˜Â¨Ã˜Â±_Ã˜Â£Ã™Æ’Ã˜ÂªÃ™Ë†Ã˜Â¨Ã˜Â±_Ã™â€ Ã™Ë†Ã™ÂÃ™â€¦Ã˜Â¨Ã˜Â±_Ã˜Â¯Ã™Å Ã˜Â³Ã™â€¦Ã˜Â¨Ã˜Â±".split("_"),monthsShort:"Ã™Å Ã™â€ Ã˜Â§Ã™Å Ã˜Â±_Ã™ÂÃ˜Â¨Ã˜Â±Ã˜Â§Ã™Å Ã˜Â±_Ã™â€¦Ã˜Â§Ã˜Â±Ã˜Â³_Ã˜Â£Ã˜Â¨Ã˜Â±Ã™Å Ã™â€ž_Ã™â€¦Ã˜Â§Ã™Å Ã™Ë†_Ã™Å Ã™Ë†Ã™â€ Ã™Å Ã™Ë†_Ã™Å Ã™Ë†Ã™â€žÃ™Å Ã™Ë†_Ã˜Â£Ã˜ÂºÃ˜Â³Ã˜Â·Ã˜Â³_Ã˜Â³Ã˜Â¨Ã˜ÂªÃ™â€¦Ã˜Â¨Ã˜Â±_Ã˜Â£Ã™Æ’Ã˜ÂªÃ™Ë†Ã˜Â¨Ã˜Â±_Ã™â€ Ã™Ë†Ã™ÂÃ™â€¦Ã˜Â¨Ã˜Â±_Ã˜Â¯Ã™Å Ã˜Â³Ã™â€¦Ã˜Â¨Ã˜Â±".split("_"),weekdays:"Ã˜Â§Ã™â€žÃ˜Â£Ã˜Â­Ã˜Â¯_Ã˜Â§Ã™â€žÃ˜Â¥Ã˜Â«Ã™â€ Ã™Å Ã™â€ _Ã˜Â§Ã™â€žÃ˜Â«Ã™â€žÃ˜Â§Ã˜Â«Ã˜Â§Ã˜Â¡_Ã˜Â§Ã™â€žÃ˜Â£Ã˜Â±Ã˜Â¨Ã˜Â¹Ã˜Â§Ã˜Â¡_Ã˜Â§Ã™â€žÃ˜Â®Ã™â€¦Ã™Å Ã˜Â³_Ã˜Â§Ã™â€žÃ˜Â¬Ã™â€¦Ã˜Â¹Ã˜Â©_Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â¨Ã˜Âª".split("_"),weekdaysShort:"Ã˜Â£Ã˜Â­Ã˜Â¯_Ã˜Â¥Ã˜Â«Ã™â€ Ã™Å Ã™â€ _Ã˜Â«Ã™â€žÃ˜Â§Ã˜Â«Ã˜Â§Ã˜Â¡_Ã˜Â£Ã˜Â±Ã˜Â¨Ã˜Â¹Ã˜Â§Ã˜Â¡_Ã˜Â®Ã™â€¦Ã™Å Ã˜Â³_Ã˜Â¬Ã™â€¦Ã˜Â¹Ã˜Â©_Ã˜Â³Ã˜Â¨Ã˜Âª".split("_"),weekdaysMin:"Ã˜Â­_Ã™â€ _Ã˜Â«_Ã˜Â±_Ã˜Â®_Ã˜Â¬_Ã˜Â³".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},meridiemParse:/Ã˜Âµ|Ã™â€¦/,isPM:function(a){return"Ã™â€¦"===a},meridiem:function(a,b,c){return 12>a?"Ã˜Âµ":"Ã™â€¦"},calendar:{sameDay:"[Ã˜Â§Ã™â€žÃ™Å Ã™Ë†Ã™â€¦ Ã˜Â¹Ã™â€žÃ™â€° Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",nextDay:"[Ã˜ÂºÃ˜Â¯Ã˜Â§ Ã˜Â¹Ã™â€žÃ™â€° Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",nextWeek:"dddd [Ã˜Â¹Ã™â€žÃ™â€° Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",lastDay:"[Ã˜Â£Ã™â€¦Ã˜Â³ Ã˜Â¹Ã™â€žÃ™â€° Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",lastWeek:"dddd [Ã˜Â¹Ã™â€žÃ™â€° Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",sameElse:"L"},relativeTime:{future:"Ã™ÂÃ™Å  %s",past:"Ã™â€¦Ã™â€ Ã˜Â° %s",s:"Ã˜Â«Ã™Ë†Ã˜Â§Ã™â€ ",m:"Ã˜Â¯Ã™â€šÃ™Å Ã™â€šÃ˜Â©",mm:"%d Ã˜Â¯Ã™â€šÃ˜Â§Ã˜Â¦Ã™â€š",h:"Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©",hh:"%d Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Â§Ã˜Âª",d:"Ã™Å Ã™Ë†Ã™â€¦",dd:"%d Ã˜Â£Ã™Å Ã˜Â§Ã™â€¦",M:"Ã˜Â´Ã™â€¡Ã˜Â±",MM:"%d Ã˜Â£Ã˜Â´Ã™â€¡Ã˜Â±",y:"Ã˜Â³Ã™â€ Ã˜Â©",yy:"%d Ã˜Â³Ã™â€ Ã™Ë†Ã˜Â§Ã˜Âª"},preparse:function(a){return a.replace(/[Ã™Â¡Ã™Â¢Ã™Â£Ã™Â¤Ã™Â¥Ã™Â¦Ã™Â§Ã™Â¨Ã™Â©Ã™ ]/g,function(a){return mg[a]}).replace(/Ã˜Å’/g,",")},postformat:function(a){return a.replace(/\d/g,function(a){return lg[a]}).replace(/,/g,"Ã˜Å’")},week:{dow:6,// Saturday is the first day of the week.
doy:12}}),kg.defineLocale("ar-tn",{months:"Ã˜Â¬Ã˜Â§Ã™â€ Ã™ÂÃ™Å _Ã™ÂÃ™Å Ã™ÂÃ˜Â±Ã™Å _Ã™â€¦Ã˜Â§Ã˜Â±Ã˜Â³_Ã˜Â£Ã™ÂÃ˜Â±Ã™Å Ã™â€ž_Ã™â€¦Ã˜Â§Ã™Å _Ã˜Â¬Ã™Ë†Ã˜Â§Ã™â€ _Ã˜Â¬Ã™Ë†Ã™Å Ã™â€žÃ™Å Ã˜Â©_Ã˜Â£Ã™Ë†Ã˜Âª_Ã˜Â³Ã˜Â¨Ã˜ÂªÃ™â€¦Ã˜Â¨Ã˜Â±_Ã˜Â£Ã™Æ’Ã˜ÂªÃ™Ë†Ã˜Â¨Ã˜Â±_Ã™â€ Ã™Ë†Ã™ÂÃ™â€¦Ã˜Â¨Ã˜Â±_Ã˜Â¯Ã™Å Ã˜Â³Ã™â€¦Ã˜Â¨Ã˜Â±".split("_"),monthsShort:"Ã˜Â¬Ã˜Â§Ã™â€ Ã™ÂÃ™Å _Ã™ÂÃ™Å Ã™ÂÃ˜Â±Ã™Å _Ã™â€¦Ã˜Â§Ã˜Â±Ã˜Â³_Ã˜Â£Ã™ÂÃ˜Â±Ã™Å Ã™â€ž_Ã™â€¦Ã˜Â§Ã™Å _Ã˜Â¬Ã™Ë†Ã˜Â§Ã™â€ _Ã˜Â¬Ã™Ë†Ã™Å Ã™â€žÃ™Å Ã˜Â©_Ã˜Â£Ã™Ë†Ã˜Âª_Ã˜Â³Ã˜Â¨Ã˜ÂªÃ™â€¦Ã˜Â¨Ã˜Â±_Ã˜Â£Ã™Æ’Ã˜ÂªÃ™Ë†Ã˜Â¨Ã˜Â±_Ã™â€ Ã™Ë†Ã™ÂÃ™â€¦Ã˜Â¨Ã˜Â±_Ã˜Â¯Ã™Å Ã˜Â³Ã™â€¦Ã˜Â¨Ã˜Â±".split("_"),weekdays:"Ã˜Â§Ã™â€žÃ˜Â£Ã˜Â­Ã˜Â¯_Ã˜Â§Ã™â€žÃ˜Â¥Ã˜Â«Ã™â€ Ã™Å Ã™â€ _Ã˜Â§Ã™â€žÃ˜Â«Ã™â€žÃ˜Â§Ã˜Â«Ã˜Â§Ã˜Â¡_Ã˜Â§Ã™â€žÃ˜Â£Ã˜Â±Ã˜Â¨Ã˜Â¹Ã˜Â§Ã˜Â¡_Ã˜Â§Ã™â€žÃ˜Â®Ã™â€¦Ã™Å Ã˜Â³_Ã˜Â§Ã™â€žÃ˜Â¬Ã™â€¦Ã˜Â¹Ã˜Â©_Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â¨Ã˜Âª".split("_"),weekdaysShort:"Ã˜Â£Ã˜Â­Ã˜Â¯_Ã˜Â¥Ã˜Â«Ã™â€ Ã™Å Ã™â€ _Ã˜Â«Ã™â€žÃ˜Â§Ã˜Â«Ã˜Â§Ã˜Â¡_Ã˜Â£Ã˜Â±Ã˜Â¨Ã˜Â¹Ã˜Â§Ã˜Â¡_Ã˜Â®Ã™â€¦Ã™Å Ã˜Â³_Ã˜Â¬Ã™â€¦Ã˜Â¹Ã˜Â©_Ã˜Â³Ã˜Â¨Ã˜Âª".split("_"),weekdaysMin:"Ã˜Â­_Ã™â€ _Ã˜Â«_Ã˜Â±_Ã˜Â®_Ã˜Â¬_Ã˜Â³".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Ã˜Â§Ã™â€žÃ™Å Ã™Ë†Ã™â€¦ Ã˜Â¹Ã™â€žÃ™â€° Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",nextDay:"[Ã˜ÂºÃ˜Â¯Ã˜Â§ Ã˜Â¹Ã™â€žÃ™â€° Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",nextWeek:"dddd [Ã˜Â¹Ã™â€žÃ™â€° Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",lastDay:"[Ã˜Â£Ã™â€¦Ã˜Â³ Ã˜Â¹Ã™â€žÃ™â€° Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",lastWeek:"dddd [Ã˜Â¹Ã™â€žÃ™â€° Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",sameElse:"L"},relativeTime:{future:"Ã™ÂÃ™Å  %s",past:"Ã™â€¦Ã™â€ Ã˜Â° %s",s:"Ã˜Â«Ã™Ë†Ã˜Â§Ã™â€ ",m:"Ã˜Â¯Ã™â€šÃ™Å Ã™â€šÃ˜Â©",mm:"%d Ã˜Â¯Ã™â€šÃ˜Â§Ã˜Â¦Ã™â€š",h:"Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©",hh:"%d Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Â§Ã˜Âª",d:"Ã™Å Ã™Ë†Ã™â€¦",dd:"%d Ã˜Â£Ã™Å Ã˜Â§Ã™â€¦",M:"Ã˜Â´Ã™â€¡Ã˜Â±",MM:"%d Ã˜Â£Ã˜Â´Ã™â€¡Ã˜Â±",y:"Ã˜Â³Ã™â€ Ã˜Â©",yy:"%d Ã˜Â³Ã™â€ Ã™Ë†Ã˜Â§Ã˜Âª"},week:{dow:1,// Monday is the first day of the week.
doy:4}}),{1:"Ã™Â¡",2:"Ã™Â¢",3:"Ã™Â£",4:"Ã™Â¤",5:"Ã™Â¥",6:"Ã™Â¦",7:"Ã™Â§",8:"Ã™Â¨",9:"Ã™Â©",0:"Ã™ "}),og={"Ã™Â¡":"1","Ã™Â¢":"2","Ã™Â£":"3","Ã™Â¤":"4","Ã™Â¥":"5","Ã™Â¦":"6","Ã™Â§":"7","Ã™Â¨":"8","Ã™Â©":"9","Ã™ ":"0"},pg=function(a){return 0===a?0:1===a?1:2===a?2:a%100>=3&&10>=a%100?3:a%100>=11?4:5},qg={s:["Ã˜Â£Ã™â€šÃ™â€ž Ã™â€¦Ã™â€  Ã˜Â«Ã˜Â§Ã™â€ Ã™Å Ã˜Â©","Ã˜Â«Ã˜Â§Ã™â€ Ã™Å Ã˜Â© Ã™Ë†Ã˜Â§Ã˜Â­Ã˜Â¯Ã˜Â©",["Ã˜Â«Ã˜Â§Ã™â€ Ã™Å Ã˜ÂªÃ˜Â§Ã™â€ ","Ã˜Â«Ã˜Â§Ã™â€ Ã™Å Ã˜ÂªÃ™Å Ã™â€ "],"%d Ã˜Â«Ã™Ë†Ã˜Â§Ã™â€ ","%d Ã˜Â«Ã˜Â§Ã™â€ Ã™Å Ã˜Â©","%d Ã˜Â«Ã˜Â§Ã™â€ Ã™Å Ã˜Â©"],m:["Ã˜Â£Ã™â€šÃ™â€ž Ã™â€¦Ã™â€  Ã˜Â¯Ã™â€šÃ™Å Ã™â€šÃ˜Â©","Ã˜Â¯Ã™â€šÃ™Å Ã™â€šÃ˜Â© Ã™Ë†Ã˜Â§Ã˜Â­Ã˜Â¯Ã˜Â©",["Ã˜Â¯Ã™â€šÃ™Å Ã™â€šÃ˜ÂªÃ˜Â§Ã™â€ ","Ã˜Â¯Ã™â€šÃ™Å Ã™â€šÃ˜ÂªÃ™Å Ã™â€ "],"%d Ã˜Â¯Ã™â€šÃ˜Â§Ã˜Â¦Ã™â€š","%d Ã˜Â¯Ã™â€šÃ™Å Ã™â€šÃ˜Â©","%d Ã˜Â¯Ã™â€šÃ™Å Ã™â€šÃ˜Â©"],h:["Ã˜Â£Ã™â€šÃ™â€ž Ã™â€¦Ã™â€  Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©","Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Â© Ã™Ë†Ã˜Â§Ã˜Â­Ã˜Â¯Ã˜Â©",["Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜ÂªÃ˜Â§Ã™â€ ","Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜ÂªÃ™Å Ã™â€ "],"%d Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Â§Ã˜Âª","%d Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©","%d Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©"],d:["Ã˜Â£Ã™â€šÃ™â€ž Ã™â€¦Ã™â€  Ã™Å Ã™Ë†Ã™â€¦","Ã™Å Ã™Ë†Ã™â€¦ Ã™Ë†Ã˜Â§Ã˜Â­Ã˜Â¯",["Ã™Å Ã™Ë†Ã™â€¦Ã˜Â§Ã™â€ ","Ã™Å Ã™Ë†Ã™â€¦Ã™Å Ã™â€ "],"%d Ã˜Â£Ã™Å Ã˜Â§Ã™â€¦","%d Ã™Å Ã™Ë†Ã™â€¦Ã™â€¹Ã˜Â§","%d Ã™Å Ã™Ë†Ã™â€¦"],M:["Ã˜Â£Ã™â€šÃ™â€ž Ã™â€¦Ã™â€  Ã˜Â´Ã™â€¡Ã˜Â±","Ã˜Â´Ã™â€¡Ã˜Â± Ã™Ë†Ã˜Â§Ã˜Â­Ã˜Â¯",["Ã˜Â´Ã™â€¡Ã˜Â±Ã˜Â§Ã™â€ ","Ã˜Â´Ã™â€¡Ã˜Â±Ã™Å Ã™â€ "],"%d Ã˜Â£Ã˜Â´Ã™â€¡Ã˜Â±","%d Ã˜Â´Ã™â€¡Ã˜Â±Ã˜Â§","%d Ã˜Â´Ã™â€¡Ã˜Â±"],y:["Ã˜Â£Ã™â€šÃ™â€ž Ã™â€¦Ã™â€  Ã˜Â¹Ã˜Â§Ã™â€¦","Ã˜Â¹Ã˜Â§Ã™â€¦ Ã™Ë†Ã˜Â§Ã˜Â­Ã˜Â¯",["Ã˜Â¹Ã˜Â§Ã™â€¦Ã˜Â§Ã™â€ ","Ã˜Â¹Ã˜Â§Ã™â€¦Ã™Å Ã™â€ "],"%d Ã˜Â£Ã˜Â¹Ã™Ë†Ã˜Â§Ã™â€¦","%d Ã˜Â¹Ã˜Â§Ã™â€¦Ã™â€¹Ã˜Â§","%d Ã˜Â¹Ã˜Â§Ã™â€¦"]},rg=function(a){return function(b,c,d,e){var f=pg(b),g=qg[a][pg(b)];return 2===f&&(g=g[c?0:1]),g.replace(/%d/i,b)}},sg=["Ã™Æ’Ã˜Â§Ã™â€ Ã™Ë†Ã™â€  Ã˜Â§Ã™â€žÃ˜Â«Ã˜Â§Ã™â€ Ã™Å  Ã™Å Ã™â€ Ã˜Â§Ã™Å Ã˜Â±","Ã˜Â´Ã˜Â¨Ã˜Â§Ã˜Â· Ã™ÂÃ˜Â¨Ã˜Â±Ã˜Â§Ã™Å Ã˜Â±","Ã˜Â¢Ã˜Â°Ã˜Â§Ã˜Â± Ã™â€¦Ã˜Â§Ã˜Â±Ã˜Â³","Ã™â€ Ã™Å Ã˜Â³Ã˜Â§Ã™â€  Ã˜Â£Ã˜Â¨Ã˜Â±Ã™Å Ã™â€ž","Ã˜Â£Ã™Å Ã˜Â§Ã˜Â± Ã™â€¦Ã˜Â§Ã™Å Ã™Ë†","Ã˜Â­Ã˜Â²Ã™Å Ã˜Â±Ã˜Â§Ã™â€  Ã™Å Ã™Ë†Ã™â€ Ã™Å Ã™Ë†","Ã˜ÂªÃ™â€¦Ã™Ë†Ã˜Â² Ã™Å Ã™Ë†Ã™â€žÃ™Å Ã™Ë†","Ã˜Â¢Ã˜Â¨ Ã˜Â£Ã˜ÂºÃ˜Â³Ã˜Â·Ã˜Â³","Ã˜Â£Ã™Å Ã™â€žÃ™Ë†Ã™â€ž Ã˜Â³Ã˜Â¨Ã˜ÂªÃ™â€¦Ã˜Â¨Ã˜Â±","Ã˜ÂªÃ˜Â´Ã˜Â±Ã™Å Ã™â€  Ã˜Â§Ã™â€žÃ˜Â£Ã™Ë†Ã™â€ž Ã˜Â£Ã™Æ’Ã˜ÂªÃ™Ë†Ã˜Â¨Ã˜Â±","Ã˜ÂªÃ˜Â´Ã˜Â±Ã™Å Ã™â€  Ã˜Â§Ã™â€žÃ˜Â«Ã˜Â§Ã™â€ Ã™Å  Ã™â€ Ã™Ë†Ã™ÂÃ™â€¦Ã˜Â¨Ã˜Â±","Ã™Æ’Ã˜Â§Ã™â€ Ã™Ë†Ã™â€  Ã˜Â§Ã™â€žÃ˜Â£Ã™Ë†Ã™â€ž Ã˜Â¯Ã™Å Ã˜Â³Ã™â€¦Ã˜Â¨Ã˜Â±"],tg=(kg.defineLocale("ar",{months:sg,monthsShort:sg,weekdays:"Ã˜Â§Ã™â€žÃ˜Â£Ã˜Â­Ã˜Â¯_Ã˜Â§Ã™â€žÃ˜Â¥Ã˜Â«Ã™â€ Ã™Å Ã™â€ _Ã˜Â§Ã™â€žÃ˜Â«Ã™â€žÃ˜Â§Ã˜Â«Ã˜Â§Ã˜Â¡_Ã˜Â§Ã™â€žÃ˜Â£Ã˜Â±Ã˜Â¨Ã˜Â¹Ã˜Â§Ã˜Â¡_Ã˜Â§Ã™â€žÃ˜Â®Ã™â€¦Ã™Å Ã˜Â³_Ã˜Â§Ã™â€žÃ˜Â¬Ã™â€¦Ã˜Â¹Ã˜Â©_Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â¨Ã˜Âª".split("_"),weekdaysShort:"Ã˜Â£Ã˜Â­Ã˜Â¯_Ã˜Â¥Ã˜Â«Ã™â€ Ã™Å Ã™â€ _Ã˜Â«Ã™â€žÃ˜Â§Ã˜Â«Ã˜Â§Ã˜Â¡_Ã˜Â£Ã˜Â±Ã˜Â¨Ã˜Â¹Ã˜Â§Ã˜Â¡_Ã˜Â®Ã™â€¦Ã™Å Ã˜Â³_Ã˜Â¬Ã™â€¦Ã˜Â¹Ã˜Â©_Ã˜Â³Ã˜Â¨Ã˜Âª".split("_"),weekdaysMin:"Ã˜Â­_Ã™â€ _Ã˜Â«_Ã˜Â±_Ã˜Â®_Ã˜Â¬_Ã˜Â³".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"D/Ã¢â‚¬ÂM/Ã¢â‚¬ÂYYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},meridiemParse:/Ã˜Âµ|Ã™â€¦/,isPM:function(a){return"Ã™â€¦"===a},meridiem:function(a,b,c){return 12>a?"Ã˜Âµ":"Ã™â€¦"},calendar:{sameDay:"[Ã˜Â§Ã™â€žÃ™Å Ã™Ë†Ã™â€¦ Ã˜Â¹Ã™â€ Ã˜Â¯ Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",nextDay:"[Ã˜ÂºÃ˜Â¯Ã™â€¹Ã˜Â§ Ã˜Â¹Ã™â€ Ã˜Â¯ Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",nextWeek:"dddd [Ã˜Â¹Ã™â€ Ã˜Â¯ Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",lastDay:"[Ã˜Â£Ã™â€¦Ã˜Â³ Ã˜Â¹Ã™â€ Ã˜Â¯ Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",lastWeek:"dddd [Ã˜Â¹Ã™â€ Ã˜Â¯ Ã˜Â§Ã™â€žÃ˜Â³Ã˜Â§Ã˜Â¹Ã˜Â©] LT",sameElse:"L"},relativeTime:{future:"Ã˜Â¨Ã˜Â¹Ã˜Â¯ %s",past:"Ã™â€¦Ã™â€ Ã˜Â° %s",s:rg("s"),m:rg("m"),mm:rg("m"),h:rg("h"),hh:rg("h"),d:rg("d"),dd:rg("d"),M:rg("M"),MM:rg("M"),y:rg("y"),yy:rg("y")},preparse:function(a){return a.replace(/\u200f/g,"").replace(/[Ã™Â¡Ã™Â¢Ã™Â£Ã™Â¤Ã™Â¥Ã™Â¦Ã™Â§Ã™Â¨Ã™Â©Ã™ ]/g,function(a){return og[a]}).replace(/Ã˜Å’/g,",")},postformat:function(a){return a.replace(/\d/g,function(a){return ng[a]}).replace(/,/g,"Ã˜Å’")},week:{dow:6,// Saturday is the first day of the week.
doy:12}}),{1:"-inci",5:"-inci",8:"-inci",70:"-inci",80:"-inci",2:"-nci",7:"-nci",20:"-nci",50:"-nci",3:"-ÃƒÂ¼ncÃƒÂ¼",4:"-ÃƒÂ¼ncÃƒÂ¼",100:"-ÃƒÂ¼ncÃƒÂ¼",6:"-ncÃ„Â±",9:"-uncu",10:"-uncu",30:"-uncu",60:"-Ã„Â±ncÃ„Â±",90:"-Ã„Â±ncÃ„Â±"}),ug=(kg.defineLocale("az",{months:"yanvar_fevral_mart_aprel_may_iyun_iyul_avqust_sentyabr_oktyabr_noyabr_dekabr".split("_"),monthsShort:"yan_fev_mar_apr_may_iyn_iyl_avq_sen_okt_noy_dek".split("_"),weekdays:"Bazar_Bazar ertÃ‰â„¢si_Ãƒâ€¡Ã‰â„¢rÃ…Å¸Ã‰â„¢nbÃ‰â„¢ axÃ…Å¸amÃ„Â±_Ãƒâ€¡Ã‰â„¢rÃ…Å¸Ã‰â„¢nbÃ‰â„¢_CÃƒÂ¼mÃ‰â„¢ axÃ…Å¸amÃ„Â±_CÃƒÂ¼mÃ‰â„¢_Ã…Å¾Ã‰â„¢nbÃ‰â„¢".split("_"),weekdaysShort:"Baz_BzE_Ãƒâ€¡Ax_Ãƒâ€¡Ã‰â„¢r_CAx_CÃƒÂ¼m_Ã…Å¾Ã‰â„¢n".split("_"),weekdaysMin:"Bz_BE_Ãƒâ€¡A_Ãƒâ€¡Ã‰â„¢_CA_CÃƒÂ¼_Ã…Å¾Ã‰â„¢".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[bugÃƒÂ¼n saat] LT",nextDay:"[sabah saat] LT",nextWeek:"[gÃ‰â„¢lÃ‰â„¢n hÃ‰â„¢ftÃ‰â„¢] dddd [saat] LT",lastDay:"[dÃƒÂ¼nÃ‰â„¢n] LT",lastWeek:"[keÃƒÂ§Ã‰â„¢n hÃ‰â„¢ftÃ‰â„¢] dddd [saat] LT",sameElse:"L"},relativeTime:{future:"%s sonra",past:"%s Ã‰â„¢vvÃ‰â„¢l",s:"birneÃƒÂ§Ã‰â„¢ saniyyÃ‰â„¢",m:"bir dÃ‰â„¢qiqÃ‰â„¢",mm:"%d dÃ‰â„¢qiqÃ‰â„¢",h:"bir saat",hh:"%d saat",d:"bir gÃƒÂ¼n",dd:"%d gÃƒÂ¼n",M:"bir ay",MM:"%d ay",y:"bir il",yy:"%d il"},meridiemParse:/gecÃ‰â„¢|sÃ‰â„¢hÃ‰â„¢r|gÃƒÂ¼ndÃƒÂ¼z|axÃ…Å¸am/,isPM:function(a){return/^(gÃƒÂ¼ndÃƒÂ¼z|axÃ…Å¸am)$/.test(a)},meridiem:function(a,b,c){return 4>a?"gecÃ‰â„¢":12>a?"sÃ‰â„¢hÃ‰â„¢r":17>a?"gÃƒÂ¼ndÃƒÂ¼z":"axÃ…Å¸am"},ordinalParse:/\d{1,2}-(Ã„Â±ncÃ„Â±|inci|nci|ÃƒÂ¼ncÃƒÂ¼|ncÃ„Â±|uncu)/,ordinal:function(a){if(0===a)// special case for zero
return a+"-Ã„Â±ncÃ„Â±";var b=a%10,c=a%100-b,d=a>=100?100:null;return a+(tg[b]||tg[c]||tg[d])},week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("be",{months:{format:"Ã‘ÂÃ‘â€šÃ‘Æ’ÃÂ´ÃÂ·ÃÂµÃÂ½Ã‘Â_ÃÂ»Ã‘Å½Ã‘â€šÃÂ°ÃÂ³ÃÂ°_Ã‘ÂÃÂ°ÃÂºÃÂ°ÃÂ²Ã‘â€“ÃÂºÃÂ°_ÃÂºÃ‘â‚¬ÃÂ°Ã‘ÂÃÂ°ÃÂ²Ã‘â€“ÃÂºÃÂ°_Ã‘â€šÃ‘â‚¬ÃÂ°Ã‘Å¾ÃÂ½Ã‘Â_Ã‘â€¡Ã‘ÂÃ‘â‚¬ÃÂ²ÃÂµÃÂ½Ã‘Â_ÃÂ»Ã‘â€“ÃÂ¿ÃÂµÃÂ½Ã‘Â_ÃÂ¶ÃÂ½Ã‘â€“Ã‘Å¾ÃÂ½Ã‘Â_ÃÂ²ÃÂµÃ‘â‚¬ÃÂ°Ã‘ÂÃÂ½Ã‘Â_ÃÂºÃÂ°Ã‘ÂÃ‘â€šÃ‘â‚¬Ã‘â€¹Ã‘â€¡ÃÂ½Ã‘â€“ÃÂºÃÂ°_ÃÂ»Ã‘â€“Ã‘ÂÃ‘â€šÃÂ°ÃÂ¿ÃÂ°ÃÂ´ÃÂ°_Ã‘ÂÃÂ½ÃÂµÃÂ¶ÃÂ½Ã‘Â".split("_"),standalone:"Ã‘ÂÃ‘â€šÃ‘Æ’ÃÂ´ÃÂ·ÃÂµÃÂ½Ã‘Å’_ÃÂ»Ã‘Å½Ã‘â€šÃ‘â€¹_Ã‘ÂÃÂ°ÃÂºÃÂ°ÃÂ²Ã‘â€“ÃÂº_ÃÂºÃ‘â‚¬ÃÂ°Ã‘ÂÃÂ°ÃÂ²Ã‘â€“ÃÂº_Ã‘â€šÃ‘â‚¬ÃÂ°ÃÂ²ÃÂµÃÂ½Ã‘Å’_Ã‘â€¡Ã‘ÂÃ‘â‚¬ÃÂ²ÃÂµÃÂ½Ã‘Å’_ÃÂ»Ã‘â€“ÃÂ¿ÃÂµÃÂ½Ã‘Å’_ÃÂ¶ÃÂ½Ã‘â€“ÃÂ²ÃÂµÃÂ½Ã‘Å’_ÃÂ²ÃÂµÃ‘â‚¬ÃÂ°Ã‘ÂÃÂµÃÂ½Ã‘Å’_ÃÂºÃÂ°Ã‘ÂÃ‘â€šÃ‘â‚¬Ã‘â€¹Ã‘â€¡ÃÂ½Ã‘â€“ÃÂº_ÃÂ»Ã‘â€“Ã‘ÂÃ‘â€šÃÂ°ÃÂ¿ÃÂ°ÃÂ´_Ã‘ÂÃÂ½ÃÂµÃÂ¶ÃÂ°ÃÂ½Ã‘Å’".split("_")},monthsShort:"Ã‘ÂÃ‘â€šÃ‘Æ’ÃÂ´_ÃÂ»Ã‘Å½Ã‘â€š_Ã‘ÂÃÂ°ÃÂº_ÃÂºÃ‘â‚¬ÃÂ°Ã‘Â_Ã‘â€šÃ‘â‚¬ÃÂ°ÃÂ²_Ã‘â€¡Ã‘ÂÃ‘â‚¬ÃÂ²_ÃÂ»Ã‘â€“ÃÂ¿_ÃÂ¶ÃÂ½Ã‘â€“ÃÂ²_ÃÂ²ÃÂµÃ‘â‚¬_ÃÂºÃÂ°Ã‘ÂÃ‘â€š_ÃÂ»Ã‘â€“Ã‘ÂÃ‘â€š_Ã‘ÂÃÂ½ÃÂµÃÂ¶".split("_"),weekdays:{format:"ÃÂ½Ã‘ÂÃÂ´ÃÂ·ÃÂµÃÂ»Ã‘Å½_ÃÂ¿ÃÂ°ÃÂ½Ã‘ÂÃÂ´ÃÂ·ÃÂµÃÂ»ÃÂ°ÃÂº_ÃÂ°Ã‘Å¾Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ°ÃÂº_Ã‘ÂÃÂµÃ‘â‚¬ÃÂ°ÃÂ´Ã‘Æ’_Ã‘â€¡ÃÂ°Ã‘â€ ÃÂ²ÃÂµÃ‘â‚¬_ÃÂ¿Ã‘ÂÃ‘â€šÃÂ½Ã‘â€“Ã‘â€ Ã‘Æ’_Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃ‘Æ’".split("_"),standalone:"ÃÂ½Ã‘ÂÃÂ´ÃÂ·ÃÂµÃÂ»Ã‘Â_ÃÂ¿ÃÂ°ÃÂ½Ã‘ÂÃÂ´ÃÂ·ÃÂµÃÂ»ÃÂ°ÃÂº_ÃÂ°Ã‘Å¾Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ°ÃÂº_Ã‘ÂÃÂµÃ‘â‚¬ÃÂ°ÃÂ´ÃÂ°_Ã‘â€¡ÃÂ°Ã‘â€ ÃÂ²ÃÂµÃ‘â‚¬_ÃÂ¿Ã‘ÂÃ‘â€šÃÂ½Ã‘â€“Ã‘â€ ÃÂ°_Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃÂ°".split("_"),isFormat:/\[ ?[Ãâ€™ÃÂ²] ?(?:ÃÂ¼Ã‘â€“ÃÂ½Ã‘Æ’ÃÂ»Ã‘Æ’Ã‘Å½|ÃÂ½ÃÂ°Ã‘ÂÃ‘â€šÃ‘Æ’ÃÂ¿ÃÂ½Ã‘Æ’Ã‘Å½)? ?\] ?dddd/},weekdaysShort:"ÃÂ½ÃÂ´_ÃÂ¿ÃÂ½_ÃÂ°Ã‘â€š_Ã‘ÂÃ‘â‚¬_Ã‘â€¡Ã‘â€ _ÃÂ¿Ã‘â€š_Ã‘ÂÃÂ±".split("_"),weekdaysMin:"ÃÂ½ÃÂ´_ÃÂ¿ÃÂ½_ÃÂ°Ã‘â€š_Ã‘ÂÃ‘â‚¬_Ã‘â€¡Ã‘â€ _ÃÂ¿Ã‘â€š_Ã‘ÂÃÂ±".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY ÃÂ³.",LLL:"D MMMM YYYY ÃÂ³., HH:mm",LLLL:"dddd, D MMMM YYYY ÃÂ³., HH:mm"},calendar:{sameDay:"[ÃÂ¡Ã‘â€˜ÃÂ½ÃÂ½Ã‘Â Ã‘Å¾] LT",nextDay:"[Ãâ€”ÃÂ°Ã‘Å¾Ã‘â€šÃ‘â‚¬ÃÂ° Ã‘Å¾] LT",lastDay:"[ÃÂ£Ã‘â€¡ÃÂ¾Ã‘â‚¬ÃÂ° Ã‘Å¾] LT",nextWeek:function(){return"[ÃÂ£] dddd [Ã‘Å¾] LT"},lastWeek:function(){switch(this.day()){case 0:case 3:case 5:case 6:return"[ÃÂ£ ÃÂ¼Ã‘â€“ÃÂ½Ã‘Æ’ÃÂ»Ã‘Æ’Ã‘Å½] dddd [Ã‘Å¾] LT";case 1:case 2:case 4:return"[ÃÂ£ ÃÂ¼Ã‘â€“ÃÂ½Ã‘Æ’ÃÂ»Ã‘â€¹] dddd [Ã‘Å¾] LT"}},sameElse:"L"},relativeTime:{future:"ÃÂ¿Ã‘â‚¬ÃÂ°ÃÂ· %s",past:"%s Ã‘â€šÃÂ°ÃÂ¼Ã‘Æ’",s:"ÃÂ½ÃÂµÃÂºÃÂ°ÃÂ»Ã‘Å’ÃÂºÃ‘â€“ Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´",m:nd,mm:nd,h:nd,hh:nd,d:"ÃÂ´ÃÂ·ÃÂµÃÂ½Ã‘Å’",dd:nd,M:"ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ ",MM:nd,y:"ÃÂ³ÃÂ¾ÃÂ´",yy:nd},meridiemParse:/ÃÂ½ÃÂ¾Ã‘â€¡Ã‘â€¹|Ã‘â‚¬ÃÂ°ÃÂ½Ã‘â€“Ã‘â€ Ã‘â€¹|ÃÂ´ÃÂ½Ã‘Â|ÃÂ²ÃÂµÃ‘â€¡ÃÂ°Ã‘â‚¬ÃÂ°/,isPM:function(a){return/^(ÃÂ´ÃÂ½Ã‘Â|ÃÂ²ÃÂµÃ‘â€¡ÃÂ°Ã‘â‚¬ÃÂ°)$/.test(a)},meridiem:function(a,b,c){return 4>a?"ÃÂ½ÃÂ¾Ã‘â€¡Ã‘â€¹":12>a?"Ã‘â‚¬ÃÂ°ÃÂ½Ã‘â€“Ã‘â€ Ã‘â€¹":17>a?"ÃÂ´ÃÂ½Ã‘Â":"ÃÂ²ÃÂµÃ‘â€¡ÃÂ°Ã‘â‚¬ÃÂ°"},ordinalParse:/\d{1,2}-(Ã‘â€“|Ã‘â€¹|ÃÂ³ÃÂ°)/,ordinal:function(a,b){switch(b){case"M":case"d":case"DDD":case"w":case"W":return a%10!==2&&a%10!==3||a%100===12||a%100===13?a+"-Ã‘â€¹":a+"-Ã‘â€“";case"D":return a+"-ÃÂ³ÃÂ°";default:return a}},week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("bg",{months:"Ã‘ÂÃÂ½Ã‘Æ’ÃÂ°Ã‘â‚¬ÃÂ¸_Ã‘â€žÃÂµÃÂ²Ã‘â‚¬Ã‘Æ’ÃÂ°Ã‘â‚¬ÃÂ¸_ÃÂ¼ÃÂ°Ã‘â‚¬Ã‘â€š_ÃÂ°ÃÂ¿Ã‘â‚¬ÃÂ¸ÃÂ»_ÃÂ¼ÃÂ°ÃÂ¹_Ã‘Å½ÃÂ½ÃÂ¸_Ã‘Å½ÃÂ»ÃÂ¸_ÃÂ°ÃÂ²ÃÂ³Ã‘Æ’Ã‘ÂÃ‘â€š_Ã‘ÂÃÂµÃÂ¿Ã‘â€šÃÂµÃÂ¼ÃÂ²Ã‘â‚¬ÃÂ¸_ÃÂ¾ÃÂºÃ‘â€šÃÂ¾ÃÂ¼ÃÂ²Ã‘â‚¬ÃÂ¸_ÃÂ½ÃÂ¾ÃÂµÃÂ¼ÃÂ²Ã‘â‚¬ÃÂ¸_ÃÂ´ÃÂµÃÂºÃÂµÃÂ¼ÃÂ²Ã‘â‚¬ÃÂ¸".split("_"),monthsShort:"Ã‘ÂÃÂ½Ã‘â‚¬_Ã‘â€žÃÂµÃÂ²_ÃÂ¼ÃÂ°Ã‘â‚¬_ÃÂ°ÃÂ¿Ã‘â‚¬_ÃÂ¼ÃÂ°ÃÂ¹_Ã‘Å½ÃÂ½ÃÂ¸_Ã‘Å½ÃÂ»ÃÂ¸_ÃÂ°ÃÂ²ÃÂ³_Ã‘ÂÃÂµÃÂ¿_ÃÂ¾ÃÂºÃ‘â€š_ÃÂ½ÃÂ¾ÃÂµ_ÃÂ´ÃÂµÃÂº".split("_"),weekdays:"ÃÂ½ÃÂµÃÂ´ÃÂµÃÂ»Ã‘Â_ÃÂ¿ÃÂ¾ÃÂ½ÃÂµÃÂ´ÃÂµÃÂ»ÃÂ½ÃÂ¸ÃÂº_ÃÂ²Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ½ÃÂ¸ÃÂº_Ã‘ÂÃ‘â‚¬Ã‘ÂÃÂ´ÃÂ°_Ã‘â€¡ÃÂµÃ‘â€šÃÂ²Ã‘Å Ã‘â‚¬Ã‘â€šÃ‘Å ÃÂº_ÃÂ¿ÃÂµÃ‘â€šÃ‘Å ÃÂº_Ã‘ÂÃ‘Å ÃÂ±ÃÂ¾Ã‘â€šÃÂ°".split("_"),weekdaysShort:"ÃÂ½ÃÂµÃÂ´_ÃÂ¿ÃÂ¾ÃÂ½_ÃÂ²Ã‘â€šÃÂ¾_Ã‘ÂÃ‘â‚¬Ã‘Â_Ã‘â€¡ÃÂµÃ‘â€š_ÃÂ¿ÃÂµÃ‘â€š_Ã‘ÂÃ‘Å ÃÂ±".split("_"),weekdaysMin:"ÃÂ½ÃÂ´_ÃÂ¿ÃÂ½_ÃÂ²Ã‘â€š_Ã‘ÂÃ‘â‚¬_Ã‘â€¡Ã‘â€š_ÃÂ¿Ã‘â€š_Ã‘ÂÃÂ±".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"D.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY H:mm",LLLL:"dddd, D MMMM YYYY H:mm"},calendar:{sameDay:"[Ãâ€ÃÂ½ÃÂµÃ‘Â ÃÂ²] LT",nextDay:"[ÃÂ£Ã‘â€šÃ‘â‚¬ÃÂµ ÃÂ²] LT",nextWeek:"dddd [ÃÂ²] LT",lastDay:"[Ãâ€™Ã‘â€¡ÃÂµÃ‘â‚¬ÃÂ° ÃÂ²] LT",lastWeek:function(){switch(this.day()){case 0:case 3:case 6:return"[Ãâ€™ ÃÂ¸ÃÂ·ÃÂ¼ÃÂ¸ÃÂ½ÃÂ°ÃÂ»ÃÂ°Ã‘â€šÃÂ°] dddd [ÃÂ²] LT";case 1:case 2:case 4:case 5:return"[Ãâ€™ ÃÂ¸ÃÂ·ÃÂ¼ÃÂ¸ÃÂ½ÃÂ°ÃÂ»ÃÂ¸Ã‘Â] dddd [ÃÂ²] LT"}},sameElse:"L"},relativeTime:{future:"Ã‘ÂÃÂ»ÃÂµÃÂ´ %s",past:"ÃÂ¿Ã‘â‚¬ÃÂµÃÂ´ÃÂ¸ %s",s:"ÃÂ½Ã‘ÂÃÂºÃÂ¾ÃÂ»ÃÂºÃÂ¾ Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ¸",m:"ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€šÃÂ°",mm:"%d ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€šÃÂ¸",h:"Ã‘â€¡ÃÂ°Ã‘Â",hh:"%d Ã‘â€¡ÃÂ°Ã‘ÂÃÂ°",d:"ÃÂ´ÃÂµÃÂ½",dd:"%d ÃÂ´ÃÂ½ÃÂ¸",M:"ÃÂ¼ÃÂµÃ‘ÂÃÂµÃ‘â€ ",MM:"%d ÃÂ¼ÃÂµÃ‘ÂÃÂµÃ‘â€ ÃÂ°",y:"ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ°",yy:"%d ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ¸"},ordinalParse:/\d{1,2}-(ÃÂµÃÂ²|ÃÂµÃÂ½|Ã‘â€šÃÂ¸|ÃÂ²ÃÂ¸|Ã‘â‚¬ÃÂ¸|ÃÂ¼ÃÂ¸)/,ordinal:function(a){var b=a%10,c=a%100;return 0===a?a+"-ÃÂµÃÂ²":0===c?a+"-ÃÂµÃÂ½":c>10&&20>c?a+"-Ã‘â€šÃÂ¸":1===b?a+"-ÃÂ²ÃÂ¸":2===b?a+"-Ã‘â‚¬ÃÂ¸":7===b||8===b?a+"-ÃÂ¼ÃÂ¸":a+"-Ã‘â€šÃÂ¸"},week:{dow:1,// Monday is the first day of the week.
doy:7}}),{1:"Ã Â§Â§",2:"Ã Â§Â¨",3:"Ã Â§Â©",4:"Ã Â§Âª",5:"Ã Â§Â«",6:"Ã Â§Â¬",7:"Ã Â§Â­",8:"Ã Â§Â®",9:"Ã Â§Â¯",0:"Ã Â§Â¦"}),vg={"Ã Â§Â§":"1","Ã Â§Â¨":"2","Ã Â§Â©":"3","Ã Â§Âª":"4","Ã Â§Â«":"5","Ã Â§Â¬":"6","Ã Â§Â­":"7","Ã Â§Â®":"8","Ã Â§Â¯":"9","Ã Â§Â¦":"0"},wg=(kg.defineLocale("bn",{months:"Ã Â¦Å“Ã Â¦Â¾Ã Â¦Â¨Ã Â§ÂÃ Â§Å¸Ã Â¦Â¾Ã Â¦Â°Ã Â§â‚¬_Ã Â¦Â«Ã Â§â€¡Ã Â¦Â¬Ã Â§ÂÃ Â§Å¸Ã Â¦Â¾Ã Â¦Â°Ã Â§â‚¬_Ã Â¦Â®Ã Â¦Â¾Ã Â¦Â°Ã Â§ÂÃ Â¦Å¡_Ã Â¦ÂÃ Â¦ÂªÃ Â§ÂÃ Â¦Â°Ã Â¦Â¿Ã Â¦Â²_Ã Â¦Â®Ã Â§â€¡_Ã Â¦Å“Ã Â§ÂÃ Â¦Â¨_Ã Â¦Å“Ã Â§ÂÃ Â¦Â²Ã Â¦Â¾Ã Â¦â€¡_Ã Â¦â€¦Ã Â¦â€”Ã Â¦Â¾Ã Â¦Â¸Ã Â§ÂÃ Â¦Å¸_Ã Â¦Â¸Ã Â§â€¡Ã Â¦ÂªÃ Â§ÂÃ Â¦Å¸Ã Â§â€¡Ã Â¦Â®Ã Â§ÂÃ Â¦Â¬Ã Â¦Â°_Ã Â¦â€¦Ã Â¦â€¢Ã Â§ÂÃ Â¦Å¸Ã Â§â€¹Ã Â¦Â¬Ã Â¦Â°_Ã Â¦Â¨Ã Â¦Â­Ã Â§â€¡Ã Â¦Â®Ã Â§ÂÃ Â¦Â¬Ã Â¦Â°_Ã Â¦Â¡Ã Â¦Â¿Ã Â¦Â¸Ã Â§â€¡Ã Â¦Â®Ã Â§ÂÃ Â¦Â¬Ã Â¦Â°".split("_"),monthsShort:"Ã Â¦Å“Ã Â¦Â¾Ã Â¦Â¨Ã Â§Â_Ã Â¦Â«Ã Â§â€¡Ã Â¦Â¬_Ã Â¦Â®Ã Â¦Â¾Ã Â¦Â°Ã Â§ÂÃ Â¦Å¡_Ã Â¦ÂÃ Â¦ÂªÃ Â¦Â°_Ã Â¦Â®Ã Â§â€¡_Ã Â¦Å“Ã Â§ÂÃ Â¦Â¨_Ã Â¦Å“Ã Â§ÂÃ Â¦Â²_Ã Â¦â€¦Ã Â¦â€”_Ã Â¦Â¸Ã Â§â€¡Ã Â¦ÂªÃ Â§ÂÃ Â¦Å¸_Ã Â¦â€¦Ã Â¦â€¢Ã Â§ÂÃ Â¦Å¸Ã Â§â€¹_Ã Â¦Â¨Ã Â¦Â­_Ã Â¦Â¡Ã Â¦Â¿Ã Â¦Â¸Ã Â§â€¡Ã Â¦Â®Ã Â§Â".split("_"),weekdays:"Ã Â¦Â°Ã Â¦Â¬Ã Â¦Â¿Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°_Ã Â¦Â¸Ã Â§â€¹Ã Â¦Â®Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°_Ã Â¦Â®Ã Â¦â„¢Ã Â§ÂÃ Â¦â€”Ã Â¦Â²Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°_Ã Â¦Â¬Ã Â§ÂÃ Â¦Â§Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°_Ã Â¦Â¬Ã Â§Æ’Ã Â¦Â¹Ã Â¦Â¸Ã Â§ÂÃ Â¦ÂªÃ Â¦Â¤Ã Â§ÂÃ Â¦Â¤Ã Â¦Â¿Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°_Ã Â¦Â¶Ã Â§ÂÃ Â¦â€¢Ã Â§ÂÃ Â¦Â°Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°_Ã Â¦Â¶Ã Â¦Â¨Ã Â¦Â¿Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°".split("_"),weekdaysShort:"Ã Â¦Â°Ã Â¦Â¬Ã Â¦Â¿_Ã Â¦Â¸Ã Â§â€¹Ã Â¦Â®_Ã Â¦Â®Ã Â¦â„¢Ã Â§ÂÃ Â¦â€”Ã Â¦Â²_Ã Â¦Â¬Ã Â§ÂÃ Â¦Â§_Ã Â¦Â¬Ã Â§Æ’Ã Â¦Â¹Ã Â¦Â¸Ã Â§ÂÃ Â¦ÂªÃ Â¦Â¤Ã Â§ÂÃ Â¦Â¤Ã Â¦Â¿_Ã Â¦Â¶Ã Â§ÂÃ Â¦â€¢Ã Â§ÂÃ Â¦Â°_Ã Â¦Â¶Ã Â¦Â¨Ã Â¦Â¿".split("_"),weekdaysMin:"Ã Â¦Â°Ã Â¦Â¬_Ã Â¦Â¸Ã Â¦Â®_Ã Â¦Â®Ã Â¦â„¢Ã Â§ÂÃ Â¦â€”_Ã Â¦Â¬Ã Â§Â_Ã Â¦Â¬Ã Â§ÂÃ Â¦Â°Ã Â¦Â¿Ã Â¦Â¹_Ã Â¦Â¶Ã Â§Â_Ã Â¦Â¶Ã Â¦Â¨Ã Â¦Â¿".split("_"),longDateFormat:{LT:"A h:mm Ã Â¦Â¸Ã Â¦Â®Ã Â§Å¸",LTS:"A h:mm:ss Ã Â¦Â¸Ã Â¦Â®Ã Â§Å¸",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm Ã Â¦Â¸Ã Â¦Â®Ã Â§Å¸",LLLL:"dddd, D MMMM YYYY, A h:mm Ã Â¦Â¸Ã Â¦Â®Ã Â§Å¸"},calendar:{sameDay:"[Ã Â¦â€ Ã Â¦Å“] LT",nextDay:"[Ã Â¦â€ Ã Â¦â€”Ã Â¦Â¾Ã Â¦Â®Ã Â§â‚¬Ã Â¦â€¢Ã Â¦Â¾Ã Â¦Â²] LT",nextWeek:"dddd, LT",lastDay:"[Ã Â¦â€”Ã Â¦Â¤Ã Â¦â€¢Ã Â¦Â¾Ã Â¦Â²] LT",lastWeek:"[Ã Â¦â€”Ã Â¦Â¤] dddd, LT",sameElse:"L"},relativeTime:{future:"%s Ã Â¦ÂªÃ Â¦Â°Ã Â§â€¡",past:"%s Ã Â¦â€ Ã Â¦â€”Ã Â§â€¡",s:"Ã Â¦â€¢Ã Â§Å¸Ã Â§â€¡Ã Â¦â€¢ Ã Â¦Â¸Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¡",m:"Ã Â¦ÂÃ Â¦â€¢ Ã Â¦Â®Ã Â¦Â¿Ã Â¦Â¨Ã Â¦Â¿Ã Â¦Å¸",mm:"%d Ã Â¦Â®Ã Â¦Â¿Ã Â¦Â¨Ã Â¦Â¿Ã Â¦Å¸",h:"Ã Â¦ÂÃ Â¦â€¢ Ã Â¦ËœÃ Â¦Â¨Ã Â§ÂÃ Â¦Å¸Ã Â¦Â¾",hh:"%d Ã Â¦ËœÃ Â¦Â¨Ã Â§ÂÃ Â¦Å¸Ã Â¦Â¾",d:"Ã Â¦ÂÃ Â¦â€¢ Ã Â¦Â¦Ã Â¦Â¿Ã Â¦Â¨",dd:"%d Ã Â¦Â¦Ã Â¦Â¿Ã Â¦Â¨",M:"Ã Â¦ÂÃ Â¦â€¢ Ã Â¦Â®Ã Â¦Â¾Ã Â¦Â¸",MM:"%d Ã Â¦Â®Ã Â¦Â¾Ã Â¦Â¸",y:"Ã Â¦ÂÃ Â¦â€¢ Ã Â¦Â¬Ã Â¦â€ºÃ Â¦Â°",yy:"%d Ã Â¦Â¬Ã Â¦â€ºÃ Â¦Â°"},preparse:function(a){return a.replace(/[Ã Â§Â§Ã Â§Â¨Ã Â§Â©Ã Â§ÂªÃ Â§Â«Ã Â§Â¬Ã Â§Â­Ã Â§Â®Ã Â§Â¯Ã Â§Â¦]/g,function(a){return vg[a]})},postformat:function(a){return a.replace(/\d/g,function(a){return ug[a]})},meridiemParse:/Ã Â¦Â°Ã Â¦Â¾Ã Â¦Â¤|Ã Â¦Â¸Ã Â¦â€¢Ã Â¦Â¾Ã Â¦Â²|Ã Â¦Â¦Ã Â§ÂÃ Â¦ÂªÃ Â§ÂÃ Â¦Â°|Ã Â¦Â¬Ã Â¦Â¿Ã Â¦â€¢Ã Â¦Â¾Ã Â¦Â²|Ã Â¦Â°Ã Â¦Â¾Ã Â¦Â¤/,meridiemHour:function(a,b){return 12===a&&(a=0),"Ã Â¦Â°Ã Â¦Â¾Ã Â¦Â¤"===b&&a>=4||"Ã Â¦Â¦Ã Â§ÂÃ Â¦ÂªÃ Â§ÂÃ Â¦Â°"===b&&5>a||"Ã Â¦Â¬Ã Â¦Â¿Ã Â¦â€¢Ã Â¦Â¾Ã Â¦Â²"===b?a+12:a},meridiem:function(a,b,c){return 4>a?"Ã Â¦Â°Ã Â¦Â¾Ã Â¦Â¤":10>a?"Ã Â¦Â¸Ã Â¦â€¢Ã Â¦Â¾Ã Â¦Â²":17>a?"Ã Â¦Â¦Ã Â§ÂÃ Â¦ÂªÃ Â§ÂÃ Â¦Â°":20>a?"Ã Â¦Â¬Ã Â¦Â¿Ã Â¦â€¢Ã Â¦Â¾Ã Â¦Â²":"Ã Â¦Â°Ã Â¦Â¾Ã Â¦Â¤"},week:{dow:0,// Sunday is the first day of the week.
doy:6}}),{1:"Ã Â¼Â¡",2:"Ã Â¼Â¢",3:"Ã Â¼Â£",4:"Ã Â¼Â¤",5:"Ã Â¼Â¥",6:"Ã Â¼Â¦",7:"Ã Â¼Â§",8:"Ã Â¼Â¨",9:"Ã Â¼Â©",0:"Ã Â¼ "}),xg={"Ã Â¼Â¡":"1","Ã Â¼Â¢":"2","Ã Â¼Â£":"3","Ã Â¼Â¤":"4","Ã Â¼Â¥":"5","Ã Â¼Â¦":"6","Ã Â¼Â§":"7","Ã Â¼Â¨":"8","Ã Â¼Â©":"9","Ã Â¼ ":"0"},yg=(kg.defineLocale("bo",{months:"Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€˜Ã Â½â€žÃ Â¼â€¹Ã Â½â€Ã Â½Â¼_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€šÃ Â½â€°Ã Â½Â²Ã Â½Â¦Ã Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€šÃ Â½Â¦Ã Â½Â´Ã Â½ËœÃ Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€“Ã Â½Å¾Ã Â½Â²Ã Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½Â£Ã Â¾â€Ã Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€˜Ã Â¾Â²Ã Â½Â´Ã Â½â€šÃ Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€“Ã Â½â€˜Ã Â½Â´Ã Â½â€œÃ Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€“Ã Â½Â¢Ã Â¾â€™Ã Â¾Â±Ã Â½â€˜Ã Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€˜Ã Â½â€šÃ Â½Â´Ã Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€“Ã Â½â€¦Ã Â½Â´Ã Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€“Ã Â½â€¦Ã Â½Â´Ã Â¼â€¹Ã Â½â€šÃ Â½â€¦Ã Â½Â²Ã Â½â€šÃ Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€“Ã Â½â€¦Ã Â½Â´Ã Â¼â€¹Ã Â½â€šÃ Â½â€°Ã Â½Â²Ã Â½Â¦Ã Â¼â€¹Ã Â½â€".split("_"),monthsShort:"Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€˜Ã Â½â€žÃ Â¼â€¹Ã Â½â€Ã Â½Â¼_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€šÃ Â½â€°Ã Â½Â²Ã Â½Â¦Ã Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€šÃ Â½Â¦Ã Â½Â´Ã Â½ËœÃ Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€“Ã Â½Å¾Ã Â½Â²Ã Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½Â£Ã Â¾â€Ã Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€˜Ã Â¾Â²Ã Â½Â´Ã Â½â€šÃ Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€“Ã Â½â€˜Ã Â½Â´Ã Â½â€œÃ Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€“Ã Â½Â¢Ã Â¾â€™Ã Â¾Â±Ã Â½â€˜Ã Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€˜Ã Â½â€šÃ Â½Â´Ã Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€“Ã Â½â€¦Ã Â½Â´Ã Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€“Ã Â½â€¦Ã Â½Â´Ã Â¼â€¹Ã Â½â€šÃ Â½â€¦Ã Â½Â²Ã Â½â€šÃ Â¼â€¹Ã Â½â€_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€“Ã Â½â€¦Ã Â½Â´Ã Â¼â€¹Ã Â½â€šÃ Â½â€°Ã Â½Â²Ã Â½Â¦Ã Â¼â€¹Ã Â½â€".split("_"),weekdays:"Ã Â½â€šÃ Â½Å¸Ã Â½ Ã Â¼â€¹Ã Â½â€°Ã Â½Â²Ã Â¼â€¹Ã Â½ËœÃ Â¼â€¹_Ã Â½â€šÃ Â½Å¸Ã Â½ Ã Â¼â€¹Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹_Ã Â½â€šÃ Â½Å¸Ã Â½ Ã Â¼â€¹Ã Â½ËœÃ Â½Â²Ã Â½â€šÃ Â¼â€¹Ã Â½â€˜Ã Â½ËœÃ Â½Â¢Ã Â¼â€¹_Ã Â½â€šÃ Â½Å¸Ã Â½ Ã Â¼â€¹Ã Â½Â£Ã Â¾Â·Ã Â½â€šÃ Â¼â€¹Ã Â½â€Ã Â¼â€¹_Ã Â½â€šÃ Â½Å¸Ã Â½ Ã Â¼â€¹Ã Â½â€¢Ã Â½Â´Ã Â½Â¢Ã Â¼â€¹Ã Â½â€“Ã Â½Â´_Ã Â½â€šÃ Â½Å¸Ã Â½ Ã Â¼â€¹Ã Â½â€Ã Â¼â€¹Ã Â½Â¦Ã Â½â€žÃ Â½Â¦Ã Â¼â€¹_Ã Â½â€šÃ Â½Å¸Ã Â½ Ã Â¼â€¹Ã Â½Â¦Ã Â¾Â¤Ã Â½ÂºÃ Â½â€œÃ Â¼â€¹Ã Â½â€Ã Â¼â€¹".split("_"),weekdaysShort:"Ã Â½â€°Ã Â½Â²Ã Â¼â€¹Ã Â½ËœÃ Â¼â€¹_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹_Ã Â½ËœÃ Â½Â²Ã Â½â€šÃ Â¼â€¹Ã Â½â€˜Ã Â½ËœÃ Â½Â¢Ã Â¼â€¹_Ã Â½Â£Ã Â¾Â·Ã Â½â€šÃ Â¼â€¹Ã Â½â€Ã Â¼â€¹_Ã Â½â€¢Ã Â½Â´Ã Â½Â¢Ã Â¼â€¹Ã Â½â€“Ã Â½Â´_Ã Â½â€Ã Â¼â€¹Ã Â½Â¦Ã Â½â€žÃ Â½Â¦Ã Â¼â€¹_Ã Â½Â¦Ã Â¾Â¤Ã Â½ÂºÃ Â½â€œÃ Â¼â€¹Ã Â½â€Ã Â¼â€¹".split("_"),weekdaysMin:"Ã Â½â€°Ã Â½Â²Ã Â¼â€¹Ã Â½ËœÃ Â¼â€¹_Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹_Ã Â½ËœÃ Â½Â²Ã Â½â€šÃ Â¼â€¹Ã Â½â€˜Ã Â½ËœÃ Â½Â¢Ã Â¼â€¹_Ã Â½Â£Ã Â¾Â·Ã Â½â€šÃ Â¼â€¹Ã Â½â€Ã Â¼â€¹_Ã Â½â€¢Ã Â½Â´Ã Â½Â¢Ã Â¼â€¹Ã Â½â€“Ã Â½Â´_Ã Â½â€Ã Â¼â€¹Ã Â½Â¦Ã Â½â€žÃ Â½Â¦Ã Â¼â€¹_Ã Â½Â¦Ã Â¾Â¤Ã Â½ÂºÃ Â½â€œÃ Â¼â€¹Ã Â½â€Ã Â¼â€¹".split("_"),longDateFormat:{LT:"A h:mm",LTS:"A h:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm",LLLL:"dddd, D MMMM YYYY, A h:mm"},calendar:{sameDay:"[Ã Â½â€˜Ã Â½Â²Ã Â¼â€¹Ã Â½Â¢Ã Â½Â²Ã Â½â€ž] LT",nextDay:"[Ã Â½Â¦Ã Â½â€žÃ Â¼â€¹Ã Â½â€°Ã Â½Â²Ã Â½â€œ] LT",nextWeek:"[Ã Â½â€“Ã Â½â€˜Ã Â½Â´Ã Â½â€œÃ Â¼â€¹Ã Â½â€¢Ã Â¾Â²Ã Â½â€šÃ Â¼â€¹Ã Â½Â¢Ã Â¾â€”Ã Â½ÂºÃ Â½Â¦Ã Â¼â€¹Ã Â½Ëœ], LT",lastDay:"[Ã Â½ÂÃ Â¼â€¹Ã Â½Â¦Ã Â½â€ž] LT",lastWeek:"[Ã Â½â€“Ã Â½â€˜Ã Â½Â´Ã Â½â€œÃ Â¼â€¹Ã Â½â€¢Ã Â¾Â²Ã Â½â€šÃ Â¼â€¹Ã Â½ËœÃ Â½ÂÃ Â½ Ã Â¼â€¹Ã Â½Ëœ] dddd, LT",sameElse:"L"},relativeTime:{future:"%s Ã Â½Â£Ã Â¼â€¹",past:"%s Ã Â½Â¦Ã Â¾â€Ã Â½â€œÃ Â¼â€¹Ã Â½Â£",s:"Ã Â½Â£Ã Â½ËœÃ Â¼â€¹Ã Â½Â¦Ã Â½â€ž",m:"Ã Â½Â¦Ã Â¾ÂÃ Â½Â¢Ã Â¼â€¹Ã Â½ËœÃ Â¼â€¹Ã Â½â€šÃ Â½â€¦Ã Â½Â²Ã Â½â€š",mm:"%d Ã Â½Â¦Ã Â¾ÂÃ Â½Â¢Ã Â¼â€¹Ã Â½Ëœ",h:"Ã Â½â€ Ã Â½Â´Ã Â¼â€¹Ã Â½Å¡Ã Â½Â¼Ã Â½â€˜Ã Â¼â€¹Ã Â½â€šÃ Â½â€¦Ã Â½Â²Ã Â½â€š",hh:"%d Ã Â½â€ Ã Â½Â´Ã Â¼â€¹Ã Â½Å¡Ã Â½Â¼Ã Â½â€˜",d:"Ã Â½â€°Ã Â½Â²Ã Â½â€œÃ Â¼â€¹Ã Â½â€šÃ Â½â€¦Ã Â½Â²Ã Â½â€š",dd:"%d Ã Â½â€°Ã Â½Â²Ã Â½â€œÃ Â¼â€¹",M:"Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“Ã Â¼â€¹Ã Â½â€šÃ Â½â€¦Ã Â½Â²Ã Â½â€š",MM:"%d Ã Â½Å¸Ã Â¾Â³Ã Â¼â€¹Ã Â½â€“",y:"Ã Â½Â£Ã Â½Â¼Ã Â¼â€¹Ã Â½â€šÃ Â½â€¦Ã Â½Â²Ã Â½â€š",yy:"%d Ã Â½Â£Ã Â½Â¼"},preparse:function(a){return a.replace(/[Ã Â¼Â¡Ã Â¼Â¢Ã Â¼Â£Ã Â¼Â¤Ã Â¼Â¥Ã Â¼Â¦Ã Â¼Â§Ã Â¼Â¨Ã Â¼Â©Ã Â¼ ]/g,function(a){return xg[a]})},postformat:function(a){return a.replace(/\d/g,function(a){return wg[a]})},meridiemParse:/Ã Â½ËœÃ Â½Å¡Ã Â½â€œÃ Â¼â€¹Ã Â½ËœÃ Â½Â¼|Ã Â½Å¾Ã Â½Â¼Ã Â½â€šÃ Â½Â¦Ã Â¼â€¹Ã Â½â‚¬Ã Â½Â¦|Ã Â½â€°Ã Â½Â²Ã Â½â€œÃ Â¼â€¹Ã Â½â€šÃ Â½Â´Ã Â½â€ž|Ã Â½â€˜Ã Â½â€šÃ Â½Â¼Ã Â½â€žÃ Â¼â€¹Ã Â½â€˜Ã Â½â€š|Ã Â½ËœÃ Â½Å¡Ã Â½â€œÃ Â¼â€¹Ã Â½ËœÃ Â½Â¼/,meridiemHour:function(a,b){return 12===a&&(a=0),"Ã Â½ËœÃ Â½Å¡Ã Â½â€œÃ Â¼â€¹Ã Â½ËœÃ Â½Â¼"===b&&a>=4||"Ã Â½â€°Ã Â½Â²Ã Â½â€œÃ Â¼â€¹Ã Â½â€šÃ Â½Â´Ã Â½â€ž"===b&&5>a||"Ã Â½â€˜Ã Â½â€šÃ Â½Â¼Ã Â½â€žÃ Â¼â€¹Ã Â½â€˜Ã Â½â€š"===b?a+12:a},meridiem:function(a,b,c){return 4>a?"Ã Â½ËœÃ Â½Å¡Ã Â½â€œÃ Â¼â€¹Ã Â½ËœÃ Â½Â¼":10>a?"Ã Â½Å¾Ã Â½Â¼Ã Â½â€šÃ Â½Â¦Ã Â¼â€¹Ã Â½â‚¬Ã Â½Â¦":17>a?"Ã Â½â€°Ã Â½Â²Ã Â½â€œÃ Â¼â€¹Ã Â½â€šÃ Â½Â´Ã Â½â€ž":20>a?"Ã Â½â€˜Ã Â½â€šÃ Â½Â¼Ã Â½â€žÃ Â¼â€¹Ã Â½â€˜Ã Â½â€š":"Ã Â½ËœÃ Â½Å¡Ã Â½â€œÃ Â¼â€¹Ã Â½ËœÃ Â½Â¼"},week:{dow:0,// Sunday is the first day of the week.
doy:6}}),kg.defineLocale("br",{months:"Genver_C'hwevrer_Meurzh_Ebrel_Mae_Mezheven_Gouere_Eost_Gwengolo_Here_Du_Kerzu".split("_"),monthsShort:"Gen_C'hwe_Meu_Ebr_Mae_Eve_Gou_Eos_Gwe_Her_Du_Ker".split("_"),weekdays:"Sul_Lun_Meurzh_Merc'her_Yaou_Gwener_Sadorn".split("_"),weekdaysShort:"Sul_Lun_Meu_Mer_Yao_Gwe_Sad".split("_"),weekdaysMin:"Su_Lu_Me_Mer_Ya_Gw_Sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"h[e]mm A",LTS:"h[e]mm:ss A",L:"DD/MM/YYYY",LL:"D [a viz] MMMM YYYY",LLL:"D [a viz] MMMM YYYY h[e]mm A",LLLL:"dddd, D [a viz] MMMM YYYY h[e]mm A"},calendar:{sameDay:"[Hiziv da] LT",nextDay:"[Warc'hoazh da] LT",nextWeek:"dddd [da] LT",lastDay:"[Dec'h da] LT",lastWeek:"dddd [paset da] LT",sameElse:"L"},relativeTime:{future:"a-benn %s",past:"%s 'zo",s:"un nebeud segondennoÃƒÂ¹",m:"ur vunutenn",mm:od,h:"un eur",hh:"%d eur",d:"un devezh",dd:od,M:"ur miz",MM:od,y:"ur bloaz",yy:pd},ordinalParse:/\d{1,2}(aÃƒÂ±|vet)/,ordinal:function(a){var b=1===a?"aÃƒÂ±":"vet";return a+b},week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("bs",{months:"januar_februar_mart_april_maj_juni_juli_august_septembar_oktobar_novembar_decembar".split("_"),monthsShort:"jan._feb._mar._apr._maj._jun._jul._aug._sep._okt._nov._dec.".split("_"),monthsParseExact:!0,weekdays:"nedjelja_ponedjeljak_utorak_srijeda_Ã„Âetvrtak_petak_subota".split("_"),weekdaysShort:"ned._pon._uto._sri._Ã„Âet._pet._sub.".split("_"),weekdaysMin:"ne_po_ut_sr_Ã„Âe_pe_su".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD. MM. YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[danas u] LT",nextDay:"[sutra u] LT",nextWeek:function(){switch(this.day()){case 0:return"[u] [nedjelju] [u] LT";case 3:return"[u] [srijedu] [u] LT";case 6:return"[u] [subotu] [u] LT";case 1:case 2:case 4:case 5:return"[u] dddd [u] LT"}},lastDay:"[juÃ„Âer u] LT",lastWeek:function(){switch(this.day()){case 0:case 3:return"[proÃ…Â¡lu] dddd [u] LT";case 6:return"[proÃ…Â¡le] [subote] [u] LT";case 1:case 2:case 4:case 5:return"[proÃ…Â¡li] dddd [u] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"prije %s",s:"par sekundi",m:td,mm:td,h:td,hh:td,d:"dan",dd:td,M:"mjesec",MM:td,y:"godinu",yy:td},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("ca",{months:"gener_febrer_marÃƒÂ§_abril_maig_juny_juliol_agost_setembre_octubre_novembre_desembre".split("_"),monthsShort:"gen._febr._mar._abr._mai._jun._jul._ag._set._oct._nov._des.".split("_"),monthsParseExact:!0,weekdays:"diumenge_dilluns_dimarts_dimecres_dijous_divendres_dissabte".split("_"),weekdaysShort:"dg._dl._dt._dc._dj._dv._ds.".split("_"),weekdaysMin:"Dg_Dl_Dt_Dc_Dj_Dv_Ds".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY H:mm",LLLL:"dddd D MMMM YYYY H:mm"},calendar:{sameDay:function(){return"[avui a "+(1!==this.hours()?"les":"la")+"] LT"},nextDay:function(){return"[demÃƒ  a "+(1!==this.hours()?"les":"la")+"] LT"},nextWeek:function(){return"dddd [a "+(1!==this.hours()?"les":"la")+"] LT"},lastDay:function(){return"[ahir a "+(1!==this.hours()?"les":"la")+"] LT"},lastWeek:function(){return"[el] dddd [passat a "+(1!==this.hours()?"les":"la")+"] LT"},sameElse:"L"},relativeTime:{future:"en %s",past:"fa %s",s:"uns segons",m:"un minut",mm:"%d minuts",h:"una hora",hh:"%d hores",d:"un dia",dd:"%d dies",M:"un mes",MM:"%d mesos",y:"un any",yy:"%d anys"},ordinalParse:/\d{1,2}(r|n|t|ÃƒÂ¨|a)/,ordinal:function(a,b){var c=1===a?"r":2===a?"n":3===a?"r":4===a?"t":"ÃƒÂ¨";return"w"!==b&&"W"!==b||(c="a"),a+c},week:{dow:1,// Monday is the first day of the week.
doy:4}}),"leden_ÃƒÂºnor_bÃ…â„¢ezen_duben_kvÃ„â€ºten_Ã„Âerven_Ã„Âervenec_srpen_zÃƒÂ¡Ã…â„¢ÃƒÂ­_Ã…â„¢ÃƒÂ­jen_listopad_prosinec".split("_")),zg="led_ÃƒÂºno_bÃ…â„¢e_dub_kvÃ„â€º_Ã„Âvn_Ã„Âvc_srp_zÃƒÂ¡Ã…â„¢_Ã…â„¢ÃƒÂ­j_lis_pro".split("_"),Ag=(kg.defineLocale("cs",{months:yg,monthsShort:zg,monthsParse:function(a,b){var c,d=[];for(c=0;12>c;c++)
// use custom parser to solve problem with July (Ã„Âervenec)
d[c]=new RegExp("^"+a[c]+"$|^"+b[c]+"$","i");return d}(yg,zg),shortMonthsParse:function(a){var b,c=[];for(b=0;12>b;b++)c[b]=new RegExp("^"+a[b]+"$","i");return c}(zg),longMonthsParse:function(a){var b,c=[];for(b=0;12>b;b++)c[b]=new RegExp("^"+a[b]+"$","i");return c}(yg),weekdays:"nedÃ„â€ºle_pondÃ„â€ºlÃƒÂ­_ÃƒÂºterÃƒÂ½_stÃ…â„¢eda_Ã„Âtvrtek_pÃƒÂ¡tek_sobota".split("_"),weekdaysShort:"ne_po_ÃƒÂºt_st_Ã„Ât_pÃƒÂ¡_so".split("_"),weekdaysMin:"ne_po_ÃƒÂºt_st_Ã„Ât_pÃƒÂ¡_so".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd D. MMMM YYYY H:mm",l:"D. M. YYYY"},calendar:{sameDay:"[dnes v] LT",nextDay:"[zÃƒÂ­tra v] LT",nextWeek:function(){switch(this.day()){case 0:return"[v nedÃ„â€ºli v] LT";case 1:case 2:return"[v] dddd [v] LT";case 3:return"[ve stÃ…â„¢edu v] LT";case 4:return"[ve Ã„Âtvrtek v] LT";case 5:return"[v pÃƒÂ¡tek v] LT";case 6:return"[v sobotu v] LT"}},lastDay:"[vÃ„Âera v] LT",lastWeek:function(){switch(this.day()){case 0:return"[minulou nedÃ„â€ºli v] LT";case 1:case 2:return"[minulÃƒÂ©] dddd [v] LT";case 3:return"[minulou stÃ…â„¢edu v] LT";case 4:case 5:return"[minulÃƒÂ½] dddd [v] LT";case 6:return"[minulou sobotu v] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"pÃ…â„¢ed %s",s:vd,m:vd,mm:vd,h:vd,hh:vd,d:vd,dd:vd,M:vd,MM:vd,y:vd,yy:vd},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("cv",{months:"ÃÂºÃ“â€˜Ã‘â‚¬ÃÂ»ÃÂ°Ã‘â€¡_ÃÂ½ÃÂ°Ã‘â‚¬Ã“â€˜Ã‘Â_ÃÂ¿Ã‘Æ’Ã‘Ë†_ÃÂ°ÃÂºÃÂ°_ÃÂ¼ÃÂ°ÃÂ¹_Ã’Â«Ã“â€”Ã‘â‚¬Ã‘â€šÃÂ¼ÃÂµ_Ã‘Æ’Ã‘â€šÃ“â€˜_Ã’Â«Ã‘Æ’Ã‘â‚¬ÃÂ»ÃÂ°_ÃÂ°ÃÂ²Ã“â€˜ÃÂ½_Ã‘Å½ÃÂ¿ÃÂ°_Ã‘â€¡Ã“Â³ÃÂº_Ã‘â‚¬ÃÂ°Ã‘Ë†Ã‘â€šÃÂ°ÃÂ²".split("_"),monthsShort:"ÃÂºÃ“â€˜Ã‘â‚¬_ÃÂ½ÃÂ°Ã‘â‚¬_ÃÂ¿Ã‘Æ’Ã‘Ë†_ÃÂ°ÃÂºÃÂ°_ÃÂ¼ÃÂ°ÃÂ¹_Ã’Â«Ã“â€”Ã‘â‚¬_Ã‘Æ’Ã‘â€šÃ“â€˜_Ã’Â«Ã‘Æ’Ã‘â‚¬_ÃÂ°ÃÂ²ÃÂ½_Ã‘Å½ÃÂ¿ÃÂ°_Ã‘â€¡Ã“Â³ÃÂº_Ã‘â‚¬ÃÂ°Ã‘Ë†".split("_"),weekdays:"ÃÂ²Ã‘â€¹Ã‘â‚¬Ã‘ÂÃÂ°Ã‘â‚¬ÃÂ½ÃÂ¸ÃÂºÃ‘Æ’ÃÂ½_Ã‘â€šÃ‘Æ’ÃÂ½Ã‘â€šÃÂ¸ÃÂºÃ‘Æ’ÃÂ½_Ã‘â€¹Ã‘â€šÃÂ»ÃÂ°Ã‘â‚¬ÃÂ¸ÃÂºÃ‘Æ’ÃÂ½_Ã‘Å½ÃÂ½ÃÂºÃ‘Æ’ÃÂ½_ÃÂºÃ“â€”Ã’Â«ÃÂ½ÃÂµÃ‘â‚¬ÃÂ½ÃÂ¸ÃÂºÃ‘Æ’ÃÂ½_Ã‘ÂÃ‘â‚¬ÃÂ½ÃÂµÃÂºÃ‘Æ’ÃÂ½_Ã‘Ë†Ã“â€˜ÃÂ¼ÃÂ°Ã‘â€šÃÂºÃ‘Æ’ÃÂ½".split("_"),weekdaysShort:"ÃÂ²Ã‘â€¹Ã‘â‚¬_Ã‘â€šÃ‘Æ’ÃÂ½_Ã‘â€¹Ã‘â€šÃÂ»_Ã‘Å½ÃÂ½_ÃÂºÃ“â€”Ã’Â«_Ã‘ÂÃ‘â‚¬ÃÂ½_Ã‘Ë†Ã“â€˜ÃÂ¼".split("_"),weekdaysMin:"ÃÂ²Ã‘â‚¬_Ã‘â€šÃÂ½_Ã‘â€¹Ã‘â€š_Ã‘Å½ÃÂ½_ÃÂºÃ’Â«_Ã‘ÂÃ‘â‚¬_Ã‘Ë†ÃÂ¼".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD-MM-YYYY",LL:"YYYY [Ã’Â«Ã‘Æ’ÃÂ»Ã‘â€¦ÃÂ¸] MMMM [Ã‘Æ’ÃÂ¹Ã“â€˜Ã‘â€¦Ã“â€”ÃÂ½] D[-ÃÂ¼Ã“â€”Ã‘Ë†Ã“â€”]",LLL:"YYYY [Ã’Â«Ã‘Æ’ÃÂ»Ã‘â€¦ÃÂ¸] MMMM [Ã‘Æ’ÃÂ¹Ã“â€˜Ã‘â€¦Ã“â€”ÃÂ½] D[-ÃÂ¼Ã“â€”Ã‘Ë†Ã“â€”], HH:mm",LLLL:"dddd, YYYY [Ã’Â«Ã‘Æ’ÃÂ»Ã‘â€¦ÃÂ¸] MMMM [Ã‘Æ’ÃÂ¹Ã“â€˜Ã‘â€¦Ã“â€”ÃÂ½] D[-ÃÂ¼Ã“â€”Ã‘Ë†Ã“â€”], HH:mm"},calendar:{sameDay:"[ÃÅ¸ÃÂ°Ã‘ÂÃÂ½] LT [Ã‘ÂÃÂµÃ‘â€¦ÃÂµÃ‘â€šÃ‘â‚¬ÃÂµ]",nextDay:"[ÃÂ«Ã‘â‚¬ÃÂ°ÃÂ½] LT [Ã‘ÂÃÂµÃ‘â€¦ÃÂµÃ‘â€šÃ‘â‚¬ÃÂµ]",lastDay:"[Ã“â€“ÃÂ½ÃÂµÃ‘â‚¬] LT [Ã‘ÂÃÂµÃ‘â€¦ÃÂµÃ‘â€šÃ‘â‚¬ÃÂµ]",nextWeek:"[Ã’ÂªÃÂ¸Ã‘â€šÃÂµÃ‘Â] dddd LT [Ã‘ÂÃÂµÃ‘â€¦ÃÂµÃ‘â€šÃ‘â‚¬ÃÂµ]",lastWeek:"[ÃËœÃ‘â‚¬Ã‘â€šÃÂ½Ã“â€”] dddd LT [Ã‘ÂÃÂµÃ‘â€¦ÃÂµÃ‘â€šÃ‘â‚¬ÃÂµ]",sameElse:"L"},relativeTime:{future:function(a){var b=/Ã‘ÂÃÂµÃ‘â€¦ÃÂµÃ‘â€š$/i.exec(a)?"Ã‘â‚¬ÃÂµÃÂ½":/Ã’Â«Ã‘Æ’ÃÂ»$/i.exec(a)?"Ã‘â€šÃÂ°ÃÂ½":"Ã‘â‚¬ÃÂ°ÃÂ½";return a+b},past:"%s ÃÂºÃÂ°Ã‘ÂÃÂ»ÃÂ»ÃÂ°",s:"ÃÂ¿Ã“â€”Ã‘â‚¬-ÃÂ¸ÃÂº Ã’Â«ÃÂµÃÂºÃÂºÃ‘Æ’ÃÂ½Ã‘â€š",m:"ÃÂ¿Ã“â€”Ã‘â‚¬ ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€š",mm:"%d ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€š",h:"ÃÂ¿Ã“â€”Ã‘â‚¬ Ã‘ÂÃÂµÃ‘â€¦ÃÂµÃ‘â€š",hh:"%d Ã‘ÂÃÂµÃ‘â€¦ÃÂµÃ‘â€š",d:"ÃÂ¿Ã“â€”Ã‘â‚¬ ÃÂºÃ‘Æ’ÃÂ½",dd:"%d ÃÂºÃ‘Æ’ÃÂ½",M:"ÃÂ¿Ã“â€”Ã‘â‚¬ Ã‘Æ’ÃÂ¹Ã“â€˜Ã‘â€¦",MM:"%d Ã‘Æ’ÃÂ¹Ã“â€˜Ã‘â€¦",y:"ÃÂ¿Ã“â€”Ã‘â‚¬ Ã’Â«Ã‘Æ’ÃÂ»",yy:"%d Ã’Â«Ã‘Æ’ÃÂ»"},ordinalParse:/\d{1,2}-ÃÂ¼Ã“â€”Ã‘Ë†/,ordinal:"%d-ÃÂ¼Ã“â€”Ã‘Ë†",week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("cy",{months:"Ionawr_Chwefror_Mawrth_Ebrill_Mai_Mehefin_Gorffennaf_Awst_Medi_Hydref_Tachwedd_Rhagfyr".split("_"),monthsShort:"Ion_Chwe_Maw_Ebr_Mai_Meh_Gor_Aws_Med_Hyd_Tach_Rhag".split("_"),weekdays:"Dydd Sul_Dydd Llun_Dydd Mawrth_Dydd Mercher_Dydd Iau_Dydd Gwener_Dydd Sadwrn".split("_"),weekdaysShort:"Sul_Llun_Maw_Mer_Iau_Gwe_Sad".split("_"),weekdaysMin:"Su_Ll_Ma_Me_Ia_Gw_Sa".split("_"),weekdaysParseExact:!0,
// time formats are the same as en-gb
longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Heddiw am] LT",nextDay:"[Yfory am] LT",nextWeek:"dddd [am] LT",lastDay:"[Ddoe am] LT",lastWeek:"dddd [diwethaf am] LT",sameElse:"L"},relativeTime:{future:"mewn %s",past:"%s yn ÃƒÂ´l",s:"ychydig eiliadau",m:"munud",mm:"%d munud",h:"awr",hh:"%d awr",d:"diwrnod",dd:"%d diwrnod",M:"mis",MM:"%d mis",y:"blwyddyn",yy:"%d flynedd"},ordinalParse:/\d{1,2}(fed|ain|af|il|ydd|ed|eg)/,
// traditional ordinal numbers above 31 are not commonly used in colloquial Welsh
ordinal:function(a){var b=a,c="",d=["","af","il","ydd","ydd","ed","ed","ed","fed","fed","fed",// 1af to 10fed
"eg","fed","eg","eg","fed","eg","eg","fed","eg","fed"];return b>20?c=40===b||50===b||60===b||80===b||100===b?"fed":"ain":b>0&&(c=d[b]),a+c},week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("da",{months:"januar_februar_marts_april_maj_juni_juli_august_september_oktober_november_december".split("_"),monthsShort:"jan_feb_mar_apr_maj_jun_jul_aug_sep_okt_nov_dec".split("_"),weekdays:"sÃƒÂ¸ndag_mandag_tirsdag_onsdag_torsdag_fredag_lÃƒÂ¸rdag".split("_"),weekdaysShort:"sÃƒÂ¸n_man_tir_ons_tor_fre_lÃƒÂ¸r".split("_"),weekdaysMin:"sÃƒÂ¸_ma_ti_on_to_fr_lÃƒÂ¸".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY HH:mm",LLLL:"dddd [d.] D. MMMM YYYY HH:mm"},calendar:{sameDay:"[I dag kl.] LT",nextDay:"[I morgen kl.] LT",nextWeek:"dddd [kl.] LT",lastDay:"[I gÃƒÂ¥r kl.] LT",lastWeek:"[sidste] dddd [kl] LT",sameElse:"L"},relativeTime:{future:"om %s",past:"%s siden",s:"fÃƒÂ¥ sekunder",m:"et minut",mm:"%d minutter",h:"en time",hh:"%d timer",d:"en dag",dd:"%d dage",M:"en mÃƒÂ¥ned",MM:"%d mÃƒÂ¥neder",y:"et ÃƒÂ¥r",yy:"%d ÃƒÂ¥r"},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("de-at",{months:"JÃƒÂ¤nner_Februar_MÃƒÂ¤rz_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),monthsShort:"JÃƒÂ¤n._Febr._Mrz._Apr._Mai_Jun._Jul._Aug._Sept._Okt._Nov._Dez.".split("_"),monthsParseExact:!0,weekdays:"Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag".split("_"),weekdaysShort:"So._Mo._Di._Mi._Do._Fr._Sa.".split("_"),weekdaysMin:"So_Mo_Di_Mi_Do_Fr_Sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY HH:mm",LLLL:"dddd, D. MMMM YYYY HH:mm"},calendar:{sameDay:"[heute um] LT [Uhr]",sameElse:"L",nextDay:"[morgen um] LT [Uhr]",nextWeek:"dddd [um] LT [Uhr]",lastDay:"[gestern um] LT [Uhr]",lastWeek:"[letzten] dddd [um] LT [Uhr]"},relativeTime:{future:"in %s",past:"vor %s",s:"ein paar Sekunden",m:wd,mm:"%d Minuten",h:wd,hh:"%d Stunden",d:wd,dd:wd,M:wd,MM:wd,y:wd,yy:wd},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("de",{months:"Januar_Februar_MÃƒÂ¤rz_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),monthsShort:"Jan._Febr._Mrz._Apr._Mai_Jun._Jul._Aug._Sept._Okt._Nov._Dez.".split("_"),monthsParseExact:!0,weekdays:"Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag".split("_"),weekdaysShort:"So._Mo._Di._Mi._Do._Fr._Sa.".split("_"),weekdaysMin:"So_Mo_Di_Mi_Do_Fr_Sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY HH:mm",LLLL:"dddd, D. MMMM YYYY HH:mm"},calendar:{sameDay:"[heute um] LT [Uhr]",sameElse:"L",nextDay:"[morgen um] LT [Uhr]",nextWeek:"dddd [um] LT [Uhr]",lastDay:"[gestern um] LT [Uhr]",lastWeek:"[letzten] dddd [um] LT [Uhr]"},relativeTime:{future:"in %s",past:"vor %s",s:"ein paar Sekunden",m:xd,mm:"%d Minuten",h:xd,hh:"%d Stunden",d:xd,dd:xd,M:xd,MM:xd,y:xd,yy:xd},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),["Ãžâ€“ÃžÂ¬Ãžâ€šÃžÂªÃžâ€¡ÃžÂ¦ÃžÆ’ÃžÂ©","ÃžÅ ÃžÂ¬Ãžâ€žÃžÂ°ÃžÆ’ÃžÂªÃžâ€¡ÃžÂ¦ÃžÆ’ÃžÂ©","Ãžâ€°ÃžÂ§ÃžÆ’ÃžÂ¨Ãžâ€”ÃžÂª","Ãžâ€¡ÃžÂ­Ãžâ€¢ÃžÂ°ÃžÆ’ÃžÂ©ÃžÂÃžÂª","Ãžâ€°ÃžÂ­","Ãžâ€“ÃžÂ«Ãžâ€šÃžÂ°","Ãžâ€“ÃžÂªÃžÂÃžÂ¦Ãžâ€¡ÃžÂ¨","Ãžâ€¡ÃžÂ¯ÃžÅ½ÃžÂ¦ÃžÂÃžÂ°Ãžâ€œÃžÂª","ÃžÂÃžÂ¬Ãžâ€¢ÃžÂ°Ãžâ€œÃžÂ¬Ãžâ€°ÃžÂ°Ãžâ€žÃžÂ¦ÃžÆ’ÃžÂª","Ãžâ€¡ÃžÂ®Ãžâ€ ÃžÂ°Ãžâ€œÃžÂ¯Ãžâ€žÃžÂ¦ÃžÆ’ÃžÂª","Ãžâ€šÃžÂ®ÃžË†ÃžÂ¬Ãžâ€°ÃžÂ°Ãžâ€žÃžÂ¦ÃžÆ’ÃžÂª","Ãžâ€˜ÃžÂ¨ÃžÂÃžÂ¬Ãžâ€°ÃžÂ°Ãžâ€žÃžÂ¦ÃžÆ’ÃžÂª"]),Bg=["Ãžâ€¡ÃžÂ§Ãžâ€¹ÃžÂ¨Ãžâ€¡ÃžÂ°ÃžÅ’ÃžÂ¦","Ãžâ‚¬ÃžÂ¯Ãžâ€°ÃžÂ¦","Ãžâ€¡ÃžÂ¦Ãžâ€šÃžÂ°ÃžÅ½ÃžÂ§ÃžÆ’ÃžÂ¦","Ãžâ€žÃžÂªÃžâ€¹ÃžÂ¦","Ãžâ€žÃžÂªÃžÆ’ÃžÂ§ÃžÂÃžÂ°ÃžÅ ÃžÂ¦ÃžÅ’ÃžÂ¨","Ãžâ‚¬ÃžÂªÃžâ€ ÃžÂªÃžÆ’ÃžÂª","Ãžâ‚¬ÃžÂ®Ãžâ€šÃžÂ¨Ãžâ‚¬ÃžÂ¨ÃžÆ’ÃžÂª"],Cg=(kg.defineLocale("dv",{months:Ag,monthsShort:Ag,weekdays:Bg,weekdaysShort:Bg,weekdaysMin:"Ãžâ€¡ÃžÂ§Ãžâ€¹ÃžÂ¨_Ãžâ‚¬ÃžÂ¯Ãžâ€°ÃžÂ¦_Ãžâ€¡ÃžÂ¦Ãžâ€šÃžÂ°_Ãžâ€žÃžÂªÃžâ€¹ÃžÂ¦_Ãžâ€žÃžÂªÃžÆ’ÃžÂ§_Ãžâ‚¬ÃžÂªÃžâ€ ÃžÂª_Ãžâ‚¬ÃžÂ®Ãžâ€šÃžÂ¨".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"D/M/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},meridiemParse:/Ãžâ€°Ãžâ€ |Ãžâ€°ÃžÅ /,isPM:function(a){return"Ãžâ€°ÃžÅ "===a},meridiem:function(a,b,c){return 12>a?"Ãžâ€°Ãžâ€ ":"Ãžâ€°ÃžÅ "},calendar:{sameDay:"[Ãžâ€°ÃžÂ¨Ãžâ€¡ÃžÂ¦Ãžâ€¹ÃžÂª] LT",nextDay:"[Ãžâ€°ÃžÂ§Ãžâ€¹ÃžÂ¦Ãžâ€°ÃžÂ§] LT",nextWeek:"dddd LT",lastDay:"[Ãžâ€¡ÃžÂ¨Ãžâ€¡ÃžÂ°Ãžâ€ÃžÂ¬] LT",lastWeek:"[ÃžÅ ÃžÂ§Ãžâ€¡ÃžÂ¨ÃžÅ’ÃžÂªÃžË†ÃžÂ¨] dddd LT",sameElse:"L"},relativeTime:{future:"ÃžÅ’ÃžÂ¬ÃžÆ’ÃžÂ­ÃžÅ½ÃžÂ¦Ãžâ€¡ÃžÂ¨ %s",past:"Ãžâ€ ÃžÂªÃžÆ’ÃžÂ¨Ãžâ€šÃžÂ° %s",s:"ÃžÂÃžÂ¨Ãžâ€ ÃžÂªÃžâ€šÃžÂ°ÃžÅ’ÃžÂªÃžâ€ ÃžÂ®Ãžâ€¦ÃžÂ¬Ãžâ€¡ÃžÂ°",m:"Ãžâ€°ÃžÂ¨Ãžâ€šÃžÂ¨Ãžâ€œÃžÂ¬Ãžâ€¡ÃžÂ°",mm:"Ãžâ€°ÃžÂ¨Ãžâ€šÃžÂ¨Ãžâ€œÃžÂª %d",h:"ÃžÅ½ÃžÂ¦Ãžâ€˜ÃžÂ¨Ãžâ€¡ÃžÂ¨ÃžÆ’ÃžÂ¬Ãžâ€¡ÃžÂ°",hh:"ÃžÅ½ÃžÂ¦Ãžâ€˜ÃžÂ¨Ãžâ€¡ÃžÂ¨ÃžÆ’ÃžÂª %d",d:"Ãžâ€¹ÃžÂªÃžË†ÃžÂ¦Ãžâ‚¬ÃžÂ¬Ãžâ€¡ÃžÂ°",dd:"Ãžâ€¹ÃžÂªÃžË†ÃžÂ¦ÃžÂÃžÂ° %d",M:"Ãžâ€°ÃžÂ¦Ãžâ‚¬ÃžÂ¬Ãžâ€¡ÃžÂ°",MM:"Ãžâ€°ÃžÂ¦ÃžÂÃžÂ° %d",y:"Ãžâ€¡ÃžÂ¦Ãžâ‚¬ÃžÂ¦ÃžÆ’ÃžÂ¬Ãžâ€¡ÃžÂ°",yy:"Ãžâ€¡ÃžÂ¦Ãžâ‚¬ÃžÂ¦ÃžÆ’ÃžÂª %d"},preparse:function(a){return a.replace(/Ã˜Å’/g,",")},postformat:function(a){return a.replace(/,/g,"Ã˜Å’")},week:{dow:7,// Sunday is the first day of the week.
doy:12}}),kg.defineLocale("el",{monthsNominativeEl:"ÃŽâ„¢ÃŽÂ±ÃŽÂ½ÃŽÂ¿Ãâ€¦ÃŽÂ¬ÃÂÃŽÂ¹ÃŽÂ¿Ãâ€š_ÃŽÂ¦ÃŽÂµÃŽÂ²ÃÂÃŽÂ¿Ãâ€¦ÃŽÂ¬ÃÂÃŽÂ¹ÃŽÂ¿Ãâ€š_ÃŽÅ“ÃŽÂ¬ÃÂÃâ€žÃŽÂ¹ÃŽÂ¿Ãâ€š_ÃŽâ€˜Ãâ‚¬ÃÂÃŽÂ¯ÃŽÂ»ÃŽÂ¹ÃŽÂ¿Ãâ€š_ÃŽÅ“ÃŽÂ¬ÃŽÂ¹ÃŽÂ¿Ãâ€š_ÃŽâ„¢ÃŽÂ¿ÃÂÃŽÂ½ÃŽÂ¹ÃŽÂ¿Ãâ€š_ÃŽâ„¢ÃŽÂ¿ÃÂÃŽÂ»ÃŽÂ¹ÃŽÂ¿Ãâ€š_ÃŽâ€˜ÃÂÃŽÂ³ÃŽÂ¿Ãâ€¦ÃÆ’Ãâ€žÃŽÂ¿Ãâ€š_ÃŽÂ£ÃŽÂµÃâ‚¬Ãâ€žÃŽÂ­ÃŽÂ¼ÃŽÂ²ÃÂÃŽÂ¹ÃŽÂ¿Ãâ€š_ÃŽÅ¸ÃŽÂºÃâ€žÃÅ½ÃŽÂ²ÃÂÃŽÂ¹ÃŽÂ¿Ãâ€š_ÃŽÂÃŽÂ¿ÃŽÂ­ÃŽÂ¼ÃŽÂ²ÃÂÃŽÂ¹ÃŽÂ¿Ãâ€š_ÃŽâ€ÃŽÂµÃŽÂºÃŽÂ­ÃŽÂ¼ÃŽÂ²ÃÂÃŽÂ¹ÃŽÂ¿Ãâ€š".split("_"),monthsGenitiveEl:"ÃŽâ„¢ÃŽÂ±ÃŽÂ½ÃŽÂ¿Ãâ€¦ÃŽÂ±ÃÂÃŽÂ¯ÃŽÂ¿Ãâ€¦_ÃŽÂ¦ÃŽÂµÃŽÂ²ÃÂÃŽÂ¿Ãâ€¦ÃŽÂ±ÃÂÃŽÂ¯ÃŽÂ¿Ãâ€¦_ÃŽÅ“ÃŽÂ±ÃÂÃâ€žÃŽÂ¯ÃŽÂ¿Ãâ€¦_ÃŽâ€˜Ãâ‚¬ÃÂÃŽÂ¹ÃŽÂ»ÃŽÂ¯ÃŽÂ¿Ãâ€¦_ÃŽÅ“ÃŽÂ±ÃŽÂÃŽÂ¿Ãâ€¦_ÃŽâ„¢ÃŽÂ¿Ãâ€¦ÃŽÂ½ÃŽÂ¯ÃŽÂ¿Ãâ€¦_ÃŽâ„¢ÃŽÂ¿Ãâ€¦ÃŽÂ»ÃŽÂ¯ÃŽÂ¿Ãâ€¦_ÃŽâ€˜Ãâ€¦ÃŽÂ³ÃŽÂ¿ÃÂÃÆ’Ãâ€žÃŽÂ¿Ãâ€¦_ÃŽÂ£ÃŽÂµÃâ‚¬Ãâ€žÃŽÂµÃŽÂ¼ÃŽÂ²ÃÂÃŽÂ¯ÃŽÂ¿Ãâ€¦_ÃŽÅ¸ÃŽÂºÃâ€žÃâ€°ÃŽÂ²ÃÂÃŽÂ¯ÃŽÂ¿Ãâ€¦_ÃŽÂÃŽÂ¿ÃŽÂµÃŽÂ¼ÃŽÂ²ÃÂÃŽÂ¯ÃŽÂ¿Ãâ€¦_ÃŽâ€ÃŽÂµÃŽÂºÃŽÂµÃŽÂ¼ÃŽÂ²ÃÂÃŽÂ¯ÃŽÂ¿Ãâ€¦".split("_"),months:function(a,b){return/D/.test(b.substring(0,b.indexOf("MMMM")))?this._monthsGenitiveEl[a.month()]:this._monthsNominativeEl[a.month()]},monthsShort:"ÃŽâ„¢ÃŽÂ±ÃŽÂ½_ÃŽÂ¦ÃŽÂµÃŽÂ²_ÃŽÅ“ÃŽÂ±ÃÂ_ÃŽâ€˜Ãâ‚¬ÃÂ_ÃŽÅ“ÃŽÂ±ÃÅ _ÃŽâ„¢ÃŽÂ¿Ãâ€¦ÃŽÂ½_ÃŽâ„¢ÃŽÂ¿Ãâ€¦ÃŽÂ»_ÃŽâ€˜Ãâ€¦ÃŽÂ³_ÃŽÂ£ÃŽÂµÃâ‚¬_ÃŽÅ¸ÃŽÂºÃâ€ž_ÃŽÂÃŽÂ¿ÃŽÂµ_ÃŽâ€ÃŽÂµÃŽÂº".split("_"),weekdays:"ÃŽÅ¡Ãâ€¦ÃÂÃŽÂ¹ÃŽÂ±ÃŽÂºÃŽÂ®_ÃŽâ€ÃŽÂµÃâ€¦Ãâ€žÃŽÂ­ÃÂÃŽÂ±_ÃŽÂ¤ÃÂÃŽÂ¯Ãâ€žÃŽÂ·_ÃŽÂ¤ÃŽÂµÃâ€žÃŽÂ¬ÃÂÃâ€žÃŽÂ·_ÃŽ ÃŽÂ­ÃŽÂ¼Ãâ‚¬Ãâ€žÃŽÂ·_ÃŽ ÃŽÂ±ÃÂÃŽÂ±ÃÆ’ÃŽÂºÃŽÂµÃâ€¦ÃŽÂ®_ÃŽÂ£ÃŽÂ¬ÃŽÂ²ÃŽÂ²ÃŽÂ±Ãâ€žÃŽÂ¿".split("_"),weekdaysShort:"ÃŽÅ¡Ãâ€¦ÃÂ_ÃŽâ€ÃŽÂµÃâ€¦_ÃŽÂ¤ÃÂÃŽÂ¹_ÃŽÂ¤ÃŽÂµÃâ€ž_ÃŽ ÃŽÂµÃŽÂ¼_ÃŽ ÃŽÂ±ÃÂ_ÃŽÂ£ÃŽÂ±ÃŽÂ²".split("_"),weekdaysMin:"ÃŽÅ¡Ãâ€¦_ÃŽâ€ÃŽÂµ_ÃŽÂ¤ÃÂ_ÃŽÂ¤ÃŽÂµ_ÃŽ ÃŽÂµ_ÃŽ ÃŽÂ±_ÃŽÂ£ÃŽÂ±".split("_"),meridiem:function(a,b,c){return a>11?c?"ÃŽÂ¼ÃŽÂ¼":"ÃŽÅ“ÃŽÅ“":c?"Ãâ‚¬ÃŽÂ¼":"ÃŽ ÃŽÅ“"},isPM:function(a){return"ÃŽÂ¼"===(a+"").toLowerCase()[0]},meridiemParse:/[ÃŽ ÃŽÅ“]\.?ÃŽÅ“?\.?/i,longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY h:mm A",LLLL:"dddd, D MMMM YYYY h:mm A"},calendarEl:{sameDay:"[ÃŽÂ£ÃŽÂ®ÃŽÂ¼ÃŽÂµÃÂÃŽÂ± {}] LT",nextDay:"[ÃŽâ€˜ÃÂÃÂÃŽÂ¹ÃŽÂ¿ {}] LT",nextWeek:"dddd [{}] LT",lastDay:"[ÃŽÂ§ÃŽÂ¸ÃŽÂµÃâ€š {}] LT",lastWeek:function(){switch(this.day()){case 6:return"[Ãâ€žÃŽÂ¿ Ãâ‚¬ÃÂÃŽÂ¿ÃŽÂ·ÃŽÂ³ÃŽÂ¿ÃÂÃŽÂ¼ÃŽÂµÃŽÂ½ÃŽÂ¿] dddd [{}] LT";default:return"[Ãâ€žÃŽÂ·ÃŽÂ½ Ãâ‚¬ÃÂÃŽÂ¿ÃŽÂ·ÃŽÂ³ÃŽÂ¿ÃÂÃŽÂ¼ÃŽÂµÃŽÂ½ÃŽÂ·] dddd [{}] LT"}},sameElse:"L"},calendar:function(a,b){var c=this._calendarEl[a],d=b&&b.hours();return y(c)&&(c=c.apply(b)),c.replace("{}",d%12===1?"ÃÆ’Ãâ€žÃŽÂ·":"ÃÆ’Ãâ€žÃŽÂ¹Ãâ€š")},relativeTime:{future:"ÃÆ’ÃŽÂµ %s",past:"%s Ãâ‚¬ÃÂÃŽÂ¹ÃŽÂ½",s:"ÃŽÂ»ÃŽÂ¯ÃŽÂ³ÃŽÂ± ÃŽÂ´ÃŽÂµÃâ€¦Ãâ€žÃŽÂµÃÂÃÅ’ÃŽÂ»ÃŽÂµÃâ‚¬Ãâ€žÃŽÂ±",m:"ÃŽÂ­ÃŽÂ½ÃŽÂ± ÃŽÂ»ÃŽÂµÃâ‚¬Ãâ€žÃÅ’",mm:"%d ÃŽÂ»ÃŽÂµÃâ‚¬Ãâ€žÃŽÂ¬",h:"ÃŽÂ¼ÃŽÂ¯ÃŽÂ± ÃÅ½ÃÂÃŽÂ±",hh:"%d ÃÅ½ÃÂÃŽÂµÃâ€š",d:"ÃŽÂ¼ÃŽÂ¯ÃŽÂ± ÃŽÂ¼ÃŽÂ­ÃÂÃŽÂ±",dd:"%d ÃŽÂ¼ÃŽÂ­ÃÂÃŽÂµÃâ€š",M:"ÃŽÂ­ÃŽÂ½ÃŽÂ±Ãâ€š ÃŽÂ¼ÃŽÂ®ÃŽÂ½ÃŽÂ±Ãâ€š",MM:"%d ÃŽÂ¼ÃŽÂ®ÃŽÂ½ÃŽÂµÃâ€š",y:"ÃŽÂ­ÃŽÂ½ÃŽÂ±Ãâ€š Ãâ€¡ÃÂÃÅ’ÃŽÂ½ÃŽÂ¿Ãâ€š",yy:"%d Ãâ€¡ÃÂÃÅ’ÃŽÂ½ÃŽÂ¹ÃŽÂ±"},ordinalParse:/\d{1,2}ÃŽÂ·/,ordinal:"%dÃŽÂ·",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("en-au",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY h:mm A",LLLL:"dddd, D MMMM YYYY h:mm A"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},ordinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(a){var b=a%10,c=1===~~(a%100/10)?"th":1===b?"st":2===b?"nd":3===b?"rd":"th";return a+c},week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("en-ca",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"YYYY-MM-DD",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},ordinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(a){var b=a%10,c=1===~~(a%100/10)?"th":1===b?"st":2===b?"nd":3===b?"rd":"th";return a+c}}),kg.defineLocale("en-gb",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},ordinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(a){var b=a%10,c=1===~~(a%100/10)?"th":1===b?"st":2===b?"nd":3===b?"rd":"th";return a+c},week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("en-ie",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD-MM-YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},ordinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(a){var b=a%10,c=1===~~(a%100/10)?"th":1===b?"st":2===b?"nd":3===b?"rd":"th";return a+c},week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("en-nz",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY h:mm A",LLLL:"dddd, D MMMM YYYY h:mm A"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},ordinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(a){var b=a%10,c=1===~~(a%100/10)?"th":1===b?"st":2===b?"nd":3===b?"rd":"th";return a+c},week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("eo",{months:"januaro_februaro_marto_aprilo_majo_junio_julio_aÃ…Â­gusto_septembro_oktobro_novembro_decembro".split("_"),monthsShort:"jan_feb_mar_apr_maj_jun_jul_aÃ…Â­g_sep_okt_nov_dec".split("_"),weekdays:"DimanÃ„â€°o_Lundo_Mardo_Merkredo_Ã„Â´aÃ…Â­do_Vendredo_Sabato".split("_"),weekdaysShort:"Dim_Lun_Mard_Merk_Ã„Â´aÃ…Â­_Ven_Sab".split("_"),weekdaysMin:"Di_Lu_Ma_Me_Ã„Â´a_Ve_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"D[-an de] MMMM, YYYY",LLL:"D[-an de] MMMM, YYYY HH:mm",LLLL:"dddd, [la] D[-an de] MMMM, YYYY HH:mm"},meridiemParse:/[ap]\.t\.m/i,isPM:function(a){return"p"===a.charAt(0).toLowerCase()},meridiem:function(a,b,c){return a>11?c?"p.t.m.":"P.T.M.":c?"a.t.m.":"A.T.M."},calendar:{sameDay:"[HodiaÃ…Â­ je] LT",nextDay:"[MorgaÃ…Â­ je] LT",nextWeek:"dddd [je] LT",lastDay:"[HieraÃ…Â­ je] LT",lastWeek:"[pasinta] dddd [je] LT",sameElse:"L"},relativeTime:{future:"je %s",past:"antaÃ…Â­ %s",s:"sekundoj",m:"minuto",mm:"%d minutoj",h:"horo",hh:"%d horoj",d:"tago",//ne 'diurno', Ã„â€°ar estas uzita por proksimumo
dd:"%d tagoj",M:"monato",MM:"%d monatoj",y:"jaro",yy:"%d jaroj"},ordinalParse:/\d{1,2}a/,ordinal:"%da",week:{dow:1,// Monday is the first day of the week.
doy:7}}),"ene._feb._mar._abr._may._jun._jul._ago._sep._oct._nov._dic.".split("_")),Dg="ene_feb_mar_abr_may_jun_jul_ago_sep_oct_nov_dic".split("_"),Eg=(kg.defineLocale("es-do",{months:"enero_febrero_marzo_abril_mayo_junio_julio_agosto_septiembre_octubre_noviembre_diciembre".split("_"),monthsShort:function(a,b){return/-MMM-/.test(b)?Dg[a.month()]:Cg[a.month()]},monthsParseExact:!0,weekdays:"domingo_lunes_martes_miÃƒÂ©rcoles_jueves_viernes_sÃƒÂ¡bado".split("_"),weekdaysShort:"dom._lun._mar._miÃƒÂ©._jue._vie._sÃƒÂ¡b.".split("_"),weekdaysMin:"do_lu_ma_mi_ju_vi_sÃƒÂ¡".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D [de] MMMM [de] YYYY",LLL:"D [de] MMMM [de] YYYY h:mm A",LLLL:"dddd, D [de] MMMM [de] YYYY h:mm A"},calendar:{sameDay:function(){return"[hoy a la"+(1!==this.hours()?"s":"")+"] LT"},nextDay:function(){return"[maÃƒÂ±ana a la"+(1!==this.hours()?"s":"")+"] LT"},nextWeek:function(){return"dddd [a la"+(1!==this.hours()?"s":"")+"] LT"},lastDay:function(){return"[ayer a la"+(1!==this.hours()?"s":"")+"] LT"},lastWeek:function(){return"[el] dddd [pasado a la"+(1!==this.hours()?"s":"")+"] LT"},sameElse:"L"},relativeTime:{future:"en %s",past:"hace %s",s:"unos segundos",m:"un minuto",mm:"%d minutos",h:"una hora",hh:"%d horas",d:"un dÃƒÂ­a",dd:"%d dÃƒÂ­as",M:"un mes",MM:"%d meses",y:"un aÃƒÂ±o",yy:"%d aÃƒÂ±os"},ordinalParse:/\d{1,2}Ã‚Âº/,ordinal:"%dÃ‚Âº",week:{dow:1,// Monday is the first day of the week.
doy:4}}),"ene._feb._mar._abr._may._jun._jul._ago._sep._oct._nov._dic.".split("_")),Fg="ene_feb_mar_abr_may_jun_jul_ago_sep_oct_nov_dic".split("_"),Gg=(kg.defineLocale("es",{months:"enero_febrero_marzo_abril_mayo_junio_julio_agosto_septiembre_octubre_noviembre_diciembre".split("_"),monthsShort:function(a,b){return/-MMM-/.test(b)?Fg[a.month()]:Eg[a.month()]},monthsParseExact:!0,weekdays:"domingo_lunes_martes_miÃƒÂ©rcoles_jueves_viernes_sÃƒÂ¡bado".split("_"),weekdaysShort:"dom._lun._mar._miÃƒÂ©._jue._vie._sÃƒÂ¡b.".split("_"),weekdaysMin:"do_lu_ma_mi_ju_vi_sÃƒÂ¡".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD/MM/YYYY",LL:"D [de] MMMM [de] YYYY",LLL:"D [de] MMMM [de] YYYY H:mm",LLLL:"dddd, D [de] MMMM [de] YYYY H:mm"},calendar:{sameDay:function(){return"[hoy a la"+(1!==this.hours()?"s":"")+"] LT"},nextDay:function(){return"[maÃƒÂ±ana a la"+(1!==this.hours()?"s":"")+"] LT"},nextWeek:function(){return"dddd [a la"+(1!==this.hours()?"s":"")+"] LT"},lastDay:function(){return"[ayer a la"+(1!==this.hours()?"s":"")+"] LT"},lastWeek:function(){return"[el] dddd [pasado a la"+(1!==this.hours()?"s":"")+"] LT"},sameElse:"L"},relativeTime:{future:"en %s",past:"hace %s",s:"unos segundos",m:"un minuto",mm:"%d minutos",h:"una hora",hh:"%d horas",d:"un dÃƒÂ­a",dd:"%d dÃƒÂ­as",M:"un mes",MM:"%d meses",y:"un aÃƒÂ±o",yy:"%d aÃƒÂ±os"},ordinalParse:/\d{1,2}Ã‚Âº/,ordinal:"%dÃ‚Âº",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("et",{months:"jaanuar_veebruar_mÃƒÂ¤rts_aprill_mai_juuni_juuli_august_september_oktoober_november_detsember".split("_"),monthsShort:"jaan_veebr_mÃƒÂ¤rts_apr_mai_juuni_juuli_aug_sept_okt_nov_dets".split("_"),weekdays:"pÃƒÂ¼hapÃƒÂ¤ev_esmaspÃƒÂ¤ev_teisipÃƒÂ¤ev_kolmapÃƒÂ¤ev_neljapÃƒÂ¤ev_reede_laupÃƒÂ¤ev".split("_"),weekdaysShort:"P_E_T_K_N_R_L".split("_"),weekdaysMin:"P_E_T_K_N_R_L".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[TÃƒÂ¤na,] LT",nextDay:"[Homme,] LT",nextWeek:"[JÃƒÂ¤rgmine] dddd LT",lastDay:"[Eile,] LT",lastWeek:"[Eelmine] dddd LT",sameElse:"L"},relativeTime:{future:"%s pÃƒÂ¤rast",past:"%s tagasi",s:yd,m:yd,mm:yd,h:yd,hh:yd,d:yd,dd:"%d pÃƒÂ¤eva",M:yd,MM:yd,y:yd,yy:yd},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("eu",{months:"urtarrila_otsaila_martxoa_apirila_maiatza_ekaina_uztaila_abuztua_iraila_urria_azaroa_abendua".split("_"),monthsShort:"urt._ots._mar._api._mai._eka._uzt._abu._ira._urr._aza._abe.".split("_"),monthsParseExact:!0,weekdays:"igandea_astelehena_asteartea_asteazkena_osteguna_ostirala_larunbata".split("_"),weekdaysShort:"ig._al._ar._az._og._ol._lr.".split("_"),weekdaysMin:"ig_al_ar_az_og_ol_lr".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"YYYY[ko] MMMM[ren] D[a]",LLL:"YYYY[ko] MMMM[ren] D[a] HH:mm",LLLL:"dddd, YYYY[ko] MMMM[ren] D[a] HH:mm",l:"YYYY-M-D",ll:"YYYY[ko] MMM D[a]",lll:"YYYY[ko] MMM D[a] HH:mm",llll:"ddd, YYYY[ko] MMM D[a] HH:mm"},calendar:{sameDay:"[gaur] LT[etan]",nextDay:"[bihar] LT[etan]",nextWeek:"dddd LT[etan]",lastDay:"[atzo] LT[etan]",lastWeek:"[aurreko] dddd LT[etan]",sameElse:"L"},relativeTime:{future:"%s barru",past:"duela %s",s:"segundo batzuk",m:"minutu bat",mm:"%d minutu",h:"ordu bat",hh:"%d ordu",d:"egun bat",dd:"%d egun",M:"hilabete bat",MM:"%d hilabete",y:"urte bat",yy:"%d urte"},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:7}}),{1:"Ã›Â±",2:"Ã›Â²",3:"Ã›Â³",4:"Ã›Â´",5:"Ã›Âµ",6:"Ã›Â¶",7:"Ã›Â·",8:"Ã›Â¸",9:"Ã›Â¹",0:"Ã›Â°"}),Hg={"Ã›Â±":"1","Ã›Â²":"2","Ã›Â³":"3","Ã›Â´":"4","Ã›Âµ":"5","Ã›Â¶":"6","Ã›Â·":"7","Ã›Â¸":"8","Ã›Â¹":"9","Ã›Â°":"0"},Ig=(kg.defineLocale("fa",{months:"ÃšËœÃ˜Â§Ã™â€ Ã™Ë†Ã›Å’Ã™â€¡_Ã™ÂÃ™Ë†Ã˜Â±Ã›Å’Ã™â€¡_Ã™â€¦Ã˜Â§Ã˜Â±Ã˜Â³_Ã˜Â¢Ã™Ë†Ã˜Â±Ã›Å’Ã™â€ž_Ã™â€¦Ã™â€¡_ÃšËœÃ™Ë†Ã˜Â¦Ã™â€ _ÃšËœÃ™Ë†Ã˜Â¦Ã›Å’Ã™â€¡_Ã˜Â§Ã™Ë†Ã˜Âª_Ã˜Â³Ã™Â¾Ã˜ÂªÃ˜Â§Ã™â€¦Ã˜Â¨Ã˜Â±_Ã˜Â§ÃšÂ©Ã˜ÂªÃ˜Â¨Ã˜Â±_Ã™â€ Ã™Ë†Ã˜Â§Ã™â€¦Ã˜Â¨Ã˜Â±_Ã˜Â¯Ã˜Â³Ã˜Â§Ã™â€¦Ã˜Â¨Ã˜Â±".split("_"),monthsShort:"ÃšËœÃ˜Â§Ã™â€ Ã™Ë†Ã›Å’Ã™â€¡_Ã™ÂÃ™Ë†Ã˜Â±Ã›Å’Ã™â€¡_Ã™â€¦Ã˜Â§Ã˜Â±Ã˜Â³_Ã˜Â¢Ã™Ë†Ã˜Â±Ã›Å’Ã™â€ž_Ã™â€¦Ã™â€¡_ÃšËœÃ™Ë†Ã˜Â¦Ã™â€ _ÃšËœÃ™Ë†Ã˜Â¦Ã›Å’Ã™â€¡_Ã˜Â§Ã™Ë†Ã˜Âª_Ã˜Â³Ã™Â¾Ã˜ÂªÃ˜Â§Ã™â€¦Ã˜Â¨Ã˜Â±_Ã˜Â§ÃšÂ©Ã˜ÂªÃ˜Â¨Ã˜Â±_Ã™â€ Ã™Ë†Ã˜Â§Ã™â€¦Ã˜Â¨Ã˜Â±_Ã˜Â¯Ã˜Â³Ã˜Â§Ã™â€¦Ã˜Â¨Ã˜Â±".split("_"),weekdays:"Ã›Å’ÃšÂ©Ã¢â‚¬Å’Ã˜Â´Ã™â€ Ã˜Â¨Ã™â€¡_Ã˜Â¯Ã™Ë†Ã˜Â´Ã™â€ Ã˜Â¨Ã™â€¡_Ã˜Â³Ã™â€¡Ã¢â‚¬Å’Ã˜Â´Ã™â€ Ã˜Â¨Ã™â€¡_Ãšâ€ Ã™â€¡Ã˜Â§Ã˜Â±Ã˜Â´Ã™â€ Ã˜Â¨Ã™â€¡_Ã™Â¾Ã™â€ Ã˜Â¬Ã¢â‚¬Å’Ã˜Â´Ã™â€ Ã˜Â¨Ã™â€¡_Ã˜Â¬Ã™â€¦Ã˜Â¹Ã™â€¡_Ã˜Â´Ã™â€ Ã˜Â¨Ã™â€¡".split("_"),weekdaysShort:"Ã›Å’ÃšÂ©Ã¢â‚¬Å’Ã˜Â´Ã™â€ Ã˜Â¨Ã™â€¡_Ã˜Â¯Ã™Ë†Ã˜Â´Ã™â€ Ã˜Â¨Ã™â€¡_Ã˜Â³Ã™â€¡Ã¢â‚¬Å’Ã˜Â´Ã™â€ Ã˜Â¨Ã™â€¡_Ãšâ€ Ã™â€¡Ã˜Â§Ã˜Â±Ã˜Â´Ã™â€ Ã˜Â¨Ã™â€¡_Ã™Â¾Ã™â€ Ã˜Â¬Ã¢â‚¬Å’Ã˜Â´Ã™â€ Ã˜Â¨Ã™â€¡_Ã˜Â¬Ã™â€¦Ã˜Â¹Ã™â€¡_Ã˜Â´Ã™â€ Ã˜Â¨Ã™â€¡".split("_"),weekdaysMin:"Ã›Å’_Ã˜Â¯_Ã˜Â³_Ãšâ€ _Ã™Â¾_Ã˜Â¬_Ã˜Â´".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},meridiemParse:/Ã™â€šÃ˜Â¨Ã™â€ž Ã˜Â§Ã˜Â² Ã˜Â¸Ã™â€¡Ã˜Â±|Ã˜Â¨Ã˜Â¹Ã˜Â¯ Ã˜Â§Ã˜Â² Ã˜Â¸Ã™â€¡Ã˜Â±/,isPM:function(a){return/Ã˜Â¨Ã˜Â¹Ã˜Â¯ Ã˜Â§Ã˜Â² Ã˜Â¸Ã™â€¡Ã˜Â±/.test(a)},meridiem:function(a,b,c){return 12>a?"Ã™â€šÃ˜Â¨Ã™â€ž Ã˜Â§Ã˜Â² Ã˜Â¸Ã™â€¡Ã˜Â±":"Ã˜Â¨Ã˜Â¹Ã˜Â¯ Ã˜Â§Ã˜Â² Ã˜Â¸Ã™â€¡Ã˜Â±"},calendar:{sameDay:"[Ã˜Â§Ã™â€¦Ã˜Â±Ã™Ë†Ã˜Â² Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Âª] LT",nextDay:"[Ã™ÂÃ˜Â±Ã˜Â¯Ã˜Â§ Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Âª] LT",nextWeek:"dddd [Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Âª] LT",lastDay:"[Ã˜Â¯Ã›Å’Ã˜Â±Ã™Ë†Ã˜Â² Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Âª] LT",lastWeek:"dddd [Ã™Â¾Ã›Å’Ã˜Â´] [Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Âª] LT",sameElse:"L"},relativeTime:{future:"Ã˜Â¯Ã˜Â± %s",past:"%s Ã™Â¾Ã›Å’Ã˜Â´",s:"Ãšâ€ Ã™â€ Ã˜Â¯Ã›Å’Ã™â€  Ã˜Â«Ã˜Â§Ã™â€ Ã›Å’Ã™â€¡",m:"Ã›Å’ÃšÂ© Ã˜Â¯Ã™â€šÃ›Å’Ã™â€šÃ™â€¡",mm:"%d Ã˜Â¯Ã™â€šÃ›Å’Ã™â€šÃ™â€¡",h:"Ã›Å’ÃšÂ© Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Âª",hh:"%d Ã˜Â³Ã˜Â§Ã˜Â¹Ã˜Âª",d:"Ã›Å’ÃšÂ© Ã˜Â±Ã™Ë†Ã˜Â²",dd:"%d Ã˜Â±Ã™Ë†Ã˜Â²",M:"Ã›Å’ÃšÂ© Ã™â€¦Ã˜Â§Ã™â€¡",MM:"%d Ã™â€¦Ã˜Â§Ã™â€¡",y:"Ã›Å’ÃšÂ© Ã˜Â³Ã˜Â§Ã™â€ž",yy:"%d Ã˜Â³Ã˜Â§Ã™â€ž"},preparse:function(a){return a.replace(/[Ã›Â°-Ã›Â¹]/g,function(a){return Hg[a]}).replace(/Ã˜Å’/g,",")},postformat:function(a){return a.replace(/\d/g,function(a){return Gg[a]}).replace(/,/g,"Ã˜Å’")},ordinalParse:/\d{1,2}Ã™â€¦/,ordinal:"%dÃ™â€¦",week:{dow:6,// Saturday is the first day of the week.
doy:12}}),"nolla yksi kaksi kolme neljÃƒÂ¤ viisi kuusi seitsemÃƒÂ¤n kahdeksan yhdeksÃƒÂ¤n".split(" ")),Jg=["nolla","yhden","kahden","kolmen","neljÃƒÂ¤n","viiden","kuuden",Ig[7],Ig[8],Ig[9]],Kg=(kg.defineLocale("fi",{months:"tammikuu_helmikuu_maaliskuu_huhtikuu_toukokuu_kesÃƒÂ¤kuu_heinÃƒÂ¤kuu_elokuu_syyskuu_lokakuu_marraskuu_joulukuu".split("_"),monthsShort:"tammi_helmi_maalis_huhti_touko_kesÃƒÂ¤_heinÃƒÂ¤_elo_syys_loka_marras_joulu".split("_"),weekdays:"sunnuntai_maanantai_tiistai_keskiviikko_torstai_perjantai_lauantai".split("_"),weekdaysShort:"su_ma_ti_ke_to_pe_la".split("_"),weekdaysMin:"su_ma_ti_ke_to_pe_la".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD.MM.YYYY",LL:"Do MMMM[ta] YYYY",LLL:"Do MMMM[ta] YYYY, [klo] HH.mm",LLLL:"dddd, Do MMMM[ta] YYYY, [klo] HH.mm",l:"D.M.YYYY",ll:"Do MMM YYYY",lll:"Do MMM YYYY, [klo] HH.mm",llll:"ddd, Do MMM YYYY, [klo] HH.mm"},calendar:{sameDay:"[tÃƒÂ¤nÃƒÂ¤ÃƒÂ¤n] [klo] LT",nextDay:"[huomenna] [klo] LT",nextWeek:"dddd [klo] LT",lastDay:"[eilen] [klo] LT",lastWeek:"[viime] dddd[na] [klo] LT",sameElse:"L"},relativeTime:{future:"%s pÃƒÂ¤ÃƒÂ¤stÃƒÂ¤",past:"%s sitten",s:zd,m:zd,mm:zd,h:zd,hh:zd,d:zd,dd:zd,M:zd,MM:zd,y:zd,yy:zd},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("fo",{months:"januar_februar_mars_aprÃƒÂ­l_mai_juni_juli_august_september_oktober_november_desember".split("_"),monthsShort:"jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"),weekdays:"sunnudagur_mÃƒÂ¡nadagur_tÃƒÂ½sdagur_mikudagur_hÃƒÂ³sdagur_frÃƒÂ­ggjadagur_leygardagur".split("_"),weekdaysShort:"sun_mÃƒÂ¡n_tÃƒÂ½s_mik_hÃƒÂ³s_frÃƒÂ­_ley".split("_"),weekdaysMin:"su_mÃƒÂ¡_tÃƒÂ½_mi_hÃƒÂ³_fr_le".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D. MMMM, YYYY HH:mm"},calendar:{sameDay:"[ÃƒÂ dag kl.] LT",nextDay:"[ÃƒÂ morgin kl.] LT",nextWeek:"dddd [kl.] LT",lastDay:"[ÃƒÂ gjÃƒÂ¡r kl.] LT",lastWeek:"[sÃƒÂ­ÃƒÂ°stu] dddd [kl] LT",sameElse:"L"},relativeTime:{future:"um %s",past:"%s sÃƒÂ­ÃƒÂ°ani",s:"fÃƒÂ¡ sekund",m:"ein minutt",mm:"%d minuttir",h:"ein tÃƒÂ­mi",hh:"%d tÃƒÂ­mar",d:"ein dagur",dd:"%d dagar",M:"ein mÃƒÂ¡naÃƒÂ°i",MM:"%d mÃƒÂ¡naÃƒÂ°ir",y:"eitt ÃƒÂ¡r",yy:"%d ÃƒÂ¡r"},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("fr-ca",{months:"janvier_fÃƒÂ©vrier_mars_avril_mai_juin_juillet_aoÃƒÂ»t_septembre_octobre_novembre_dÃƒÂ©cembre".split("_"),monthsShort:"janv._fÃƒÂ©vr._mars_avr._mai_juin_juil._aoÃƒÂ»t_sept._oct._nov._dÃƒÂ©c.".split("_"),monthsParseExact:!0,weekdays:"dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),weekdaysShort:"dim._lun._mar._mer._jeu._ven._sam.".split("_"),weekdaysMin:"Di_Lu_Ma_Me_Je_Ve_Sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Aujourd'hui Ãƒ ] LT",nextDay:"[Demain Ãƒ ] LT",nextWeek:"dddd [Ãƒ ] LT",lastDay:"[Hier Ãƒ ] LT",lastWeek:"dddd [dernier Ãƒ ] LT",sameElse:"L"},relativeTime:{future:"dans %s",past:"il y a %s",s:"quelques secondes",m:"une minute",mm:"%d minutes",h:"une heure",hh:"%d heures",d:"un jour",dd:"%d jours",M:"un mois",MM:"%d mois",y:"un an",yy:"%d ans"},ordinalParse:/\d{1,2}(er|e)/,ordinal:function(a){return a+(1===a?"er":"e")}}),kg.defineLocale("fr-ch",{months:"janvier_fÃƒÂ©vrier_mars_avril_mai_juin_juillet_aoÃƒÂ»t_septembre_octobre_novembre_dÃƒÂ©cembre".split("_"),monthsShort:"janv._fÃƒÂ©vr._mars_avr._mai_juin_juil._aoÃƒÂ»t_sept._oct._nov._dÃƒÂ©c.".split("_"),monthsParseExact:!0,weekdays:"dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),weekdaysShort:"dim._lun._mar._mer._jeu._ven._sam.".split("_"),weekdaysMin:"Di_Lu_Ma_Me_Je_Ve_Sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Aujourd'hui Ãƒ ] LT",nextDay:"[Demain Ãƒ ] LT",nextWeek:"dddd [Ãƒ ] LT",lastDay:"[Hier Ãƒ ] LT",lastWeek:"dddd [dernier Ãƒ ] LT",sameElse:"L"},relativeTime:{future:"dans %s",past:"il y a %s",s:"quelques secondes",m:"une minute",mm:"%d minutes",h:"une heure",hh:"%d heures",d:"un jour",dd:"%d jours",M:"un mois",MM:"%d mois",y:"un an",yy:"%d ans"},ordinalParse:/\d{1,2}(er|e)/,ordinal:function(a){return a+(1===a?"er":"e")},week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("fr",{months:"janvier_fÃƒÂ©vrier_mars_avril_mai_juin_juillet_aoÃƒÂ»t_septembre_octobre_novembre_dÃƒÂ©cembre".split("_"),monthsShort:"janv._fÃƒÂ©vr._mars_avr._mai_juin_juil._aoÃƒÂ»t_sept._oct._nov._dÃƒÂ©c.".split("_"),monthsParseExact:!0,weekdays:"dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),weekdaysShort:"dim._lun._mar._mer._jeu._ven._sam.".split("_"),weekdaysMin:"Di_Lu_Ma_Me_Je_Ve_Sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Aujourd'hui Ãƒ ] LT",nextDay:"[Demain Ãƒ ] LT",nextWeek:"dddd [Ãƒ ] LT",lastDay:"[Hier Ãƒ ] LT",lastWeek:"dddd [dernier Ãƒ ] LT",sameElse:"L"},relativeTime:{future:"dans %s",past:"il y a %s",s:"quelques secondes",m:"une minute",mm:"%d minutes",h:"une heure",hh:"%d heures",d:"un jour",dd:"%d jours",M:"un mois",MM:"%d mois",y:"un an",yy:"%d ans"},ordinalParse:/\d{1,2}(er|)/,ordinal:function(a){return a+(1===a?"er":"")},week:{dow:1,// Monday is the first day of the week.
doy:4}}),"jan._feb._mrt._apr._mai_jun._jul._aug._sep._okt._nov._des.".split("_")),Lg="jan_feb_mrt_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"),Mg=(kg.defineLocale("fy",{months:"jannewaris_febrewaris_maart_april_maaie_juny_july_augustus_septimber_oktober_novimber_desimber".split("_"),monthsShort:function(a,b){return/-MMM-/.test(b)?Lg[a.month()]:Kg[a.month()]},monthsParseExact:!0,weekdays:"snein_moandei_tiisdei_woansdei_tongersdei_freed_sneon".split("_"),weekdaysShort:"si._mo._ti._wo._to._fr._so.".split("_"),weekdaysMin:"Si_Mo_Ti_Wo_To_Fr_So".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD-MM-YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[hjoed om] LT",nextDay:"[moarn om] LT",nextWeek:"dddd [om] LT",lastDay:"[juster om] LT",lastWeek:"[ÃƒÂ´frÃƒÂ»ne] dddd [om] LT",sameElse:"L"},relativeTime:{future:"oer %s",past:"%s lyn",s:"in pear sekonden",m:"ien minÃƒÂºt",mm:"%d minuten",h:"ien oere",hh:"%d oeren",d:"ien dei",dd:"%d dagen",M:"ien moanne",MM:"%d moannen",y:"ien jier",yy:"%d jierren"},ordinalParse:/\d{1,2}(ste|de)/,ordinal:function(a){return a+(1===a||8===a||a>=20?"ste":"de")},week:{dow:1,// Monday is the first day of the week.
doy:4}}),["Am Faoilleach","An Gearran","Am MÃƒ rt","An Giblean","An CÃƒÂ¨itean","An t-Ãƒâ€™gmhios","An t-Iuchar","An LÃƒÂ¹nastal","An t-Sultain","An DÃƒ mhair","An t-Samhain","An DÃƒÂ¹bhlachd"]),Ng=["Faoi","Gear","MÃƒ rt","Gibl","CÃƒÂ¨it","Ãƒâ€™gmh","Iuch","LÃƒÂ¹n","Sult","DÃƒ mh","Samh","DÃƒÂ¹bh"],Og=["DidÃƒÂ²mhnaich","Diluain","DimÃƒ irt","Diciadain","Diardaoin","Dihaoine","Disathairne"],Pg=["Did","Dil","Dim","Dic","Dia","Dih","Dis"],Qg=["DÃƒÂ²","Lu","MÃƒ ","Ci","Ar","Ha","Sa"],Rg=(kg.defineLocale("gd",{months:Mg,monthsShort:Ng,monthsParseExact:!0,weekdays:Og,weekdaysShort:Pg,weekdaysMin:Qg,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[An-diugh aig] LT",nextDay:"[A-mÃƒ ireach aig] LT",nextWeek:"dddd [aig] LT",lastDay:"[An-dÃƒÂ¨ aig] LT",lastWeek:"dddd [seo chaidh] [aig] LT",sameElse:"L"},relativeTime:{future:"ann an %s",past:"bho chionn %s",s:"beagan diogan",m:"mionaid",mm:"%d mionaidean",h:"uair",hh:"%d uairean",d:"latha",dd:"%d latha",M:"mÃƒÂ¬os",MM:"%d mÃƒÂ¬osan",y:"bliadhna",yy:"%d bliadhna"},ordinalParse:/\d{1,2}(d|na|mh)/,ordinal:function(a){var b=1===a?"d":a%10===2?"na":"mh";return a+b},week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("gl",{months:"Xaneiro_Febreiro_Marzo_Abril_Maio_XuÃƒÂ±o_Xullo_Agosto_Setembro_Outubro_Novembro_Decembro".split("_"),monthsShort:"Xan._Feb._Mar._Abr._Mai._XuÃƒÂ±._Xul._Ago._Set._Out._Nov._Dec.".split("_"),monthsParseExact:!0,weekdays:"Domingo_Luns_Martes_MÃƒÂ©rcores_Xoves_Venres_SÃƒÂ¡bado".split("_"),weekdaysShort:"Dom._Lun._Mar._MÃƒÂ©r._Xov._Ven._SÃƒÂ¡b.".split("_"),weekdaysMin:"Do_Lu_Ma_MÃƒÂ©_Xo_Ve_SÃƒÂ¡".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY H:mm",LLLL:"dddd D MMMM YYYY H:mm"},calendar:{sameDay:function(){return"[hoxe "+(1!==this.hours()?"ÃƒÂ¡s":"ÃƒÂ¡")+"] LT"},nextDay:function(){return"[maÃƒÂ±ÃƒÂ¡ "+(1!==this.hours()?"ÃƒÂ¡s":"ÃƒÂ¡")+"] LT"},nextWeek:function(){return"dddd ["+(1!==this.hours()?"ÃƒÂ¡s":"a")+"] LT"},lastDay:function(){return"[onte "+(1!==this.hours()?"ÃƒÂ¡":"a")+"] LT"},lastWeek:function(){return"[o] dddd [pasado "+(1!==this.hours()?"ÃƒÂ¡s":"a")+"] LT"},sameElse:"L"},relativeTime:{future:function(a){return"uns segundos"===a?"nuns segundos":"en "+a},past:"hai %s",s:"uns segundos",m:"un minuto",mm:"%d minutos",h:"unha hora",hh:"%d horas",d:"un dÃƒÂ­a",dd:"%d dÃƒÂ­as",M:"un mes",MM:"%d meses",y:"un ano",yy:"%d anos"},ordinalParse:/\d{1,2}Ã‚Âº/,ordinal:"%dÃ‚Âº",week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("he",{months:"Ã—â„¢Ã— Ã—â€¢Ã—ÂÃ—Â¨_Ã—Â¤Ã—â€˜Ã—Â¨Ã—â€¢Ã—ÂÃ—Â¨_Ã—Å¾Ã—Â¨Ã—Â¥_Ã—ÂÃ—Â¤Ã—Â¨Ã—â„¢Ã—Å“_Ã—Å¾Ã—ÂÃ—â„¢_Ã—â„¢Ã—â€¢Ã— Ã—â„¢_Ã—â„¢Ã—â€¢Ã—Å“Ã—â„¢_Ã—ÂÃ—â€¢Ã—â€™Ã—â€¢Ã—Â¡Ã—Ëœ_Ã—Â¡Ã—Â¤Ã—ËœÃ—Å¾Ã—â€˜Ã—Â¨_Ã—ÂÃ—â€¢Ã—Â§Ã—ËœÃ—â€¢Ã—â€˜Ã—Â¨_Ã— Ã—â€¢Ã—â€˜Ã—Å¾Ã—â€˜Ã—Â¨_Ã—â€œÃ—Â¦Ã—Å¾Ã—â€˜Ã—Â¨".split("_"),monthsShort:"Ã—â„¢Ã— Ã—â€¢Ã—Â³_Ã—Â¤Ã—â€˜Ã—Â¨Ã—Â³_Ã—Å¾Ã—Â¨Ã—Â¥_Ã—ÂÃ—Â¤Ã—Â¨Ã—Â³_Ã—Å¾Ã—ÂÃ—â„¢_Ã—â„¢Ã—â€¢Ã— Ã—â„¢_Ã—â„¢Ã—â€¢Ã—Å“Ã—â„¢_Ã—ÂÃ—â€¢Ã—â€™Ã—Â³_Ã—Â¡Ã—Â¤Ã—ËœÃ—Â³_Ã—ÂÃ—â€¢Ã—Â§Ã—Â³_Ã— Ã—â€¢Ã—â€˜Ã—Â³_Ã—â€œÃ—Â¦Ã—Å¾Ã—Â³".split("_"),weekdays:"Ã—Â¨Ã—ÂÃ—Â©Ã—â€¢Ã—Å¸_Ã—Â©Ã— Ã—â„¢_Ã—Â©Ã—Å“Ã—â„¢Ã—Â©Ã—â„¢_Ã—Â¨Ã—â€˜Ã—â„¢Ã—Â¢Ã—â„¢_Ã—â€”Ã—Å¾Ã—â„¢Ã—Â©Ã—â„¢_Ã—Â©Ã—â„¢Ã—Â©Ã—â„¢_Ã—Â©Ã—â€˜Ã—Âª".split("_"),weekdaysShort:"Ã—ÂÃ—Â³_Ã—â€˜Ã—Â³_Ã—â€™Ã—Â³_Ã—â€œÃ—Â³_Ã—â€Ã—Â³_Ã—â€¢Ã—Â³_Ã—Â©Ã—Â³".split("_"),weekdaysMin:"Ã—Â_Ã—â€˜_Ã—â€™_Ã—â€œ_Ã—â€_Ã—â€¢_Ã—Â©".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D [Ã—â€˜]MMMM YYYY",LLL:"D [Ã—â€˜]MMMM YYYY HH:mm",LLLL:"dddd, D [Ã—â€˜]MMMM YYYY HH:mm",l:"D/M/YYYY",ll:"D MMM YYYY",lll:"D MMM YYYY HH:mm",llll:"ddd, D MMM YYYY HH:mm"},calendar:{sameDay:"[Ã—â€Ã—â„¢Ã—â€¢Ã—Â Ã—â€˜Ã–Â¾]LT",nextDay:"[Ã—Å¾Ã—â€”Ã—Â¨ Ã—â€˜Ã–Â¾]LT",nextWeek:"dddd [Ã—â€˜Ã—Â©Ã—Â¢Ã—â€] LT",lastDay:"[Ã—ÂÃ—ÂªÃ—Å¾Ã—â€¢Ã—Å“ Ã—â€˜Ã–Â¾]LT",lastWeek:"[Ã—â€˜Ã—â„¢Ã—â€¢Ã—Â] dddd [Ã—â€Ã—ÂÃ—â€”Ã—Â¨Ã—â€¢Ã—Å¸ Ã—â€˜Ã—Â©Ã—Â¢Ã—â€] LT",sameElse:"L"},relativeTime:{future:"Ã—â€˜Ã—Â¢Ã—â€¢Ã—â€œ %s",past:"Ã—Å“Ã—Â¤Ã— Ã—â„¢ %s",s:"Ã—Å¾Ã—Â¡Ã—Â¤Ã—Â¨ Ã—Â©Ã— Ã—â„¢Ã—â€¢Ã—Âª",m:"Ã—â€œÃ—Â§Ã—â€",mm:"%d Ã—â€œÃ—Â§Ã—â€¢Ã—Âª",h:"Ã—Â©Ã—Â¢Ã—â€",hh:function(a){return 2===a?"Ã—Â©Ã—Â¢Ã—ÂªÃ—â„¢Ã—â„¢Ã—Â":a+" Ã—Â©Ã—Â¢Ã—â€¢Ã—Âª"},d:"Ã—â„¢Ã—â€¢Ã—Â",dd:function(a){return 2===a?"Ã—â„¢Ã—â€¢Ã—Å¾Ã—â„¢Ã—â„¢Ã—Â":a+" Ã—â„¢Ã—Å¾Ã—â„¢Ã—Â"},M:"Ã—â€”Ã—â€¢Ã—â€œÃ—Â©",MM:function(a){return 2===a?"Ã—â€”Ã—â€¢Ã—â€œÃ—Â©Ã—â„¢Ã—â„¢Ã—Â":a+" Ã—â€”Ã—â€¢Ã—â€œÃ—Â©Ã—â„¢Ã—Â"},y:"Ã—Â©Ã— Ã—â€",yy:function(a){return 2===a?"Ã—Â©Ã— Ã—ÂªÃ—â„¢Ã—â„¢Ã—Â":a%10===0&&10!==a?a+" Ã—Â©Ã— Ã—â€":a+" Ã—Â©Ã— Ã—â„¢Ã—Â"}},meridiemParse:/Ã—ÂÃ—â€”Ã—â€"Ã—Â¦|Ã—Å“Ã—Â¤Ã— Ã—â€"Ã—Â¦|Ã—ÂÃ—â€”Ã—Â¨Ã—â„¢ Ã—â€Ã—Â¦Ã—â€Ã—Â¨Ã—â„¢Ã—â„¢Ã—Â|Ã—Å“Ã—Â¤Ã— Ã—â„¢ Ã—â€Ã—Â¦Ã—â€Ã—Â¨Ã—â„¢Ã—â„¢Ã—Â|Ã—Å“Ã—Â¤Ã— Ã—â€¢Ã—Âª Ã—â€˜Ã—â€¢Ã—Â§Ã—Â¨|Ã—â€˜Ã—â€˜Ã—â€¢Ã—Â§Ã—Â¨|Ã—â€˜Ã—Â¢Ã—Â¨Ã—â€˜/i,isPM:function(a){return/^(Ã—ÂÃ—â€”Ã—â€"Ã—Â¦|Ã—ÂÃ—â€”Ã—Â¨Ã—â„¢ Ã—â€Ã—Â¦Ã—â€Ã—Â¨Ã—â„¢Ã—â„¢Ã—Â|Ã—â€˜Ã—Â¢Ã—Â¨Ã—â€˜)$/.test(a)},meridiem:function(a,b,c){return 5>a?"Ã—Å“Ã—Â¤Ã— Ã—â€¢Ã—Âª Ã—â€˜Ã—â€¢Ã—Â§Ã—Â¨":10>a?"Ã—â€˜Ã—â€˜Ã—â€¢Ã—Â§Ã—Â¨":12>a?c?'Ã—Å“Ã—Â¤Ã— Ã—â€"Ã—Â¦':"Ã—Å“Ã—Â¤Ã— Ã—â„¢ Ã—â€Ã—Â¦Ã—â€Ã—Â¨Ã—â„¢Ã—â„¢Ã—Â":18>a?c?'Ã—ÂÃ—â€”Ã—â€"Ã—Â¦':"Ã—ÂÃ—â€”Ã—Â¨Ã—â„¢ Ã—â€Ã—Â¦Ã—â€Ã—Â¨Ã—â„¢Ã—â„¢Ã—Â":"Ã—â€˜Ã—Â¢Ã—Â¨Ã—â€˜"}}),{1:"Ã Â¥Â§",2:"Ã Â¥Â¨",3:"Ã Â¥Â©",4:"Ã Â¥Âª",5:"Ã Â¥Â«",6:"Ã Â¥Â¬",7:"Ã Â¥Â­",8:"Ã Â¥Â®",9:"Ã Â¥Â¯",0:"Ã Â¥Â¦"}),Sg={"Ã Â¥Â§":"1","Ã Â¥Â¨":"2","Ã Â¥Â©":"3","Ã Â¥Âª":"4","Ã Â¥Â«":"5","Ã Â¥Â¬":"6","Ã Â¥Â­":"7","Ã Â¥Â®":"8","Ã Â¥Â¯":"9","Ã Â¥Â¦":"0"},Tg=(kg.defineLocale("hi",{months:"Ã Â¤Å“Ã Â¤Â¨Ã Â¤ÂµÃ Â¤Â°Ã Â¥â‚¬_Ã Â¤Â«Ã Â¤Â¼Ã Â¤Â°Ã Â¤ÂµÃ Â¤Â°Ã Â¥â‚¬_Ã Â¤Â®Ã Â¤Â¾Ã Â¤Â°Ã Â¥ÂÃ Â¤Å¡_Ã Â¤â€¦Ã Â¤ÂªÃ Â¥ÂÃ Â¤Â°Ã Â¥Ë†Ã Â¤Â²_Ã Â¤Â®Ã Â¤Ë†_Ã Â¤Å“Ã Â¥â€šÃ Â¤Â¨_Ã Â¤Å“Ã Â¥ÂÃ Â¤Â²Ã Â¤Â¾Ã Â¤Ë†_Ã Â¤â€¦Ã Â¤â€”Ã Â¤Â¸Ã Â¥ÂÃ Â¤Â¤_Ã Â¤Â¸Ã Â¤Â¿Ã Â¤Â¤Ã Â¤Â®Ã Â¥ÂÃ Â¤Â¬Ã Â¤Â°_Ã Â¤â€¦Ã Â¤â€¢Ã Â¥ÂÃ Â¤Å¸Ã Â¥â€šÃ Â¤Â¬Ã Â¤Â°_Ã Â¤Â¨Ã Â¤ÂµÃ Â¤Â®Ã Â¥ÂÃ Â¤Â¬Ã Â¤Â°_Ã Â¤Â¦Ã Â¤Â¿Ã Â¤Â¸Ã Â¤Â®Ã Â¥ÂÃ Â¤Â¬Ã Â¤Â°".split("_"),monthsShort:"Ã Â¤Å“Ã Â¤Â¨._Ã Â¤Â«Ã Â¤Â¼Ã Â¤Â°._Ã Â¤Â®Ã Â¤Â¾Ã Â¤Â°Ã Â¥ÂÃ Â¤Å¡_Ã Â¤â€¦Ã Â¤ÂªÃ Â¥ÂÃ Â¤Â°Ã Â¥Ë†._Ã Â¤Â®Ã Â¤Ë†_Ã Â¤Å“Ã Â¥â€šÃ Â¤Â¨_Ã Â¤Å“Ã Â¥ÂÃ Â¤Â²._Ã Â¤â€¦Ã Â¤â€”._Ã Â¤Â¸Ã Â¤Â¿Ã Â¤Â¤._Ã Â¤â€¦Ã Â¤â€¢Ã Â¥ÂÃ Â¤Å¸Ã Â¥â€š._Ã Â¤Â¨Ã Â¤Âµ._Ã Â¤Â¦Ã Â¤Â¿Ã Â¤Â¸.".split("_"),monthsParseExact:!0,weekdays:"Ã Â¤Â°Ã Â¤ÂµÃ Â¤Â¿Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Â°_Ã Â¤Â¸Ã Â¥â€¹Ã Â¤Â®Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Â°_Ã Â¤Â®Ã Â¤â€šÃ Â¤â€”Ã Â¤Â²Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Â°_Ã Â¤Â¬Ã Â¥ÂÃ Â¤Â§Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Â°_Ã Â¤â€”Ã Â¥ÂÃ Â¤Â°Ã Â¥â€šÃ Â¤ÂµÃ Â¤Â¾Ã Â¤Â°_Ã Â¤Â¶Ã Â¥ÂÃ Â¤â€¢Ã Â¥ÂÃ Â¤Â°Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Â°_Ã Â¤Â¶Ã Â¤Â¨Ã Â¤Â¿Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Â°".split("_"),weekdaysShort:"Ã Â¤Â°Ã Â¤ÂµÃ Â¤Â¿_Ã Â¤Â¸Ã Â¥â€¹Ã Â¤Â®_Ã Â¤Â®Ã Â¤â€šÃ Â¤â€”Ã Â¤Â²_Ã Â¤Â¬Ã Â¥ÂÃ Â¤Â§_Ã Â¤â€”Ã Â¥ÂÃ Â¤Â°Ã Â¥â€š_Ã Â¤Â¶Ã Â¥ÂÃ Â¤â€¢Ã Â¥ÂÃ Â¤Â°_Ã Â¤Â¶Ã Â¤Â¨Ã Â¤Â¿".split("_"),weekdaysMin:"Ã Â¤Â°_Ã Â¤Â¸Ã Â¥â€¹_Ã Â¤Â®Ã Â¤â€š_Ã Â¤Â¬Ã Â¥Â_Ã Â¤â€”Ã Â¥Â_Ã Â¤Â¶Ã Â¥Â_Ã Â¤Â¶".split("_"),longDateFormat:{LT:"A h:mm Ã Â¤Â¬Ã Â¤Å“Ã Â¥â€¡",LTS:"A h:mm:ss Ã Â¤Â¬Ã Â¤Å“Ã Â¥â€¡",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm Ã Â¤Â¬Ã Â¤Å“Ã Â¥â€¡",LLLL:"dddd, D MMMM YYYY, A h:mm Ã Â¤Â¬Ã Â¤Å“Ã Â¥â€¡"},calendar:{sameDay:"[Ã Â¤â€ Ã Â¤Å“] LT",nextDay:"[Ã Â¤â€¢Ã Â¤Â²] LT",nextWeek:"dddd, LT",lastDay:"[Ã Â¤â€¢Ã Â¤Â²] LT",lastWeek:"[Ã Â¤ÂªÃ Â¤Â¿Ã Â¤â€ºÃ Â¤Â²Ã Â¥â€¡] dddd, LT",sameElse:"L"},relativeTime:{future:"%s Ã Â¤Â®Ã Â¥â€¡Ã Â¤â€š",past:"%s Ã Â¤ÂªÃ Â¤Â¹Ã Â¤Â²Ã Â¥â€¡",s:"Ã Â¤â€¢Ã Â¥ÂÃ Â¤â€º Ã Â¤Â¹Ã Â¥â‚¬ Ã Â¤â€¢Ã Â¥ÂÃ Â¤Â·Ã Â¤Â£",m:"Ã Â¤ÂÃ Â¤â€¢ Ã Â¤Â®Ã Â¤Â¿Ã Â¤Â¨Ã Â¤Å¸",mm:"%d Ã Â¤Â®Ã Â¤Â¿Ã Â¤Â¨Ã Â¤Å¸",h:"Ã Â¤ÂÃ Â¤â€¢ Ã Â¤ËœÃ Â¤â€šÃ Â¤Å¸Ã Â¤Â¾",hh:"%d Ã Â¤ËœÃ Â¤â€šÃ Â¤Å¸Ã Â¥â€¡",d:"Ã Â¤ÂÃ Â¤â€¢ Ã Â¤Â¦Ã Â¤Â¿Ã Â¤Â¨",dd:"%d Ã Â¤Â¦Ã Â¤Â¿Ã Â¤Â¨",M:"Ã Â¤ÂÃ Â¤â€¢ Ã Â¤Â®Ã Â¤Â¹Ã Â¥â‚¬Ã Â¤Â¨Ã Â¥â€¡",MM:"%d Ã Â¤Â®Ã Â¤Â¹Ã Â¥â‚¬Ã Â¤Â¨Ã Â¥â€¡",y:"Ã Â¤ÂÃ Â¤â€¢ Ã Â¤ÂµÃ Â¤Â°Ã Â¥ÂÃ Â¤Â·",yy:"%d Ã Â¤ÂµÃ Â¤Â°Ã Â¥ÂÃ Â¤Â·"},preparse:function(a){return a.replace(/[Ã Â¥Â§Ã Â¥Â¨Ã Â¥Â©Ã Â¥ÂªÃ Â¥Â«Ã Â¥Â¬Ã Â¥Â­Ã Â¥Â®Ã Â¥Â¯Ã Â¥Â¦]/g,function(a){return Sg[a]})},postformat:function(a){return a.replace(/\d/g,function(a){return Rg[a]})},
// Hindi notation for meridiems are quite fuzzy in practice. While there exists
// a rigid notion of a 'Pahar' it is not used as rigidly in modern Hindi.
meridiemParse:/Ã Â¤Â°Ã Â¤Â¾Ã Â¤Â¤|Ã Â¤Â¸Ã Â¥ÂÃ Â¤Â¬Ã Â¤Â¹|Ã Â¤Â¦Ã Â¥â€¹Ã Â¤ÂªÃ Â¤Â¹Ã Â¤Â°|Ã Â¤Â¶Ã Â¤Â¾Ã Â¤Â®/,meridiemHour:function(a,b){return 12===a&&(a=0),"Ã Â¤Â°Ã Â¤Â¾Ã Â¤Â¤"===b?4>a?a:a+12:"Ã Â¤Â¸Ã Â¥ÂÃ Â¤Â¬Ã Â¤Â¹"===b?a:"Ã Â¤Â¦Ã Â¥â€¹Ã Â¤ÂªÃ Â¤Â¹Ã Â¤Â°"===b?a>=10?a:a+12:"Ã Â¤Â¶Ã Â¤Â¾Ã Â¤Â®"===b?a+12:void 0},meridiem:function(a,b,c){return 4>a?"Ã Â¤Â°Ã Â¤Â¾Ã Â¤Â¤":10>a?"Ã Â¤Â¸Ã Â¥ÂÃ Â¤Â¬Ã Â¤Â¹":17>a?"Ã Â¤Â¦Ã Â¥â€¹Ã Â¤ÂªÃ Â¤Â¹Ã Â¤Â°":20>a?"Ã Â¤Â¶Ã Â¤Â¾Ã Â¤Â®":"Ã Â¤Â°Ã Â¤Â¾Ã Â¤Â¤"},week:{dow:0,// Sunday is the first day of the week.
doy:6}}),kg.defineLocale("hr",{months:{format:"sijeÃ„Ânja_veljaÃ„Âe_oÃ…Â¾ujka_travnja_svibnja_lipnja_srpnja_kolovoza_rujna_listopada_studenoga_prosinca".split("_"),standalone:"sijeÃ„Âanj_veljaÃ„Âa_oÃ…Â¾ujak_travanj_svibanj_lipanj_srpanj_kolovoz_rujan_listopad_studeni_prosinac".split("_")},monthsShort:"sij._velj._oÃ…Â¾u._tra._svi._lip._srp._kol._ruj._lis._stu._pro.".split("_"),monthsParseExact:!0,weekdays:"nedjelja_ponedjeljak_utorak_srijeda_Ã„Âetvrtak_petak_subota".split("_"),weekdaysShort:"ned._pon._uto._sri._Ã„Âet._pet._sub.".split("_"),weekdaysMin:"ne_po_ut_sr_Ã„Âe_pe_su".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD. MM. YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[danas u] LT",nextDay:"[sutra u] LT",nextWeek:function(){switch(this.day()){case 0:return"[u] [nedjelju] [u] LT";case 3:return"[u] [srijedu] [u] LT";case 6:return"[u] [subotu] [u] LT";case 1:case 2:case 4:case 5:return"[u] dddd [u] LT"}},lastDay:"[juÃ„Âer u] LT",lastWeek:function(){switch(this.day()){case 0:case 3:return"[proÃ…Â¡lu] dddd [u] LT";case 6:return"[proÃ…Â¡le] [subote] [u] LT";case 1:case 2:case 4:case 5:return"[proÃ…Â¡li] dddd [u] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"prije %s",s:"par sekundi",m:Bd,mm:Bd,h:Bd,hh:Bd,d:"dan",dd:Bd,M:"mjesec",MM:Bd,y:"godinu",yy:Bd},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:7}}),"vasÃƒÂ¡rnap hÃƒÂ©tfÃ…â€˜n kedden szerdÃƒÂ¡n csÃƒÂ¼tÃƒÂ¶rtÃƒÂ¶kÃƒÂ¶n pÃƒÂ©nteken szombaton".split(" ")),Ug=(kg.defineLocale("hu",{months:"januÃƒÂ¡r_februÃƒÂ¡r_mÃƒÂ¡rcius_ÃƒÂ¡prilis_mÃƒÂ¡jus_jÃƒÂºnius_jÃƒÂºlius_augusztus_szeptember_oktÃƒÂ³ber_november_december".split("_"),monthsShort:"jan_feb_mÃƒÂ¡rc_ÃƒÂ¡pr_mÃƒÂ¡j_jÃƒÂºn_jÃƒÂºl_aug_szept_okt_nov_dec".split("_"),weekdays:"vasÃƒÂ¡rnap_hÃƒÂ©tfÃ…â€˜_kedd_szerda_csÃƒÂ¼tÃƒÂ¶rtÃƒÂ¶k_pÃƒÂ©ntek_szombat".split("_"),weekdaysShort:"vas_hÃƒÂ©t_kedd_sze_csÃƒÂ¼t_pÃƒÂ©n_szo".split("_"),weekdaysMin:"v_h_k_sze_cs_p_szo".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"YYYY.MM.DD.",LL:"YYYY. MMMM D.",LLL:"YYYY. MMMM D. H:mm",LLLL:"YYYY. MMMM D., dddd H:mm"},meridiemParse:/de|du/i,isPM:function(a){return"u"===a.charAt(1).toLowerCase()},meridiem:function(a,b,c){return 12>a?c===!0?"de":"DE":c===!0?"du":"DU"},calendar:{sameDay:"[ma] LT[-kor]",nextDay:"[holnap] LT[-kor]",nextWeek:function(){return Dd.call(this,!0)},lastDay:"[tegnap] LT[-kor]",lastWeek:function(){return Dd.call(this,!1)},sameElse:"L"},relativeTime:{future:"%s mÃƒÂºlva",past:"%s",s:Cd,m:Cd,mm:Cd,h:Cd,hh:Cd,d:Cd,dd:Cd,M:Cd,MM:Cd,y:Cd,yy:Cd},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("hy-am",{months:{format:"Ã•Â°Ã•Â¸Ã–â€šÃ•Â¶Ã•Â¾Ã•Â¡Ã–â‚¬Ã•Â«_Ã–Æ’Ã•Â¥Ã•Â¿Ã–â‚¬Ã•Â¾Ã•Â¡Ã–â‚¬Ã•Â«_Ã•Â´Ã•Â¡Ã–â‚¬Ã•Â¿Ã•Â«_Ã•Â¡Ã•ÂºÃ–â‚¬Ã•Â«Ã•Â¬Ã•Â«_Ã•Â´Ã•Â¡Ã•ÂµÃ•Â«Ã•Â½Ã•Â«_Ã•Â°Ã•Â¸Ã–â€šÃ•Â¶Ã•Â«Ã•Â½Ã•Â«_Ã•Â°Ã•Â¸Ã–â€šÃ•Â¬Ã•Â«Ã•Â½Ã•Â«_Ã–â€¦Ã•Â£Ã•Â¸Ã•Â½Ã•Â¿Ã•Â¸Ã•Â½Ã•Â«_Ã•Â½Ã•Â¥Ã•ÂºÃ•Â¿Ã•Â¥Ã•Â´Ã•Â¢Ã•Â¥Ã–â‚¬Ã•Â«_Ã•Â°Ã•Â¸Ã•Â¯Ã•Â¿Ã•Â¥Ã•Â´Ã•Â¢Ã•Â¥Ã–â‚¬Ã•Â«_Ã•Â¶Ã•Â¸Ã•ÂµÃ•Â¥Ã•Â´Ã•Â¢Ã•Â¥Ã–â‚¬Ã•Â«_Ã•Â¤Ã•Â¥Ã•Â¯Ã•Â¿Ã•Â¥Ã•Â´Ã•Â¢Ã•Â¥Ã–â‚¬Ã•Â«".split("_"),standalone:"Ã•Â°Ã•Â¸Ã–â€šÃ•Â¶Ã•Â¾Ã•Â¡Ã–â‚¬_Ã–Æ’Ã•Â¥Ã•Â¿Ã–â‚¬Ã•Â¾Ã•Â¡Ã–â‚¬_Ã•Â´Ã•Â¡Ã–â‚¬Ã•Â¿_Ã•Â¡Ã•ÂºÃ–â‚¬Ã•Â«Ã•Â¬_Ã•Â´Ã•Â¡Ã•ÂµÃ•Â«Ã•Â½_Ã•Â°Ã•Â¸Ã–â€šÃ•Â¶Ã•Â«Ã•Â½_Ã•Â°Ã•Â¸Ã–â€šÃ•Â¬Ã•Â«Ã•Â½_Ã–â€¦Ã•Â£Ã•Â¸Ã•Â½Ã•Â¿Ã•Â¸Ã•Â½_Ã•Â½Ã•Â¥Ã•ÂºÃ•Â¿Ã•Â¥Ã•Â´Ã•Â¢Ã•Â¥Ã–â‚¬_Ã•Â°Ã•Â¸Ã•Â¯Ã•Â¿Ã•Â¥Ã•Â´Ã•Â¢Ã•Â¥Ã–â‚¬_Ã•Â¶Ã•Â¸Ã•ÂµÃ•Â¥Ã•Â´Ã•Â¢Ã•Â¥Ã–â‚¬_Ã•Â¤Ã•Â¥Ã•Â¯Ã•Â¿Ã•Â¥Ã•Â´Ã•Â¢Ã•Â¥Ã–â‚¬".split("_")},monthsShort:"Ã•Â°Ã•Â¶Ã•Â¾_Ã–Æ’Ã•Â¿Ã–â‚¬_Ã•Â´Ã–â‚¬Ã•Â¿_Ã•Â¡Ã•ÂºÃ–â‚¬_Ã•Â´Ã•ÂµÃ•Â½_Ã•Â°Ã•Â¶Ã•Â½_Ã•Â°Ã•Â¬Ã•Â½_Ã–â€¦Ã•Â£Ã•Â½_Ã•Â½Ã•ÂºÃ•Â¿_Ã•Â°Ã•Â¯Ã•Â¿_Ã•Â¶Ã•Â´Ã•Â¢_Ã•Â¤Ã•Â¯Ã•Â¿".split("_"),weekdays:"Ã•Â¯Ã•Â«Ã–â‚¬Ã•Â¡Ã•Â¯Ã•Â«_Ã•Â¥Ã–â‚¬Ã•Â¯Ã•Â¸Ã–â€šÃ•Â·Ã•Â¡Ã•Â¢Ã•Â©Ã•Â«_Ã•Â¥Ã–â‚¬Ã•Â¥Ã–â€žÃ•Â·Ã•Â¡Ã•Â¢Ã•Â©Ã•Â«_Ã•Â¹Ã•Â¸Ã–â‚¬Ã•Â¥Ã–â€žÃ•Â·Ã•Â¡Ã•Â¢Ã•Â©Ã•Â«_Ã•Â°Ã•Â«Ã•Â¶Ã•Â£Ã•Â·Ã•Â¡Ã•Â¢Ã•Â©Ã•Â«_Ã•Â¸Ã–â€šÃ–â‚¬Ã•Â¢Ã•Â¡Ã•Â©_Ã•Â·Ã•Â¡Ã•Â¢Ã•Â¡Ã•Â©".split("_"),weekdaysShort:"Ã•Â¯Ã–â‚¬Ã•Â¯_Ã•Â¥Ã–â‚¬Ã•Â¯_Ã•Â¥Ã–â‚¬Ã–â€ž_Ã•Â¹Ã–â‚¬Ã–â€ž_Ã•Â°Ã•Â¶Ã•Â£_Ã•Â¸Ã–â€šÃ–â‚¬Ã•Â¢_Ã•Â·Ã•Â¢Ã•Â©".split("_"),weekdaysMin:"Ã•Â¯Ã–â‚¬Ã•Â¯_Ã•Â¥Ã–â‚¬Ã•Â¯_Ã•Â¥Ã–â‚¬Ã–â€ž_Ã•Â¹Ã–â‚¬Ã–â€ž_Ã•Â°Ã•Â¶Ã•Â£_Ã•Â¸Ã–â€šÃ–â‚¬Ã•Â¢_Ã•Â·Ã•Â¢Ã•Â©".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY Ã•Â©.",LLL:"D MMMM YYYY Ã•Â©., HH:mm",LLLL:"dddd, D MMMM YYYY Ã•Â©., HH:mm"},calendar:{sameDay:"[Ã•Â¡Ã•ÂµÃ•Â½Ã–â€¦Ã–â‚¬] LT",nextDay:"[Ã•Â¾Ã•Â¡Ã•Â²Ã•Â¨] LT",lastDay:"[Ã•Â¥Ã–â‚¬Ã•Â¥Ã•Â¯] LT",nextWeek:function(){return"dddd [Ã–â€¦Ã–â‚¬Ã•Â¨ Ã•ÂªÃ•Â¡Ã•Â´Ã•Â¨] LT"},lastWeek:function(){return"[Ã•Â¡Ã•Â¶Ã–ÂÃ•Â¡Ã•Â®] dddd [Ã–â€¦Ã–â‚¬Ã•Â¨ Ã•ÂªÃ•Â¡Ã•Â´Ã•Â¨] LT"},sameElse:"L"},relativeTime:{future:"%s Ã•Â°Ã•Â¥Ã•Â¿Ã•Â¸",past:"%s Ã•Â¡Ã•Â¼Ã•Â¡Ã•Â»",s:"Ã•Â´Ã•Â« Ã–â€žÃ•Â¡Ã•Â¶Ã•Â« Ã•Â¾Ã•Â¡Ã•ÂµÃ–â‚¬Ã•Â¯Ã•ÂµÃ•Â¡Ã•Â¶",m:"Ã–â‚¬Ã•Â¸Ã•ÂºÃ•Â¥",mm:"%d Ã–â‚¬Ã•Â¸Ã•ÂºÃ•Â¥",h:"Ã•ÂªÃ•Â¡Ã•Â´",hh:"%d Ã•ÂªÃ•Â¡Ã•Â´",d:"Ã–â€¦Ã–â‚¬",dd:"%d Ã–â€¦Ã–â‚¬",M:"Ã•Â¡Ã•Â´Ã•Â«Ã•Â½",MM:"%d Ã•Â¡Ã•Â´Ã•Â«Ã•Â½",y:"Ã•Â¿Ã•Â¡Ã–â‚¬Ã•Â«",yy:"%d Ã•Â¿Ã•Â¡Ã–â‚¬Ã•Â«"},meridiemParse:/Ã•Â£Ã•Â«Ã•Â·Ã•Â¥Ã–â‚¬Ã•Â¾Ã•Â¡|Ã•Â¡Ã•Â¼Ã•Â¡Ã•Â¾Ã•Â¸Ã•Â¿Ã•Â¾Ã•Â¡|Ã–ÂÃ•Â¥Ã–â‚¬Ã•Â¥Ã•Â¯Ã•Â¾Ã•Â¡|Ã•Â¥Ã–â‚¬Ã•Â¥Ã•Â¯Ã•Â¸Ã•ÂµÃ•Â¡Ã•Â¶/,isPM:function(a){return/^(Ã–ÂÃ•Â¥Ã–â‚¬Ã•Â¥Ã•Â¯Ã•Â¾Ã•Â¡|Ã•Â¥Ã–â‚¬Ã•Â¥Ã•Â¯Ã•Â¸Ã•ÂµÃ•Â¡Ã•Â¶)$/.test(a)},meridiem:function(a){return 4>a?"Ã•Â£Ã•Â«Ã•Â·Ã•Â¥Ã–â‚¬Ã•Â¾Ã•Â¡":12>a?"Ã•Â¡Ã•Â¼Ã•Â¡Ã•Â¾Ã•Â¸Ã•Â¿Ã•Â¾Ã•Â¡":17>a?"Ã–ÂÃ•Â¥Ã–â‚¬Ã•Â¥Ã•Â¯Ã•Â¾Ã•Â¡":"Ã•Â¥Ã–â‚¬Ã•Â¥Ã•Â¯Ã•Â¸Ã•ÂµÃ•Â¡Ã•Â¶"},ordinalParse:/\d{1,2}|\d{1,2}-(Ã•Â«Ã•Â¶|Ã–â‚¬Ã•Â¤)/,ordinal:function(a,b){switch(b){case"DDD":case"w":case"W":case"DDDo":return 1===a?a+"-Ã•Â«Ã•Â¶":a+"-Ã–â‚¬Ã•Â¤";default:return a}},week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("id",{months:"Januari_Februari_Maret_April_Mei_Juni_Juli_Agustus_September_Oktober_November_Desember".split("_"),monthsShort:"Jan_Feb_Mar_Apr_Mei_Jun_Jul_Ags_Sep_Okt_Nov_Des".split("_"),weekdays:"Minggu_Senin_Selasa_Rabu_Kamis_Jumat_Sabtu".split("_"),weekdaysShort:"Min_Sen_Sel_Rab_Kam_Jum_Sab".split("_"),weekdaysMin:"Mg_Sn_Sl_Rb_Km_Jm_Sb".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY [pukul] HH.mm",LLLL:"dddd, D MMMM YYYY [pukul] HH.mm"},meridiemParse:/pagi|siang|sore|malam/,meridiemHour:function(a,b){return 12===a&&(a=0),"pagi"===b?a:"siang"===b?a>=11?a:a+12:"sore"===b||"malam"===b?a+12:void 0},meridiem:function(a,b,c){return 11>a?"pagi":15>a?"siang":19>a?"sore":"malam"},calendar:{sameDay:"[Hari ini pukul] LT",nextDay:"[Besok pukul] LT",nextWeek:"dddd [pukul] LT",lastDay:"[Kemarin pukul] LT",lastWeek:"dddd [lalu pukul] LT",sameElse:"L"},relativeTime:{future:"dalam %s",past:"%s yang lalu",s:"beberapa detik",m:"semenit",mm:"%d menit",h:"sejam",hh:"%d jam",d:"sehari",dd:"%d hari",M:"sebulan",MM:"%d bulan",y:"setahun",yy:"%d tahun"},week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("is",{months:"janÃƒÂºar_febrÃƒÂºar_mars_aprÃƒÂ­l_maÃƒÂ­_jÃƒÂºnÃƒÂ­_jÃƒÂºlÃƒÂ­_ÃƒÂ¡gÃƒÂºst_september_oktÃƒÂ³ber_nÃƒÂ³vember_desember".split("_"),monthsShort:"jan_feb_mar_apr_maÃƒÂ­_jÃƒÂºn_jÃƒÂºl_ÃƒÂ¡gÃƒÂº_sep_okt_nÃƒÂ³v_des".split("_"),weekdays:"sunnudagur_mÃƒÂ¡nudagur_ÃƒÂ¾riÃƒÂ°judagur_miÃƒÂ°vikudagur_fimmtudagur_fÃƒÂ¶studagur_laugardagur".split("_"),weekdaysShort:"sun_mÃƒÂ¡n_ÃƒÂ¾ri_miÃƒÂ°_fim_fÃƒÂ¶s_lau".split("_"),weekdaysMin:"Su_MÃƒÂ¡_ÃƒÅ¾r_Mi_Fi_FÃƒÂ¶_La".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY [kl.] H:mm",LLLL:"dddd, D. MMMM YYYY [kl.] H:mm"},calendar:{sameDay:"[ÃƒÂ­ dag kl.] LT",nextDay:"[ÃƒÂ¡ morgun kl.] LT",nextWeek:"dddd [kl.] LT",lastDay:"[ÃƒÂ­ gÃƒÂ¦r kl.] LT",lastWeek:"[sÃƒÂ­ÃƒÂ°asta] dddd [kl.] LT",sameElse:"L"},relativeTime:{future:"eftir %s",past:"fyrir %s sÃƒÂ­ÃƒÂ°an",s:Fd,m:Fd,mm:Fd,h:"klukkustund",hh:Fd,d:Fd,dd:Fd,M:Fd,MM:Fd,y:Fd,yy:Fd},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("it",{months:"gennaio_febbraio_marzo_aprile_maggio_giugno_luglio_agosto_settembre_ottobre_novembre_dicembre".split("_"),monthsShort:"gen_feb_mar_apr_mag_giu_lug_ago_set_ott_nov_dic".split("_"),weekdays:"Domenica_LunedÃƒÂ¬_MartedÃƒÂ¬_MercoledÃƒÂ¬_GiovedÃƒÂ¬_VenerdÃƒÂ¬_Sabato".split("_"),weekdaysShort:"Dom_Lun_Mar_Mer_Gio_Ven_Sab".split("_"),weekdaysMin:"Do_Lu_Ma_Me_Gi_Ve_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Oggi alle] LT",nextDay:"[Domani alle] LT",nextWeek:"dddd [alle] LT",lastDay:"[Ieri alle] LT",lastWeek:function(){switch(this.day()){case 0:return"[la scorsa] dddd [alle] LT";default:return"[lo scorso] dddd [alle] LT"}},sameElse:"L"},relativeTime:{future:function(a){return(/^[0-9].+$/.test(a)?"tra":"in")+" "+a},past:"%s fa",s:"alcuni secondi",m:"un minuto",mm:"%d minuti",h:"un'ora",hh:"%d ore",d:"un giorno",dd:"%d giorni",M:"un mese",MM:"%d mesi",y:"un anno",yy:"%d anni"},ordinalParse:/\d{1,2}Ã‚Âº/,ordinal:"%dÃ‚Âº",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("ja",{months:"1Ã¦Å“Ë†_2Ã¦Å“Ë†_3Ã¦Å“Ë†_4Ã¦Å“Ë†_5Ã¦Å“Ë†_6Ã¦Å“Ë†_7Ã¦Å“Ë†_8Ã¦Å“Ë†_9Ã¦Å“Ë†_10Ã¦Å“Ë†_11Ã¦Å“Ë†_12Ã¦Å“Ë†".split("_"),monthsShort:"1Ã¦Å“Ë†_2Ã¦Å“Ë†_3Ã¦Å“Ë†_4Ã¦Å“Ë†_5Ã¦Å“Ë†_6Ã¦Å“Ë†_7Ã¦Å“Ë†_8Ã¦Å“Ë†_9Ã¦Å“Ë†_10Ã¦Å“Ë†_11Ã¦Å“Ë†_12Ã¦Å“Ë†".split("_"),weekdays:"Ã¦â€”Â¥Ã¦â€ºÅ“Ã¦â€”Â¥_Ã¦Å“Ë†Ã¦â€ºÅ“Ã¦â€”Â¥_Ã§ÂÂ«Ã¦â€ºÅ“Ã¦â€”Â¥_Ã¦Â°Â´Ã¦â€ºÅ“Ã¦â€”Â¥_Ã¦Å“Â¨Ã¦â€ºÅ“Ã¦â€”Â¥_Ã©â€¡â€˜Ã¦â€ºÅ“Ã¦â€”Â¥_Ã¥Å“Å¸Ã¦â€ºÅ“Ã¦â€”Â¥".split("_"),weekdaysShort:"Ã¦â€”Â¥_Ã¦Å“Ë†_Ã§ÂÂ«_Ã¦Â°Â´_Ã¦Å“Â¨_Ã©â€¡â€˜_Ã¥Å“Å¸".split("_"),weekdaysMin:"Ã¦â€”Â¥_Ã¦Å“Ë†_Ã§ÂÂ«_Ã¦Â°Â´_Ã¦Å“Â¨_Ã©â€¡â€˜_Ã¥Å“Å¸".split("_"),longDateFormat:{LT:"AhÃ¦â„¢â€šmÃ¥Ë†â€ ",LTS:"AhÃ¦â„¢â€šmÃ¥Ë†â€ sÃ§Â§â€™",L:"YYYY/MM/DD",LL:"YYYYÃ¥Â¹Â´MÃ¦Å“Ë†DÃ¦â€”Â¥",LLL:"YYYYÃ¥Â¹Â´MÃ¦Å“Ë†DÃ¦â€”Â¥AhÃ¦â„¢â€šmÃ¥Ë†â€ ",LLLL:"YYYYÃ¥Â¹Â´MÃ¦Å“Ë†DÃ¦â€”Â¥AhÃ¦â„¢â€šmÃ¥Ë†â€  dddd"},meridiemParse:/Ã¥ÂË†Ã¥â€°Â|Ã¥ÂË†Ã¥Â¾Å’/i,isPM:function(a){return"Ã¥ÂË†Ã¥Â¾Å’"===a},meridiem:function(a,b,c){return 12>a?"Ã¥ÂË†Ã¥â€°Â":"Ã¥ÂË†Ã¥Â¾Å’"},calendar:{sameDay:"[Ã¤Â»Å Ã¦â€”Â¥] LT",nextDay:"[Ã¦ËœÅ½Ã¦â€”Â¥] LT",nextWeek:"[Ã¦ÂÂ¥Ã©â‚¬Â±]dddd LT",lastDay:"[Ã¦ËœÂ¨Ã¦â€”Â¥] LT",lastWeek:"[Ã¥â€°ÂÃ©â‚¬Â±]dddd LT",sameElse:"L"},ordinalParse:/\d{1,2}Ã¦â€”Â¥/,ordinal:function(a,b){switch(b){case"d":case"D":case"DDD":return a+"Ã¦â€”Â¥";default:return a}},relativeTime:{future:"%sÃ¥Â¾Å’",past:"%sÃ¥â€°Â",s:"Ã¦â€¢Â°Ã§Â§â€™",m:"1Ã¥Ë†â€ ",mm:"%dÃ¥Ë†â€ ",h:"1Ã¦â„¢â€šÃ©â€“â€œ",hh:"%dÃ¦â„¢â€šÃ©â€“â€œ",d:"1Ã¦â€”Â¥",dd:"%dÃ¦â€”Â¥",M:"1Ã£Æ’Â¶Ã¦Å“Ë†",MM:"%dÃ£Æ’Â¶Ã¦Å“Ë†",y:"1Ã¥Â¹Â´",yy:"%dÃ¥Â¹Â´"}}),kg.defineLocale("jv",{months:"Januari_Februari_Maret_April_Mei_Juni_Juli_Agustus_September_Oktober_Nopember_Desember".split("_"),monthsShort:"Jan_Feb_Mar_Apr_Mei_Jun_Jul_Ags_Sep_Okt_Nop_Des".split("_"),weekdays:"Minggu_Senen_Seloso_Rebu_Kemis_Jemuwah_Septu".split("_"),weekdaysShort:"Min_Sen_Sel_Reb_Kem_Jem_Sep".split("_"),weekdaysMin:"Mg_Sn_Sl_Rb_Km_Jm_Sp".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY [pukul] HH.mm",LLLL:"dddd, D MMMM YYYY [pukul] HH.mm"},meridiemParse:/enjing|siyang|sonten|ndalu/,meridiemHour:function(a,b){return 12===a&&(a=0),"enjing"===b?a:"siyang"===b?a>=11?a:a+12:"sonten"===b||"ndalu"===b?a+12:void 0},meridiem:function(a,b,c){return 11>a?"enjing":15>a?"siyang":19>a?"sonten":"ndalu"},calendar:{sameDay:"[Dinten puniko pukul] LT",nextDay:"[Mbenjang pukul] LT",nextWeek:"dddd [pukul] LT",lastDay:"[Kala wingi pukul] LT",lastWeek:"dddd [kepengker pukul] LT",sameElse:"L"},relativeTime:{future:"wonten ing %s",past:"%s ingkang kepengker",s:"sawetawis detik",m:"setunggal menit",mm:"%d menit",h:"setunggal jam",hh:"%d jam",d:"sedinten",dd:"%d dinten",M:"sewulan",MM:"%d wulan",y:"setaun",yy:"%d taun"},week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("ka",{months:{standalone:"Ã¡Æ’ËœÃ¡Æ’ÂÃ¡Æ’Å“Ã¡Æ’â€¢Ã¡Æ’ÂÃ¡Æ’ Ã¡Æ’Ëœ_Ã¡Æ’â€”Ã¡Æ’â€Ã¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’ Ã¡Æ’â€¢Ã¡Æ’ÂÃ¡Æ’Å¡Ã¡Æ’Ëœ_Ã¡Æ’â€ºÃ¡Æ’ÂÃ¡Æ’ Ã¡Æ’Â¢Ã¡Æ’Ëœ_Ã¡Æ’ÂÃ¡Æ’Å¾Ã¡Æ’ Ã¡Æ’ËœÃ¡Æ’Å¡Ã¡Æ’Ëœ_Ã¡Æ’â€ºÃ¡Æ’ÂÃ¡Æ’ËœÃ¡Æ’Â¡Ã¡Æ’Ëœ_Ã¡Æ’ËœÃ¡Æ’â€¢Ã¡Æ’Å“Ã¡Æ’ËœÃ¡Æ’Â¡Ã¡Æ’Ëœ_Ã¡Æ’ËœÃ¡Æ’â€¢Ã¡Æ’Å¡Ã¡Æ’ËœÃ¡Æ’Â¡Ã¡Æ’Ëœ_Ã¡Æ’ÂÃ¡Æ’â€™Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â¡Ã¡Æ’Â¢Ã¡Æ’Â_Ã¡Æ’Â¡Ã¡Æ’â€Ã¡Æ’Â¥Ã¡Æ’Â¢Ã¡Æ’â€Ã¡Æ’â€ºÃ¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’ Ã¡Æ’Ëœ_Ã¡Æ’ÂÃ¡Æ’Â¥Ã¡Æ’Â¢Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’ Ã¡Æ’Ëœ_Ã¡Æ’Å“Ã¡Æ’ÂÃ¡Æ’â€Ã¡Æ’â€ºÃ¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’ Ã¡Æ’Ëœ_Ã¡Æ’â€œÃ¡Æ’â€Ã¡Æ’â„¢Ã¡Æ’â€Ã¡Æ’â€ºÃ¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’ Ã¡Æ’Ëœ".split("_"),format:"Ã¡Æ’ËœÃ¡Æ’ÂÃ¡Æ’Å“Ã¡Æ’â€¢Ã¡Æ’ÂÃ¡Æ’ Ã¡Æ’Â¡_Ã¡Æ’â€”Ã¡Æ’â€Ã¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’ Ã¡Æ’â€¢Ã¡Æ’ÂÃ¡Æ’Å¡Ã¡Æ’Â¡_Ã¡Æ’â€ºÃ¡Æ’ÂÃ¡Æ’ Ã¡Æ’Â¢Ã¡Æ’Â¡_Ã¡Æ’ÂÃ¡Æ’Å¾Ã¡Æ’ Ã¡Æ’ËœÃ¡Æ’Å¡Ã¡Æ’ËœÃ¡Æ’Â¡_Ã¡Æ’â€ºÃ¡Æ’ÂÃ¡Æ’ËœÃ¡Æ’Â¡Ã¡Æ’Â¡_Ã¡Æ’ËœÃ¡Æ’â€¢Ã¡Æ’Å“Ã¡Æ’ËœÃ¡Æ’Â¡Ã¡Æ’Â¡_Ã¡Æ’ËœÃ¡Æ’â€¢Ã¡Æ’Å¡Ã¡Æ’ËœÃ¡Æ’Â¡Ã¡Æ’Â¡_Ã¡Æ’ÂÃ¡Æ’â€™Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â¡Ã¡Æ’Â¢Ã¡Æ’Â¡_Ã¡Æ’Â¡Ã¡Æ’â€Ã¡Æ’Â¥Ã¡Æ’Â¢Ã¡Æ’â€Ã¡Æ’â€ºÃ¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’ Ã¡Æ’Â¡_Ã¡Æ’ÂÃ¡Æ’Â¥Ã¡Æ’Â¢Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’ Ã¡Æ’Â¡_Ã¡Æ’Å“Ã¡Æ’ÂÃ¡Æ’â€Ã¡Æ’â€ºÃ¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’ Ã¡Æ’Â¡_Ã¡Æ’â€œÃ¡Æ’â€Ã¡Æ’â„¢Ã¡Æ’â€Ã¡Æ’â€ºÃ¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’ Ã¡Æ’Â¡".split("_")},monthsShort:"Ã¡Æ’ËœÃ¡Æ’ÂÃ¡Æ’Å“_Ã¡Æ’â€”Ã¡Æ’â€Ã¡Æ’â€˜_Ã¡Æ’â€ºÃ¡Æ’ÂÃ¡Æ’ _Ã¡Æ’ÂÃ¡Æ’Å¾Ã¡Æ’ _Ã¡Æ’â€ºÃ¡Æ’ÂÃ¡Æ’Ëœ_Ã¡Æ’ËœÃ¡Æ’â€¢Ã¡Æ’Å“_Ã¡Æ’ËœÃ¡Æ’â€¢Ã¡Æ’Å¡_Ã¡Æ’ÂÃ¡Æ’â€™Ã¡Æ’â€¢_Ã¡Æ’Â¡Ã¡Æ’â€Ã¡Æ’Â¥_Ã¡Æ’ÂÃ¡Æ’Â¥Ã¡Æ’Â¢_Ã¡Æ’Å“Ã¡Æ’ÂÃ¡Æ’â€_Ã¡Æ’â€œÃ¡Æ’â€Ã¡Æ’â„¢".split("_"),weekdays:{standalone:"Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’ Ã¡Æ’Â_Ã¡Æ’ÂÃ¡Æ’ Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ_Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ_Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â®Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ_Ã¡Æ’Â®Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ_Ã¡Æ’Å¾Ã¡Æ’ÂÃ¡Æ’ Ã¡Æ’ÂÃ¡Æ’Â¡Ã¡Æ’â„¢Ã¡Æ’â€Ã¡Æ’â€¢Ã¡Æ’Ëœ_Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ".split("_"),format:"Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’ Ã¡Æ’ÂÃ¡Æ’Â¡_Ã¡Æ’ÂÃ¡Æ’ Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â¡_Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â¡_Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â®Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â¡_Ã¡Æ’Â®Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â¡_Ã¡Æ’Å¾Ã¡Æ’ÂÃ¡Æ’ Ã¡Æ’ÂÃ¡Æ’Â¡Ã¡Æ’â„¢Ã¡Æ’â€Ã¡Æ’â€¢Ã¡Æ’Â¡_Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â¡".split("_"),isFormat:/(Ã¡Æ’Â¬Ã¡Æ’ËœÃ¡Æ’Å“Ã¡Æ’Â|Ã¡Æ’Â¨Ã¡Æ’â€Ã¡Æ’â€ºÃ¡Æ’â€œÃ¡Æ’â€Ã¡Æ’â€™)/},weekdaysShort:"Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’Ëœ_Ã¡Æ’ÂÃ¡Æ’ Ã¡Æ’Â¨_Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’â€º_Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â®_Ã¡Æ’Â®Ã¡Æ’Â£Ã¡Æ’â€”_Ã¡Æ’Å¾Ã¡Æ’ÂÃ¡Æ’ _Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜".split("_"),weekdaysMin:"Ã¡Æ’â„¢Ã¡Æ’â€¢_Ã¡Æ’ÂÃ¡Æ’ _Ã¡Æ’Â¡Ã¡Æ’Â_Ã¡Æ’ÂÃ¡Æ’â€”_Ã¡Æ’Â®Ã¡Æ’Â£_Ã¡Æ’Å¾Ã¡Æ’Â_Ã¡Æ’Â¨Ã¡Æ’Â".split("_"),longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY h:mm A",LLLL:"dddd, D MMMM YYYY h:mm A"},calendar:{sameDay:"[Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’â€Ã¡Æ’Â¡] LT[-Ã¡Æ’â€“Ã¡Æ’â€]",nextDay:"[Ã¡Æ’Â®Ã¡Æ’â€¢Ã¡Æ’ÂÃ¡Æ’Å¡] LT[-Ã¡Æ’â€“Ã¡Æ’â€]",lastDay:"[Ã¡Æ’â€™Ã¡Æ’Â£Ã¡Æ’Â¨Ã¡Æ’ËœÃ¡Æ’Å“] LT[-Ã¡Æ’â€“Ã¡Æ’â€]",nextWeek:"[Ã¡Æ’Â¨Ã¡Æ’â€Ã¡Æ’â€ºÃ¡Æ’â€œÃ¡Æ’â€Ã¡Æ’â€™] dddd LT[-Ã¡Æ’â€“Ã¡Æ’â€]",lastWeek:"[Ã¡Æ’Â¬Ã¡Æ’ËœÃ¡Æ’Å“Ã¡Æ’Â] dddd LT-Ã¡Æ’â€“Ã¡Æ’â€",sameElse:"L"},relativeTime:{future:function(a){return/(Ã¡Æ’Â¬Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’Ëœ|Ã¡Æ’Â¬Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Ëœ|Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ|Ã¡Æ’Â¬Ã¡Æ’â€Ã¡Æ’Å¡Ã¡Æ’Ëœ)/.test(a)?a.replace(/Ã¡Æ’Ëœ$/,"Ã¡Æ’Â¨Ã¡Æ’Ëœ"):a+"Ã¡Æ’Â¨Ã¡Æ’Ëœ"},past:function(a){return/(Ã¡Æ’Â¬Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’Ëœ|Ã¡Æ’Â¬Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Ëœ|Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ|Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’â€|Ã¡Æ’â€”Ã¡Æ’â€¢Ã¡Æ’â€)/.test(a)?a.replace(/(Ã¡Æ’Ëœ|Ã¡Æ’â€)$/,"Ã¡Æ’ËœÃ¡Æ’Â¡ Ã¡Æ’Â¬Ã¡Æ’ËœÃ¡Æ’Å“"):/Ã¡Æ’Â¬Ã¡Æ’â€Ã¡Æ’Å¡Ã¡Æ’Ëœ/.test(a)?a.replace(/Ã¡Æ’Â¬Ã¡Æ’â€Ã¡Æ’Å¡Ã¡Æ’Ëœ$/,"Ã¡Æ’Â¬Ã¡Æ’Å¡Ã¡Æ’ËœÃ¡Æ’Â¡ Ã¡Æ’Â¬Ã¡Æ’ËœÃ¡Æ’Å“"):void 0},s:"Ã¡Æ’ Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’â€œÃ¡Æ’â€Ã¡Æ’Å“Ã¡Æ’ËœÃ¡Æ’â€ºÃ¡Æ’â€ Ã¡Æ’Â¬Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’Ëœ",m:"Ã¡Æ’Â¬Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Ëœ",mm:"%d Ã¡Æ’Â¬Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Ëœ",h:"Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ",hh:"%d Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ",d:"Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’â€",dd:"%d Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’â€",M:"Ã¡Æ’â€”Ã¡Æ’â€¢Ã¡Æ’â€",MM:"%d Ã¡Æ’â€”Ã¡Æ’â€¢Ã¡Æ’â€",y:"Ã¡Æ’Â¬Ã¡Æ’â€Ã¡Æ’Å¡Ã¡Æ’Ëœ",yy:"%d Ã¡Æ’Â¬Ã¡Æ’â€Ã¡Æ’Å¡Ã¡Æ’Ëœ"},ordinalParse:/0|1-Ã¡Æ’Å¡Ã¡Æ’Ëœ|Ã¡Æ’â€ºÃ¡Æ’â€-\d{1,2}|\d{1,2}-Ã¡Æ’â€/,ordinal:function(a){return 0===a?a:1===a?a+"-Ã¡Æ’Å¡Ã¡Æ’Ëœ":20>a||100>=a&&a%20===0||a%100===0?"Ã¡Æ’â€ºÃ¡Æ’â€-"+a:a+"-Ã¡Æ’â€"},week:{dow:1,doy:7}}),{0:"-Ã‘Ë†Ã‘â€“",1:"-Ã‘Ë†Ã‘â€“",2:"-Ã‘Ë†Ã‘â€“",3:"-Ã‘Ë†Ã‘â€“",4:"-Ã‘Ë†Ã‘â€“",5:"-Ã‘Ë†Ã‘â€“",6:"-Ã‘Ë†Ã‘â€¹",7:"-Ã‘Ë†Ã‘â€“",8:"-Ã‘Ë†Ã‘â€“",9:"-Ã‘Ë†Ã‘â€¹",10:"-Ã‘Ë†Ã‘â€¹",20:"-Ã‘Ë†Ã‘â€¹",30:"-Ã‘Ë†Ã‘â€¹",40:"-Ã‘Ë†Ã‘â€¹",50:"-Ã‘Ë†Ã‘â€“",60:"-Ã‘Ë†Ã‘â€¹",70:"-Ã‘Ë†Ã‘â€“",80:"-Ã‘Ë†Ã‘â€“",90:"-Ã‘Ë†Ã‘â€¹",100:"-Ã‘Ë†Ã‘â€“"}),Vg=(kg.defineLocale("kk",{months:"Ã’â€ºÃÂ°Ã’Â£Ã‘â€šÃÂ°Ã‘â‚¬_ÃÂ°Ã’â€ºÃÂ¿ÃÂ°ÃÂ½_ÃÂ½ÃÂ°Ã‘Æ’Ã‘â‚¬Ã‘â€¹ÃÂ·_Ã‘ÂÃ“â„¢Ã‘Æ’Ã‘â€“Ã‘â‚¬_ÃÂ¼ÃÂ°ÃÂ¼Ã‘â€¹Ã‘â‚¬_ÃÂ¼ÃÂ°Ã‘Æ’Ã‘ÂÃ‘â€¹ÃÂ¼_Ã‘Ë†Ã‘â€“ÃÂ»ÃÂ´ÃÂµ_Ã‘â€šÃÂ°ÃÂ¼Ã‘â€¹ÃÂ·_Ã’â€ºÃ‘â€¹Ã‘â‚¬ÃÂºÃ’Â¯ÃÂ¹ÃÂµÃÂº_Ã’â€ºÃÂ°ÃÂ·ÃÂ°ÃÂ½_Ã’â€ºÃÂ°Ã‘â‚¬ÃÂ°Ã‘Ë†ÃÂ°_ÃÂ¶ÃÂµÃÂ»Ã‘â€šÃÂ¾Ã’â€ºÃ‘ÂÃÂ°ÃÂ½".split("_"),monthsShort:"Ã’â€ºÃÂ°Ã’Â£_ÃÂ°Ã’â€ºÃÂ¿_ÃÂ½ÃÂ°Ã‘Æ’_Ã‘ÂÃ“â„¢Ã‘Æ’_ÃÂ¼ÃÂ°ÃÂ¼_ÃÂ¼ÃÂ°Ã‘Æ’_Ã‘Ë†Ã‘â€“ÃÂ»_Ã‘â€šÃÂ°ÃÂ¼_Ã’â€ºÃ‘â€¹Ã‘â‚¬_Ã’â€ºÃÂ°ÃÂ·_Ã’â€ºÃÂ°Ã‘â‚¬_ÃÂ¶ÃÂµÃÂ»".split("_"),weekdays:"ÃÂ¶ÃÂµÃÂºÃ‘ÂÃÂµÃÂ½ÃÂ±Ã‘â€“_ÃÂ´Ã’Â¯ÃÂ¹Ã‘ÂÃÂµÃÂ½ÃÂ±Ã‘â€“_Ã‘ÂÃÂµÃÂ¹Ã‘ÂÃÂµÃÂ½ÃÂ±Ã‘â€“_Ã‘ÂÃ“â„¢Ã‘â‚¬Ã‘ÂÃÂµÃÂ½ÃÂ±Ã‘â€“_ÃÂ±ÃÂµÃÂ¹Ã‘ÂÃÂµÃÂ½ÃÂ±Ã‘â€“_ÃÂ¶Ã’Â±ÃÂ¼ÃÂ°_Ã‘ÂÃÂµÃÂ½ÃÂ±Ã‘â€“".split("_"),weekdaysShort:"ÃÂ¶ÃÂµÃÂº_ÃÂ´Ã’Â¯ÃÂ¹_Ã‘ÂÃÂµÃÂ¹_Ã‘ÂÃ“â„¢Ã‘â‚¬_ÃÂ±ÃÂµÃÂ¹_ÃÂ¶Ã’Â±ÃÂ¼_Ã‘ÂÃÂµÃÂ½".split("_"),weekdaysMin:"ÃÂ¶ÃÂº_ÃÂ´ÃÂ¹_Ã‘ÂÃÂ¹_Ã‘ÂÃ‘â‚¬_ÃÂ±ÃÂ¹_ÃÂ¶ÃÂ¼_Ã‘ÂÃÂ½".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Ãâ€˜Ã’Â¯ÃÂ³Ã‘â€“ÃÂ½ Ã‘ÂÃÂ°Ã’â€œÃÂ°Ã‘â€š] LT",nextDay:"[Ãâ€¢Ã‘â‚¬Ã‘â€šÃÂµÃ’Â£ Ã‘ÂÃÂ°Ã’â€œÃÂ°Ã‘â€š] LT",nextWeek:"dddd [Ã‘ÂÃÂ°Ã’â€œÃÂ°Ã‘â€š] LT",lastDay:"[ÃÅ¡ÃÂµÃ‘Ë†ÃÂµ Ã‘ÂÃÂ°Ã’â€œÃÂ°Ã‘â€š] LT",lastWeek:"[Ã“Â¨Ã‘â€šÃÂºÃÂµÃÂ½ ÃÂ°ÃÂ¿Ã‘â€šÃÂ°ÃÂ½Ã‘â€¹Ã’Â£] dddd [Ã‘ÂÃÂ°Ã’â€œÃÂ°Ã‘â€š] LT",sameElse:"L"},relativeTime:{future:"%s Ã‘â€“Ã‘Ë†Ã‘â€“ÃÂ½ÃÂ´ÃÂµ",past:"%s ÃÂ±Ã’Â±Ã‘â‚¬Ã‘â€¹ÃÂ½",s:"ÃÂ±Ã‘â€“Ã‘â‚¬ÃÂ½ÃÂµÃ‘Ë†ÃÂµ Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´",m:"ÃÂ±Ã‘â€“Ã‘â‚¬ ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€š",mm:"%d ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€š",h:"ÃÂ±Ã‘â€“Ã‘â‚¬ Ã‘ÂÃÂ°Ã’â€œÃÂ°Ã‘â€š",hh:"%d Ã‘ÂÃÂ°Ã’â€œÃÂ°Ã‘â€š",d:"ÃÂ±Ã‘â€“Ã‘â‚¬ ÃÂºÃ’Â¯ÃÂ½",dd:"%d ÃÂºÃ’Â¯ÃÂ½",M:"ÃÂ±Ã‘â€“Ã‘â‚¬ ÃÂ°ÃÂ¹",MM:"%d ÃÂ°ÃÂ¹",y:"ÃÂ±Ã‘â€“Ã‘â‚¬ ÃÂ¶Ã‘â€¹ÃÂ»",yy:"%d ÃÂ¶Ã‘â€¹ÃÂ»"},ordinalParse:/\d{1,2}-(Ã‘Ë†Ã‘â€“|Ã‘Ë†Ã‘â€¹)/,ordinal:function(a){var b=a%10,c=a>=100?100:null;return a+(Ug[a]||Ug[b]||Ug[c])},week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("km",{months:"Ã¡Å¾ËœÃ¡Å¾â‚¬Ã¡Å¾Å¡Ã¡Å¾Â¶_Ã¡Å¾â‚¬Ã¡Å¾Â»Ã¡Å¾ËœÃ¡Å¸â€™Ã¡Å¾â€”Ã¡Å¸Ë†_Ã¡Å¾ËœÃ¡Å¾Â¸Ã¡Å¾â€œÃ¡Å¾Â¶_Ã¡Å¾ËœÃ¡Å¸ÂÃ¡Å¾Å¸Ã¡Å¾Â¶_Ã¡Å¾Â§Ã¡Å¾Å¸Ã¡Å¾â€”Ã¡Å¾Â¶_Ã¡Å¾ËœÃ¡Å¾Â·Ã¡Å¾ÂÃ¡Å¾Â»Ã¡Å¾â€œÃ¡Å¾Â¶_Ã¡Å¾â‚¬Ã¡Å¾â‚¬Ã¡Å¸â€™Ã¡Å¾â‚¬Ã¡Å¾Å Ã¡Å¾Â¶_Ã¡Å¾Å¸Ã¡Å¾Â¸Ã¡Å¾ Ã¡Å¾Â¶_Ã¡Å¾â‚¬Ã¡Å¾â€°Ã¡Å¸â€™Ã¡Å¾â€°Ã¡Å¾Â¶_Ã¡Å¾ÂÃ¡Å¾Â»Ã¡Å¾â€ºÃ¡Å¾Â¶_Ã¡Å¾Å“Ã¡Å¾Â·Ã¡Å¾â€¦Ã¡Å¸â€™Ã¡Å¾â€ Ã¡Å¾Â·Ã¡Å¾â‚¬Ã¡Å¾Â¶_Ã¡Å¾â€™Ã¡Å¸â€™Ã¡Å¾â€œÃ¡Å¾Â¼".split("_"),monthsShort:"Ã¡Å¾ËœÃ¡Å¾â‚¬Ã¡Å¾Å¡Ã¡Å¾Â¶_Ã¡Å¾â‚¬Ã¡Å¾Â»Ã¡Å¾ËœÃ¡Å¸â€™Ã¡Å¾â€”Ã¡Å¸Ë†_Ã¡Å¾ËœÃ¡Å¾Â¸Ã¡Å¾â€œÃ¡Å¾Â¶_Ã¡Å¾ËœÃ¡Å¸ÂÃ¡Å¾Å¸Ã¡Å¾Â¶_Ã¡Å¾Â§Ã¡Å¾Å¸Ã¡Å¾â€”Ã¡Å¾Â¶_Ã¡Å¾ËœÃ¡Å¾Â·Ã¡Å¾ÂÃ¡Å¾Â»Ã¡Å¾â€œÃ¡Å¾Â¶_Ã¡Å¾â‚¬Ã¡Å¾â‚¬Ã¡Å¸â€™Ã¡Å¾â‚¬Ã¡Å¾Å Ã¡Å¾Â¶_Ã¡Å¾Å¸Ã¡Å¾Â¸Ã¡Å¾ Ã¡Å¾Â¶_Ã¡Å¾â‚¬Ã¡Å¾â€°Ã¡Å¸â€™Ã¡Å¾â€°Ã¡Å¾Â¶_Ã¡Å¾ÂÃ¡Å¾Â»Ã¡Å¾â€ºÃ¡Å¾Â¶_Ã¡Å¾Å“Ã¡Å¾Â·Ã¡Å¾â€¦Ã¡Å¸â€™Ã¡Å¾â€ Ã¡Å¾Â·Ã¡Å¾â‚¬Ã¡Å¾Â¶_Ã¡Å¾â€™Ã¡Å¸â€™Ã¡Å¾â€œÃ¡Å¾Â¼".split("_"),weekdays:"Ã¡Å¾Â¢Ã¡Å¾Â¶Ã¡Å¾â€˜Ã¡Å¾Â·Ã¡Å¾ÂÃ¡Å¸â€™Ã¡Å¾â„¢_Ã¡Å¾â€¦Ã¡Å¸ÂÃ¡Å¾â€œÃ¡Å¸â€™Ã¡Å¾â€˜_Ã¡Å¾Â¢Ã¡Å¾â€žÃ¡Å¸â€™Ã¡Å¾â€šÃ¡Å¾Â¶Ã¡Å¾Å¡_Ã¡Å¾â€“Ã¡Å¾Â»Ã¡Å¾â€™_Ã¡Å¾â€“Ã¡Å¸â€™Ã¡Å¾Å¡Ã¡Å¾ Ã¡Å¾Å¸Ã¡Å¸â€™Ã¡Å¾â€Ã¡Å¾ÂÃ¡Å¾Â·Ã¡Å¸Â_Ã¡Å¾Å¸Ã¡Å¾Â»Ã¡Å¾â‚¬Ã¡Å¸â€™Ã¡Å¾Å¡_Ã¡Å¾Å¸Ã¡Å¸â€¦Ã¡Å¾Å¡Ã¡Å¸Â".split("_"),weekdaysShort:"Ã¡Å¾Â¢Ã¡Å¾Â¶Ã¡Å¾â€˜Ã¡Å¾Â·Ã¡Å¾ÂÃ¡Å¸â€™Ã¡Å¾â„¢_Ã¡Å¾â€¦Ã¡Å¸ÂÃ¡Å¾â€œÃ¡Å¸â€™Ã¡Å¾â€˜_Ã¡Å¾Â¢Ã¡Å¾â€žÃ¡Å¸â€™Ã¡Å¾â€šÃ¡Å¾Â¶Ã¡Å¾Å¡_Ã¡Å¾â€“Ã¡Å¾Â»Ã¡Å¾â€™_Ã¡Å¾â€“Ã¡Å¸â€™Ã¡Å¾Å¡Ã¡Å¾ Ã¡Å¾Å¸Ã¡Å¸â€™Ã¡Å¾â€Ã¡Å¾ÂÃ¡Å¾Â·Ã¡Å¸Â_Ã¡Å¾Å¸Ã¡Å¾Â»Ã¡Å¾â‚¬Ã¡Å¸â€™Ã¡Å¾Å¡_Ã¡Å¾Å¸Ã¡Å¸â€¦Ã¡Å¾Å¡Ã¡Å¸Â".split("_"),weekdaysMin:"Ã¡Å¾Â¢Ã¡Å¾Â¶Ã¡Å¾â€˜Ã¡Å¾Â·Ã¡Å¾ÂÃ¡Å¸â€™Ã¡Å¾â„¢_Ã¡Å¾â€¦Ã¡Å¸ÂÃ¡Å¾â€œÃ¡Å¸â€™Ã¡Å¾â€˜_Ã¡Å¾Â¢Ã¡Å¾â€žÃ¡Å¸â€™Ã¡Å¾â€šÃ¡Å¾Â¶Ã¡Å¾Å¡_Ã¡Å¾â€“Ã¡Å¾Â»Ã¡Å¾â€™_Ã¡Å¾â€“Ã¡Å¸â€™Ã¡Å¾Å¡Ã¡Å¾ Ã¡Å¾Å¸Ã¡Å¸â€™Ã¡Å¾â€Ã¡Å¾ÂÃ¡Å¾Â·Ã¡Å¸Â_Ã¡Å¾Å¸Ã¡Å¾Â»Ã¡Å¾â‚¬Ã¡Å¸â€™Ã¡Å¾Å¡_Ã¡Å¾Å¸Ã¡Å¸â€¦Ã¡Å¾Å¡Ã¡Å¸Â".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Ã¡Å¾ÂÃ¡Å¸â€™Ã¡Å¾â€žÃ¡Å¸Æ’Ã¡Å¾â€œÃ¡Å¸ÂÃ¡Å¸â€¡ Ã¡Å¾ËœÃ¡Å¸â€°Ã¡Å¸â€žÃ¡Å¾â€ž] LT",nextDay:"[Ã¡Å¾Å¸Ã¡Å¸â€™Ã¡Å¾Â¢Ã¡Å¸â€šÃ¡Å¾â‚¬ Ã¡Å¾ËœÃ¡Å¸â€°Ã¡Å¸â€žÃ¡Å¾â€ž] LT",nextWeek:"dddd [Ã¡Å¾ËœÃ¡Å¸â€°Ã¡Å¸â€žÃ¡Å¾â€ž] LT",lastDay:"[Ã¡Å¾ËœÃ¡Å¸â€™Ã¡Å¾Å¸Ã¡Å¾Â·Ã¡Å¾â€ºÃ¡Å¾ËœÃ¡Å¾Â·Ã¡Å¾â€° Ã¡Å¾ËœÃ¡Å¸â€°Ã¡Å¸â€žÃ¡Å¾â€ž] LT",lastWeek:"dddd [Ã¡Å¾Å¸Ã¡Å¾â€Ã¡Å¸â€™Ã¡Å¾ÂÃ¡Å¾Â¶Ã¡Å¾ Ã¡Å¸ÂÃ¡Å¾ËœÃ¡Å¾Â»Ã¡Å¾â€œ] [Ã¡Å¾ËœÃ¡Å¸â€°Ã¡Å¸â€žÃ¡Å¾â€ž] LT",sameElse:"L"},relativeTime:{future:"%sÃ¡Å¾â€˜Ã¡Å¸â‚¬Ã¡Å¾Â",past:"%sÃ¡Å¾ËœÃ¡Å¾Â»Ã¡Å¾â€œ",s:"Ã¡Å¾â€Ã¡Å¸â€°Ã¡Å¾Â»Ã¡Å¾â€œÃ¡Å¸â€™Ã¡Å¾ËœÃ¡Å¾Â¶Ã¡Å¾â€œÃ¡Å¾Å“Ã¡Å¾Â·Ã¡Å¾â€œÃ¡Å¾Â¶Ã¡Å¾â€˜Ã¡Å¾Â¸",m:"Ã¡Å¾ËœÃ¡Å¾Â½Ã¡Å¾â„¢Ã¡Å¾â€œÃ¡Å¾Â¶Ã¡Å¾â€˜Ã¡Å¾Â¸",mm:"%d Ã¡Å¾â€œÃ¡Å¾Â¶Ã¡Å¾â€˜Ã¡Å¾Â¸",h:"Ã¡Å¾ËœÃ¡Å¾Â½Ã¡Å¾â„¢Ã¡Å¾ËœÃ¡Å¸â€°Ã¡Å¸â€žÃ¡Å¾â€ž",hh:"%d Ã¡Å¾ËœÃ¡Å¸â€°Ã¡Å¸â€žÃ¡Å¾â€ž",d:"Ã¡Å¾ËœÃ¡Å¾Â½Ã¡Å¾â„¢Ã¡Å¾ÂÃ¡Å¸â€™Ã¡Å¾â€žÃ¡Å¸Æ’",dd:"%d Ã¡Å¾ÂÃ¡Å¸â€™Ã¡Å¾â€žÃ¡Å¸Æ’",M:"Ã¡Å¾ËœÃ¡Å¾Â½Ã¡Å¾â„¢Ã¡Å¾ÂÃ¡Å¸â€š",MM:"%d Ã¡Å¾ÂÃ¡Å¸â€š",y:"Ã¡Å¾ËœÃ¡Å¾Â½Ã¡Å¾â„¢Ã¡Å¾â€ Ã¡Å¸â€™Ã¡Å¾â€œÃ¡Å¾Â¶Ã¡Å¸â€ ",yy:"%d Ã¡Å¾â€ Ã¡Å¸â€™Ã¡Å¾â€œÃ¡Å¾Â¶Ã¡Å¸â€ "},week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("ko",{months:"1Ã¬â€ºâ€_2Ã¬â€ºâ€_3Ã¬â€ºâ€_4Ã¬â€ºâ€_5Ã¬â€ºâ€_6Ã¬â€ºâ€_7Ã¬â€ºâ€_8Ã¬â€ºâ€_9Ã¬â€ºâ€_10Ã¬â€ºâ€_11Ã¬â€ºâ€_12Ã¬â€ºâ€".split("_"),monthsShort:"1Ã¬â€ºâ€_2Ã¬â€ºâ€_3Ã¬â€ºâ€_4Ã¬â€ºâ€_5Ã¬â€ºâ€_6Ã¬â€ºâ€_7Ã¬â€ºâ€_8Ã¬â€ºâ€_9Ã¬â€ºâ€_10Ã¬â€ºâ€_11Ã¬â€ºâ€_12Ã¬â€ºâ€".split("_"),weekdays:"Ã¬ÂÂ¼Ã¬Å¡â€Ã¬ÂÂ¼_Ã¬â€ºâ€Ã¬Å¡â€Ã¬ÂÂ¼_Ã­â„¢â€Ã¬Å¡â€Ã¬ÂÂ¼_Ã¬Ë†ËœÃ¬Å¡â€Ã¬ÂÂ¼_Ã«ÂªÂ©Ã¬Å¡â€Ã¬ÂÂ¼_ÃªÂ¸Ë†Ã¬Å¡â€Ã¬ÂÂ¼_Ã­â€  Ã¬Å¡â€Ã¬ÂÂ¼".split("_"),weekdaysShort:"Ã¬ÂÂ¼_Ã¬â€ºâ€_Ã­â„¢â€_Ã¬Ë†Ëœ_Ã«ÂªÂ©_ÃªÂ¸Ë†_Ã­â€  ".split("_"),weekdaysMin:"Ã¬ÂÂ¼_Ã¬â€ºâ€_Ã­â„¢â€_Ã¬Ë†Ëœ_Ã«ÂªÂ©_ÃªÂ¸Ë†_Ã­â€  ".split("_"),longDateFormat:{LT:"A hÃ¬â€¹Å“ mÃ«Â¶â€ž",LTS:"A hÃ¬â€¹Å“ mÃ«Â¶â€ž sÃ¬Â´Ë†",L:"YYYY.MM.DD",LL:"YYYYÃ«â€¦â€ž MMMM DÃ¬ÂÂ¼",LLL:"YYYYÃ«â€¦â€ž MMMM DÃ¬ÂÂ¼ A hÃ¬â€¹Å“ mÃ«Â¶â€ž",LLLL:"YYYYÃ«â€¦â€ž MMMM DÃ¬ÂÂ¼ dddd A hÃ¬â€¹Å“ mÃ«Â¶â€ž"},calendar:{sameDay:"Ã¬ËœÂ¤Ã«Å Ëœ LT",nextDay:"Ã«â€šÂ´Ã¬ÂÂ¼ LT",nextWeek:"dddd LT",lastDay:"Ã¬â€“Â´Ã¬ Å“ LT",lastWeek:"Ã¬Â§â‚¬Ã«â€šÅ“Ã¬Â£Â¼ dddd LT",sameElse:"L"},relativeTime:{future:"%s Ã­â€ºâ€ž",past:"%s Ã¬ â€ž",s:"Ã«Âªâ€¡ Ã¬Â´Ë†",ss:"%dÃ¬Â´Ë†",m:"Ã¬ÂÂ¼Ã«Â¶â€ž",mm:"%dÃ«Â¶â€ž",h:"Ã­â€¢Å“ Ã¬â€¹Å“ÃªÂ°â€ž",hh:"%dÃ¬â€¹Å“ÃªÂ°â€ž",d:"Ã­â€¢ËœÃ«Â£Â¨",dd:"%dÃ¬ÂÂ¼",M:"Ã­â€¢Å“ Ã«â€¹Â¬",MM:"%dÃ«â€¹Â¬",y:"Ã¬ÂÂ¼ Ã«â€¦â€ž",yy:"%dÃ«â€¦â€ž"},ordinalParse:/\d{1,2}Ã¬ÂÂ¼/,ordinal:"%dÃ¬ÂÂ¼",meridiemParse:/Ã¬ËœÂ¤Ã¬ â€ž|Ã¬ËœÂ¤Ã­â€ºâ€ž/,isPM:function(a){return"Ã¬ËœÂ¤Ã­â€ºâ€ž"===a},meridiem:function(a,b,c){return 12>a?"Ã¬ËœÂ¤Ã¬ â€ž":"Ã¬ËœÂ¤Ã­â€ºâ€ž"}}),{0:"-Ã‘â€¡Ã’Â¯",1:"-Ã‘â€¡ÃÂ¸",2:"-Ã‘â€¡ÃÂ¸",3:"-Ã‘â€¡Ã’Â¯",4:"-Ã‘â€¡Ã’Â¯",5:"-Ã‘â€¡ÃÂ¸",6:"-Ã‘â€¡Ã‘â€¹",7:"-Ã‘â€¡ÃÂ¸",8:"-Ã‘â€¡ÃÂ¸",9:"-Ã‘â€¡Ã‘Æ’",10:"-Ã‘â€¡Ã‘Æ’",20:"-Ã‘â€¡Ã‘â€¹",30:"-Ã‘â€¡Ã‘Æ’",40:"-Ã‘â€¡Ã‘â€¹",50:"-Ã‘â€¡Ã’Â¯",60:"-Ã‘â€¡Ã‘â€¹",70:"-Ã‘â€¡ÃÂ¸",80:"-Ã‘â€¡ÃÂ¸",90:"-Ã‘â€¡Ã‘Æ’",100:"-Ã‘â€¡Ã’Â¯"}),Wg=(kg.defineLocale("ky",{months:"Ã‘ÂÃÂ½ÃÂ²ÃÂ°Ã‘â‚¬Ã‘Å’_Ã‘â€žÃÂµÃÂ²Ã‘â‚¬ÃÂ°ÃÂ»Ã‘Å’_ÃÂ¼ÃÂ°Ã‘â‚¬Ã‘â€š_ÃÂ°ÃÂ¿Ã‘â‚¬ÃÂµÃÂ»Ã‘Å’_ÃÂ¼ÃÂ°ÃÂ¹_ÃÂ¸Ã‘Å½ÃÂ½Ã‘Å’_ÃÂ¸Ã‘Å½ÃÂ»Ã‘Å’_ÃÂ°ÃÂ²ÃÂ³Ã‘Æ’Ã‘ÂÃ‘â€š_Ã‘ÂÃÂµÃÂ½Ã‘â€šÃ‘ÂÃÂ±Ã‘â‚¬Ã‘Å’_ÃÂ¾ÃÂºÃ‘â€šÃ‘ÂÃÂ±Ã‘â‚¬Ã‘Å’_ÃÂ½ÃÂ¾Ã‘ÂÃÂ±Ã‘â‚¬Ã‘Å’_ÃÂ´ÃÂµÃÂºÃÂ°ÃÂ±Ã‘â‚¬Ã‘Å’".split("_"),monthsShort:"Ã‘ÂÃÂ½ÃÂ²_Ã‘â€žÃÂµÃÂ²_ÃÂ¼ÃÂ°Ã‘â‚¬Ã‘â€š_ÃÂ°ÃÂ¿Ã‘â‚¬_ÃÂ¼ÃÂ°ÃÂ¹_ÃÂ¸Ã‘Å½ÃÂ½Ã‘Å’_ÃÂ¸Ã‘Å½ÃÂ»Ã‘Å’_ÃÂ°ÃÂ²ÃÂ³_Ã‘ÂÃÂµÃÂ½_ÃÂ¾ÃÂºÃ‘â€š_ÃÂ½ÃÂ¾Ã‘Â_ÃÂ´ÃÂµÃÂº".split("_"),weekdays:"Ãâ€“ÃÂµÃÂºÃ‘Ë†ÃÂµÃÂ¼ÃÂ±ÃÂ¸_Ãâ€Ã’Â¯ÃÂ¹Ã‘Ë†Ã“Â©ÃÂ¼ÃÂ±Ã’Â¯_ÃÂ¨ÃÂµÃÂ¹Ã‘Ë†ÃÂµÃÂ¼ÃÂ±ÃÂ¸_ÃÂ¨ÃÂ°Ã‘â‚¬Ã‘Ë†ÃÂµÃÂ¼ÃÂ±ÃÂ¸_Ãâ€˜ÃÂµÃÂ¹Ã‘Ë†ÃÂµÃÂ¼ÃÂ±ÃÂ¸_Ãâ€“Ã‘Æ’ÃÂ¼ÃÂ°_ÃËœÃ‘Ë†ÃÂµÃÂ¼ÃÂ±ÃÂ¸".split("_"),weekdaysShort:"Ãâ€“ÃÂµÃÂº_Ãâ€Ã’Â¯ÃÂ¹_ÃÂ¨ÃÂµÃÂ¹_ÃÂ¨ÃÂ°Ã‘â‚¬_Ãâ€˜ÃÂµÃÂ¹_Ãâ€“Ã‘Æ’ÃÂ¼_ÃËœÃ‘Ë†ÃÂµ".split("_"),weekdaysMin:"Ãâ€“ÃÂº_Ãâ€ÃÂ¹_ÃÂ¨ÃÂ¹_ÃÂ¨Ã‘â‚¬_Ãâ€˜ÃÂ¹_Ãâ€“ÃÂ¼_ÃËœÃ‘Ë†".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Ãâ€˜Ã’Â¯ÃÂ³Ã’Â¯ÃÂ½ Ã‘ÂÃÂ°ÃÂ°Ã‘â€š] LT",nextDay:"[ÃÂ­Ã‘â‚¬Ã‘â€šÃÂµÃ’Â£ Ã‘ÂÃÂ°ÃÂ°Ã‘â€š] LT",nextWeek:"dddd [Ã‘ÂÃÂ°ÃÂ°Ã‘â€š] LT",lastDay:"[ÃÅ¡ÃÂµÃ‘â€¡ÃÂµ Ã‘ÂÃÂ°ÃÂ°Ã‘â€š] LT",lastWeek:"[Ã“Â¨Ã‘â€šÃÂºÃÂµÃÂ½ ÃÂ°ÃÂ¿Ã‘â€šÃÂ°ÃÂ½Ã‘â€¹ÃÂ½] dddd [ÃÂºÃ’Â¯ÃÂ½Ã’Â¯] [Ã‘ÂÃÂ°ÃÂ°Ã‘â€š] LT",sameElse:"L"},relativeTime:{future:"%s ÃÂ¸Ã‘â€¡ÃÂ¸ÃÂ½ÃÂ´ÃÂµ",past:"%s ÃÂ¼Ã‘Æ’Ã‘â‚¬Ã‘Æ’ÃÂ½",s:"ÃÂ±ÃÂ¸Ã‘â‚¬ÃÂ½ÃÂµÃ‘â€¡ÃÂµ Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´",m:"ÃÂ±ÃÂ¸Ã‘â‚¬ ÃÂ¼Ã’Â¯ÃÂ½Ã“Â©Ã‘â€š",mm:"%d ÃÂ¼Ã’Â¯ÃÂ½Ã“Â©Ã‘â€š",h:"ÃÂ±ÃÂ¸Ã‘â‚¬ Ã‘ÂÃÂ°ÃÂ°Ã‘â€š",hh:"%d Ã‘ÂÃÂ°ÃÂ°Ã‘â€š",d:"ÃÂ±ÃÂ¸Ã‘â‚¬ ÃÂºÃ’Â¯ÃÂ½",dd:"%d ÃÂºÃ’Â¯ÃÂ½",M:"ÃÂ±ÃÂ¸Ã‘â‚¬ ÃÂ°ÃÂ¹",MM:"%d ÃÂ°ÃÂ¹",y:"ÃÂ±ÃÂ¸Ã‘â‚¬ ÃÂ¶Ã‘â€¹ÃÂ»",yy:"%d ÃÂ¶Ã‘â€¹ÃÂ»"},ordinalParse:/\d{1,2}-(Ã‘â€¡ÃÂ¸|Ã‘â€¡Ã‘â€¹|Ã‘â€¡Ã’Â¯|Ã‘â€¡Ã‘Æ’)/,ordinal:function(a){var b=a%10,c=a>=100?100:null;return a+(Vg[a]||Vg[b]||Vg[c])},week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("lb",{months:"Januar_Februar_MÃƒÂ¤erz_AbrÃƒÂ«ll_Mee_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),monthsShort:"Jan._Febr._Mrz._Abr._Mee_Jun._Jul._Aug._Sept._Okt._Nov._Dez.".split("_"),monthsParseExact:!0,weekdays:"Sonndeg_MÃƒÂ©indeg_DÃƒÂ«nschdeg_MÃƒÂ«ttwoch_Donneschdeg_Freideg_Samschdeg".split("_"),weekdaysShort:"So._MÃƒÂ©._DÃƒÂ«._MÃƒÂ«._Do._Fr._Sa.".split("_"),weekdaysMin:"So_MÃƒÂ©_DÃƒÂ«_MÃƒÂ«_Do_Fr_Sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm [Auer]",LTS:"H:mm:ss [Auer]",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm [Auer]",LLLL:"dddd, D. MMMM YYYY H:mm [Auer]"},calendar:{sameDay:"[Haut um] LT",sameElse:"L",nextDay:"[Muer um] LT",nextWeek:"dddd [um] LT",lastDay:"[GÃƒÂ«schter um] LT",lastWeek:function(){
// Different date string for 'DÃƒÂ«nschdeg' (Tuesday) and 'Donneschdeg' (Thursday) due to phonological rule
switch(this.day()){case 2:case 4:return"[Leschten] dddd [um] LT";default:return"[Leschte] dddd [um] LT"}}},relativeTime:{future:Hd,past:Id,s:"e puer Sekonnen",m:Gd,mm:"%d Minutten",h:Gd,hh:"%d Stonnen",d:Gd,dd:"%d Deeg",M:Gd,MM:"%d MÃƒÂ©int",y:Gd,yy:"%d Joer"},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("lo",{months:"Ã ÂºÂ¡Ã ÂºÂ±Ã Âºâ€¡Ã ÂºÂÃ ÂºÂ­Ã Âºâ„¢_Ã ÂºÂÃ ÂºÂ¸Ã ÂºÂ¡Ã ÂºÅ¾Ã ÂºÂ²_Ã ÂºÂ¡Ã ÂºÂµÃ Âºâ„¢Ã ÂºÂ²_Ã Â»â‚¬Ã ÂºÂ¡Ã ÂºÂªÃ ÂºÂ²_Ã ÂºÅ¾Ã ÂºÂ¶Ã Âºâ€Ã ÂºÂªÃ ÂºÂ°Ã ÂºÅ¾Ã ÂºÂ²_Ã ÂºÂ¡Ã ÂºÂ´Ã Âºâ€“Ã ÂºÂ¸Ã Âºâ„¢Ã ÂºÂ²_Ã ÂºÂÃ Â»ÂÃ ÂºÂ¥Ã ÂºÂ°Ã ÂºÂÃ ÂºÂ»Ã Âºâ€_Ã ÂºÂªÃ ÂºÂ´Ã Âºâ€¡Ã ÂºÂ«Ã ÂºÂ²_Ã ÂºÂÃ ÂºÂ±Ã Âºâ„¢Ã ÂºÂÃ ÂºÂ²_Ã Âºâ€¢Ã ÂºÂ¸Ã ÂºÂ¥Ã ÂºÂ²_Ã ÂºÅ¾Ã ÂºÂ°Ã ÂºË†Ã ÂºÂ´Ã ÂºÂ_Ã Âºâ€”Ã ÂºÂ±Ã Âºâ„¢Ã ÂºÂ§Ã ÂºÂ²".split("_"),monthsShort:"Ã ÂºÂ¡Ã ÂºÂ±Ã Âºâ€¡Ã ÂºÂÃ ÂºÂ­Ã Âºâ„¢_Ã ÂºÂÃ ÂºÂ¸Ã ÂºÂ¡Ã ÂºÅ¾Ã ÂºÂ²_Ã ÂºÂ¡Ã ÂºÂµÃ Âºâ„¢Ã ÂºÂ²_Ã Â»â‚¬Ã ÂºÂ¡Ã ÂºÂªÃ ÂºÂ²_Ã ÂºÅ¾Ã ÂºÂ¶Ã Âºâ€Ã ÂºÂªÃ ÂºÂ°Ã ÂºÅ¾Ã ÂºÂ²_Ã ÂºÂ¡Ã ÂºÂ´Ã Âºâ€“Ã ÂºÂ¸Ã Âºâ„¢Ã ÂºÂ²_Ã ÂºÂÃ Â»ÂÃ ÂºÂ¥Ã ÂºÂ°Ã ÂºÂÃ ÂºÂ»Ã Âºâ€_Ã ÂºÂªÃ ÂºÂ´Ã Âºâ€¡Ã ÂºÂ«Ã ÂºÂ²_Ã ÂºÂÃ ÂºÂ±Ã Âºâ„¢Ã ÂºÂÃ ÂºÂ²_Ã Âºâ€¢Ã ÂºÂ¸Ã ÂºÂ¥Ã ÂºÂ²_Ã ÂºÅ¾Ã ÂºÂ°Ã ÂºË†Ã ÂºÂ´Ã ÂºÂ_Ã Âºâ€”Ã ÂºÂ±Ã Âºâ„¢Ã ÂºÂ§Ã ÂºÂ²".split("_"),weekdays:"Ã ÂºÂ­Ã ÂºÂ²Ã Âºâ€”Ã ÂºÂ´Ã Âºâ€_Ã ÂºË†Ã ÂºÂ±Ã Âºâ„¢_Ã ÂºÂ­Ã ÂºÂ±Ã Âºâ€¡Ã Âºâ€žÃ ÂºÂ²Ã Âºâ„¢_Ã ÂºÅ¾Ã ÂºÂ¸Ã Âºâ€_Ã ÂºÅ¾Ã ÂºÂ°Ã ÂºÂ«Ã ÂºÂ±Ã Âºâ€_Ã ÂºÂªÃ ÂºÂ¸Ã ÂºÂ_Ã Â»â‚¬Ã ÂºÂªÃ ÂºÂ»Ã ÂºÂ²".split("_"),weekdaysShort:"Ã Âºâ€”Ã ÂºÂ´Ã Âºâ€_Ã ÂºË†Ã ÂºÂ±Ã Âºâ„¢_Ã ÂºÂ­Ã ÂºÂ±Ã Âºâ€¡Ã Âºâ€žÃ ÂºÂ²Ã Âºâ„¢_Ã ÂºÅ¾Ã ÂºÂ¸Ã Âºâ€_Ã ÂºÅ¾Ã ÂºÂ°Ã ÂºÂ«Ã ÂºÂ±Ã Âºâ€_Ã ÂºÂªÃ ÂºÂ¸Ã ÂºÂ_Ã Â»â‚¬Ã ÂºÂªÃ ÂºÂ»Ã ÂºÂ²".split("_"),weekdaysMin:"Ã Âºâ€”_Ã ÂºË†_Ã ÂºÂ­Ã Âºâ€ž_Ã ÂºÅ¾_Ã ÂºÅ¾Ã ÂºÂ«_Ã ÂºÂªÃ ÂºÂ_Ã ÂºÂª".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"Ã ÂºÂ§Ã ÂºÂ±Ã Âºâ„¢dddd D MMMM YYYY HH:mm"},meridiemParse:/Ã Âºâ€¢Ã ÂºÂ­Ã Âºâ„¢Ã Â»â‚¬Ã ÂºÅ Ã ÂºÂ»Ã Â»â€°Ã ÂºÂ²|Ã Âºâ€¢Ã ÂºÂ­Ã Âºâ„¢Ã Â»ÂÃ ÂºÂ¥Ã Âºâ€¡/,isPM:function(a){return"Ã Âºâ€¢Ã ÂºÂ­Ã Âºâ„¢Ã Â»ÂÃ ÂºÂ¥Ã Âºâ€¡"===a},meridiem:function(a,b,c){return 12>a?"Ã Âºâ€¢Ã ÂºÂ­Ã Âºâ„¢Ã Â»â‚¬Ã ÂºÅ Ã ÂºÂ»Ã Â»â€°Ã ÂºÂ²":"Ã Âºâ€¢Ã ÂºÂ­Ã Âºâ„¢Ã Â»ÂÃ ÂºÂ¥Ã Âºâ€¡"},calendar:{sameDay:"[Ã ÂºÂ¡Ã ÂºÂ·Ã Â»â€°Ã Âºâ„¢Ã ÂºÂµÃ Â»â€°Ã Â»â‚¬Ã ÂºÂ§Ã ÂºÂ¥Ã ÂºÂ²] LT",nextDay:"[Ã ÂºÂ¡Ã ÂºÂ·Ã Â»â€°Ã ÂºÂ­Ã ÂºÂ·Ã Â»Ë†Ã Âºâ„¢Ã Â»â‚¬Ã ÂºÂ§Ã ÂºÂ¥Ã ÂºÂ²] LT",nextWeek:"[Ã ÂºÂ§Ã ÂºÂ±Ã Âºâ„¢]dddd[Ã Â»Å“Ã Â»â€°Ã ÂºÂ²Ã Â»â‚¬Ã ÂºÂ§Ã ÂºÂ¥Ã ÂºÂ²] LT",lastDay:"[Ã ÂºÂ¡Ã ÂºÂ·Ã Â»â€°Ã ÂºÂ§Ã ÂºÂ²Ã Âºâ„¢Ã Âºâ„¢Ã ÂºÂµÃ Â»â€°Ã Â»â‚¬Ã ÂºÂ§Ã ÂºÂ¥Ã ÂºÂ²] LT",lastWeek:"[Ã ÂºÂ§Ã ÂºÂ±Ã Âºâ„¢]dddd[Ã Â»ÂÃ ÂºÂ¥Ã Â»â€°Ã ÂºÂ§Ã Âºâ„¢Ã ÂºÂµÃ Â»â€°Ã Â»â‚¬Ã ÂºÂ§Ã ÂºÂ¥Ã ÂºÂ²] LT",sameElse:"L"},relativeTime:{future:"Ã ÂºÂ­Ã ÂºÂµÃ ÂºÂ %s",past:"%sÃ ÂºÅ“Ã Â»Ë†Ã ÂºÂ²Ã Âºâ„¢Ã ÂºÂ¡Ã ÂºÂ²",s:"Ã ÂºÅ¡Ã Â»ÂÃ Â»Ë†Ã Â»â‚¬Ã Âºâ€”Ã ÂºÂ»Ã Â»Ë†Ã ÂºÂ²Ã Â»Æ’Ã Âºâ€Ã ÂºÂ§Ã ÂºÂ´Ã Âºâ„¢Ã ÂºÂ²Ã Âºâ€”Ã ÂºÂµ",m:"1 Ã Âºâ„¢Ã ÂºÂ²Ã Âºâ€”Ã ÂºÂµ",mm:"%d Ã Âºâ„¢Ã ÂºÂ²Ã Âºâ€”Ã ÂºÂµ",h:"1 Ã ÂºÅ Ã ÂºÂ»Ã Â»Ë†Ã ÂºÂ§Ã Â»â€šÃ ÂºÂ¡Ã Âºâ€¡",hh:"%d Ã ÂºÅ Ã ÂºÂ»Ã Â»Ë†Ã ÂºÂ§Ã Â»â€šÃ ÂºÂ¡Ã Âºâ€¡",d:"1 Ã ÂºÂ¡Ã ÂºÂ·Ã Â»â€°",dd:"%d Ã ÂºÂ¡Ã ÂºÂ·Ã Â»â€°",M:"1 Ã Â»â‚¬Ã Âºâ€Ã ÂºÂ·Ã ÂºÂ­Ã Âºâ„¢",MM:"%d Ã Â»â‚¬Ã Âºâ€Ã ÂºÂ·Ã ÂºÂ­Ã Âºâ„¢",y:"1 Ã Âºâ€ºÃ ÂºÂµ",yy:"%d Ã Âºâ€ºÃ ÂºÂµ"},ordinalParse:/(Ã Âºâ€”Ã ÂºÂµÃ Â»Ë†)\d{1,2}/,ordinal:function(a){return"Ã Âºâ€”Ã ÂºÂµÃ Â»Ë†"+a}}),{m:"minutÃ„â€”_minutÃ„â€”s_minutÃ„â„¢",mm:"minutÃ„â€”s_minuÃ„ÂiÃ…Â³_minutes",h:"valanda_valandos_valandÃ„â€¦",hh:"valandos_valandÃ…Â³_valandas",d:"diena_dienos_dienÃ„â€¦",dd:"dienos_dienÃ…Â³_dienas",M:"mÃ„â€”nuo_mÃ„â€”nesio_mÃ„â€”nesÃ„Â¯",MM:"mÃ„â€”nesiai_mÃ„â€”nesiÃ…Â³_mÃ„â€”nesius",y:"metai_metÃ…Â³_metus",yy:"metai_metÃ…Â³_metus"}),Xg=(kg.defineLocale("lt",{months:{format:"sausio_vasario_kovo_balandÃ…Â¾io_geguÃ…Â¾Ã„â€”s_birÃ…Â¾elio_liepos_rugpjÃ…Â«Ã„Âio_rugsÃ„â€”jo_spalio_lapkriÃ„Âio_gruodÃ…Â¾io".split("_"),standalone:"sausis_vasaris_kovas_balandis_geguÃ…Â¾Ã„â€”_birÃ…Â¾elis_liepa_rugpjÃ…Â«tis_rugsÃ„â€”jis_spalis_lapkritis_gruodis".split("_"),isFormat:/D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?|MMMM?(\[[^\[\]]*\]|\s+)+D[oD]?/},monthsShort:"sau_vas_kov_bal_geg_bir_lie_rgp_rgs_spa_lap_grd".split("_"),weekdays:{format:"sekmadienÃ„Â¯_pirmadienÃ„Â¯_antradienÃ„Â¯_treÃ„ÂiadienÃ„Â¯_ketvirtadienÃ„Â¯_penktadienÃ„Â¯_Ã…Â¡eÃ…Â¡tadienÃ„Â¯".split("_"),standalone:"sekmadienis_pirmadienis_antradienis_treÃ„Âiadienis_ketvirtadienis_penktadienis_Ã…Â¡eÃ…Â¡tadienis".split("_"),isFormat:/dddd HH:mm/},weekdaysShort:"Sek_Pir_Ant_Tre_Ket_Pen_Ã… eÃ…Â¡".split("_"),weekdaysMin:"S_P_A_T_K_Pn_Ã… ".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"YYYY [m.] MMMM D [d.]",LLL:"YYYY [m.] MMMM D [d.], HH:mm [val.]",LLLL:"YYYY [m.] MMMM D [d.], dddd, HH:mm [val.]",l:"YYYY-MM-DD",ll:"YYYY [m.] MMMM D [d.]",lll:"YYYY [m.] MMMM D [d.], HH:mm [val.]",llll:"YYYY [m.] MMMM D [d.], ddd, HH:mm [val.]"},calendar:{sameDay:"[Ã… iandien] LT",nextDay:"[Rytoj] LT",nextWeek:"dddd LT",lastDay:"[Vakar] LT",lastWeek:"[PraÃ„â€”jusÃ„Â¯] dddd LT",sameElse:"L"},relativeTime:{future:"po %s",past:"prieÃ…Â¡ %s",s:Kd,m:Ld,mm:Od,h:Ld,hh:Od,d:Ld,dd:Od,M:Ld,MM:Od,y:Ld,yy:Od},ordinalParse:/\d{1,2}-oji/,ordinal:function(a){return a+"-oji"},week:{dow:1,// Monday is the first day of the week.
doy:4}}),{m:"minÃ…Â«tes_minÃ…Â«tÃ„â€œm_minÃ…Â«te_minÃ…Â«tes".split("_"),mm:"minÃ…Â«tes_minÃ…Â«tÃ„â€œm_minÃ…Â«te_minÃ…Â«tes".split("_"),h:"stundas_stundÃ„Âm_stunda_stundas".split("_"),hh:"stundas_stundÃ„Âm_stunda_stundas".split("_"),d:"dienas_dienÃ„Âm_diena_dienas".split("_"),dd:"dienas_dienÃ„Âm_diena_dienas".split("_"),M:"mÃ„â€œneÃ…Â¡a_mÃ„â€œneÃ…Â¡iem_mÃ„â€œnesis_mÃ„â€œneÃ…Â¡i".split("_"),MM:"mÃ„â€œneÃ…Â¡a_mÃ„â€œneÃ…Â¡iem_mÃ„â€œnesis_mÃ„â€œneÃ…Â¡i".split("_"),y:"gada_gadiem_gads_gadi".split("_"),yy:"gada_gadiem_gads_gadi".split("_")}),Yg=(kg.defineLocale("lv",{months:"janvÃ„Âris_februÃ„Âris_marts_aprÃ„Â«lis_maijs_jÃ…Â«nijs_jÃ…Â«lijs_augusts_septembris_oktobris_novembris_decembris".split("_"),monthsShort:"jan_feb_mar_apr_mai_jÃ…Â«n_jÃ…Â«l_aug_sep_okt_nov_dec".split("_"),weekdays:"svÃ„â€œtdiena_pirmdiena_otrdiena_treÃ…Â¡diena_ceturtdiena_piektdiena_sestdiena".split("_"),weekdaysShort:"Sv_P_O_T_C_Pk_S".split("_"),weekdaysMin:"Sv_P_O_T_C_Pk_S".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY.",LL:"YYYY. [gada] D. MMMM",LLL:"YYYY. [gada] D. MMMM, HH:mm",LLLL:"YYYY. [gada] D. MMMM, dddd, HH:mm"},calendar:{sameDay:"[Ã… odien pulksten] LT",nextDay:"[RÃ„Â«t pulksten] LT",nextWeek:"dddd [pulksten] LT",lastDay:"[Vakar pulksten] LT",lastWeek:"[PagÃ„ÂjuÃ…Â¡Ã„Â] dddd [pulksten] LT",sameElse:"L"},relativeTime:{future:"pÃ„â€œc %s",past:"pirms %s",s:Sd,m:Rd,mm:Qd,h:Rd,hh:Qd,d:Rd,dd:Qd,M:Rd,MM:Qd,y:Rd,yy:Qd},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),{words:{//Different grammatical cases
m:["jedan minut","jednog minuta"],mm:["minut","minuta","minuta"],h:["jedan sat","jednog sata"],hh:["sat","sata","sati"],dd:["dan","dana","dana"],MM:["mjesec","mjeseca","mjeseci"],yy:["godina","godine","godina"]},correctGrammaticalCase:function(a,b){return 1===a?b[0]:a>=2&&4>=a?b[1]:b[2]},translate:function(a,b,c){var d=Yg.words[c];return 1===c.length?b?d[0]:d[1]:a+" "+Yg.correctGrammaticalCase(a,d)}}),Zg=(kg.defineLocale("me",{months:"januar_februar_mart_april_maj_jun_jul_avgust_septembar_oktobar_novembar_decembar".split("_"),monthsShort:"jan._feb._mar._apr._maj_jun_jul_avg._sep._okt._nov._dec.".split("_"),monthsParseExact:!0,weekdays:"nedjelja_ponedjeljak_utorak_srijeda_Ã„Âetvrtak_petak_subota".split("_"),weekdaysShort:"ned._pon._uto._sri._Ã„Âet._pet._sub.".split("_"),weekdaysMin:"ne_po_ut_sr_Ã„Âe_pe_su".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD. MM. YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[danas u] LT",nextDay:"[sjutra u] LT",nextWeek:function(){switch(this.day()){case 0:return"[u] [nedjelju] [u] LT";case 3:return"[u] [srijedu] [u] LT";case 6:return"[u] [subotu] [u] LT";case 1:case 2:case 4:case 5:return"[u] dddd [u] LT"}},lastDay:"[juÃ„Âe u] LT",lastWeek:function(){var a=["[proÃ…Â¡le] [nedjelje] [u] LT","[proÃ…Â¡log] [ponedjeljka] [u] LT","[proÃ…Â¡log] [utorka] [u] LT","[proÃ…Â¡le] [srijede] [u] LT","[proÃ…Â¡log] [Ã„Âetvrtka] [u] LT","[proÃ…Â¡log] [petka] [u] LT","[proÃ…Â¡le] [subote] [u] LT"];return a[this.day()]},sameElse:"L"},relativeTime:{future:"za %s",past:"prije %s",s:"nekoliko sekundi",m:Yg.translate,mm:Yg.translate,h:Yg.translate,hh:Yg.translate,d:"dan",dd:Yg.translate,M:"mjesec",MM:Yg.translate,y:"godinu",yy:Yg.translate},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("mk",{months:"Ã‘ËœÃÂ°ÃÂ½Ã‘Æ’ÃÂ°Ã‘â‚¬ÃÂ¸_Ã‘â€žÃÂµÃÂ²Ã‘â‚¬Ã‘Æ’ÃÂ°Ã‘â‚¬ÃÂ¸_ÃÂ¼ÃÂ°Ã‘â‚¬Ã‘â€š_ÃÂ°ÃÂ¿Ã‘â‚¬ÃÂ¸ÃÂ»_ÃÂ¼ÃÂ°Ã‘Ëœ_Ã‘ËœÃ‘Æ’ÃÂ½ÃÂ¸_Ã‘ËœÃ‘Æ’ÃÂ»ÃÂ¸_ÃÂ°ÃÂ²ÃÂ³Ã‘Æ’Ã‘ÂÃ‘â€š_Ã‘ÂÃÂµÃÂ¿Ã‘â€šÃÂµÃÂ¼ÃÂ²Ã‘â‚¬ÃÂ¸_ÃÂ¾ÃÂºÃ‘â€šÃÂ¾ÃÂ¼ÃÂ²Ã‘â‚¬ÃÂ¸_ÃÂ½ÃÂ¾ÃÂµÃÂ¼ÃÂ²Ã‘â‚¬ÃÂ¸_ÃÂ´ÃÂµÃÂºÃÂµÃÂ¼ÃÂ²Ã‘â‚¬ÃÂ¸".split("_"),monthsShort:"Ã‘ËœÃÂ°ÃÂ½_Ã‘â€žÃÂµÃÂ²_ÃÂ¼ÃÂ°Ã‘â‚¬_ÃÂ°ÃÂ¿Ã‘â‚¬_ÃÂ¼ÃÂ°Ã‘Ëœ_Ã‘ËœÃ‘Æ’ÃÂ½_Ã‘ËœÃ‘Æ’ÃÂ»_ÃÂ°ÃÂ²ÃÂ³_Ã‘ÂÃÂµÃÂ¿_ÃÂ¾ÃÂºÃ‘â€š_ÃÂ½ÃÂ¾ÃÂµ_ÃÂ´ÃÂµÃÂº".split("_"),weekdays:"ÃÂ½ÃÂµÃÂ´ÃÂµÃÂ»ÃÂ°_ÃÂ¿ÃÂ¾ÃÂ½ÃÂµÃÂ´ÃÂµÃÂ»ÃÂ½ÃÂ¸ÃÂº_ÃÂ²Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ½ÃÂ¸ÃÂº_Ã‘ÂÃ‘â‚¬ÃÂµÃÂ´ÃÂ°_Ã‘â€¡ÃÂµÃ‘â€šÃÂ²Ã‘â‚¬Ã‘â€šÃÂ¾ÃÂº_ÃÂ¿ÃÂµÃ‘â€šÃÂ¾ÃÂº_Ã‘ÂÃÂ°ÃÂ±ÃÂ¾Ã‘â€šÃÂ°".split("_"),weekdaysShort:"ÃÂ½ÃÂµÃÂ´_ÃÂ¿ÃÂ¾ÃÂ½_ÃÂ²Ã‘â€šÃÂ¾_Ã‘ÂÃ‘â‚¬ÃÂµ_Ã‘â€¡ÃÂµÃ‘â€š_ÃÂ¿ÃÂµÃ‘â€š_Ã‘ÂÃÂ°ÃÂ±".split("_"),weekdaysMin:"ÃÂ½e_ÃÂ¿o_ÃÂ²Ã‘â€š_Ã‘ÂÃ‘â‚¬_Ã‘â€¡ÃÂµ_ÃÂ¿ÃÂµ_Ã‘Âa".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"D.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY H:mm",LLLL:"dddd, D MMMM YYYY H:mm"},calendar:{sameDay:"[Ãâ€ÃÂµÃÂ½ÃÂµÃ‘Â ÃÂ²ÃÂ¾] LT",nextDay:"[ÃÂ£Ã‘â€šÃ‘â‚¬ÃÂµ ÃÂ²ÃÂ¾] LT",nextWeek:"[Ãâ€™ÃÂ¾] dddd [ÃÂ²ÃÂ¾] LT",lastDay:"[Ãâ€™Ã‘â€¡ÃÂµÃ‘â‚¬ÃÂ° ÃÂ²ÃÂ¾] LT",lastWeek:function(){switch(this.day()){case 0:case 3:case 6:return"[ÃËœÃÂ·ÃÂ¼ÃÂ¸ÃÂ½ÃÂ°Ã‘â€šÃÂ°Ã‘â€šÃÂ°] dddd [ÃÂ²ÃÂ¾] LT";case 1:case 2:case 4:case 5:return"[ÃËœÃÂ·ÃÂ¼ÃÂ¸ÃÂ½ÃÂ°Ã‘â€šÃÂ¸ÃÂ¾Ã‘â€š] dddd [ÃÂ²ÃÂ¾] LT"}},sameElse:"L"},relativeTime:{future:"ÃÂ¿ÃÂ¾Ã‘ÂÃÂ»ÃÂµ %s",past:"ÃÂ¿Ã‘â‚¬ÃÂµÃÂ´ %s",s:"ÃÂ½ÃÂµÃÂºÃÂ¾ÃÂ»ÃÂºÃ‘Æ’ Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ¸",m:"ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€šÃÂ°",mm:"%d ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€šÃÂ¸",h:"Ã‘â€¡ÃÂ°Ã‘Â",hh:"%d Ã‘â€¡ÃÂ°Ã‘ÂÃÂ°",d:"ÃÂ´ÃÂµÃÂ½",dd:"%d ÃÂ´ÃÂµÃÂ½ÃÂ°",M:"ÃÂ¼ÃÂµÃ‘ÂÃÂµÃ‘â€ ",MM:"%d ÃÂ¼ÃÂµÃ‘ÂÃÂµÃ‘â€ ÃÂ¸",y:"ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ°",yy:"%d ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ¸"},ordinalParse:/\d{1,2}-(ÃÂµÃÂ²|ÃÂµÃÂ½|Ã‘â€šÃÂ¸|ÃÂ²ÃÂ¸|Ã‘â‚¬ÃÂ¸|ÃÂ¼ÃÂ¸)/,ordinal:function(a){var b=a%10,c=a%100;return 0===a?a+"-ÃÂµÃÂ²":0===c?a+"-ÃÂµÃÂ½":c>10&&20>c?a+"-Ã‘â€šÃÂ¸":1===b?a+"-ÃÂ²ÃÂ¸":2===b?a+"-Ã‘â‚¬ÃÂ¸":7===b||8===b?a+"-ÃÂ¼ÃÂ¸":a+"-Ã‘â€šÃÂ¸"},week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("ml",{months:"Ã Â´Å“Ã Â´Â¨Ã ÂµÂÃ Â´ÂµÃ Â´Â°Ã Â´Â¿_Ã Â´Â«Ã Âµâ€ Ã Â´Â¬Ã ÂµÂÃ Â´Â°Ã ÂµÂÃ Â´ÂµÃ Â´Â°Ã Â´Â¿_Ã Â´Â®Ã Â´Â¾Ã ÂµÂ¼Ã Â´Å¡Ã ÂµÂÃ Â´Å¡Ã ÂµÂ_Ã Â´ÂÃ Â´ÂªÃ ÂµÂÃ Â´Â°Ã Â´Â¿Ã ÂµÂ½_Ã Â´Â®Ã Âµâ€¡Ã Â´Â¯Ã ÂµÂ_Ã Â´Å“Ã Âµâ€šÃ ÂµÂº_Ã Â´Å“Ã Âµâ€šÃ Â´Â²Ã ÂµË†_Ã Â´â€œÃ Â´â€”Ã Â´Â¸Ã ÂµÂÃ Â´Â±Ã ÂµÂÃ Â´Â±Ã ÂµÂ_Ã Â´Â¸Ã Âµâ€ Ã Â´ÂªÃ ÂµÂÃ Â´Â±Ã ÂµÂÃ Â´Â±Ã Â´â€šÃ Â´Â¬Ã ÂµÂ¼_Ã Â´â€™Ã Â´â€¢Ã ÂµÂÃ Â´Å¸Ã Âµâ€¹Ã Â´Â¬Ã ÂµÂ¼_Ã Â´Â¨Ã Â´ÂµÃ Â´â€šÃ Â´Â¬Ã ÂµÂ¼_Ã Â´Â¡Ã Â´Â¿Ã Â´Â¸Ã Â´â€šÃ Â´Â¬Ã ÂµÂ¼".split("_"),monthsShort:"Ã Â´Å“Ã Â´Â¨Ã ÂµÂ._Ã Â´Â«Ã Âµâ€ Ã Â´Â¬Ã ÂµÂÃ Â´Â°Ã ÂµÂ._Ã Â´Â®Ã Â´Â¾Ã ÂµÂ¼._Ã Â´ÂÃ Â´ÂªÃ ÂµÂÃ Â´Â°Ã Â´Â¿._Ã Â´Â®Ã Âµâ€¡Ã Â´Â¯Ã ÂµÂ_Ã Â´Å“Ã Âµâ€šÃ ÂµÂº_Ã Â´Å“Ã Âµâ€šÃ Â´Â²Ã ÂµË†._Ã Â´â€œÃ Â´â€”._Ã Â´Â¸Ã Âµâ€ Ã Â´ÂªÃ ÂµÂÃ Â´Â±Ã ÂµÂÃ Â´Â±._Ã Â´â€™Ã Â´â€¢Ã ÂµÂÃ Â´Å¸Ã Âµâ€¹._Ã Â´Â¨Ã Â´ÂµÃ Â´â€š._Ã Â´Â¡Ã Â´Â¿Ã Â´Â¸Ã Â´â€š.".split("_"),monthsParseExact:!0,weekdays:"Ã Â´Å¾Ã Â´Â¾Ã Â´Â¯Ã Â´Â±Ã Â´Â¾Ã Â´Â´Ã ÂµÂÃ Â´Å¡_Ã Â´Â¤Ã Â´Â¿Ã Â´â„¢Ã ÂµÂÃ Â´â€¢Ã Â´Â³Ã Â´Â¾Ã Â´Â´Ã ÂµÂÃ Â´Å¡_Ã Â´Å¡Ã ÂµÅ Ã Â´ÂµÃ ÂµÂÃ Â´ÂµÃ Â´Â¾Ã Â´Â´Ã ÂµÂÃ Â´Å¡_Ã Â´Â¬Ã ÂµÂÃ Â´Â§Ã Â´Â¨Ã Â´Â¾Ã Â´Â´Ã ÂµÂÃ Â´Å¡_Ã Â´ÂµÃ ÂµÂÃ Â´Â¯Ã Â´Â¾Ã Â´Â´Ã Â´Â¾Ã Â´Â´Ã ÂµÂÃ Â´Å¡_Ã Â´ÂµÃ Âµâ€ Ã Â´Â³Ã ÂµÂÃ Â´Â³Ã Â´Â¿Ã Â´Â¯Ã Â´Â¾Ã Â´Â´Ã ÂµÂÃ Â´Å¡_Ã Â´Â¶Ã Â´Â¨Ã Â´Â¿Ã Â´Â¯Ã Â´Â¾Ã Â´Â´Ã ÂµÂÃ Â´Å¡".split("_"),weekdaysShort:"Ã Â´Å¾Ã Â´Â¾Ã Â´Â¯Ã ÂµÂ¼_Ã Â´Â¤Ã Â´Â¿Ã Â´â„¢Ã ÂµÂÃ Â´â€¢Ã ÂµÂ¾_Ã Â´Å¡Ã ÂµÅ Ã Â´ÂµÃ ÂµÂÃ Â´Âµ_Ã Â´Â¬Ã ÂµÂÃ Â´Â§Ã ÂµÂ»_Ã Â´ÂµÃ ÂµÂÃ Â´Â¯Ã Â´Â¾Ã Â´Â´Ã Â´â€š_Ã Â´ÂµÃ Âµâ€ Ã Â´Â³Ã ÂµÂÃ Â´Â³Ã Â´Â¿_Ã Â´Â¶Ã Â´Â¨Ã Â´Â¿".split("_"),weekdaysMin:"Ã Â´Å¾Ã Â´Â¾_Ã Â´Â¤Ã Â´Â¿_Ã Â´Å¡Ã ÂµÅ _Ã Â´Â¬Ã ÂµÂ_Ã Â´ÂµÃ ÂµÂÃ Â´Â¯Ã Â´Â¾_Ã Â´ÂµÃ Âµâ€ _Ã Â´Â¶".split("_"),longDateFormat:{LT:"A h:mm -Ã Â´Â¨Ã ÂµÂ",LTS:"A h:mm:ss -Ã Â´Â¨Ã ÂµÂ",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm -Ã Â´Â¨Ã ÂµÂ",LLLL:"dddd, D MMMM YYYY, A h:mm -Ã Â´Â¨Ã ÂµÂ"},calendar:{sameDay:"[Ã Â´â€¡Ã Â´Â¨Ã ÂµÂÃ Â´Â¨Ã ÂµÂ] LT",nextDay:"[Ã Â´Â¨Ã Â´Â¾Ã Â´Â³Ã Âµâ€ ] LT",nextWeek:"dddd, LT",lastDay:"[Ã Â´â€¡Ã Â´Â¨Ã ÂµÂÃ Â´Â¨Ã Â´Â²Ã Âµâ€ ] LT",lastWeek:"[Ã Â´â€¢Ã Â´Â´Ã Â´Â¿Ã Â´Å¾Ã ÂµÂÃ Â´Å¾] dddd, LT",sameElse:"L"},relativeTime:{future:"%s Ã Â´â€¢Ã Â´Â´Ã Â´Â¿Ã Â´Å¾Ã ÂµÂÃ Â´Å¾Ã ÂµÂ",past:"%s Ã Â´Â®Ã ÂµÂÃ ÂµÂ»Ã Â´ÂªÃ ÂµÂ",s:"Ã Â´â€¦Ã ÂµÂ½Ã Â´Âª Ã Â´Â¨Ã Â´Â¿Ã Â´Â®Ã Â´Â¿Ã Â´Â·Ã Â´â„¢Ã ÂµÂÃ Â´â„¢Ã ÂµÂ¾",m:"Ã Â´â€™Ã Â´Â°Ã ÂµÂ Ã Â´Â®Ã Â´Â¿Ã Â´Â¨Ã Â´Â¿Ã Â´Â±Ã ÂµÂÃ Â´Â±Ã ÂµÂ",mm:"%d Ã Â´Â®Ã Â´Â¿Ã Â´Â¨Ã Â´Â¿Ã Â´Â±Ã ÂµÂÃ Â´Â±Ã ÂµÂ",h:"Ã Â´â€™Ã Â´Â°Ã ÂµÂ Ã Â´Â®Ã Â´Â£Ã Â´Â¿Ã Â´â€¢Ã ÂµÂÃ Â´â€¢Ã Âµâ€šÃ ÂµÂ¼",hh:"%d Ã Â´Â®Ã Â´Â£Ã Â´Â¿Ã Â´â€¢Ã ÂµÂÃ Â´â€¢Ã Âµâ€šÃ ÂµÂ¼",d:"Ã Â´â€™Ã Â´Â°Ã ÂµÂ Ã Â´Â¦Ã Â´Â¿Ã Â´ÂµÃ Â´Â¸Ã Â´â€š",dd:"%d Ã Â´Â¦Ã Â´Â¿Ã Â´ÂµÃ Â´Â¸Ã Â´â€š",M:"Ã Â´â€™Ã Â´Â°Ã ÂµÂ Ã Â´Â®Ã Â´Â¾Ã Â´Â¸Ã Â´â€š",MM:"%d Ã Â´Â®Ã Â´Â¾Ã Â´Â¸Ã Â´â€š",y:"Ã Â´â€™Ã Â´Â°Ã ÂµÂ Ã Â´ÂµÃ ÂµÂ¼Ã Â´Â·Ã Â´â€š",yy:"%d Ã Â´ÂµÃ ÂµÂ¼Ã Â´Â·Ã Â´â€š"},meridiemParse:/Ã Â´Â°Ã Â´Â¾Ã Â´Â¤Ã ÂµÂÃ Â´Â°Ã Â´Â¿|Ã Â´Â°Ã Â´Â¾Ã Â´ÂµÃ Â´Â¿Ã Â´Â²Ã Âµâ€ |Ã Â´â€°Ã Â´Å¡Ã ÂµÂÃ Â´Å¡ Ã Â´â€¢Ã Â´Â´Ã Â´Â¿Ã Â´Å¾Ã ÂµÂÃ Â´Å¾Ã ÂµÂ|Ã Â´ÂµÃ ÂµË†Ã Â´â€¢Ã ÂµÂÃ Â´Â¨Ã ÂµÂÃ Â´Â¨Ã Âµâ€¡Ã Â´Â°Ã Â´â€š|Ã Â´Â°Ã Â´Â¾Ã Â´Â¤Ã ÂµÂÃ Â´Â°Ã Â´Â¿/i,meridiemHour:function(a,b){return 12===a&&(a=0),"Ã Â´Â°Ã Â´Â¾Ã Â´Â¤Ã ÂµÂÃ Â´Â°Ã Â´Â¿"===b&&a>=4||"Ã Â´â€°Ã Â´Å¡Ã ÂµÂÃ Â´Å¡ Ã Â´â€¢Ã Â´Â´Ã Â´Â¿Ã Â´Å¾Ã ÂµÂÃ Â´Å¾Ã ÂµÂ"===b||"Ã Â´ÂµÃ ÂµË†Ã Â´â€¢Ã ÂµÂÃ Â´Â¨Ã ÂµÂÃ Â´Â¨Ã Âµâ€¡Ã Â´Â°Ã Â´â€š"===b?a+12:a},meridiem:function(a,b,c){return 4>a?"Ã Â´Â°Ã Â´Â¾Ã Â´Â¤Ã ÂµÂÃ Â´Â°Ã Â´Â¿":12>a?"Ã Â´Â°Ã Â´Â¾Ã Â´ÂµÃ Â´Â¿Ã Â´Â²Ã Âµâ€ ":17>a?"Ã Â´â€°Ã Â´Å¡Ã ÂµÂÃ Â´Å¡ Ã Â´â€¢Ã Â´Â´Ã Â´Â¿Ã Â´Å¾Ã ÂµÂÃ Â´Å¾Ã ÂµÂ":20>a?"Ã Â´ÂµÃ ÂµË†Ã Â´â€¢Ã ÂµÂÃ Â´Â¨Ã ÂµÂÃ Â´Â¨Ã Âµâ€¡Ã Â´Â°Ã Â´â€š":"Ã Â´Â°Ã Â´Â¾Ã Â´Â¤Ã ÂµÂÃ Â´Â°Ã Â´Â¿"}}),{1:"Ã Â¥Â§",2:"Ã Â¥Â¨",3:"Ã Â¥Â©",4:"Ã Â¥Âª",5:"Ã Â¥Â«",6:"Ã Â¥Â¬",7:"Ã Â¥Â­",8:"Ã Â¥Â®",9:"Ã Â¥Â¯",0:"Ã Â¥Â¦"}),$g={"Ã Â¥Â§":"1","Ã Â¥Â¨":"2","Ã Â¥Â©":"3","Ã Â¥Âª":"4","Ã Â¥Â«":"5","Ã Â¥Â¬":"6","Ã Â¥Â­":"7","Ã Â¥Â®":"8","Ã Â¥Â¯":"9","Ã Â¥Â¦":"0"},_g=(kg.defineLocale("mr",{months:"Ã Â¤Å“Ã Â¤Â¾Ã Â¤Â¨Ã Â¥â€¡Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Â°Ã Â¥â‚¬_Ã Â¤Â«Ã Â¥â€¡Ã Â¤Â¬Ã Â¥ÂÃ Â¤Â°Ã Â¥ÂÃ Â¤ÂµÃ Â¤Â¾Ã Â¤Â°Ã Â¥â‚¬_Ã Â¤Â®Ã Â¤Â¾Ã Â¤Â°Ã Â¥ÂÃ Â¤Å¡_Ã Â¤ÂÃ Â¤ÂªÃ Â¥ÂÃ Â¤Â°Ã Â¤Â¿Ã Â¤Â²_Ã Â¤Â®Ã Â¥â€¡_Ã Â¤Å“Ã Â¥â€šÃ Â¤Â¨_Ã Â¤Å“Ã Â¥ÂÃ Â¤Â²Ã Â¥Ë†_Ã Â¤â€˜Ã Â¤â€”Ã Â¤Â¸Ã Â¥ÂÃ Â¤Å¸_Ã Â¤Â¸Ã Â¤ÂªÃ Â¥ÂÃ Â¤Å¸Ã Â¥â€¡Ã Â¤â€šÃ Â¤Â¬Ã Â¤Â°_Ã Â¤â€˜Ã Â¤â€¢Ã Â¥ÂÃ Â¤Å¸Ã Â¥â€¹Ã Â¤Â¬Ã Â¤Â°_Ã Â¤Â¨Ã Â¥â€¹Ã Â¤ÂµÃ Â¥ÂÃ Â¤Â¹Ã Â¥â€¡Ã Â¤â€šÃ Â¤Â¬Ã Â¤Â°_Ã Â¤Â¡Ã Â¤Â¿Ã Â¤Â¸Ã Â¥â€¡Ã Â¤â€šÃ Â¤Â¬Ã Â¤Â°".split("_"),monthsShort:"Ã Â¤Å“Ã Â¤Â¾Ã Â¤Â¨Ã Â¥â€¡._Ã Â¤Â«Ã Â¥â€¡Ã Â¤Â¬Ã Â¥ÂÃ Â¤Â°Ã Â¥Â._Ã Â¤Â®Ã Â¤Â¾Ã Â¤Â°Ã Â¥ÂÃ Â¤Å¡._Ã Â¤ÂÃ Â¤ÂªÃ Â¥ÂÃ Â¤Â°Ã Â¤Â¿._Ã Â¤Â®Ã Â¥â€¡._Ã Â¤Å“Ã Â¥â€šÃ Â¤Â¨._Ã Â¤Å“Ã Â¥ÂÃ Â¤Â²Ã Â¥Ë†._Ã Â¤â€˜Ã Â¤â€”._Ã Â¤Â¸Ã Â¤ÂªÃ Â¥ÂÃ Â¤Å¸Ã Â¥â€¡Ã Â¤â€š._Ã Â¤â€˜Ã Â¤â€¢Ã Â¥ÂÃ Â¤Å¸Ã Â¥â€¹._Ã Â¤Â¨Ã Â¥â€¹Ã Â¤ÂµÃ Â¥ÂÃ Â¤Â¹Ã Â¥â€¡Ã Â¤â€š._Ã Â¤Â¡Ã Â¤Â¿Ã Â¤Â¸Ã Â¥â€¡Ã Â¤â€š.".split("_"),monthsParseExact:!0,weekdays:"Ã Â¤Â°Ã Â¤ÂµÃ Â¤Â¿Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Â°_Ã Â¤Â¸Ã Â¥â€¹Ã Â¤Â®Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Â°_Ã Â¤Â®Ã Â¤â€šÃ Â¤â€”Ã Â¤Â³Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Â°_Ã Â¤Â¬Ã Â¥ÂÃ Â¤Â§Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Â°_Ã Â¤â€”Ã Â¥ÂÃ Â¤Â°Ã Â¥â€šÃ Â¤ÂµÃ Â¤Â¾Ã Â¤Â°_Ã Â¤Â¶Ã Â¥ÂÃ Â¤â€¢Ã Â¥ÂÃ Â¤Â°Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Â°_Ã Â¤Â¶Ã Â¤Â¨Ã Â¤Â¿Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Â°".split("_"),weekdaysShort:"Ã Â¤Â°Ã Â¤ÂµÃ Â¤Â¿_Ã Â¤Â¸Ã Â¥â€¹Ã Â¤Â®_Ã Â¤Â®Ã Â¤â€šÃ Â¤â€”Ã Â¤Â³_Ã Â¤Â¬Ã Â¥ÂÃ Â¤Â§_Ã Â¤â€”Ã Â¥ÂÃ Â¤Â°Ã Â¥â€š_Ã Â¤Â¶Ã Â¥ÂÃ Â¤â€¢Ã Â¥ÂÃ Â¤Â°_Ã Â¤Â¶Ã Â¤Â¨Ã Â¤Â¿".split("_"),weekdaysMin:"Ã Â¤Â°_Ã Â¤Â¸Ã Â¥â€¹_Ã Â¤Â®Ã Â¤â€š_Ã Â¤Â¬Ã Â¥Â_Ã Â¤â€”Ã Â¥Â_Ã Â¤Â¶Ã Â¥Â_Ã Â¤Â¶".split("_"),longDateFormat:{LT:"A h:mm Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Å“Ã Â¤Â¤Ã Â¤Â¾",LTS:"A h:mm:ss Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Å“Ã Â¤Â¤Ã Â¤Â¾",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Å“Ã Â¤Â¤Ã Â¤Â¾",LLLL:"dddd, D MMMM YYYY, A h:mm Ã Â¤ÂµÃ Â¤Â¾Ã Â¤Å“Ã Â¤Â¤Ã Â¤Â¾"},calendar:{sameDay:"[Ã Â¤â€ Ã Â¤Å“] LT",nextDay:"[Ã Â¤â€°Ã Â¤Â¦Ã Â¥ÂÃ Â¤Â¯Ã Â¤Â¾] LT",nextWeek:"dddd, LT",lastDay:"[Ã Â¤â€¢Ã Â¤Â¾Ã Â¤Â²] LT",lastWeek:"[Ã Â¤Â®Ã Â¤Â¾Ã Â¤â€”Ã Â¥â‚¬Ã Â¤Â²] dddd, LT",sameElse:"L"},relativeTime:{future:"%sÃ Â¤Â®Ã Â¤Â§Ã Â¥ÂÃ Â¤Â¯Ã Â¥â€¡",past:"%sÃ Â¤ÂªÃ Â¥â€šÃ Â¤Â°Ã Â¥ÂÃ Â¤ÂµÃ Â¥â‚¬",s:Td,m:Td,mm:Td,h:Td,hh:Td,d:Td,dd:Td,M:Td,MM:Td,y:Td,yy:Td},preparse:function(a){return a.replace(/[Ã Â¥Â§Ã Â¥Â¨Ã Â¥Â©Ã Â¥ÂªÃ Â¥Â«Ã Â¥Â¬Ã Â¥Â­Ã Â¥Â®Ã Â¥Â¯Ã Â¥Â¦]/g,function(a){return $g[a]})},postformat:function(a){return a.replace(/\d/g,function(a){return Zg[a]})},meridiemParse:/Ã Â¤Â°Ã Â¤Â¾Ã Â¤Â¤Ã Â¥ÂÃ Â¤Â°Ã Â¥â‚¬|Ã Â¤Â¸Ã Â¤â€¢Ã Â¤Â¾Ã Â¤Â³Ã Â¥â‚¬|Ã Â¤Â¦Ã Â¥ÂÃ Â¤ÂªÃ Â¤Â¾Ã Â¤Â°Ã Â¥â‚¬|Ã Â¤Â¸Ã Â¤Â¾Ã Â¤Â¯Ã Â¤â€šÃ Â¤â€¢Ã Â¤Â¾Ã Â¤Â³Ã Â¥â‚¬/,meridiemHour:function(a,b){return 12===a&&(a=0),"Ã Â¤Â°Ã Â¤Â¾Ã Â¤Â¤Ã Â¥ÂÃ Â¤Â°Ã Â¥â‚¬"===b?4>a?a:a+12:"Ã Â¤Â¸Ã Â¤â€¢Ã Â¤Â¾Ã Â¤Â³Ã Â¥â‚¬"===b?a:"Ã Â¤Â¦Ã Â¥ÂÃ Â¤ÂªÃ Â¤Â¾Ã Â¤Â°Ã Â¥â‚¬"===b?a>=10?a:a+12:"Ã Â¤Â¸Ã Â¤Â¾Ã Â¤Â¯Ã Â¤â€šÃ Â¤â€¢Ã Â¤Â¾Ã Â¤Â³Ã Â¥â‚¬"===b?a+12:void 0},meridiem:function(a,b,c){return 4>a?"Ã Â¤Â°Ã Â¤Â¾Ã Â¤Â¤Ã Â¥ÂÃ Â¤Â°Ã Â¥â‚¬":10>a?"Ã Â¤Â¸Ã Â¤â€¢Ã Â¤Â¾Ã Â¤Â³Ã Â¥â‚¬":17>a?"Ã Â¤Â¦Ã Â¥ÂÃ Â¤ÂªÃ Â¤Â¾Ã Â¤Â°Ã Â¥â‚¬":20>a?"Ã Â¤Â¸Ã Â¤Â¾Ã Â¤Â¯Ã Â¤â€šÃ Â¤â€¢Ã Â¤Â¾Ã Â¤Â³Ã Â¥â‚¬":"Ã Â¤Â°Ã Â¤Â¾Ã Â¤Â¤Ã Â¥ÂÃ Â¤Â°Ã Â¥â‚¬"},week:{dow:0,// Sunday is the first day of the week.
doy:6}}),kg.defineLocale("ms-my",{months:"Januari_Februari_Mac_April_Mei_Jun_Julai_Ogos_September_Oktober_November_Disember".split("_"),monthsShort:"Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ogs_Sep_Okt_Nov_Dis".split("_"),weekdays:"Ahad_Isnin_Selasa_Rabu_Khamis_Jumaat_Sabtu".split("_"),weekdaysShort:"Ahd_Isn_Sel_Rab_Kha_Jum_Sab".split("_"),weekdaysMin:"Ah_Is_Sl_Rb_Km_Jm_Sb".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY [pukul] HH.mm",LLLL:"dddd, D MMMM YYYY [pukul] HH.mm"},meridiemParse:/pagi|tengahari|petang|malam/,meridiemHour:function(a,b){return 12===a&&(a=0),"pagi"===b?a:"tengahari"===b?a>=11?a:a+12:"petang"===b||"malam"===b?a+12:void 0},meridiem:function(a,b,c){return 11>a?"pagi":15>a?"tengahari":19>a?"petang":"malam"},calendar:{sameDay:"[Hari ini pukul] LT",nextDay:"[Esok pukul] LT",nextWeek:"dddd [pukul] LT",lastDay:"[Kelmarin pukul] LT",lastWeek:"dddd [lepas pukul] LT",sameElse:"L"},relativeTime:{future:"dalam %s",past:"%s yang lepas",s:"beberapa saat",m:"seminit",mm:"%d minit",h:"sejam",hh:"%d jam",d:"sehari",dd:"%d hari",M:"sebulan",MM:"%d bulan",y:"setahun",yy:"%d tahun"},week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("ms",{months:"Januari_Februari_Mac_April_Mei_Jun_Julai_Ogos_September_Oktober_November_Disember".split("_"),monthsShort:"Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ogs_Sep_Okt_Nov_Dis".split("_"),weekdays:"Ahad_Isnin_Selasa_Rabu_Khamis_Jumaat_Sabtu".split("_"),weekdaysShort:"Ahd_Isn_Sel_Rab_Kha_Jum_Sab".split("_"),weekdaysMin:"Ah_Is_Sl_Rb_Km_Jm_Sb".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY [pukul] HH.mm",LLLL:"dddd, D MMMM YYYY [pukul] HH.mm"},meridiemParse:/pagi|tengahari|petang|malam/,meridiemHour:function(a,b){return 12===a&&(a=0),"pagi"===b?a:"tengahari"===b?a>=11?a:a+12:"petang"===b||"malam"===b?a+12:void 0},meridiem:function(a,b,c){return 11>a?"pagi":15>a?"tengahari":19>a?"petang":"malam"},calendar:{sameDay:"[Hari ini pukul] LT",nextDay:"[Esok pukul] LT",nextWeek:"dddd [pukul] LT",lastDay:"[Kelmarin pukul] LT",lastWeek:"dddd [lepas pukul] LT",sameElse:"L"},relativeTime:{future:"dalam %s",past:"%s yang lepas",s:"beberapa saat",m:"seminit",mm:"%d minit",h:"sejam",hh:"%d jam",d:"sehari",dd:"%d hari",M:"sebulan",MM:"%d bulan",y:"setahun",yy:"%d tahun"},week:{dow:1,// Monday is the first day of the week.
doy:7}}),{1:"Ã¡ÂÂ",2:"Ã¡Ââ€š",3:"Ã¡ÂÆ’",4:"Ã¡Ââ€ž",5:"Ã¡Ââ€¦",6:"Ã¡Ââ€ ",7:"Ã¡Ââ€¡",8:"Ã¡ÂË†",9:"Ã¡Ââ€°",0:"Ã¡Ââ‚¬"}),ah={"Ã¡ÂÂ":"1","Ã¡Ââ€š":"2","Ã¡ÂÆ’":"3","Ã¡Ââ€ž":"4","Ã¡Ââ€¦":"5","Ã¡Ââ€ ":"6","Ã¡Ââ€¡":"7","Ã¡ÂË†":"8","Ã¡Ââ€°":"9","Ã¡Ââ‚¬":"0"},bh=(kg.defineLocale("my",{months:"Ã¡â‚¬â€¡Ã¡â‚¬â€Ã¡â‚¬ÂºÃ¡â‚¬â€Ã¡â‚¬ÂÃ¡â‚¬Â«Ã¡â‚¬â€ºÃ¡â‚¬Â®_Ã¡â‚¬â€“Ã¡â‚¬Â±Ã¡â‚¬â€“Ã¡â‚¬Â±Ã¡â‚¬Â¬Ã¡â‚¬ÂºÃ¡â‚¬ÂÃ¡â‚¬Â«Ã¡â‚¬â€ºÃ¡â‚¬Â®_Ã¡â‚¬â„¢Ã¡â‚¬ÂÃ¡â‚¬Âº_Ã¡â‚¬Â§Ã¡â‚¬â€¢Ã¡â‚¬Â¼Ã¡â‚¬Â®_Ã¡â‚¬â„¢Ã¡â‚¬Â±_Ã¡â‚¬â€¡Ã¡â‚¬Â½Ã¡â‚¬â€Ã¡â‚¬Âº_Ã¡â‚¬â€¡Ã¡â‚¬Â°Ã¡â‚¬Å“Ã¡â‚¬Â­Ã¡â‚¬Â¯Ã¡â‚¬â€žÃ¡â‚¬Âº_Ã¡â‚¬Å¾Ã¡â‚¬Â¼Ã¡â‚¬â€šÃ¡â‚¬Â¯Ã¡â‚¬ÂÃ¡â‚¬Âº_Ã¡â‚¬â€¦Ã¡â‚¬â‚¬Ã¡â‚¬ÂºÃ¡â‚¬ÂÃ¡â‚¬â€žÃ¡â‚¬ÂºÃ¡â‚¬ËœÃ¡â‚¬Â¬_Ã¡â‚¬Â¡Ã¡â‚¬Â±Ã¡â‚¬Â¬Ã¡â‚¬â‚¬Ã¡â‚¬ÂºÃ¡â‚¬ÂÃ¡â‚¬Â­Ã¡â‚¬Â¯Ã¡â‚¬ËœÃ¡â‚¬Â¬_Ã¡â‚¬â€Ã¡â‚¬Â­Ã¡â‚¬Â¯Ã¡â‚¬ÂÃ¡â‚¬â€žÃ¡â‚¬ÂºÃ¡â‚¬ËœÃ¡â‚¬Â¬_Ã¡â‚¬â€™Ã¡â‚¬Â®Ã¡â‚¬â€¡Ã¡â‚¬â€žÃ¡â‚¬ÂºÃ¡â‚¬ËœÃ¡â‚¬Â¬".split("_"),monthsShort:"Ã¡â‚¬â€¡Ã¡â‚¬â€Ã¡â‚¬Âº_Ã¡â‚¬â€“Ã¡â‚¬Â±_Ã¡â‚¬â„¢Ã¡â‚¬ÂÃ¡â‚¬Âº_Ã¡â‚¬â€¢Ã¡â‚¬Â¼Ã¡â‚¬Â®_Ã¡â‚¬â„¢Ã¡â‚¬Â±_Ã¡â‚¬â€¡Ã¡â‚¬Â½Ã¡â‚¬â€Ã¡â‚¬Âº_Ã¡â‚¬Å“Ã¡â‚¬Â­Ã¡â‚¬Â¯Ã¡â‚¬â€žÃ¡â‚¬Âº_Ã¡â‚¬Å¾Ã¡â‚¬Â¼_Ã¡â‚¬â€¦Ã¡â‚¬â‚¬Ã¡â‚¬Âº_Ã¡â‚¬Â¡Ã¡â‚¬Â±Ã¡â‚¬Â¬Ã¡â‚¬â‚¬Ã¡â‚¬Âº_Ã¡â‚¬â€Ã¡â‚¬Â­Ã¡â‚¬Â¯_Ã¡â‚¬â€™Ã¡â‚¬Â®".split("_"),weekdays:"Ã¡â‚¬ÂÃ¡â‚¬â€Ã¡â‚¬â€žÃ¡â‚¬ÂºÃ¡â‚¬Â¹Ã¡â‚¬â€šÃ¡â‚¬â€Ã¡â‚¬Â½Ã¡â‚¬Â±_Ã¡â‚¬ÂÃ¡â‚¬â€Ã¡â‚¬â€žÃ¡â‚¬ÂºÃ¡â‚¬Â¹Ã¡â‚¬Å“Ã¡â‚¬Â¬_Ã¡â‚¬Â¡Ã¡â‚¬â€žÃ¡â‚¬ÂºÃ¡â‚¬Â¹Ã¡â‚¬â€šÃ¡â‚¬Â«_Ã¡â‚¬â€”Ã¡â‚¬Â¯Ã¡â‚¬â€™Ã¡â‚¬Â¹Ã¡â‚¬â€œÃ¡â‚¬Å¸Ã¡â‚¬Â°Ã¡â‚¬Â¸_Ã¡â‚¬â‚¬Ã¡â‚¬Â¼Ã¡â‚¬Â¬Ã¡â‚¬Å¾Ã¡â‚¬â€¢Ã¡â‚¬ÂÃ¡â‚¬Â±Ã¡â‚¬Â¸_Ã¡â‚¬Å¾Ã¡â‚¬Â±Ã¡â‚¬Â¬Ã¡â‚¬â‚¬Ã¡â‚¬Â¼Ã¡â‚¬Â¬_Ã¡â‚¬â€¦Ã¡â‚¬â€Ã¡â‚¬Â±".split("_"),weekdaysShort:"Ã¡â‚¬â€Ã¡â‚¬Â½Ã¡â‚¬Â±_Ã¡â‚¬Å“Ã¡â‚¬Â¬_Ã¡â‚¬â€šÃ¡â‚¬Â«_Ã¡â‚¬Å¸Ã¡â‚¬Â°Ã¡â‚¬Â¸_Ã¡â‚¬â‚¬Ã¡â‚¬Â¼Ã¡â‚¬Â¬_Ã¡â‚¬Å¾Ã¡â‚¬Â±Ã¡â‚¬Â¬_Ã¡â‚¬â€Ã¡â‚¬Â±".split("_"),weekdaysMin:"Ã¡â‚¬â€Ã¡â‚¬Â½Ã¡â‚¬Â±_Ã¡â‚¬Å“Ã¡â‚¬Â¬_Ã¡â‚¬â€šÃ¡â‚¬Â«_Ã¡â‚¬Å¸Ã¡â‚¬Â°Ã¡â‚¬Â¸_Ã¡â‚¬â‚¬Ã¡â‚¬Â¼Ã¡â‚¬Â¬_Ã¡â‚¬Å¾Ã¡â‚¬Â±Ã¡â‚¬Â¬_Ã¡â‚¬â€Ã¡â‚¬Â±".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Ã¡â‚¬Å¡Ã¡â‚¬â€Ã¡â‚¬Â±.] LT [Ã¡â‚¬â„¢Ã¡â‚¬Â¾Ã¡â‚¬Â¬]",nextDay:"[Ã¡â‚¬â„¢Ã¡â‚¬â€Ã¡â‚¬â‚¬Ã¡â‚¬ÂºÃ¡â‚¬â€“Ã¡â‚¬Â¼Ã¡â‚¬â€Ã¡â‚¬Âº] LT [Ã¡â‚¬â„¢Ã¡â‚¬Â¾Ã¡â‚¬Â¬]",nextWeek:"dddd LT [Ã¡â‚¬â„¢Ã¡â‚¬Â¾Ã¡â‚¬Â¬]",lastDay:"[Ã¡â‚¬â„¢Ã¡â‚¬â€Ã¡â‚¬Â±.Ã¡â‚¬â‚¬] LT [Ã¡â‚¬â„¢Ã¡â‚¬Â¾Ã¡â‚¬Â¬]",lastWeek:"[Ã¡â‚¬â€¢Ã¡â‚¬Â¼Ã¡â‚¬Â®Ã¡â‚¬Â¸Ã¡â‚¬ÂÃ¡â‚¬Â²Ã¡â‚¬Â·Ã¡â‚¬Å¾Ã¡â‚¬Â±Ã¡â‚¬Â¬] dddd LT [Ã¡â‚¬â„¢Ã¡â‚¬Â¾Ã¡â‚¬Â¬]",sameElse:"L"},relativeTime:{future:"Ã¡â‚¬Å“Ã¡â‚¬Â¬Ã¡â‚¬â„¢Ã¡â‚¬Å Ã¡â‚¬ÂºÃ¡â‚¬Â· %s Ã¡â‚¬â„¢Ã¡â‚¬Â¾Ã¡â‚¬Â¬",past:"Ã¡â‚¬Å“Ã¡â‚¬Â½Ã¡â‚¬â€Ã¡â‚¬ÂºÃ¡â‚¬ÂÃ¡â‚¬Â²Ã¡â‚¬Â·Ã¡â‚¬Å¾Ã¡â‚¬Â±Ã¡â‚¬Â¬ %s Ã¡â‚¬â‚¬",s:"Ã¡â‚¬â€¦Ã¡â‚¬â‚¬Ã¡â‚¬Â¹Ã¡â‚¬â‚¬Ã¡â‚¬â€Ã¡â‚¬Âº.Ã¡â‚¬Â¡Ã¡â‚¬â€Ã¡â‚¬Å Ã¡â‚¬ÂºÃ¡â‚¬Â¸Ã¡â‚¬â€žÃ¡â‚¬Å¡Ã¡â‚¬Âº",m:"Ã¡â‚¬ÂÃ¡â‚¬â€¦Ã¡â‚¬ÂºÃ¡â‚¬â„¢Ã¡â‚¬Â­Ã¡â‚¬â€Ã¡â‚¬â€¦Ã¡â‚¬Âº",mm:"%d Ã¡â‚¬â„¢Ã¡â‚¬Â­Ã¡â‚¬â€Ã¡â‚¬â€¦Ã¡â‚¬Âº",h:"Ã¡â‚¬ÂÃ¡â‚¬â€¦Ã¡â‚¬ÂºÃ¡â‚¬â€Ã¡â‚¬Â¬Ã¡â‚¬â€ºÃ¡â‚¬Â®",hh:"%d Ã¡â‚¬â€Ã¡â‚¬Â¬Ã¡â‚¬â€ºÃ¡â‚¬Â®",d:"Ã¡â‚¬ÂÃ¡â‚¬â€¦Ã¡â‚¬ÂºÃ¡â‚¬â€ºÃ¡â‚¬â‚¬Ã¡â‚¬Âº",dd:"%d Ã¡â‚¬â€ºÃ¡â‚¬â‚¬Ã¡â‚¬Âº",M:"Ã¡â‚¬ÂÃ¡â‚¬â€¦Ã¡â‚¬ÂºÃ¡â‚¬Å“",MM:"%d Ã¡â‚¬Å“",y:"Ã¡â‚¬ÂÃ¡â‚¬â€¦Ã¡â‚¬ÂºÃ¡â‚¬â€Ã¡â‚¬Â¾Ã¡â‚¬â€¦Ã¡â‚¬Âº",yy:"%d Ã¡â‚¬â€Ã¡â‚¬Â¾Ã¡â‚¬â€¦Ã¡â‚¬Âº"},preparse:function(a){return a.replace(/[Ã¡ÂÂÃ¡Ââ€šÃ¡ÂÆ’Ã¡Ââ€žÃ¡Ââ€¦Ã¡Ââ€ Ã¡Ââ€¡Ã¡ÂË†Ã¡Ââ€°Ã¡Ââ‚¬]/g,function(a){return ah[a]})},postformat:function(a){return a.replace(/\d/g,function(a){return _g[a]})},week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("nb",{months:"januar_februar_mars_april_mai_juni_juli_august_september_oktober_november_desember".split("_"),monthsShort:"jan._feb._mars_april_mai_juni_juli_aug._sep._okt._nov._des.".split("_"),monthsParseExact:!0,weekdays:"sÃƒÂ¸ndag_mandag_tirsdag_onsdag_torsdag_fredag_lÃƒÂ¸rdag".split("_"),weekdaysShort:"sÃƒÂ¸._ma._ti._on._to._fr._lÃƒÂ¸.".split("_"),weekdaysMin:"sÃƒÂ¸_ma_ti_on_to_fr_lÃƒÂ¸".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY [kl.] HH:mm",LLLL:"dddd D. MMMM YYYY [kl.] HH:mm"},calendar:{sameDay:"[i dag kl.] LT",nextDay:"[i morgen kl.] LT",nextWeek:"dddd [kl.] LT",lastDay:"[i gÃƒÂ¥r kl.] LT",lastWeek:"[forrige] dddd [kl.] LT",sameElse:"L"},relativeTime:{future:"om %s",past:"%s siden",s:"noen sekunder",m:"ett minutt",mm:"%d minutter",h:"en time",hh:"%d timer",d:"en dag",dd:"%d dager",M:"en mÃƒÂ¥ned",MM:"%d mÃƒÂ¥neder",y:"ett ÃƒÂ¥r",yy:"%d ÃƒÂ¥r"},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),{1:"Ã Â¥Â§",2:"Ã Â¥Â¨",3:"Ã Â¥Â©",4:"Ã Â¥Âª",5:"Ã Â¥Â«",6:"Ã Â¥Â¬",7:"Ã Â¥Â­",8:"Ã Â¥Â®",9:"Ã Â¥Â¯",0:"Ã Â¥Â¦"}),ch={"Ã Â¥Â§":"1","Ã Â¥Â¨":"2","Ã Â¥Â©":"3","Ã Â¥Âª":"4","Ã Â¥Â«":"5","Ã Â¥Â¬":"6","Ã Â¥Â­":"7","Ã Â¥Â®":"8","Ã Â¥Â¯":"9","Ã Â¥Â¦":"0"},dh=(kg.defineLocale("ne",{months:"Ã Â¤Å“Ã Â¤Â¨Ã Â¤ÂµÃ Â¤Â°Ã Â¥â‚¬_Ã Â¤Â«Ã Â¥â€¡Ã Â¤Â¬Ã Â¥ÂÃ Â¤Â°Ã Â¥ÂÃ Â¤ÂµÃ Â¤Â°Ã Â¥â‚¬_Ã Â¤Â®Ã Â¤Â¾Ã Â¤Â°Ã Â¥ÂÃ Â¤Å¡_Ã Â¤â€¦Ã Â¤ÂªÃ Â¥ÂÃ Â¤Â°Ã Â¤Â¿Ã Â¤Â²_Ã Â¤Â®Ã Â¤Ë†_Ã Â¤Å“Ã Â¥ÂÃ Â¤Â¨_Ã Â¤Å“Ã Â¥ÂÃ Â¤Â²Ã Â¤Â¾Ã Â¤Ë†_Ã Â¤â€¦Ã Â¤â€”Ã Â¤Â·Ã Â¥ÂÃ Â¤Å¸_Ã Â¤Â¸Ã Â¥â€¡Ã Â¤ÂªÃ Â¥ÂÃ Â¤Å¸Ã Â¥â€¡Ã Â¤Â®Ã Â¥ÂÃ Â¤Â¬Ã Â¤Â°_Ã Â¤â€¦Ã Â¤â€¢Ã Â¥ÂÃ Â¤Å¸Ã Â¥â€¹Ã Â¤Â¬Ã Â¤Â°_Ã Â¤Â¨Ã Â¥â€¹Ã Â¤Â­Ã Â¥â€¡Ã Â¤Â®Ã Â¥ÂÃ Â¤Â¬Ã Â¤Â°_Ã Â¤Â¡Ã Â¤Â¿Ã Â¤Â¸Ã Â¥â€¡Ã Â¤Â®Ã Â¥ÂÃ Â¤Â¬Ã Â¤Â°".split("_"),monthsShort:"Ã Â¤Å“Ã Â¤Â¨._Ã Â¤Â«Ã Â¥â€¡Ã Â¤Â¬Ã Â¥ÂÃ Â¤Â°Ã Â¥Â._Ã Â¤Â®Ã Â¤Â¾Ã Â¤Â°Ã Â¥ÂÃ Â¤Å¡_Ã Â¤â€¦Ã Â¤ÂªÃ Â¥ÂÃ Â¤Â°Ã Â¤Â¿._Ã Â¤Â®Ã Â¤Ë†_Ã Â¤Å“Ã Â¥ÂÃ Â¤Â¨_Ã Â¤Å“Ã Â¥ÂÃ Â¤Â²Ã Â¤Â¾Ã Â¤Ë†._Ã Â¤â€¦Ã Â¤â€”._Ã Â¤Â¸Ã Â¥â€¡Ã Â¤ÂªÃ Â¥ÂÃ Â¤Å¸._Ã Â¤â€¦Ã Â¤â€¢Ã Â¥ÂÃ Â¤Å¸Ã Â¥â€¹._Ã Â¤Â¨Ã Â¥â€¹Ã Â¤Â­Ã Â¥â€¡._Ã Â¤Â¡Ã Â¤Â¿Ã Â¤Â¸Ã Â¥â€¡.".split("_"),monthsParseExact:!0,weekdays:"Ã Â¤â€ Ã Â¤â€¡Ã Â¤Â¤Ã Â¤Â¬Ã Â¤Â¾Ã Â¤Â°_Ã Â¤Â¸Ã Â¥â€¹Ã Â¤Â®Ã Â¤Â¬Ã Â¤Â¾Ã Â¤Â°_Ã Â¤Â®Ã Â¤â„¢Ã Â¥ÂÃ Â¤â€”Ã Â¤Â²Ã Â¤Â¬Ã Â¤Â¾Ã Â¤Â°_Ã Â¤Â¬Ã Â¥ÂÃ Â¤Â§Ã Â¤Â¬Ã Â¤Â¾Ã Â¤Â°_Ã Â¤Â¬Ã Â¤Â¿Ã Â¤Â¹Ã Â¤Â¿Ã Â¤Â¬Ã Â¤Â¾Ã Â¤Â°_Ã Â¤Â¶Ã Â¥ÂÃ Â¤â€¢Ã Â¥ÂÃ Â¤Â°Ã Â¤Â¬Ã Â¤Â¾Ã Â¤Â°_Ã Â¤Â¶Ã Â¤Â¨Ã Â¤Â¿Ã Â¤Â¬Ã Â¤Â¾Ã Â¤Â°".split("_"),weekdaysShort:"Ã Â¤â€ Ã Â¤â€¡Ã Â¤Â¤._Ã Â¤Â¸Ã Â¥â€¹Ã Â¤Â®._Ã Â¤Â®Ã Â¤â„¢Ã Â¥ÂÃ Â¤â€”Ã Â¤Â²._Ã Â¤Â¬Ã Â¥ÂÃ Â¤Â§._Ã Â¤Â¬Ã Â¤Â¿Ã Â¤Â¹Ã Â¤Â¿._Ã Â¤Â¶Ã Â¥ÂÃ Â¤â€¢Ã Â¥ÂÃ Â¤Â°._Ã Â¤Â¶Ã Â¤Â¨Ã Â¤Â¿.".split("_"),weekdaysMin:"Ã Â¤â€ ._Ã Â¤Â¸Ã Â¥â€¹._Ã Â¤Â®Ã Â¤â€š._Ã Â¤Â¬Ã Â¥Â._Ã Â¤Â¬Ã Â¤Â¿._Ã Â¤Â¶Ã Â¥Â._Ã Â¤Â¶.".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"AÃ Â¤â€¢Ã Â¥â€¹ h:mm Ã Â¤Â¬Ã Â¤Å“Ã Â¥â€¡",LTS:"AÃ Â¤â€¢Ã Â¥â€¹ h:mm:ss Ã Â¤Â¬Ã Â¤Å“Ã Â¥â€¡",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, AÃ Â¤â€¢Ã Â¥â€¹ h:mm Ã Â¤Â¬Ã Â¤Å“Ã Â¥â€¡",LLLL:"dddd, D MMMM YYYY, AÃ Â¤â€¢Ã Â¥â€¹ h:mm Ã Â¤Â¬Ã Â¤Å“Ã Â¥â€¡"},preparse:function(a){return a.replace(/[Ã Â¥Â§Ã Â¥Â¨Ã Â¥Â©Ã Â¥ÂªÃ Â¥Â«Ã Â¥Â¬Ã Â¥Â­Ã Â¥Â®Ã Â¥Â¯Ã Â¥Â¦]/g,function(a){return ch[a]})},postformat:function(a){return a.replace(/\d/g,function(a){return bh[a]})},meridiemParse:/Ã Â¤Â°Ã Â¤Â¾Ã Â¤Â¤Ã Â¤Â¿|Ã Â¤Â¬Ã Â¤Â¿Ã Â¤Â¹Ã Â¤Â¾Ã Â¤Â¨|Ã Â¤Â¦Ã Â¤Â¿Ã Â¤â€°Ã Â¤ÂÃ Â¤Â¸Ã Â¥â€¹|Ã Â¤Â¸Ã Â¤Â¾Ã Â¤ÂÃ Â¤Â/,meridiemHour:function(a,b){return 12===a&&(a=0),"Ã Â¤Â°Ã Â¤Â¾Ã Â¤Â¤Ã Â¤Â¿"===b?4>a?a:a+12:"Ã Â¤Â¬Ã Â¤Â¿Ã Â¤Â¹Ã Â¤Â¾Ã Â¤Â¨"===b?a:"Ã Â¤Â¦Ã Â¤Â¿Ã Â¤â€°Ã Â¤ÂÃ Â¤Â¸Ã Â¥â€¹"===b?a>=10?a:a+12:"Ã Â¤Â¸Ã Â¤Â¾Ã Â¤ÂÃ Â¤Â"===b?a+12:void 0},meridiem:function(a,b,c){return 3>a?"Ã Â¤Â°Ã Â¤Â¾Ã Â¤Â¤Ã Â¤Â¿":12>a?"Ã Â¤Â¬Ã Â¤Â¿Ã Â¤Â¹Ã Â¤Â¾Ã Â¤Â¨":16>a?"Ã Â¤Â¦Ã Â¤Â¿Ã Â¤â€°Ã Â¤ÂÃ Â¤Â¸Ã Â¥â€¹":20>a?"Ã Â¤Â¸Ã Â¤Â¾Ã Â¤ÂÃ Â¤Â":"Ã Â¤Â°Ã Â¤Â¾Ã Â¤Â¤Ã Â¤Â¿"},calendar:{sameDay:"[Ã Â¤â€ Ã Â¤Å“] LT",nextDay:"[Ã Â¤Â­Ã Â¥â€¹Ã Â¤Â²Ã Â¤Â¿] LT",nextWeek:"[Ã Â¤â€ Ã Â¤â€°Ã Â¤ÂÃ Â¤Â¦Ã Â¥â€¹] dddd[,] LT",lastDay:"[Ã Â¤Â¹Ã Â¤Â¿Ã Â¤Å“Ã Â¥â€¹] LT",lastWeek:"[Ã Â¤â€”Ã Â¤ÂÃ Â¤â€¢Ã Â¥â€¹] dddd[,] LT",sameElse:"L"},relativeTime:{future:"%sÃ Â¤Â®Ã Â¤Â¾",past:"%s Ã Â¤â€¦Ã Â¤â€”Ã Â¤Â¾Ã Â¤Â¡Ã Â¤Â¿",s:"Ã Â¤â€¢Ã Â¥â€¡Ã Â¤Â¹Ã Â¥â‚¬ Ã Â¤â€¢Ã Â¥ÂÃ Â¤Â·Ã Â¤Â£",m:"Ã Â¤ÂÃ Â¤â€¢ Ã Â¤Â®Ã Â¤Â¿Ã Â¤Â¨Ã Â¥â€¡Ã Â¤Å¸",mm:"%d Ã Â¤Â®Ã Â¤Â¿Ã Â¤Â¨Ã Â¥â€¡Ã Â¤Å¸",h:"Ã Â¤ÂÃ Â¤â€¢ Ã Â¤ËœÃ Â¤Â£Ã Â¥ÂÃ Â¤Å¸Ã Â¤Â¾",hh:"%d Ã Â¤ËœÃ Â¤Â£Ã Â¥ÂÃ Â¤Å¸Ã Â¤Â¾",d:"Ã Â¤ÂÃ Â¤â€¢ Ã Â¤Â¦Ã Â¤Â¿Ã Â¤Â¨",dd:"%d Ã Â¤Â¦Ã Â¤Â¿Ã Â¤Â¨",M:"Ã Â¤ÂÃ Â¤â€¢ Ã Â¤Â®Ã Â¤Â¹Ã Â¤Â¿Ã Â¤Â¨Ã Â¤Â¾",MM:"%d Ã Â¤Â®Ã Â¤Â¹Ã Â¤Â¿Ã Â¤Â¨Ã Â¤Â¾",y:"Ã Â¤ÂÃ Â¤â€¢ Ã Â¤Â¬Ã Â¤Â°Ã Â¥ÂÃ Â¤Â·",yy:"%d Ã Â¤Â¬Ã Â¤Â°Ã Â¥ÂÃ Â¤Â·"},week:{dow:0,// Sunday is the first day of the week.
doy:6}}),"jan._feb._mrt._apr._mei_jun._jul._aug._sep._okt._nov._dec.".split("_")),eh="jan_feb_mrt_apr_mei_jun_jul_aug_sep_okt_nov_dec".split("_"),fh=(kg.defineLocale("nl",{months:"januari_februari_maart_april_mei_juni_juli_augustus_september_oktober_november_december".split("_"),monthsShort:function(a,b){return/-MMM-/.test(b)?eh[a.month()]:dh[a.month()]},monthsParseExact:!0,weekdays:"zondag_maandag_dinsdag_woensdag_donderdag_vrijdag_zaterdag".split("_"),weekdaysShort:"zo._ma._di._wo._do._vr._za.".split("_"),weekdaysMin:"Zo_Ma_Di_Wo_Do_Vr_Za".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD-MM-YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[vandaag om] LT",nextDay:"[morgen om] LT",nextWeek:"dddd [om] LT",lastDay:"[gisteren om] LT",lastWeek:"[afgelopen] dddd [om] LT",sameElse:"L"},relativeTime:{future:"over %s",past:"%s geleden",s:"een paar seconden",m:"ÃƒÂ©ÃƒÂ©n minuut",mm:"%d minuten",h:"ÃƒÂ©ÃƒÂ©n uur",hh:"%d uur",d:"ÃƒÂ©ÃƒÂ©n dag",dd:"%d dagen",M:"ÃƒÂ©ÃƒÂ©n maand",MM:"%d maanden",y:"ÃƒÂ©ÃƒÂ©n jaar",yy:"%d jaar"},ordinalParse:/\d{1,2}(ste|de)/,ordinal:function(a){return a+(1===a||8===a||a>=20?"ste":"de")},week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("nn",{months:"januar_februar_mars_april_mai_juni_juli_august_september_oktober_november_desember".split("_"),monthsShort:"jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"),weekdays:"sundag_mÃƒÂ¥ndag_tysdag_onsdag_torsdag_fredag_laurdag".split("_"),weekdaysShort:"sun_mÃƒÂ¥n_tys_ons_tor_fre_lau".split("_"),weekdaysMin:"su_mÃƒÂ¥_ty_on_to_fr_lÃƒÂ¸".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY [kl.] H:mm",LLLL:"dddd D. MMMM YYYY [kl.] HH:mm"},calendar:{sameDay:"[I dag klokka] LT",nextDay:"[I morgon klokka] LT",nextWeek:"dddd [klokka] LT",lastDay:"[I gÃƒÂ¥r klokka] LT",lastWeek:"[FÃƒÂ¸regÃƒÂ¥ande] dddd [klokka] LT",sameElse:"L"},relativeTime:{future:"om %s",past:"%s sidan",s:"nokre sekund",m:"eit minutt",mm:"%d minutt",h:"ein time",hh:"%d timar",d:"ein dag",dd:"%d dagar",M:"ein mÃƒÂ¥nad",MM:"%d mÃƒÂ¥nader",y:"eit ÃƒÂ¥r",yy:"%d ÃƒÂ¥r"},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),{1:"Ã Â©Â§",2:"Ã Â©Â¨",3:"Ã Â©Â©",4:"Ã Â©Âª",5:"Ã Â©Â«",6:"Ã Â©Â¬",7:"Ã Â©Â­",8:"Ã Â©Â®",9:"Ã Â©Â¯",0:"Ã Â©Â¦"}),gh={"Ã Â©Â§":"1","Ã Â©Â¨":"2","Ã Â©Â©":"3","Ã Â©Âª":"4","Ã Â©Â«":"5","Ã Â©Â¬":"6","Ã Â©Â­":"7","Ã Â©Â®":"8","Ã Â©Â¯":"9","Ã Â©Â¦":"0"},hh=(kg.defineLocale("pa-in",{
// There are months name as per Nanakshahi Calender but they are not used as rigidly in modern Punjabi.
months:"Ã Â¨Å“Ã Â¨Â¨Ã Â¨ÂµÃ Â¨Â°Ã Â©â‚¬_Ã Â¨Â«Ã Â¨Â¼Ã Â¨Â°Ã Â¨ÂµÃ Â¨Â°Ã Â©â‚¬_Ã Â¨Â®Ã Â¨Â¾Ã Â¨Â°Ã Â¨Å¡_Ã Â¨â€¦Ã Â¨ÂªÃ Â©ÂÃ Â¨Â°Ã Â©Ë†Ã Â¨Â²_Ã Â¨Â®Ã Â¨Ë†_Ã Â¨Å“Ã Â©â€šÃ Â¨Â¨_Ã Â¨Å“Ã Â©ÂÃ Â¨Â²Ã Â¨Â¾Ã Â¨Ë†_Ã Â¨â€¦Ã Â¨â€”Ã Â¨Â¸Ã Â¨Â¤_Ã Â¨Â¸Ã Â¨Â¤Ã Â©Â°Ã Â¨Â¬Ã Â¨Â°_Ã Â¨â€¦Ã Â¨â€¢Ã Â¨Â¤Ã Â©â€šÃ Â¨Â¬Ã Â¨Â°_Ã Â¨Â¨Ã Â¨ÂµÃ Â©Â°Ã Â¨Â¬Ã Â¨Â°_Ã Â¨Â¦Ã Â¨Â¸Ã Â©Â°Ã Â¨Â¬Ã Â¨Â°".split("_"),monthsShort:"Ã Â¨Å“Ã Â¨Â¨Ã Â¨ÂµÃ Â¨Â°Ã Â©â‚¬_Ã Â¨Â«Ã Â¨Â¼Ã Â¨Â°Ã Â¨ÂµÃ Â¨Â°Ã Â©â‚¬_Ã Â¨Â®Ã Â¨Â¾Ã Â¨Â°Ã Â¨Å¡_Ã Â¨â€¦Ã Â¨ÂªÃ Â©ÂÃ Â¨Â°Ã Â©Ë†Ã Â¨Â²_Ã Â¨Â®Ã Â¨Ë†_Ã Â¨Å“Ã Â©â€šÃ Â¨Â¨_Ã Â¨Å“Ã Â©ÂÃ Â¨Â²Ã Â¨Â¾Ã Â¨Ë†_Ã Â¨â€¦Ã Â¨â€”Ã Â¨Â¸Ã Â¨Â¤_Ã Â¨Â¸Ã Â¨Â¤Ã Â©Â°Ã Â¨Â¬Ã Â¨Â°_Ã Â¨â€¦Ã Â¨â€¢Ã Â¨Â¤Ã Â©â€šÃ Â¨Â¬Ã Â¨Â°_Ã Â¨Â¨Ã Â¨ÂµÃ Â©Â°Ã Â¨Â¬Ã Â¨Â°_Ã Â¨Â¦Ã Â¨Â¸Ã Â©Â°Ã Â¨Â¬Ã Â¨Â°".split("_"),weekdays:"Ã Â¨ÂÃ Â¨Â¤Ã Â¨ÂµÃ Â¨Â¾Ã Â¨Â°_Ã Â¨Â¸Ã Â©â€¹Ã Â¨Â®Ã Â¨ÂµÃ Â¨Â¾Ã Â¨Â°_Ã Â¨Â®Ã Â©Â°Ã Â¨â€”Ã Â¨Â²Ã Â¨ÂµÃ Â¨Â¾Ã Â¨Â°_Ã Â¨Â¬Ã Â©ÂÃ Â¨Â§Ã Â¨ÂµÃ Â¨Â¾Ã Â¨Â°_Ã Â¨ÂµÃ Â©â‚¬Ã Â¨Â°Ã Â¨ÂµÃ Â¨Â¾Ã Â¨Â°_Ã Â¨Â¸Ã Â¨Â¼Ã Â©ÂÃ Â©Â±Ã Â¨â€¢Ã Â¨Â°Ã Â¨ÂµÃ Â¨Â¾Ã Â¨Â°_Ã Â¨Â¸Ã Â¨Â¼Ã Â¨Â¨Ã Â©â‚¬Ã Â¨Å¡Ã Â¨Â°Ã Â¨ÂµÃ Â¨Â¾Ã Â¨Â°".split("_"),weekdaysShort:"Ã Â¨ÂÃ Â¨Â¤_Ã Â¨Â¸Ã Â©â€¹Ã Â¨Â®_Ã Â¨Â®Ã Â©Â°Ã Â¨â€”Ã Â¨Â²_Ã Â¨Â¬Ã Â©ÂÃ Â¨Â§_Ã Â¨ÂµÃ Â©â‚¬Ã Â¨Â°_Ã Â¨Â¸Ã Â¨Â¼Ã Â©ÂÃ Â¨â€¢Ã Â¨Â°_Ã Â¨Â¸Ã Â¨Â¼Ã Â¨Â¨Ã Â©â‚¬".split("_"),weekdaysMin:"Ã Â¨ÂÃ Â¨Â¤_Ã Â¨Â¸Ã Â©â€¹Ã Â¨Â®_Ã Â¨Â®Ã Â©Â°Ã Â¨â€”Ã Â¨Â²_Ã Â¨Â¬Ã Â©ÂÃ Â¨Â§_Ã Â¨ÂµÃ Â©â‚¬Ã Â¨Â°_Ã Â¨Â¸Ã Â¨Â¼Ã Â©ÂÃ Â¨â€¢Ã Â¨Â°_Ã Â¨Â¸Ã Â¨Â¼Ã Â¨Â¨Ã Â©â‚¬".split("_"),longDateFormat:{LT:"A h:mm Ã Â¨ÂµÃ Â¨Å“Ã Â©â€¡",LTS:"A h:mm:ss Ã Â¨ÂµÃ Â¨Å“Ã Â©â€¡",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm Ã Â¨ÂµÃ Â¨Å“Ã Â©â€¡",LLLL:"dddd, D MMMM YYYY, A h:mm Ã Â¨ÂµÃ Â¨Å“Ã Â©â€¡"},calendar:{sameDay:"[Ã Â¨â€¦Ã Â¨Å“] LT",nextDay:"[Ã Â¨â€¢Ã Â¨Â²] LT",nextWeek:"dddd, LT",lastDay:"[Ã Â¨â€¢Ã Â¨Â²] LT",lastWeek:"[Ã Â¨ÂªÃ Â¨Â¿Ã Â¨â€ºÃ Â¨Â²Ã Â©â€¡] dddd, LT",sameElse:"L"},relativeTime:{future:"%s Ã Â¨ÂµÃ Â¨Â¿Ã Â©Â±Ã Â¨Å¡",past:"%s Ã Â¨ÂªÃ Â¨Â¿Ã Â¨â€ºÃ Â¨Â²Ã Â©â€¡",s:"Ã Â¨â€¢Ã Â©ÂÃ Â¨Â Ã Â¨Â¸Ã Â¨â€¢Ã Â¨Â¿Ã Â©Â°Ã Â¨Å¸",m:"Ã Â¨â€¡Ã Â¨â€¢ Ã Â¨Â®Ã Â¨Â¿Ã Â©Â°Ã Â¨Å¸",mm:"%d Ã Â¨Â®Ã Â¨Â¿Ã Â©Â°Ã Â¨Å¸",h:"Ã Â¨â€¡Ã Â©Â±Ã Â¨â€¢ Ã Â¨ËœÃ Â©Â°Ã Â¨Å¸Ã Â¨Â¾",hh:"%d Ã Â¨ËœÃ Â©Â°Ã Â¨Å¸Ã Â©â€¡",d:"Ã Â¨â€¡Ã Â©Â±Ã Â¨â€¢ Ã Â¨Â¦Ã Â¨Â¿Ã Â¨Â¨",dd:"%d Ã Â¨Â¦Ã Â¨Â¿Ã Â¨Â¨",M:"Ã Â¨â€¡Ã Â©Â±Ã Â¨â€¢ Ã Â¨Â®Ã Â¨Â¹Ã Â©â‚¬Ã Â¨Â¨Ã Â¨Â¾",MM:"%d Ã Â¨Â®Ã Â¨Â¹Ã Â©â‚¬Ã Â¨Â¨Ã Â©â€¡",y:"Ã Â¨â€¡Ã Â©Â±Ã Â¨â€¢ Ã Â¨Â¸Ã Â¨Â¾Ã Â¨Â²",yy:"%d Ã Â¨Â¸Ã Â¨Â¾Ã Â¨Â²"},preparse:function(a){return a.replace(/[Ã Â©Â§Ã Â©Â¨Ã Â©Â©Ã Â©ÂªÃ Â©Â«Ã Â©Â¬Ã Â©Â­Ã Â©Â®Ã Â©Â¯Ã Â©Â¦]/g,function(a){return gh[a]})},postformat:function(a){return a.replace(/\d/g,function(a){return fh[a]})},
// Punjabi notation for meridiems are quite fuzzy in practice. While there exists
// a rigid notion of a 'Pahar' it is not used as rigidly in modern Punjabi.
meridiemParse:/Ã Â¨Â°Ã Â¨Â¾Ã Â¨Â¤|Ã Â¨Â¸Ã Â¨ÂµÃ Â©â€¡Ã Â¨Â°|Ã Â¨Â¦Ã Â©ÂÃ Â¨ÂªÃ Â¨Â¹Ã Â¨Â¿Ã Â¨Â°|Ã Â¨Â¸Ã Â¨Â¼Ã Â¨Â¾Ã Â¨Â®/,meridiemHour:function(a,b){return 12===a&&(a=0),"Ã Â¨Â°Ã Â¨Â¾Ã Â¨Â¤"===b?4>a?a:a+12:"Ã Â¨Â¸Ã Â¨ÂµÃ Â©â€¡Ã Â¨Â°"===b?a:"Ã Â¨Â¦Ã Â©ÂÃ Â¨ÂªÃ Â¨Â¹Ã Â¨Â¿Ã Â¨Â°"===b?a>=10?a:a+12:"Ã Â¨Â¸Ã Â¨Â¼Ã Â¨Â¾Ã Â¨Â®"===b?a+12:void 0},meridiem:function(a,b,c){return 4>a?"Ã Â¨Â°Ã Â¨Â¾Ã Â¨Â¤":10>a?"Ã Â¨Â¸Ã Â¨ÂµÃ Â©â€¡Ã Â¨Â°":17>a?"Ã Â¨Â¦Ã Â©ÂÃ Â¨ÂªÃ Â¨Â¹Ã Â¨Â¿Ã Â¨Â°":20>a?"Ã Â¨Â¸Ã Â¨Â¼Ã Â¨Â¾Ã Â¨Â®":"Ã Â¨Â°Ã Â¨Â¾Ã Â¨Â¤"},week:{dow:0,// Sunday is the first day of the week.
doy:6}}),"styczeÃ…â€ž_luty_marzec_kwiecieÃ…â€ž_maj_czerwiec_lipiec_sierpieÃ…â€ž_wrzesieÃ…â€ž_paÃ…Âºdziernik_listopad_grudzieÃ…â€ž".split("_")),ih="stycznia_lutego_marca_kwietnia_maja_czerwca_lipca_sierpnia_wrzeÃ…â€ºnia_paÃ…Âºdziernika_listopada_grudnia".split("_"),jh=(kg.defineLocale("pl",{months:function(a,b){return""===b?"("+ih[a.month()]+"|"+hh[a.month()]+")":/D MMMM/.test(b)?ih[a.month()]:hh[a.month()]},monthsShort:"sty_lut_mar_kwi_maj_cze_lip_sie_wrz_paÃ…Âº_lis_gru".split("_"),weekdays:"niedziela_poniedziaÃ…â€šek_wtorek_Ã…â€ºroda_czwartek_piÃ„â€¦tek_sobota".split("_"),weekdaysShort:"nie_pon_wt_Ã…â€ºr_czw_pt_sb".split("_"),weekdaysMin:"Nd_Pn_Wt_Ã…Å¡r_Cz_Pt_So".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[DziÃ…â€º o] LT",nextDay:"[Jutro o] LT",nextWeek:"[W] dddd [o] LT",lastDay:"[Wczoraj o] LT",lastWeek:function(){switch(this.day()){case 0:return"[W zeszÃ…â€šÃ„â€¦ niedzielÃ„â„¢ o] LT";case 3:return"[W zeszÃ…â€šÃ„â€¦ Ã…â€ºrodÃ„â„¢ o] LT";case 6:return"[W zeszÃ…â€šÃ„â€¦ sobotÃ„â„¢ o] LT";default:return"[W zeszÃ…â€šy] dddd [o] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"%s temu",s:"kilka sekund",m:Vd,mm:Vd,h:Vd,hh:Vd,d:"1 dzieÃ…â€ž",dd:"%d dni",M:"miesiÃ„â€¦c",MM:Vd,y:"rok",yy:Vd},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("pt-br",{months:"Janeiro_Fevereiro_MarÃƒÂ§o_Abril_Maio_Junho_Julho_Agosto_Setembro_Outubro_Novembro_Dezembro".split("_"),monthsShort:"Jan_Fev_Mar_Abr_Mai_Jun_Jul_Ago_Set_Out_Nov_Dez".split("_"),weekdays:"Domingo_Segunda-feira_TerÃƒÂ§a-feira_Quarta-feira_Quinta-feira_Sexta-feira_SÃƒÂ¡bado".split("_"),weekdaysShort:"Dom_Seg_Ter_Qua_Qui_Sex_SÃƒÂ¡b".split("_"),weekdaysMin:"Dom_2Ã‚Âª_3Ã‚Âª_4Ã‚Âª_5Ã‚Âª_6Ã‚Âª_SÃƒÂ¡b".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D [de] MMMM [de] YYYY",LLL:"D [de] MMMM [de] YYYY [Ãƒ s] HH:mm",LLLL:"dddd, D [de] MMMM [de] YYYY [Ãƒ s] HH:mm"},calendar:{sameDay:"[Hoje Ãƒ s] LT",nextDay:"[AmanhÃƒÂ£ Ãƒ s] LT",nextWeek:"dddd [Ãƒ s] LT",lastDay:"[Ontem Ãƒ s] LT",lastWeek:function(){// Saturday + Sunday
return 0===this.day()||6===this.day()?"[ÃƒÅ¡ltimo] dddd [Ãƒ s] LT":"[ÃƒÅ¡ltima] dddd [Ãƒ s] LT"},sameElse:"L"},relativeTime:{future:"em %s",past:"%s atrÃƒÂ¡s",s:"poucos segundos",m:"um minuto",mm:"%d minutos",h:"uma hora",hh:"%d horas",d:"um dia",dd:"%d dias",M:"um mÃƒÂªs",MM:"%d meses",y:"um ano",yy:"%d anos"},ordinalParse:/\d{1,2}Ã‚Âº/,ordinal:"%dÃ‚Âº"}),kg.defineLocale("pt",{months:"Janeiro_Fevereiro_MarÃƒÂ§o_Abril_Maio_Junho_Julho_Agosto_Setembro_Outubro_Novembro_Dezembro".split("_"),monthsShort:"Jan_Fev_Mar_Abr_Mai_Jun_Jul_Ago_Set_Out_Nov_Dez".split("_"),weekdays:"Domingo_Segunda-Feira_TerÃƒÂ§a-Feira_Quarta-Feira_Quinta-Feira_Sexta-Feira_SÃƒÂ¡bado".split("_"),weekdaysShort:"Dom_Seg_Ter_Qua_Qui_Sex_SÃƒÂ¡b".split("_"),weekdaysMin:"Dom_2Ã‚Âª_3Ã‚Âª_4Ã‚Âª_5Ã‚Âª_6Ã‚Âª_SÃƒÂ¡b".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D [de] MMMM [de] YYYY",LLL:"D [de] MMMM [de] YYYY HH:mm",LLLL:"dddd, D [de] MMMM [de] YYYY HH:mm"},calendar:{sameDay:"[Hoje Ãƒ s] LT",nextDay:"[AmanhÃƒÂ£ Ãƒ s] LT",nextWeek:"dddd [Ãƒ s] LT",lastDay:"[Ontem Ãƒ s] LT",lastWeek:function(){// Saturday + Sunday
return 0===this.day()||6===this.day()?"[ÃƒÅ¡ltimo] dddd [Ãƒ s] LT":"[ÃƒÅ¡ltima] dddd [Ãƒ s] LT"},sameElse:"L"},relativeTime:{future:"em %s",past:"hÃƒÂ¡ %s",s:"segundos",m:"um minuto",mm:"%d minutos",h:"uma hora",hh:"%d horas",d:"um dia",dd:"%d dias",M:"um mÃƒÂªs",MM:"%d meses",y:"um ano",yy:"%d anos"},ordinalParse:/\d{1,2}Ã‚Âº/,ordinal:"%dÃ‚Âº",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("ro",{months:"ianuarie_februarie_martie_aprilie_mai_iunie_iulie_august_septembrie_octombrie_noiembrie_decembrie".split("_"),monthsShort:"ian._febr._mart._apr._mai_iun._iul._aug._sept._oct._nov._dec.".split("_"),monthsParseExact:!0,weekdays:"duminicÃ„Æ’_luni_marÃˆâ€ºi_miercuri_joi_vineri_sÃƒÂ¢mbÃ„Æ’tÃ„Æ’".split("_"),weekdaysShort:"Dum_Lun_Mar_Mie_Joi_Vin_SÃƒÂ¢m".split("_"),weekdaysMin:"Du_Lu_Ma_Mi_Jo_Vi_SÃƒÂ¢".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY H:mm",LLLL:"dddd, D MMMM YYYY H:mm"},calendar:{sameDay:"[azi la] LT",nextDay:"[mÃƒÂ¢ine la] LT",nextWeek:"dddd [la] LT",lastDay:"[ieri la] LT",lastWeek:"[fosta] dddd [la] LT",sameElse:"L"},relativeTime:{future:"peste %s",past:"%s ÃƒÂ®n urmÃ„Æ’",s:"cÃƒÂ¢teva secunde",m:"un minut",mm:Wd,h:"o orÃ„Æ’",hh:Wd,d:"o zi",dd:Wd,M:"o lunÃ„Æ’",MM:Wd,y:"un an",yy:Wd},week:{dow:1,// Monday is the first day of the week.
doy:7}}),[/^Ã‘ÂÃÂ½ÃÂ²/i,/^Ã‘â€žÃÂµÃÂ²/i,/^ÃÂ¼ÃÂ°Ã‘â‚¬/i,/^ÃÂ°ÃÂ¿Ã‘â‚¬/i,/^ÃÂ¼ÃÂ°[ÃÂ¹Ã‘Â]/i,/^ÃÂ¸Ã‘Å½ÃÂ½/i,/^ÃÂ¸Ã‘Å½ÃÂ»/i,/^ÃÂ°ÃÂ²ÃÂ³/i,/^Ã‘ÂÃÂµÃÂ½/i,/^ÃÂ¾ÃÂºÃ‘â€š/i,/^ÃÂ½ÃÂ¾Ã‘Â/i,/^ÃÂ´ÃÂµÃÂº/i]),kh=(kg.defineLocale("ru",{months:{format:"Ã‘ÂÃÂ½ÃÂ²ÃÂ°Ã‘â‚¬Ã‘Â_Ã‘â€žÃÂµÃÂ²Ã‘â‚¬ÃÂ°ÃÂ»Ã‘Â_ÃÂ¼ÃÂ°Ã‘â‚¬Ã‘â€šÃÂ°_ÃÂ°ÃÂ¿Ã‘â‚¬ÃÂµÃÂ»Ã‘Â_ÃÂ¼ÃÂ°Ã‘Â_ÃÂ¸Ã‘Å½ÃÂ½Ã‘Â_ÃÂ¸Ã‘Å½ÃÂ»Ã‘Â_ÃÂ°ÃÂ²ÃÂ³Ã‘Æ’Ã‘ÂÃ‘â€šÃÂ°_Ã‘ÂÃÂµÃÂ½Ã‘â€šÃ‘ÂÃÂ±Ã‘â‚¬Ã‘Â_ÃÂ¾ÃÂºÃ‘â€šÃ‘ÂÃÂ±Ã‘â‚¬Ã‘Â_ÃÂ½ÃÂ¾Ã‘ÂÃÂ±Ã‘â‚¬Ã‘Â_ÃÂ´ÃÂµÃÂºÃÂ°ÃÂ±Ã‘â‚¬Ã‘Â".split("_"),standalone:"Ã‘ÂÃÂ½ÃÂ²ÃÂ°Ã‘â‚¬Ã‘Å’_Ã‘â€žÃÂµÃÂ²Ã‘â‚¬ÃÂ°ÃÂ»Ã‘Å’_ÃÂ¼ÃÂ°Ã‘â‚¬Ã‘â€š_ÃÂ°ÃÂ¿Ã‘â‚¬ÃÂµÃÂ»Ã‘Å’_ÃÂ¼ÃÂ°ÃÂ¹_ÃÂ¸Ã‘Å½ÃÂ½Ã‘Å’_ÃÂ¸Ã‘Å½ÃÂ»Ã‘Å’_ÃÂ°ÃÂ²ÃÂ³Ã‘Æ’Ã‘ÂÃ‘â€š_Ã‘ÂÃÂµÃÂ½Ã‘â€šÃ‘ÂÃÂ±Ã‘â‚¬Ã‘Å’_ÃÂ¾ÃÂºÃ‘â€šÃ‘ÂÃÂ±Ã‘â‚¬Ã‘Å’_ÃÂ½ÃÂ¾Ã‘ÂÃÂ±Ã‘â‚¬Ã‘Å’_ÃÂ´ÃÂµÃÂºÃÂ°ÃÂ±Ã‘â‚¬Ã‘Å’".split("_")},monthsShort:{
// ÃÂ¿ÃÂ¾ CLDR ÃÂ¸ÃÂ¼ÃÂµÃÂ½ÃÂ½ÃÂ¾ "ÃÂ¸Ã‘Å½ÃÂ»." ÃÂ¸ "ÃÂ¸Ã‘Å½ÃÂ½.", ÃÂ½ÃÂ¾ ÃÂºÃÂ°ÃÂºÃÂ¾ÃÂ¹ Ã‘ÂÃÂ¼Ã‘â€¹Ã‘ÂÃÂ» ÃÂ¼ÃÂµÃÂ½Ã‘ÂÃ‘â€šÃ‘Å’ ÃÂ±Ã‘Æ’ÃÂºÃÂ²Ã‘Æ’ ÃÂ½ÃÂ° Ã‘â€šÃÂ¾Ã‘â€¡ÃÂºÃ‘Æ’ ?
format:"Ã‘ÂÃÂ½ÃÂ²._Ã‘â€žÃÂµÃÂ²Ã‘â‚¬._ÃÂ¼ÃÂ°Ã‘â‚¬._ÃÂ°ÃÂ¿Ã‘â‚¬._ÃÂ¼ÃÂ°Ã‘Â_ÃÂ¸Ã‘Å½ÃÂ½Ã‘Â_ÃÂ¸Ã‘Å½ÃÂ»Ã‘Â_ÃÂ°ÃÂ²ÃÂ³._Ã‘ÂÃÂµÃÂ½Ã‘â€š._ÃÂ¾ÃÂºÃ‘â€š._ÃÂ½ÃÂ¾Ã‘ÂÃÂ±._ÃÂ´ÃÂµÃÂº.".split("_"),standalone:"Ã‘ÂÃÂ½ÃÂ²._Ã‘â€žÃÂµÃÂ²Ã‘â‚¬._ÃÂ¼ÃÂ°Ã‘â‚¬Ã‘â€š_ÃÂ°ÃÂ¿Ã‘â‚¬._ÃÂ¼ÃÂ°ÃÂ¹_ÃÂ¸Ã‘Å½ÃÂ½Ã‘Å’_ÃÂ¸Ã‘Å½ÃÂ»Ã‘Å’_ÃÂ°ÃÂ²ÃÂ³._Ã‘ÂÃÂµÃÂ½Ã‘â€š._ÃÂ¾ÃÂºÃ‘â€š._ÃÂ½ÃÂ¾Ã‘ÂÃÂ±._ÃÂ´ÃÂµÃÂº.".split("_")},weekdays:{standalone:"ÃÂ²ÃÂ¾Ã‘ÂÃÂºÃ‘â‚¬ÃÂµÃ‘ÂÃÂµÃÂ½Ã‘Å’ÃÂµ_ÃÂ¿ÃÂ¾ÃÂ½ÃÂµÃÂ´ÃÂµÃÂ»Ã‘Å’ÃÂ½ÃÂ¸ÃÂº_ÃÂ²Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ½ÃÂ¸ÃÂº_Ã‘ÂÃ‘â‚¬ÃÂµÃÂ´ÃÂ°_Ã‘â€¡ÃÂµÃ‘â€šÃÂ²ÃÂµÃ‘â‚¬ÃÂ³_ÃÂ¿Ã‘ÂÃ‘â€šÃÂ½ÃÂ¸Ã‘â€ ÃÂ°_Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ±ÃÂ¾Ã‘â€šÃÂ°".split("_"),format:"ÃÂ²ÃÂ¾Ã‘ÂÃÂºÃ‘â‚¬ÃÂµÃ‘ÂÃÂµÃÂ½Ã‘Å’ÃÂµ_ÃÂ¿ÃÂ¾ÃÂ½ÃÂµÃÂ´ÃÂµÃÂ»Ã‘Å’ÃÂ½ÃÂ¸ÃÂº_ÃÂ²Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ½ÃÂ¸ÃÂº_Ã‘ÂÃ‘â‚¬ÃÂµÃÂ´Ã‘Æ’_Ã‘â€¡ÃÂµÃ‘â€šÃÂ²ÃÂµÃ‘â‚¬ÃÂ³_ÃÂ¿Ã‘ÂÃ‘â€šÃÂ½ÃÂ¸Ã‘â€ Ã‘Æ’_Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ±ÃÂ¾Ã‘â€šÃ‘Æ’".split("_"),isFormat:/\[ ?[Ãâ€™ÃÂ²] ?(?:ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»Ã‘Æ’Ã‘Å½|Ã‘ÂÃÂ»ÃÂµÃÂ´Ã‘Æ’Ã‘Å½Ã‘â€°Ã‘Æ’Ã‘Å½|Ã‘ÂÃ‘â€šÃ‘Æ’)? ?\] ?dddd/},weekdaysShort:"ÃÂ²Ã‘Â_ÃÂ¿ÃÂ½_ÃÂ²Ã‘â€š_Ã‘ÂÃ‘â‚¬_Ã‘â€¡Ã‘â€š_ÃÂ¿Ã‘â€š_Ã‘ÂÃÂ±".split("_"),weekdaysMin:"ÃÂ²Ã‘Â_ÃÂ¿ÃÂ½_ÃÂ²Ã‘â€š_Ã‘ÂÃ‘â‚¬_Ã‘â€¡Ã‘â€š_ÃÂ¿Ã‘â€š_Ã‘ÂÃÂ±".split("_"),monthsParse:jh,longMonthsParse:jh,shortMonthsParse:jh,
// ÃÂ¿ÃÂ¾ÃÂ»ÃÂ½Ã‘â€¹ÃÂµ ÃÂ½ÃÂ°ÃÂ·ÃÂ²ÃÂ°ÃÂ½ÃÂ¸Ã‘Â Ã‘Â ÃÂ¿ÃÂ°ÃÂ´ÃÂµÃÂ¶ÃÂ°ÃÂ¼ÃÂ¸, ÃÂ¿ÃÂ¾ Ã‘â€šÃ‘â‚¬ÃÂ¸ ÃÂ±Ã‘Æ’ÃÂºÃÂ²Ã‘â€¹, ÃÂ´ÃÂ»Ã‘Â ÃÂ½ÃÂµÃÂºÃÂ¾Ã‘â€šÃÂ¾Ã‘â‚¬Ã‘â€¹Ã‘â€¦, ÃÂ¿ÃÂ¾ 4 ÃÂ±Ã‘Æ’ÃÂºÃÂ²Ã‘â€¹, Ã‘ÂÃÂ¾ÃÂºÃ‘â‚¬ÃÂ°Ã‘â€°ÃÂµÃÂ½ÃÂ¸Ã‘Â Ã‘Â Ã‘â€šÃÂ¾Ã‘â€¡ÃÂºÃÂ¾ÃÂ¹ ÃÂ¸ ÃÂ±ÃÂµÃÂ· Ã‘â€šÃÂ¾Ã‘â€¡ÃÂºÃÂ¸
monthsRegex:/^(Ã‘ÂÃÂ½ÃÂ²ÃÂ°Ã‘â‚¬[Ã‘Å’Ã‘Â]|Ã‘ÂÃÂ½ÃÂ²\.?|Ã‘â€žÃÂµÃÂ²Ã‘â‚¬ÃÂ°ÃÂ»[Ã‘Å’Ã‘Â]|Ã‘â€žÃÂµÃÂ²Ã‘â‚¬?\.?|ÃÂ¼ÃÂ°Ã‘â‚¬Ã‘â€šÃÂ°?|ÃÂ¼ÃÂ°Ã‘â‚¬\.?|ÃÂ°ÃÂ¿Ã‘â‚¬ÃÂµÃÂ»[Ã‘Å’Ã‘Â]|ÃÂ°ÃÂ¿Ã‘â‚¬\.?|ÃÂ¼ÃÂ°[ÃÂ¹Ã‘Â]|ÃÂ¸Ã‘Å½ÃÂ½[Ã‘Å’Ã‘Â]|ÃÂ¸Ã‘Å½ÃÂ½\.?|ÃÂ¸Ã‘Å½ÃÂ»[Ã‘Å’Ã‘Â]|ÃÂ¸Ã‘Å½ÃÂ»\.?|ÃÂ°ÃÂ²ÃÂ³Ã‘Æ’Ã‘ÂÃ‘â€šÃÂ°?|ÃÂ°ÃÂ²ÃÂ³\.?|Ã‘ÂÃÂµÃÂ½Ã‘â€šÃ‘ÂÃÂ±Ã‘â‚¬[Ã‘Å’Ã‘Â]|Ã‘ÂÃÂµÃÂ½Ã‘â€š?\.?|ÃÂ¾ÃÂºÃ‘â€šÃ‘ÂÃÂ±Ã‘â‚¬[Ã‘Å’Ã‘Â]|ÃÂ¾ÃÂºÃ‘â€š\.?|ÃÂ½ÃÂ¾Ã‘ÂÃÂ±Ã‘â‚¬[Ã‘Å’Ã‘Â]|ÃÂ½ÃÂ¾Ã‘ÂÃÂ±?\.?|ÃÂ´ÃÂµÃÂºÃÂ°ÃÂ±Ã‘â‚¬[Ã‘Å’Ã‘Â]|ÃÂ´ÃÂµÃÂº\.?)/i,
// ÃÂºÃÂ¾ÃÂ¿ÃÂ¸Ã‘Â ÃÂ¿Ã‘â‚¬ÃÂµÃÂ´Ã‘â€¹ÃÂ´Ã‘Æ’Ã‘â€°ÃÂµÃÂ³ÃÂ¾
monthsShortRegex:/^(Ã‘ÂÃÂ½ÃÂ²ÃÂ°Ã‘â‚¬[Ã‘Å’Ã‘Â]|Ã‘ÂÃÂ½ÃÂ²\.?|Ã‘â€žÃÂµÃÂ²Ã‘â‚¬ÃÂ°ÃÂ»[Ã‘Å’Ã‘Â]|Ã‘â€žÃÂµÃÂ²Ã‘â‚¬?\.?|ÃÂ¼ÃÂ°Ã‘â‚¬Ã‘â€šÃÂ°?|ÃÂ¼ÃÂ°Ã‘â‚¬\.?|ÃÂ°ÃÂ¿Ã‘â‚¬ÃÂµÃÂ»[Ã‘Å’Ã‘Â]|ÃÂ°ÃÂ¿Ã‘â‚¬\.?|ÃÂ¼ÃÂ°[ÃÂ¹Ã‘Â]|ÃÂ¸Ã‘Å½ÃÂ½[Ã‘Å’Ã‘Â]|ÃÂ¸Ã‘Å½ÃÂ½\.?|ÃÂ¸Ã‘Å½ÃÂ»[Ã‘Å’Ã‘Â]|ÃÂ¸Ã‘Å½ÃÂ»\.?|ÃÂ°ÃÂ²ÃÂ³Ã‘Æ’Ã‘ÂÃ‘â€šÃÂ°?|ÃÂ°ÃÂ²ÃÂ³\.?|Ã‘ÂÃÂµÃÂ½Ã‘â€šÃ‘ÂÃÂ±Ã‘â‚¬[Ã‘Å’Ã‘Â]|Ã‘ÂÃÂµÃÂ½Ã‘â€š?\.?|ÃÂ¾ÃÂºÃ‘â€šÃ‘ÂÃÂ±Ã‘â‚¬[Ã‘Å’Ã‘Â]|ÃÂ¾ÃÂºÃ‘â€š\.?|ÃÂ½ÃÂ¾Ã‘ÂÃÂ±Ã‘â‚¬[Ã‘Å’Ã‘Â]|ÃÂ½ÃÂ¾Ã‘ÂÃÂ±?\.?|ÃÂ´ÃÂµÃÂºÃÂ°ÃÂ±Ã‘â‚¬[Ã‘Å’Ã‘Â]|ÃÂ´ÃÂµÃÂº\.?)/i,
// ÃÂ¿ÃÂ¾ÃÂ»ÃÂ½Ã‘â€¹ÃÂµ ÃÂ½ÃÂ°ÃÂ·ÃÂ²ÃÂ°ÃÂ½ÃÂ¸Ã‘Â Ã‘Â ÃÂ¿ÃÂ°ÃÂ´ÃÂµÃÂ¶ÃÂ°ÃÂ¼ÃÂ¸
monthsStrictRegex:/^(Ã‘ÂÃÂ½ÃÂ²ÃÂ°Ã‘â‚¬[Ã‘ÂÃ‘Å’]|Ã‘â€žÃÂµÃÂ²Ã‘â‚¬ÃÂ°ÃÂ»[Ã‘ÂÃ‘Å’]|ÃÂ¼ÃÂ°Ã‘â‚¬Ã‘â€šÃÂ°?|ÃÂ°ÃÂ¿Ã‘â‚¬ÃÂµÃÂ»[Ã‘ÂÃ‘Å’]|ÃÂ¼ÃÂ°[Ã‘ÂÃÂ¹]|ÃÂ¸Ã‘Å½ÃÂ½[Ã‘ÂÃ‘Å’]|ÃÂ¸Ã‘Å½ÃÂ»[Ã‘ÂÃ‘Å’]|ÃÂ°ÃÂ²ÃÂ³Ã‘Æ’Ã‘ÂÃ‘â€šÃÂ°?|Ã‘ÂÃÂµÃÂ½Ã‘â€šÃ‘ÂÃÂ±Ã‘â‚¬[Ã‘ÂÃ‘Å’]|ÃÂ¾ÃÂºÃ‘â€šÃ‘ÂÃÂ±Ã‘â‚¬[Ã‘ÂÃ‘Å’]|ÃÂ½ÃÂ¾Ã‘ÂÃÂ±Ã‘â‚¬[Ã‘ÂÃ‘Å’]|ÃÂ´ÃÂµÃÂºÃÂ°ÃÂ±Ã‘â‚¬[Ã‘ÂÃ‘Å’])/i,
// Ãâ€™Ã‘â€¹Ã‘â‚¬ÃÂ°ÃÂ¶ÃÂµÃÂ½ÃÂ¸ÃÂµ, ÃÂºÃÂ¾Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ¾ÃÂµ Ã‘ÂÃÂ¾ÃÂ¾Ã‘â€šÃÂ²ÃÂµÃ‘ÂÃ‘â€šÃÂ²Ã‘Æ’ÃÂµÃ‘â€š Ã‘â€šÃÂ¾ÃÂ»Ã‘Å’ÃÂºÃÂ¾ Ã‘ÂÃÂ¾ÃÂºÃ‘â‚¬ÃÂ°Ã‘â€°Ã‘â€˜ÃÂ½ÃÂ½Ã‘â€¹ÃÂ¼ Ã‘â€žÃÂ¾Ã‘â‚¬ÃÂ¼ÃÂ°ÃÂ¼
monthsShortStrictRegex:/^(Ã‘ÂÃÂ½ÃÂ²\.|Ã‘â€žÃÂµÃÂ²Ã‘â‚¬?\.|ÃÂ¼ÃÂ°Ã‘â‚¬[Ã‘â€š.]|ÃÂ°ÃÂ¿Ã‘â‚¬\.|ÃÂ¼ÃÂ°[Ã‘ÂÃÂ¹]|ÃÂ¸Ã‘Å½ÃÂ½[Ã‘Å’Ã‘Â.]|ÃÂ¸Ã‘Å½ÃÂ»[Ã‘Å’Ã‘Â.]|ÃÂ°ÃÂ²ÃÂ³\.|Ã‘ÂÃÂµÃÂ½Ã‘â€š?\.|ÃÂ¾ÃÂºÃ‘â€š\.|ÃÂ½ÃÂ¾Ã‘ÂÃÂ±?\.|ÃÂ´ÃÂµÃÂº\.)/i,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY ÃÂ³.",LLL:"D MMMM YYYY ÃÂ³., HH:mm",LLLL:"dddd, D MMMM YYYY ÃÂ³., HH:mm"},calendar:{sameDay:"[ÃÂ¡ÃÂµÃÂ³ÃÂ¾ÃÂ´ÃÂ½Ã‘Â ÃÂ²] LT",nextDay:"[Ãâ€”ÃÂ°ÃÂ²Ã‘â€šÃ‘â‚¬ÃÂ° ÃÂ²] LT",lastDay:"[Ãâ€™Ã‘â€¡ÃÂµÃ‘â‚¬ÃÂ° ÃÂ²] LT",nextWeek:function(a){if(a.week()===this.week())return 2===this.day()?"[Ãâ€™ÃÂ¾] dddd [ÃÂ²] LT":"[Ãâ€™] dddd [ÃÂ²] LT";switch(this.day()){case 0:return"[Ãâ€™ Ã‘ÂÃÂ»ÃÂµÃÂ´Ã‘Æ’Ã‘Å½Ã‘â€°ÃÂµÃÂµ] dddd [ÃÂ²] LT";case 1:case 2:case 4:return"[Ãâ€™ Ã‘ÂÃÂ»ÃÂµÃÂ´Ã‘Æ’Ã‘Å½Ã‘â€°ÃÂ¸ÃÂ¹] dddd [ÃÂ²] LT";case 3:case 5:case 6:return"[Ãâ€™ Ã‘ÂÃÂ»ÃÂµÃÂ´Ã‘Æ’Ã‘Å½Ã‘â€°Ã‘Æ’Ã‘Å½] dddd [ÃÂ²] LT"}},lastWeek:function(a){if(a.week()===this.week())return 2===this.day()?"[Ãâ€™ÃÂ¾] dddd [ÃÂ²] LT":"[Ãâ€™] dddd [ÃÂ²] LT";switch(this.day()){case 0:return"[Ãâ€™ ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»ÃÂ¾ÃÂµ] dddd [ÃÂ²] LT";case 1:case 2:case 4:return"[Ãâ€™ ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»Ã‘â€¹ÃÂ¹] dddd [ÃÂ²] LT";case 3:case 5:case 6:return"[Ãâ€™ ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»Ã‘Æ’Ã‘Å½] dddd [ÃÂ²] LT"}},sameElse:"L"},relativeTime:{future:"Ã‘â€¡ÃÂµÃ‘â‚¬ÃÂµÃÂ· %s",past:"%s ÃÂ½ÃÂ°ÃÂ·ÃÂ°ÃÂ´",s:"ÃÂ½ÃÂµÃ‘ÂÃÂºÃÂ¾ÃÂ»Ã‘Å’ÃÂºÃÂ¾ Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´",m:Yd,mm:Yd,h:"Ã‘â€¡ÃÂ°Ã‘Â",hh:Yd,d:"ÃÂ´ÃÂµÃÂ½Ã‘Å’",dd:Yd,M:"ÃÂ¼ÃÂµÃ‘ÂÃ‘ÂÃ‘â€ ",MM:Yd,y:"ÃÂ³ÃÂ¾ÃÂ´",yy:Yd},meridiemParse:/ÃÂ½ÃÂ¾Ã‘â€¡ÃÂ¸|Ã‘Æ’Ã‘â€šÃ‘â‚¬ÃÂ°|ÃÂ´ÃÂ½Ã‘Â|ÃÂ²ÃÂµÃ‘â€¡ÃÂµÃ‘â‚¬ÃÂ°/i,isPM:function(a){return/^(ÃÂ´ÃÂ½Ã‘Â|ÃÂ²ÃÂµÃ‘â€¡ÃÂµÃ‘â‚¬ÃÂ°)$/.test(a)},meridiem:function(a,b,c){return 4>a?"ÃÂ½ÃÂ¾Ã‘â€¡ÃÂ¸":12>a?"Ã‘Æ’Ã‘â€šÃ‘â‚¬ÃÂ°":17>a?"ÃÂ´ÃÂ½Ã‘Â":"ÃÂ²ÃÂµÃ‘â€¡ÃÂµÃ‘â‚¬ÃÂ°"},ordinalParse:/\d{1,2}-(ÃÂ¹|ÃÂ³ÃÂ¾|Ã‘Â)/,ordinal:function(a,b){switch(b){case"M":case"d":case"DDD":return a+"-ÃÂ¹";case"D":return a+"-ÃÂ³ÃÂ¾";case"w":case"W":return a+"-Ã‘Â";default:return a}},week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("se",{months:"oÃ„â€˜Ã„â€˜ajagemÃƒÂ¡nnu_guovvamÃƒÂ¡nnu_njukÃ„ÂamÃƒÂ¡nnu_cuoÃ…â€¹omÃƒÂ¡nnu_miessemÃƒÂ¡nnu_geassemÃƒÂ¡nnu_suoidnemÃƒÂ¡nnu_borgemÃƒÂ¡nnu_Ã„ÂakÃ„ÂamÃƒÂ¡nnu_golggotmÃƒÂ¡nnu_skÃƒÂ¡bmamÃƒÂ¡nnu_juovlamÃƒÂ¡nnu".split("_"),monthsShort:"oÃ„â€˜Ã„â€˜j_guov_njuk_cuo_mies_geas_suoi_borg_Ã„ÂakÃ„Â_golg_skÃƒÂ¡b_juov".split("_"),weekdays:"sotnabeaivi_vuossÃƒÂ¡rga_maÃ…â€¹Ã…â€¹ebÃƒÂ¡rga_gaskavahkku_duorastat_bearjadat_lÃƒÂ¡vvardat".split("_"),weekdaysShort:"sotn_vuos_maÃ…â€¹_gask_duor_bear_lÃƒÂ¡v".split("_"),weekdaysMin:"s_v_m_g_d_b_L".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"MMMM D. [b.] YYYY",LLL:"MMMM D. [b.] YYYY [ti.] HH:mm",LLLL:"dddd, MMMM D. [b.] YYYY [ti.] HH:mm"},calendar:{sameDay:"[otne ti] LT",nextDay:"[ihttin ti] LT",nextWeek:"dddd [ti] LT",lastDay:"[ikte ti] LT",lastWeek:"[ovddit] dddd [ti] LT",sameElse:"L"},relativeTime:{future:"%s geaÃ…Â¾es",past:"maÃ…â€¹it %s",s:"moadde sekunddat",m:"okta minuhta",mm:"%d minuhtat",h:"okta diimmu",hh:"%d diimmut",d:"okta beaivi",dd:"%d beaivvit",M:"okta mÃƒÂ¡nnu",MM:"%d mÃƒÂ¡nut",y:"okta jahki",yy:"%d jagit"},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("si",{months:"Ã Â¶Â¢Ã Â¶Â±Ã Â·â‚¬Ã Â·ÂÃ Â¶Â»Ã Â·â€™_Ã Â¶Â´Ã Â·â„¢Ã Â¶Â¶Ã Â¶Â»Ã Â·â‚¬Ã Â·ÂÃ Â¶Â»Ã Â·â€™_Ã Â¶Â¸Ã Â·ÂÃ Â¶Â»Ã Â·Å Ã Â¶Â­Ã Â·â€_Ã Â¶â€¦Ã Â¶Â´Ã Â·Å Ã¢â‚¬ÂÃ Â¶Â»Ã Â·Å¡Ã Â¶Â½Ã Â·Å _Ã Â¶Â¸Ã Â·ÂÃ Â¶ÂºÃ Â·â€™_Ã Â¶Â¢Ã Â·â€“Ã Â¶Â±Ã Â·â€™_Ã Â¶Â¢Ã Â·â€“Ã Â¶Â½Ã Â·â€™_Ã Â¶â€¦Ã Â¶Å“Ã Â·ÂÃ Â·Æ’Ã Â·Å Ã Â¶Â­Ã Â·â€_Ã Â·Æ’Ã Â·ÂÃ Â¶Â´Ã Â·Å Ã Â¶Â­Ã Â·ÂÃ Â¶Â¸Ã Â·Å Ã Â¶Â¶Ã Â¶Â»Ã Â·Å _Ã Â¶â€Ã Â¶Å¡Ã Â·Å Ã Â¶Â­Ã Â·ÂÃ Â¶Â¶Ã Â¶Â»Ã Â·Å _Ã Â¶Â±Ã Â·Å“Ã Â·â‚¬Ã Â·ÂÃ Â¶Â¸Ã Â·Å Ã Â¶Â¶Ã Â¶Â»Ã Â·Å _Ã Â¶Â¯Ã Â·â„¢Ã Â·Æ’Ã Â·ÂÃ Â¶Â¸Ã Â·Å Ã Â¶Â¶Ã Â¶Â»Ã Â·Å ".split("_"),monthsShort:"Ã Â¶Â¢Ã Â¶Â±_Ã Â¶Â´Ã Â·â„¢Ã Â¶Â¶_Ã Â¶Â¸Ã Â·ÂÃ Â¶Â»Ã Â·Å _Ã Â¶â€¦Ã Â¶Â´Ã Â·Å _Ã Â¶Â¸Ã Â·ÂÃ Â¶ÂºÃ Â·â€™_Ã Â¶Â¢Ã Â·â€“Ã Â¶Â±Ã Â·â€™_Ã Â¶Â¢Ã Â·â€“Ã Â¶Â½Ã Â·â€™_Ã Â¶â€¦Ã Â¶Å“Ã Â·Â_Ã Â·Æ’Ã Â·ÂÃ Â¶Â´Ã Â·Å _Ã Â¶â€Ã Â¶Å¡Ã Â·Å _Ã Â¶Â±Ã Â·Å“Ã Â·â‚¬Ã Â·Â_Ã Â¶Â¯Ã Â·â„¢Ã Â·Æ’Ã Â·Â".split("_"),weekdays:"Ã Â¶â€°Ã Â¶Â»Ã Â·â€™Ã Â¶Â¯Ã Â·Â_Ã Â·Æ’Ã Â¶Â³Ã Â·â€Ã Â¶Â¯Ã Â·Â_Ã Â¶â€¦Ã Â¶Å¸Ã Â·â€žÃ Â¶Â»Ã Â·â€Ã Â·â‚¬Ã Â·ÂÃ Â¶Â¯Ã Â·Â_Ã Â¶Â¶Ã Â¶Â¯Ã Â·ÂÃ Â¶Â¯Ã Â·Â_Ã Â¶Â¶Ã Â·Å Ã¢â‚¬ÂÃ Â¶Â»Ã Â·â€žÃ Â·Æ’Ã Â·Å Ã Â¶Â´Ã Â¶Â­Ã Â·â€™Ã Â¶Â±Ã Â·Å Ã Â¶Â¯Ã Â·Â_Ã Â·Æ’Ã Â·â€™Ã Â¶Å¡Ã Â·â€Ã Â¶Â»Ã Â·ÂÃ Â¶Â¯Ã Â·Â_Ã Â·Æ’Ã Â·â„¢Ã Â¶Â±Ã Â·Æ’Ã Â·â€Ã Â¶Â»Ã Â·ÂÃ Â¶Â¯Ã Â·Â".split("_"),weekdaysShort:"Ã Â¶â€°Ã Â¶Â»Ã Â·â€™_Ã Â·Æ’Ã Â¶Â³Ã Â·â€_Ã Â¶â€¦Ã Â¶Å¸_Ã Â¶Â¶Ã Â¶Â¯Ã Â·Â_Ã Â¶Â¶Ã Â·Å Ã¢â‚¬ÂÃ Â¶Â»Ã Â·â€ž_Ã Â·Æ’Ã Â·â€™Ã Â¶Å¡Ã Â·â€_Ã Â·Æ’Ã Â·â„¢Ã Â¶Â±".split("_"),weekdaysMin:"Ã Â¶â€°_Ã Â·Æ’_Ã Â¶â€¦_Ã Â¶Â¶_Ã Â¶Â¶Ã Â·Å Ã¢â‚¬ÂÃ Â¶Â»_Ã Â·Æ’Ã Â·â€™_Ã Â·Æ’Ã Â·â„¢".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"a h:mm",LTS:"a h:mm:ss",L:"YYYY/MM/DD",LL:"YYYY MMMM D",LLL:"YYYY MMMM D, a h:mm",LLLL:"YYYY MMMM D [Ã Â·â‚¬Ã Â·ÂÃ Â¶Â±Ã Â·â€™] dddd, a h:mm:ss"},calendar:{sameDay:"[Ã Â¶â€¦Ã Â¶Â¯] LT[Ã Â¶Â§]",nextDay:"[Ã Â·â€žÃ Â·â„¢Ã Â¶Â§] LT[Ã Â¶Â§]",nextWeek:"dddd LT[Ã Â¶Â§]",lastDay:"[Ã Â¶Å Ã Â¶ÂºÃ Â·Å¡] LT[Ã Â¶Â§]",lastWeek:"[Ã Â¶Â´Ã Â·Æ’Ã Â·â€Ã Â¶Å“Ã Â·â€™Ã Â¶Âº] dddd LT[Ã Â¶Â§]",sameElse:"L"},relativeTime:{future:"%sÃ Â¶Å¡Ã Â·â€™Ã Â¶Â±Ã Â·Å ",past:"%sÃ Â¶Å¡Ã Â¶Â§ Ã Â¶Â´Ã Â·â„¢Ã Â¶Â»",s:"Ã Â¶Â­Ã Â¶Â­Ã Â·Å Ã Â¶Â´Ã Â¶Â» Ã Â¶Å¡Ã Â·â€™Ã Â·â€žÃ Â·â€™Ã Â¶Â´Ã Â¶Âº",m:"Ã Â¶Â¸Ã Â·â€™Ã Â¶Â±Ã Â·â€™Ã Â¶Â­Ã Â·Å Ã Â¶Â­Ã Â·â€Ã Â·â‚¬",mm:"Ã Â¶Â¸Ã Â·â€™Ã Â¶Â±Ã Â·â€™Ã Â¶Â­Ã Â·Å Ã Â¶Â­Ã Â·â€ %d",h:"Ã Â¶Â´Ã Â·ÂÃ Â¶Âº",hh:"Ã Â¶Â´Ã Â·ÂÃ Â¶Âº %d",d:"Ã Â¶Â¯Ã Â·â€™Ã Â¶Â±Ã Â¶Âº",dd:"Ã Â¶Â¯Ã Â·â€™Ã Â¶Â± %d",M:"Ã Â¶Â¸Ã Â·ÂÃ Â·Æ’Ã Â¶Âº",MM:"Ã Â¶Â¸Ã Â·ÂÃ Â·Æ’ %d",y:"Ã Â·â‚¬Ã Â·Æ’Ã Â¶Â»",yy:"Ã Â·â‚¬Ã Â·Æ’Ã Â¶Â» %d"},ordinalParse:/\d{1,2} Ã Â·â‚¬Ã Â·ÂÃ Â¶Â±Ã Â·â€™/,ordinal:function(a){return a+" Ã Â·â‚¬Ã Â·ÂÃ Â¶Â±Ã Â·â€™"},meridiemParse:/Ã Â¶Â´Ã Â·â„¢Ã Â¶Â» Ã Â·â‚¬Ã Â¶Â»Ã Â·â€|Ã Â¶Â´Ã Â·Æ’Ã Â·Å  Ã Â·â‚¬Ã Â¶Â»Ã Â·â€|Ã Â¶Â´Ã Â·â„¢.Ã Â·â‚¬|Ã Â¶Â´.Ã Â·â‚¬./,isPM:function(a){return"Ã Â¶Â´.Ã Â·â‚¬."===a||"Ã Â¶Â´Ã Â·Æ’Ã Â·Å  Ã Â·â‚¬Ã Â¶Â»Ã Â·â€"===a},meridiem:function(a,b,c){return a>11?c?"Ã Â¶Â´.Ã Â·â‚¬.":"Ã Â¶Â´Ã Â·Æ’Ã Â·Å  Ã Â·â‚¬Ã Â¶Â»Ã Â·â€":c?"Ã Â¶Â´Ã Â·â„¢.Ã Â·â‚¬.":"Ã Â¶Â´Ã Â·â„¢Ã Â¶Â» Ã Â·â‚¬Ã Â¶Â»Ã Â·â€"}}),"januÃƒÂ¡r_februÃƒÂ¡r_marec_aprÃƒÂ­l_mÃƒÂ¡j_jÃƒÂºn_jÃƒÂºl_august_september_oktÃƒÂ³ber_november_december".split("_")),lh="jan_feb_mar_apr_mÃƒÂ¡j_jÃƒÂºn_jÃƒÂºl_aug_sep_okt_nov_dec".split("_"),mh=(kg.defineLocale("sk",{months:kh,monthsShort:lh,weekdays:"nedeÃ„Â¾a_pondelok_utorok_streda_Ã…Â¡tvrtok_piatok_sobota".split("_"),weekdaysShort:"ne_po_ut_st_Ã…Â¡t_pi_so".split("_"),weekdaysMin:"ne_po_ut_st_Ã…Â¡t_pi_so".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd D. MMMM YYYY H:mm"},calendar:{sameDay:"[dnes o] LT",nextDay:"[zajtra o] LT",nextWeek:function(){switch(this.day()){case 0:return"[v nedeÃ„Â¾u o] LT";case 1:case 2:return"[v] dddd [o] LT";case 3:return"[v stredu o] LT";case 4:return"[vo Ã…Â¡tvrtok o] LT";case 5:return"[v piatok o] LT";case 6:return"[v sobotu o] LT"}},lastDay:"[vÃ„Âera o] LT",lastWeek:function(){switch(this.day()){case 0:return"[minulÃƒÂº nedeÃ„Â¾u o] LT";case 1:case 2:return"[minulÃƒÂ½] dddd [o] LT";case 3:return"[minulÃƒÂº stredu o] LT";case 4:case 5:return"[minulÃƒÂ½] dddd [o] LT";case 6:return"[minulÃƒÂº sobotu o] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"pred %s",s:$d,m:$d,mm:$d,h:$d,hh:$d,d:$d,dd:$d,M:$d,MM:$d,y:$d,yy:$d},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("sl",{months:"januar_februar_marec_april_maj_junij_julij_avgust_september_oktober_november_december".split("_"),monthsShort:"jan._feb._mar._apr._maj._jun._jul._avg._sep._okt._nov._dec.".split("_"),monthsParseExact:!0,weekdays:"nedelja_ponedeljek_torek_sreda_Ã„Âetrtek_petek_sobota".split("_"),weekdaysShort:"ned._pon._tor._sre._Ã„Âet._pet._sob.".split("_"),weekdaysMin:"ne_po_to_sr_Ã„Âe_pe_so".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD. MM. YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[danes ob] LT",nextDay:"[jutri ob] LT",nextWeek:function(){switch(this.day()){case 0:return"[v] [nedeljo] [ob] LT";case 3:return"[v] [sredo] [ob] LT";case 6:return"[v] [soboto] [ob] LT";case 1:case 2:case 4:case 5:return"[v] dddd [ob] LT"}},lastDay:"[vÃ„Âeraj ob] LT",lastWeek:function(){switch(this.day()){case 0:return"[prejÃ…Â¡njo] [nedeljo] [ob] LT";case 3:return"[prejÃ…Â¡njo] [sredo] [ob] LT";case 6:return"[prejÃ…Â¡njo] [soboto] [ob] LT";case 1:case 2:case 4:case 5:return"[prejÃ…Â¡nji] dddd [ob] LT"}},sameElse:"L"},relativeTime:{future:"Ã„Âez %s",past:"pred %s",s:_d,m:_d,mm:_d,h:_d,hh:_d,d:_d,dd:_d,M:_d,MM:_d,y:_d,yy:_d},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("sq",{months:"Janar_Shkurt_Mars_Prill_Maj_Qershor_Korrik_Gusht_Shtator_Tetor_NÃƒÂ«ntor_Dhjetor".split("_"),monthsShort:"Jan_Shk_Mar_Pri_Maj_Qer_Kor_Gus_Sht_Tet_NÃƒÂ«n_Dhj".split("_"),weekdays:"E Diel_E HÃƒÂ«nÃƒÂ«_E MartÃƒÂ«_E MÃƒÂ«rkurÃƒÂ«_E Enjte_E Premte_E ShtunÃƒÂ«".split("_"),weekdaysShort:"Die_HÃƒÂ«n_Mar_MÃƒÂ«r_Enj_Pre_Sht".split("_"),weekdaysMin:"D_H_Ma_MÃƒÂ«_E_P_Sh".split("_"),weekdaysParseExact:!0,meridiemParse:/PD|MD/,isPM:function(a){return"M"===a.charAt(0)},meridiem:function(a,b,c){return 12>a?"PD":"MD"},longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Sot nÃƒÂ«] LT",nextDay:"[NesÃƒÂ«r nÃƒÂ«] LT",nextWeek:"dddd [nÃƒÂ«] LT",lastDay:"[Dje nÃƒÂ«] LT",lastWeek:"dddd [e kaluar nÃƒÂ«] LT",sameElse:"L"},relativeTime:{future:"nÃƒÂ« %s",past:"%s mÃƒÂ« parÃƒÂ«",s:"disa sekonda",m:"njÃƒÂ« minutÃƒÂ«",mm:"%d minuta",h:"njÃƒÂ« orÃƒÂ«",hh:"%d orÃƒÂ«",d:"njÃƒÂ« ditÃƒÂ«",dd:"%d ditÃƒÂ«",M:"njÃƒÂ« muaj",MM:"%d muaj",y:"njÃƒÂ« vit",yy:"%d vite"},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),{words:{//Different grammatical cases
m:["Ã‘ËœÃÂµÃÂ´ÃÂ°ÃÂ½ ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€š","Ã‘ËœÃÂµÃÂ´ÃÂ½ÃÂµ ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€šÃÂµ"],mm:["ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€š","ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€šÃÂµ","ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€šÃÂ°"],h:["Ã‘ËœÃÂµÃÂ´ÃÂ°ÃÂ½ Ã‘ÂÃÂ°Ã‘â€š","Ã‘ËœÃÂµÃÂ´ÃÂ½ÃÂ¾ÃÂ³ Ã‘ÂÃÂ°Ã‘â€šÃÂ°"],hh:["Ã‘ÂÃÂ°Ã‘â€š","Ã‘ÂÃÂ°Ã‘â€šÃÂ°","Ã‘ÂÃÂ°Ã‘â€šÃÂ¸"],dd:["ÃÂ´ÃÂ°ÃÂ½","ÃÂ´ÃÂ°ÃÂ½ÃÂ°","ÃÂ´ÃÂ°ÃÂ½ÃÂ°"],MM:["ÃÂ¼ÃÂµÃ‘ÂÃÂµÃ‘â€ ","ÃÂ¼ÃÂµÃ‘ÂÃÂµÃ‘â€ ÃÂ°","ÃÂ¼ÃÂµÃ‘ÂÃÂµÃ‘â€ ÃÂ¸"],yy:["ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ°","ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂµ","ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ°"]},correctGrammaticalCase:function(a,b){return 1===a?b[0]:a>=2&&4>=a?b[1]:b[2]},translate:function(a,b,c){var d=mh.words[c];return 1===c.length?b?d[0]:d[1]:a+" "+mh.correctGrammaticalCase(a,d)}}),nh=(kg.defineLocale("sr-cyrl",{months:"Ã‘ËœÃÂ°ÃÂ½Ã‘Æ’ÃÂ°Ã‘â‚¬_Ã‘â€žÃÂµÃÂ±Ã‘â‚¬Ã‘Æ’ÃÂ°Ã‘â‚¬_ÃÂ¼ÃÂ°Ã‘â‚¬Ã‘â€š_ÃÂ°ÃÂ¿Ã‘â‚¬ÃÂ¸ÃÂ»_ÃÂ¼ÃÂ°Ã‘Ëœ_Ã‘ËœÃ‘Æ’ÃÂ½_Ã‘ËœÃ‘Æ’ÃÂ»_ÃÂ°ÃÂ²ÃÂ³Ã‘Æ’Ã‘ÂÃ‘â€š_Ã‘ÂÃÂµÃÂ¿Ã‘â€šÃÂµÃÂ¼ÃÂ±ÃÂ°Ã‘â‚¬_ÃÂ¾ÃÂºÃ‘â€šÃÂ¾ÃÂ±ÃÂ°Ã‘â‚¬_ÃÂ½ÃÂ¾ÃÂ²ÃÂµÃÂ¼ÃÂ±ÃÂ°Ã‘â‚¬_ÃÂ´ÃÂµÃ‘â€ ÃÂµÃÂ¼ÃÂ±ÃÂ°Ã‘â‚¬".split("_"),monthsShort:"Ã‘ËœÃÂ°ÃÂ½._Ã‘â€žÃÂµÃÂ±._ÃÂ¼ÃÂ°Ã‘â‚¬._ÃÂ°ÃÂ¿Ã‘â‚¬._ÃÂ¼ÃÂ°Ã‘Ëœ_Ã‘ËœÃ‘Æ’ÃÂ½_Ã‘ËœÃ‘Æ’ÃÂ»_ÃÂ°ÃÂ²ÃÂ³._Ã‘ÂÃÂµÃÂ¿._ÃÂ¾ÃÂºÃ‘â€š._ÃÂ½ÃÂ¾ÃÂ²._ÃÂ´ÃÂµÃ‘â€ .".split("_"),monthsParseExact:!0,weekdays:"ÃÂ½ÃÂµÃÂ´ÃÂµÃ‘â„¢ÃÂ°_ÃÂ¿ÃÂ¾ÃÂ½ÃÂµÃÂ´ÃÂµÃ‘â„¢ÃÂ°ÃÂº_Ã‘Æ’Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ°ÃÂº_Ã‘ÂÃ‘â‚¬ÃÂµÃÂ´ÃÂ°_Ã‘â€¡ÃÂµÃ‘â€šÃÂ²Ã‘â‚¬Ã‘â€šÃÂ°ÃÂº_ÃÂ¿ÃÂµÃ‘â€šÃÂ°ÃÂº_Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃÂ°".split("_"),weekdaysShort:"ÃÂ½ÃÂµÃÂ´._ÃÂ¿ÃÂ¾ÃÂ½._Ã‘Æ’Ã‘â€šÃÂ¾._Ã‘ÂÃ‘â‚¬ÃÂµ._Ã‘â€¡ÃÂµÃ‘â€š._ÃÂ¿ÃÂµÃ‘â€š._Ã‘ÂÃ‘Æ’ÃÂ±.".split("_"),weekdaysMin:"ÃÂ½ÃÂµ_ÃÂ¿ÃÂ¾_Ã‘Æ’Ã‘â€š_Ã‘ÂÃ‘â‚¬_Ã‘â€¡ÃÂµ_ÃÂ¿ÃÂµ_Ã‘ÂÃ‘Æ’".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD. MM. YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[ÃÂ´ÃÂ°ÃÂ½ÃÂ°Ã‘Â Ã‘Æ’] LT",nextDay:"[Ã‘ÂÃ‘Æ’Ã‘â€šÃ‘â‚¬ÃÂ° Ã‘Æ’] LT",nextWeek:function(){switch(this.day()){case 0:return"[Ã‘Æ’] [ÃÂ½ÃÂµÃÂ´ÃÂµÃ‘â„¢Ã‘Æ’] [Ã‘Æ’] LT";case 3:return"[Ã‘Æ’] [Ã‘ÂÃ‘â‚¬ÃÂµÃÂ´Ã‘Æ’] [Ã‘Æ’] LT";case 6:return"[Ã‘Æ’] [Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃ‘Æ’] [Ã‘Æ’] LT";case 1:case 2:case 4:case 5:return"[Ã‘Æ’] dddd [Ã‘Æ’] LT"}},lastDay:"[Ã‘ËœÃ‘Æ’Ã‘â€¡ÃÂµ Ã‘Æ’] LT",lastWeek:function(){var a=["[ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»ÃÂµ] [ÃÂ½ÃÂµÃÂ´ÃÂµÃ‘â„¢ÃÂµ] [Ã‘Æ’] LT","[ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»ÃÂ¾ÃÂ³] [ÃÂ¿ÃÂ¾ÃÂ½ÃÂµÃÂ´ÃÂµÃ‘â„¢ÃÂºÃÂ°] [Ã‘Æ’] LT","[ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»ÃÂ¾ÃÂ³] [Ã‘Æ’Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂºÃÂ°] [Ã‘Æ’] LT","[ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»ÃÂµ] [Ã‘ÂÃ‘â‚¬ÃÂµÃÂ´ÃÂµ] [Ã‘Æ’] LT","[ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»ÃÂ¾ÃÂ³] [Ã‘â€¡ÃÂµÃ‘â€šÃÂ²Ã‘â‚¬Ã‘â€šÃÂºÃÂ°] [Ã‘Æ’] LT","[ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»ÃÂ¾ÃÂ³] [ÃÂ¿ÃÂµÃ‘â€šÃÂºÃÂ°] [Ã‘Æ’] LT","[ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»ÃÂµ] [Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃÂµ] [Ã‘Æ’] LT"];return a[this.day()]},sameElse:"L"},relativeTime:{future:"ÃÂ·ÃÂ° %s",past:"ÃÂ¿Ã‘â‚¬ÃÂµ %s",s:"ÃÂ½ÃÂµÃÂºÃÂ¾ÃÂ»ÃÂ¸ÃÂºÃÂ¾ Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ¸",m:mh.translate,mm:mh.translate,h:mh.translate,hh:mh.translate,d:"ÃÂ´ÃÂ°ÃÂ½",dd:mh.translate,M:"ÃÂ¼ÃÂµÃ‘ÂÃÂµÃ‘â€ ",MM:mh.translate,y:"ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’",yy:mh.translate},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:7}}),{words:{//Different grammatical cases
m:["jedan minut","jedne minute"],mm:["minut","minute","minuta"],h:["jedan sat","jednog sata"],hh:["sat","sata","sati"],dd:["dan","dana","dana"],MM:["mesec","meseca","meseci"],yy:["godina","godine","godina"]},correctGrammaticalCase:function(a,b){return 1===a?b[0]:a>=2&&4>=a?b[1]:b[2]},translate:function(a,b,c){var d=nh.words[c];return 1===c.length?b?d[0]:d[1]:a+" "+nh.correctGrammaticalCase(a,d)}}),oh=(kg.defineLocale("sr",{months:"januar_februar_mart_april_maj_jun_jul_avgust_septembar_oktobar_novembar_decembar".split("_"),monthsShort:"jan._feb._mar._apr._maj_jun_jul_avg._sep._okt._nov._dec.".split("_"),monthsParseExact:!0,weekdays:"nedelja_ponedeljak_utorak_sreda_Ã„Âetvrtak_petak_subota".split("_"),weekdaysShort:"ned._pon._uto._sre._Ã„Âet._pet._sub.".split("_"),weekdaysMin:"ne_po_ut_sr_Ã„Âe_pe_su".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD. MM. YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[danas u] LT",nextDay:"[sutra u] LT",nextWeek:function(){switch(this.day()){case 0:return"[u] [nedelju] [u] LT";case 3:return"[u] [sredu] [u] LT";case 6:return"[u] [subotu] [u] LT";case 1:case 2:case 4:case 5:return"[u] dddd [u] LT"}},lastDay:"[juÃ„Âe u] LT",lastWeek:function(){var a=["[proÃ…Â¡le] [nedelje] [u] LT","[proÃ…Â¡log] [ponedeljka] [u] LT","[proÃ…Â¡log] [utorka] [u] LT","[proÃ…Â¡le] [srede] [u] LT","[proÃ…Â¡log] [Ã„Âetvrtka] [u] LT","[proÃ…Â¡log] [petka] [u] LT","[proÃ…Â¡le] [subote] [u] LT"];return a[this.day()]},sameElse:"L"},relativeTime:{future:"za %s",past:"pre %s",s:"nekoliko sekundi",m:nh.translate,mm:nh.translate,h:nh.translate,hh:nh.translate,d:"dan",dd:nh.translate,M:"mesec",MM:nh.translate,y:"godinu",yy:nh.translate},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("ss",{months:"Bhimbidvwane_Indlovana_Indlov'lenkhulu_Mabasa_Inkhwekhweti_Inhlaba_Kholwane_Ingci_Inyoni_Imphala_Lweti_Ingongoni".split("_"),monthsShort:"Bhi_Ina_Inu_Mab_Ink_Inh_Kho_Igc_Iny_Imp_Lwe_Igo".split("_"),weekdays:"Lisontfo_Umsombuluko_Lesibili_Lesitsatfu_Lesine_Lesihlanu_Umgcibelo".split("_"),weekdaysShort:"Lis_Umb_Lsb_Les_Lsi_Lsh_Umg".split("_"),weekdaysMin:"Li_Us_Lb_Lt_Ls_Lh_Ug".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY h:mm A",LLLL:"dddd, D MMMM YYYY h:mm A"},calendar:{sameDay:"[Namuhla nga] LT",nextDay:"[Kusasa nga] LT",nextWeek:"dddd [nga] LT",lastDay:"[Itolo nga] LT",lastWeek:"dddd [leliphelile] [nga] LT",sameElse:"L"},relativeTime:{future:"nga %s",past:"wenteka nga %s",s:"emizuzwana lomcane",m:"umzuzu",mm:"%d emizuzu",h:"lihora",hh:"%d emahora",d:"lilanga",dd:"%d emalanga",M:"inyanga",MM:"%d tinyanga",y:"umnyaka",yy:"%d iminyaka"},meridiemParse:/ekuseni|emini|entsambama|ebusuku/,meridiem:function(a,b,c){return 11>a?"ekuseni":15>a?"emini":19>a?"entsambama":"ebusuku"},meridiemHour:function(a,b){return 12===a&&(a=0),"ekuseni"===b?a:"emini"===b?a>=11?a:a+12:"entsambama"===b||"ebusuku"===b?0===a?0:a+12:void 0},ordinalParse:/\d{1,2}/,ordinal:"%d",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("sv",{months:"januari_februari_mars_april_maj_juni_juli_augusti_september_oktober_november_december".split("_"),monthsShort:"jan_feb_mar_apr_maj_jun_jul_aug_sep_okt_nov_dec".split("_"),weekdays:"sÃƒÂ¶ndag_mÃƒÂ¥ndag_tisdag_onsdag_torsdag_fredag_lÃƒÂ¶rdag".split("_"),weekdaysShort:"sÃƒÂ¶n_mÃƒÂ¥n_tis_ons_tor_fre_lÃƒÂ¶r".split("_"),weekdaysMin:"sÃƒÂ¶_mÃƒÂ¥_ti_on_to_fr_lÃƒÂ¶".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"D MMMM YYYY",LLL:"D MMMM YYYY [kl.] HH:mm",LLLL:"dddd D MMMM YYYY [kl.] HH:mm",lll:"D MMM YYYY HH:mm",llll:"ddd D MMM YYYY HH:mm"},calendar:{sameDay:"[Idag] LT",nextDay:"[Imorgon] LT",lastDay:"[IgÃƒÂ¥r] LT",nextWeek:"[PÃƒÂ¥] dddd LT",lastWeek:"[I] dddd[s] LT",sameElse:"L"},relativeTime:{future:"om %s",past:"fÃƒÂ¶r %s sedan",s:"nÃƒÂ¥gra sekunder",m:"en minut",mm:"%d minuter",h:"en timme",hh:"%d timmar",d:"en dag",dd:"%d dagar",M:"en mÃƒÂ¥nad",MM:"%d mÃƒÂ¥nader",y:"ett ÃƒÂ¥r",yy:"%d ÃƒÂ¥r"},ordinalParse:/\d{1,2}(e|a)/,ordinal:function(a){var b=a%10,c=1===~~(a%100/10)?"e":1===b?"a":2===b?"a":"e";return a+c},week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("sw",{months:"Januari_Februari_Machi_Aprili_Mei_Juni_Julai_Agosti_Septemba_Oktoba_Novemba_Desemba".split("_"),monthsShort:"Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ago_Sep_Okt_Nov_Des".split("_"),weekdays:"Jumapili_Jumatatu_Jumanne_Jumatano_Alhamisi_Ijumaa_Jumamosi".split("_"),weekdaysShort:"Jpl_Jtat_Jnne_Jtan_Alh_Ijm_Jmos".split("_"),weekdaysMin:"J2_J3_J4_J5_Al_Ij_J1".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[leo saa] LT",nextDay:"[kesho saa] LT",nextWeek:"[wiki ijayo] dddd [saat] LT",lastDay:"[jana] LT",lastWeek:"[wiki iliyopita] dddd [saat] LT",sameElse:"L"},relativeTime:{future:"%s baadaye",past:"tokea %s",s:"hivi punde",m:"dakika moja",mm:"dakika %d",h:"saa limoja",hh:"masaa %d",d:"siku moja",dd:"masiku %d",M:"mwezi mmoja",MM:"miezi %d",y:"mwaka mmoja",yy:"miaka %d"},week:{dow:1,// Monday is the first day of the week.
doy:7}}),{1:"Ã Â¯Â§",2:"Ã Â¯Â¨",3:"Ã Â¯Â©",4:"Ã Â¯Âª",5:"Ã Â¯Â«",6:"Ã Â¯Â¬",7:"Ã Â¯Â­",8:"Ã Â¯Â®",9:"Ã Â¯Â¯",0:"Ã Â¯Â¦"}),ph={"Ã Â¯Â§":"1","Ã Â¯Â¨":"2","Ã Â¯Â©":"3","Ã Â¯Âª":"4","Ã Â¯Â«":"5","Ã Â¯Â¬":"6","Ã Â¯Â­":"7","Ã Â¯Â®":"8","Ã Â¯Â¯":"9","Ã Â¯Â¦":"0"},qh=(kg.defineLocale("ta",{months:"Ã Â®Å“Ã Â®Â©Ã Â®ÂµÃ Â®Â°Ã Â®Â¿_Ã Â®ÂªÃ Â®Â¿Ã Â®ÂªÃ Â¯ÂÃ Â®Â°Ã Â®ÂµÃ Â®Â°Ã Â®Â¿_Ã Â®Â®Ã Â®Â¾Ã Â®Â°Ã Â¯ÂÃ Â®Å¡Ã Â¯Â_Ã Â®ÂÃ Â®ÂªÃ Â¯ÂÃ Â®Â°Ã Â®Â²Ã Â¯Â_Ã Â®Â®Ã Â¯â€¡_Ã Â®Å“Ã Â¯â€šÃ Â®Â©Ã Â¯Â_Ã Â®Å“Ã Â¯â€šÃ Â®Â²Ã Â¯Ë†_Ã Â®â€ Ã Â®â€¢Ã Â®Â¸Ã Â¯ÂÃ Â®Å¸Ã Â¯Â_Ã Â®Å¡Ã Â¯â€ Ã Â®ÂªÃ Â¯ÂÃ Â®Å¸Ã Â¯â€ Ã Â®Â®Ã Â¯ÂÃ Â®ÂªÃ Â®Â°Ã Â¯Â_Ã Â®â€¦Ã Â®â€¢Ã Â¯ÂÃ Â®Å¸Ã Â¯â€¡Ã Â®Â¾Ã Â®ÂªÃ Â®Â°Ã Â¯Â_Ã Â®Â¨Ã Â®ÂµÃ Â®Â®Ã Â¯ÂÃ Â®ÂªÃ Â®Â°Ã Â¯Â_Ã Â®Å¸Ã Â®Â¿Ã Â®Å¡Ã Â®Â®Ã Â¯ÂÃ Â®ÂªÃ Â®Â°Ã Â¯Â".split("_"),monthsShort:"Ã Â®Å“Ã Â®Â©Ã Â®ÂµÃ Â®Â°Ã Â®Â¿_Ã Â®ÂªÃ Â®Â¿Ã Â®ÂªÃ Â¯ÂÃ Â®Â°Ã Â®ÂµÃ Â®Â°Ã Â®Â¿_Ã Â®Â®Ã Â®Â¾Ã Â®Â°Ã Â¯ÂÃ Â®Å¡Ã Â¯Â_Ã Â®ÂÃ Â®ÂªÃ Â¯ÂÃ Â®Â°Ã Â®Â²Ã Â¯Â_Ã Â®Â®Ã Â¯â€¡_Ã Â®Å“Ã Â¯â€šÃ Â®Â©Ã Â¯Â_Ã Â®Å“Ã Â¯â€šÃ Â®Â²Ã Â¯Ë†_Ã Â®â€ Ã Â®â€¢Ã Â®Â¸Ã Â¯ÂÃ Â®Å¸Ã Â¯Â_Ã Â®Å¡Ã Â¯â€ Ã Â®ÂªÃ Â¯ÂÃ Â®Å¸Ã Â¯â€ Ã Â®Â®Ã Â¯ÂÃ Â®ÂªÃ Â®Â°Ã Â¯Â_Ã Â®â€¦Ã Â®â€¢Ã Â¯ÂÃ Â®Å¸Ã Â¯â€¡Ã Â®Â¾Ã Â®ÂªÃ Â®Â°Ã Â¯Â_Ã Â®Â¨Ã Â®ÂµÃ Â®Â®Ã Â¯ÂÃ Â®ÂªÃ Â®Â°Ã Â¯Â_Ã Â®Å¸Ã Â®Â¿Ã Â®Å¡Ã Â®Â®Ã Â¯ÂÃ Â®ÂªÃ Â®Â°Ã Â¯Â".split("_"),weekdays:"Ã Â®Å¾Ã Â®Â¾Ã Â®Â¯Ã Â®Â¿Ã Â®Â±Ã Â¯ÂÃ Â®Â±Ã Â¯ÂÃ Â®â€¢Ã Â¯ÂÃ Â®â€¢Ã Â®Â¿Ã Â®Â´Ã Â®Â®Ã Â¯Ë†_Ã Â®Â¤Ã Â®Â¿Ã Â®â„¢Ã Â¯ÂÃ Â®â€¢Ã Â®Å¸Ã Â¯ÂÃ Â®â€¢Ã Â®Â¿Ã Â®Â´Ã Â®Â®Ã Â¯Ë†_Ã Â®Å¡Ã Â¯â€ Ã Â®ÂµÃ Â¯ÂÃ Â®ÂµÃ Â®Â¾Ã Â®Â¯Ã Â¯ÂÃ Â®â€¢Ã Â®Â¿Ã Â®Â´Ã Â®Â®Ã Â¯Ë†_Ã Â®ÂªÃ Â¯ÂÃ Â®Â¤Ã Â®Â©Ã Â¯ÂÃ Â®â€¢Ã Â®Â¿Ã Â®Â´Ã Â®Â®Ã Â¯Ë†_Ã Â®ÂµÃ Â®Â¿Ã Â®Â¯Ã Â®Â¾Ã Â®Â´Ã Â®â€¢Ã Â¯ÂÃ Â®â€¢Ã Â®Â¿Ã Â®Â´Ã Â®Â®Ã Â¯Ë†_Ã Â®ÂµÃ Â¯â€ Ã Â®Â³Ã Â¯ÂÃ Â®Â³Ã Â®Â¿Ã Â®â€¢Ã Â¯ÂÃ Â®â€¢Ã Â®Â¿Ã Â®Â´Ã Â®Â®Ã Â¯Ë†_Ã Â®Å¡Ã Â®Â©Ã Â®Â¿Ã Â®â€¢Ã Â¯ÂÃ Â®â€¢Ã Â®Â¿Ã Â®Â´Ã Â®Â®Ã Â¯Ë†".split("_"),weekdaysShort:"Ã Â®Å¾Ã Â®Â¾Ã Â®Â¯Ã Â®Â¿Ã Â®Â±Ã Â¯Â_Ã Â®Â¤Ã Â®Â¿Ã Â®â„¢Ã Â¯ÂÃ Â®â€¢Ã Â®Â³Ã Â¯Â_Ã Â®Å¡Ã Â¯â€ Ã Â®ÂµÃ Â¯ÂÃ Â®ÂµÃ Â®Â¾Ã Â®Â¯Ã Â¯Â_Ã Â®ÂªÃ Â¯ÂÃ Â®Â¤Ã Â®Â©Ã Â¯Â_Ã Â®ÂµÃ Â®Â¿Ã Â®Â¯Ã Â®Â¾Ã Â®Â´Ã Â®Â©Ã Â¯Â_Ã Â®ÂµÃ Â¯â€ Ã Â®Â³Ã Â¯ÂÃ Â®Â³Ã Â®Â¿_Ã Â®Å¡Ã Â®Â©Ã Â®Â¿".split("_"),weekdaysMin:"Ã Â®Å¾Ã Â®Â¾_Ã Â®Â¤Ã Â®Â¿_Ã Â®Å¡Ã Â¯â€ _Ã Â®ÂªÃ Â¯Â_Ã Â®ÂµÃ Â®Â¿_Ã Â®ÂµÃ Â¯â€ _Ã Â®Å¡".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, HH:mm",LLLL:"dddd, D MMMM YYYY, HH:mm"},calendar:{sameDay:"[Ã Â®â€¡Ã Â®Â©Ã Â¯ÂÃ Â®Â±Ã Â¯Â] LT",nextDay:"[Ã Â®Â¨Ã Â®Â¾Ã Â®Â³Ã Â¯Ë†] LT",nextWeek:"dddd, LT",lastDay:"[Ã Â®Â¨Ã Â¯â€¡Ã Â®Â±Ã Â¯ÂÃ Â®Â±Ã Â¯Â] LT",lastWeek:"[Ã Â®â€¢Ã Â®Å¸Ã Â®Â¨Ã Â¯ÂÃ Â®Â¤ Ã Â®ÂµÃ Â®Â¾Ã Â®Â°Ã Â®Â®Ã Â¯Â] dddd, LT",sameElse:"L"},relativeTime:{future:"%s Ã Â®â€¡Ã Â®Â²Ã Â¯Â",past:"%s Ã Â®Â®Ã Â¯ÂÃ Â®Â©Ã Â¯Â",s:"Ã Â®â€™Ã Â®Â°Ã Â¯Â Ã Â®Å¡Ã Â®Â¿Ã Â®Â² Ã Â®ÂµÃ Â®Â¿Ã Â®Â¨Ã Â®Â¾Ã Â®Å¸Ã Â®Â¿Ã Â®â€¢Ã Â®Â³Ã Â¯Â",m:"Ã Â®â€™Ã Â®Â°Ã Â¯Â Ã Â®Â¨Ã Â®Â¿Ã Â®Â®Ã Â®Â¿Ã Â®Å¸Ã Â®Â®Ã Â¯Â",mm:"%d Ã Â®Â¨Ã Â®Â¿Ã Â®Â®Ã Â®Â¿Ã Â®Å¸Ã Â®â„¢Ã Â¯ÂÃ Â®â€¢Ã Â®Â³Ã Â¯Â",h:"Ã Â®â€™Ã Â®Â°Ã Â¯Â Ã Â®Â®Ã Â®Â£Ã Â®Â¿ Ã Â®Â¨Ã Â¯â€¡Ã Â®Â°Ã Â®Â®Ã Â¯Â",hh:"%d Ã Â®Â®Ã Â®Â£Ã Â®Â¿ Ã Â®Â¨Ã Â¯â€¡Ã Â®Â°Ã Â®Â®Ã Â¯Â",d:"Ã Â®â€™Ã Â®Â°Ã Â¯Â Ã Â®Â¨Ã Â®Â¾Ã Â®Â³Ã Â¯Â",dd:"%d Ã Â®Â¨Ã Â®Â¾Ã Â®Å¸Ã Â¯ÂÃ Â®â€¢Ã Â®Â³Ã Â¯Â",M:"Ã Â®â€™Ã Â®Â°Ã Â¯Â Ã Â®Â®Ã Â®Â¾Ã Â®Â¤Ã Â®Â®Ã Â¯Â",MM:"%d Ã Â®Â®Ã Â®Â¾Ã Â®Â¤Ã Â®â„¢Ã Â¯ÂÃ Â®â€¢Ã Â®Â³Ã Â¯Â",y:"Ã Â®â€™Ã Â®Â°Ã Â¯Â Ã Â®ÂµÃ Â®Â°Ã Â¯ÂÃ Â®Å¸Ã Â®Â®Ã Â¯Â",yy:"%d Ã Â®â€ Ã Â®Â£Ã Â¯ÂÃ Â®Å¸Ã Â¯ÂÃ Â®â€¢Ã Â®Â³Ã Â¯Â"},ordinalParse:/\d{1,2}Ã Â®ÂµÃ Â®Â¤Ã Â¯Â/,ordinal:function(a){return a+"Ã Â®ÂµÃ Â®Â¤Ã Â¯Â"},preparse:function(a){return a.replace(/[Ã Â¯Â§Ã Â¯Â¨Ã Â¯Â©Ã Â¯ÂªÃ Â¯Â«Ã Â¯Â¬Ã Â¯Â­Ã Â¯Â®Ã Â¯Â¯Ã Â¯Â¦]/g,function(a){return ph[a]})},postformat:function(a){return a.replace(/\d/g,function(a){return oh[a]})},
// refer http://ta.wikipedia.org/s/1er1
meridiemParse:/Ã Â®Â¯Ã Â®Â¾Ã Â®Â®Ã Â®Â®Ã Â¯Â|Ã Â®ÂµÃ Â¯Ë†Ã Â®â€¢Ã Â®Â±Ã Â¯Ë†|Ã Â®â€¢Ã Â®Â¾Ã Â®Â²Ã Â¯Ë†|Ã Â®Â¨Ã Â®Â£Ã Â¯ÂÃ Â®ÂªÃ Â®â€¢Ã Â®Â²Ã Â¯Â|Ã Â®Å½Ã Â®Â±Ã Â¯ÂÃ Â®ÂªÃ Â®Â¾Ã Â®Å¸Ã Â¯Â|Ã Â®Â®Ã Â®Â¾Ã Â®Â²Ã Â¯Ë†/,meridiem:function(a,b,c){return 2>a?" Ã Â®Â¯Ã Â®Â¾Ã Â®Â®Ã Â®Â®Ã Â¯Â":6>a?" Ã Â®ÂµÃ Â¯Ë†Ã Â®â€¢Ã Â®Â±Ã Â¯Ë†":10>a?" Ã Â®â€¢Ã Â®Â¾Ã Â®Â²Ã Â¯Ë†":14>a?" Ã Â®Â¨Ã Â®Â£Ã Â¯ÂÃ Â®ÂªÃ Â®â€¢Ã Â®Â²Ã Â¯Â":18>a?" Ã Â®Å½Ã Â®Â±Ã Â¯ÂÃ Â®ÂªÃ Â®Â¾Ã Â®Å¸Ã Â¯Â":22>a?" Ã Â®Â®Ã Â®Â¾Ã Â®Â²Ã Â¯Ë†":" Ã Â®Â¯Ã Â®Â¾Ã Â®Â®Ã Â®Â®Ã Â¯Â"},meridiemHour:function(a,b){return 12===a&&(a=0),"Ã Â®Â¯Ã Â®Â¾Ã Â®Â®Ã Â®Â®Ã Â¯Â"===b?2>a?a:a+12:"Ã Â®ÂµÃ Â¯Ë†Ã Â®â€¢Ã Â®Â±Ã Â¯Ë†"===b||"Ã Â®â€¢Ã Â®Â¾Ã Â®Â²Ã Â¯Ë†"===b?a:"Ã Â®Â¨Ã Â®Â£Ã Â¯ÂÃ Â®ÂªÃ Â®â€¢Ã Â®Â²Ã Â¯Â"===b&&a>=10?a:a+12},week:{dow:0,// Sunday is the first day of the week.
doy:6}}),kg.defineLocale("te",{months:"Ã Â°Å“Ã Â°Â¨Ã Â°ÂµÃ Â°Â°Ã Â°Â¿_Ã Â°Â«Ã Â°Â¿Ã Â°Â¬Ã Â±ÂÃ Â°Â°Ã Â°ÂµÃ Â°Â°Ã Â°Â¿_Ã Â°Â®Ã Â°Â¾Ã Â°Â°Ã Â±ÂÃ Â°Å¡Ã Â°Â¿_Ã Â°ÂÃ Â°ÂªÃ Â±ÂÃ Â°Â°Ã Â°Â¿Ã Â°Â²Ã Â±Â_Ã Â°Â®Ã Â±â€¡_Ã Â°Å“Ã Â±â€šÃ Â°Â¨Ã Â±Â_Ã Â°Å“Ã Â±â€šÃ Â°Â²Ã Â±â€ Ã Â±â€“_Ã Â°â€ Ã Â°â€”Ã Â°Â¸Ã Â±ÂÃ Â°Å¸Ã Â±Â_Ã Â°Â¸Ã Â±â€ Ã Â°ÂªÃ Â±ÂÃ Â°Å¸Ã Â±â€ Ã Â°â€šÃ Â°Â¬Ã Â°Â°Ã Â±Â_Ã Â°â€¦Ã Â°â€¢Ã Â±ÂÃ Â°Å¸Ã Â±â€¹Ã Â°Â¬Ã Â°Â°Ã Â±Â_Ã Â°Â¨Ã Â°ÂµÃ Â°â€šÃ Â°Â¬Ã Â°Â°Ã Â±Â_Ã Â°Â¡Ã Â°Â¿Ã Â°Â¸Ã Â±â€ Ã Â°â€šÃ Â°Â¬Ã Â°Â°Ã Â±Â".split("_"),monthsShort:"Ã Â°Å“Ã Â°Â¨._Ã Â°Â«Ã Â°Â¿Ã Â°Â¬Ã Â±ÂÃ Â°Â°._Ã Â°Â®Ã Â°Â¾Ã Â°Â°Ã Â±ÂÃ Â°Å¡Ã Â°Â¿_Ã Â°ÂÃ Â°ÂªÃ Â±ÂÃ Â°Â°Ã Â°Â¿._Ã Â°Â®Ã Â±â€¡_Ã Â°Å“Ã Â±â€šÃ Â°Â¨Ã Â±Â_Ã Â°Å“Ã Â±â€šÃ Â°Â²Ã Â±â€ Ã Â±â€“_Ã Â°â€ Ã Â°â€”._Ã Â°Â¸Ã Â±â€ Ã Â°ÂªÃ Â±Â._Ã Â°â€¦Ã Â°â€¢Ã Â±ÂÃ Â°Å¸Ã Â±â€¹._Ã Â°Â¨Ã Â°Âµ._Ã Â°Â¡Ã Â°Â¿Ã Â°Â¸Ã Â±â€ .".split("_"),monthsParseExact:!0,weekdays:"Ã Â°â€ Ã Â°Â¦Ã Â°Â¿Ã Â°ÂµÃ Â°Â¾Ã Â°Â°Ã Â°â€š_Ã Â°Â¸Ã Â±â€¹Ã Â°Â®Ã Â°ÂµÃ Â°Â¾Ã Â°Â°Ã Â°â€š_Ã Â°Â®Ã Â°â€šÃ Â°â€”Ã Â°Â³Ã Â°ÂµÃ Â°Â¾Ã Â°Â°Ã Â°â€š_Ã Â°Â¬Ã Â±ÂÃ Â°Â§Ã Â°ÂµÃ Â°Â¾Ã Â°Â°Ã Â°â€š_Ã Â°â€”Ã Â±ÂÃ Â°Â°Ã Â±ÂÃ Â°ÂµÃ Â°Â¾Ã Â°Â°Ã Â°â€š_Ã Â°Â¶Ã Â±ÂÃ Â°â€¢Ã Â±ÂÃ Â°Â°Ã Â°ÂµÃ Â°Â¾Ã Â°Â°Ã Â°â€š_Ã Â°Â¶Ã Â°Â¨Ã Â°Â¿Ã Â°ÂµÃ Â°Â¾Ã Â°Â°Ã Â°â€š".split("_"),weekdaysShort:"Ã Â°â€ Ã Â°Â¦Ã Â°Â¿_Ã Â°Â¸Ã Â±â€¹Ã Â°Â®_Ã Â°Â®Ã Â°â€šÃ Â°â€”Ã Â°Â³_Ã Â°Â¬Ã Â±ÂÃ Â°Â§_Ã Â°â€”Ã Â±ÂÃ Â°Â°Ã Â±Â_Ã Â°Â¶Ã Â±ÂÃ Â°â€¢Ã Â±ÂÃ Â°Â°_Ã Â°Â¶Ã Â°Â¨Ã Â°Â¿".split("_"),weekdaysMin:"Ã Â°â€ _Ã Â°Â¸Ã Â±â€¹_Ã Â°Â®Ã Â°â€š_Ã Â°Â¬Ã Â±Â_Ã Â°â€”Ã Â±Â_Ã Â°Â¶Ã Â±Â_Ã Â°Â¶".split("_"),longDateFormat:{LT:"A h:mm",LTS:"A h:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm",LLLL:"dddd, D MMMM YYYY, A h:mm"},calendar:{sameDay:"[Ã Â°Â¨Ã Â±â€¡Ã Â°Â¡Ã Â±Â] LT",nextDay:"[Ã Â°Â°Ã Â±â€¡Ã Â°ÂªÃ Â±Â] LT",nextWeek:"dddd, LT",lastDay:"[Ã Â°Â¨Ã Â°Â¿Ã Â°Â¨Ã Â±ÂÃ Â°Â¨] LT",lastWeek:"[Ã Â°â€”Ã Â°Â¤] dddd, LT",sameElse:"L"},relativeTime:{future:"%s Ã Â°Â²Ã Â±â€¹",past:"%s Ã Â°â€¢Ã Â±ÂÃ Â°Â°Ã Â°Â¿Ã Â°Â¤Ã Â°â€š",s:"Ã Â°â€¢Ã Â±Å Ã Â°Â¨Ã Â±ÂÃ Â°Â¨Ã Â°Â¿ Ã Â°â€¢Ã Â±ÂÃ Â°Â·Ã Â°Â£Ã Â°Â¾Ã Â°Â²Ã Â±Â",m:"Ã Â°â€™Ã Â°â€¢ Ã Â°Â¨Ã Â°Â¿Ã Â°Â®Ã Â°Â¿Ã Â°Â·Ã Â°â€š",mm:"%d Ã Â°Â¨Ã Â°Â¿Ã Â°Â®Ã Â°Â¿Ã Â°Â·Ã Â°Â¾Ã Â°Â²Ã Â±Â",h:"Ã Â°â€™Ã Â°â€¢ Ã Â°â€”Ã Â°â€šÃ Â°Å¸",hh:"%d Ã Â°â€”Ã Â°â€šÃ Â°Å¸Ã Â°Â²Ã Â±Â",d:"Ã Â°â€™Ã Â°â€¢ Ã Â°Â°Ã Â±â€¹Ã Â°Å“Ã Â±Â",dd:"%d Ã Â°Â°Ã Â±â€¹Ã Â°Å“Ã Â±ÂÃ Â°Â²Ã Â±Â",M:"Ã Â°â€™Ã Â°â€¢ Ã Â°Â¨Ã Â±â€ Ã Â°Â²",MM:"%d Ã Â°Â¨Ã Â±â€ Ã Â°Â²Ã Â°Â²Ã Â±Â",y:"Ã Â°â€™Ã Â°â€¢ Ã Â°Â¸Ã Â°â€šÃ Â°ÂµÃ Â°Â¤Ã Â±ÂÃ Â°Â¸Ã Â°Â°Ã Â°â€š",yy:"%d Ã Â°Â¸Ã Â°â€šÃ Â°ÂµÃ Â°Â¤Ã Â±ÂÃ Â°Â¸Ã Â°Â°Ã Â°Â¾Ã Â°Â²Ã Â±Â"},ordinalParse:/\d{1,2}Ã Â°Âµ/,ordinal:"%dÃ Â°Âµ",meridiemParse:/Ã Â°Â°Ã Â°Â¾Ã Â°Â¤Ã Â±ÂÃ Â°Â°Ã Â°Â¿|Ã Â°â€°Ã Â°Â¦Ã Â°Â¯Ã Â°â€š|Ã Â°Â®Ã Â°Â§Ã Â±ÂÃ Â°Â¯Ã Â°Â¾Ã Â°Â¹Ã Â±ÂÃ Â°Â¨Ã Â°â€š|Ã Â°Â¸Ã Â°Â¾Ã Â°Â¯Ã Â°â€šÃ Â°Â¤Ã Â±ÂÃ Â°Â°Ã Â°â€š/,meridiemHour:function(a,b){return 12===a&&(a=0),"Ã Â°Â°Ã Â°Â¾Ã Â°Â¤Ã Â±ÂÃ Â°Â°Ã Â°Â¿"===b?4>a?a:a+12:"Ã Â°â€°Ã Â°Â¦Ã Â°Â¯Ã Â°â€š"===b?a:"Ã Â°Â®Ã Â°Â§Ã Â±ÂÃ Â°Â¯Ã Â°Â¾Ã Â°Â¹Ã Â±ÂÃ Â°Â¨Ã Â°â€š"===b?a>=10?a:a+12:"Ã Â°Â¸Ã Â°Â¾Ã Â°Â¯Ã Â°â€šÃ Â°Â¤Ã Â±ÂÃ Â°Â°Ã Â°â€š"===b?a+12:void 0},meridiem:function(a,b,c){return 4>a?"Ã Â°Â°Ã Â°Â¾Ã Â°Â¤Ã Â±ÂÃ Â°Â°Ã Â°Â¿":10>a?"Ã Â°â€°Ã Â°Â¦Ã Â°Â¯Ã Â°â€š":17>a?"Ã Â°Â®Ã Â°Â§Ã Â±ÂÃ Â°Â¯Ã Â°Â¾Ã Â°Â¹Ã Â±ÂÃ Â°Â¨Ã Â°â€š":20>a?"Ã Â°Â¸Ã Â°Â¾Ã Â°Â¯Ã Â°â€šÃ Â°Â¤Ã Â±ÂÃ Â°Â°Ã Â°â€š":"Ã Â°Â°Ã Â°Â¾Ã Â°Â¤Ã Â±ÂÃ Â°Â°Ã Â°Â¿"},week:{dow:0,// Sunday is the first day of the week.
doy:6}}),kg.defineLocale("th",{months:"Ã Â¸Â¡Ã Â¸ÂÃ Â¸Â£Ã Â¸Â²Ã Â¸â€žÃ Â¸Â¡_Ã Â¸ÂÃ Â¸Â¸Ã Â¸Â¡Ã Â¸ Ã Â¸Â²Ã Â¸Å¾Ã Â¸Â±Ã Â¸â„¢Ã Â¸ËœÃ Â¹Å’_Ã Â¸Â¡Ã Â¸ÂµÃ Â¸â„¢Ã Â¸Â²Ã Â¸â€žÃ Â¸Â¡_Ã Â¹â‚¬Ã Â¸Â¡Ã Â¸Â©Ã Â¸Â²Ã Â¸Â¢Ã Â¸â„¢_Ã Â¸Å¾Ã Â¸Â¤Ã Â¸Â©Ã Â¸ Ã Â¸Â²Ã Â¸â€žÃ Â¸Â¡_Ã Â¸Â¡Ã Â¸Â´Ã Â¸â€“Ã Â¸Â¸Ã Â¸â„¢Ã Â¸Â²Ã Â¸Â¢Ã Â¸â„¢_Ã Â¸ÂÃ Â¸Â£Ã Â¸ÂÃ Â¸Å½Ã Â¸Â²Ã Â¸â€žÃ Â¸Â¡_Ã Â¸ÂªÃ Â¸Â´Ã Â¸â€¡Ã Â¸Â«Ã Â¸Â²Ã Â¸â€žÃ Â¸Â¡_Ã Â¸ÂÃ Â¸Â±Ã Â¸â„¢Ã Â¸Â¢Ã Â¸Â²Ã Â¸Â¢Ã Â¸â„¢_Ã Â¸â€¢Ã Â¸Â¸Ã Â¸Â¥Ã Â¸Â²Ã Â¸â€žÃ Â¸Â¡_Ã Â¸Å¾Ã Â¸Â¤Ã Â¸Â¨Ã Â¸Ë†Ã Â¸Â´Ã Â¸ÂÃ Â¸Â²Ã Â¸Â¢Ã Â¸â„¢_Ã Â¸ËœÃ Â¸Â±Ã Â¸â„¢Ã Â¸Â§Ã Â¸Â²Ã Â¸â€žÃ Â¸Â¡".split("_"),monthsShort:"Ã Â¸Â¡.Ã Â¸â€ž._Ã Â¸Â.Ã Â¸Å¾._Ã Â¸Â¡Ã Â¸Âµ.Ã Â¸â€ž._Ã Â¹â‚¬Ã Â¸Â¡.Ã Â¸Â¢._Ã Â¸Å¾.Ã Â¸â€ž._Ã Â¸Â¡Ã Â¸Â´.Ã Â¸Â¢._Ã Â¸Â.Ã Â¸â€ž._Ã Â¸Âª.Ã Â¸â€ž._Ã Â¸Â.Ã Â¸Â¢._Ã Â¸â€¢.Ã Â¸â€ž._Ã Â¸Å¾.Ã Â¸Â¢._Ã Â¸Ëœ.Ã Â¸â€ž.".split("_"),monthsParseExact:!0,weekdays:"Ã Â¸Â­Ã Â¸Â²Ã Â¸â€”Ã Â¸Â´Ã Â¸â€¢Ã Â¸Â¢Ã Â¹Å’_Ã Â¸Ë†Ã Â¸Â±Ã Â¸â„¢Ã Â¸â€”Ã Â¸Â£Ã Â¹Å’_Ã Â¸Â­Ã Â¸Â±Ã Â¸â€¡Ã Â¸â€žÃ Â¸Â²Ã Â¸Â£_Ã Â¸Å¾Ã Â¸Â¸Ã Â¸Ëœ_Ã Â¸Å¾Ã Â¸Â¤Ã Â¸Â«Ã Â¸Â±Ã Â¸ÂªÃ Â¸Å¡Ã Â¸â€Ã Â¸Âµ_Ã Â¸Â¨Ã Â¸Â¸Ã Â¸ÂÃ Â¸Â£Ã Â¹Å’_Ã Â¹â‚¬Ã Â¸ÂªÃ Â¸Â²Ã Â¸Â£Ã Â¹Å’".split("_"),weekdaysShort:"Ã Â¸Â­Ã Â¸Â²Ã Â¸â€”Ã Â¸Â´Ã Â¸â€¢Ã Â¸Â¢Ã Â¹Å’_Ã Â¸Ë†Ã Â¸Â±Ã Â¸â„¢Ã Â¸â€”Ã Â¸Â£Ã Â¹Å’_Ã Â¸Â­Ã Â¸Â±Ã Â¸â€¡Ã Â¸â€žÃ Â¸Â²Ã Â¸Â£_Ã Â¸Å¾Ã Â¸Â¸Ã Â¸Ëœ_Ã Â¸Å¾Ã Â¸Â¤Ã Â¸Â«Ã Â¸Â±Ã Â¸Âª_Ã Â¸Â¨Ã Â¸Â¸Ã Â¸ÂÃ Â¸Â£Ã Â¹Å’_Ã Â¹â‚¬Ã Â¸ÂªÃ Â¸Â²Ã Â¸Â£Ã Â¹Å’".split("_"),// yes, three characters difference
weekdaysMin:"Ã Â¸Â­Ã Â¸Â²._Ã Â¸Ë†._Ã Â¸Â­._Ã Â¸Å¾._Ã Â¸Å¾Ã Â¸Â¤._Ã Â¸Â¨._Ã Â¸Âª.".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H Ã Â¸â„¢Ã Â¸Â²Ã Â¸Â¬Ã Â¸Â´Ã Â¸ÂÃ Â¸Â² m Ã Â¸â„¢Ã Â¸Â²Ã Â¸â€”Ã Â¸Âµ",LTS:"H Ã Â¸â„¢Ã Â¸Â²Ã Â¸Â¬Ã Â¸Â´Ã Â¸ÂÃ Â¸Â² m Ã Â¸â„¢Ã Â¸Â²Ã Â¸â€”Ã Â¸Âµ s Ã Â¸Â§Ã Â¸Â´Ã Â¸â„¢Ã Â¸Â²Ã Â¸â€”Ã Â¸Âµ",L:"YYYY/MM/DD",LL:"D MMMM YYYY",LLL:"D MMMM YYYY Ã Â¹â‚¬Ã Â¸Â§Ã Â¸Â¥Ã Â¸Â² H Ã Â¸â„¢Ã Â¸Â²Ã Â¸Â¬Ã Â¸Â´Ã Â¸ÂÃ Â¸Â² m Ã Â¸â„¢Ã Â¸Â²Ã Â¸â€”Ã Â¸Âµ",LLLL:"Ã Â¸Â§Ã Â¸Â±Ã Â¸â„¢ddddÃ Â¸â€”Ã Â¸ÂµÃ Â¹Ë† D MMMM YYYY Ã Â¹â‚¬Ã Â¸Â§Ã Â¸Â¥Ã Â¸Â² H Ã Â¸â„¢Ã Â¸Â²Ã Â¸Â¬Ã Â¸Â´Ã Â¸ÂÃ Â¸Â² m Ã Â¸â„¢Ã Â¸Â²Ã Â¸â€”Ã Â¸Âµ"},meridiemParse:/Ã Â¸ÂÃ Â¹Ë†Ã Â¸Â­Ã Â¸â„¢Ã Â¹â‚¬Ã Â¸â€”Ã Â¸ÂµÃ Â¹Ë†Ã Â¸Â¢Ã Â¸â€¡|Ã Â¸Â«Ã Â¸Â¥Ã Â¸Â±Ã Â¸â€¡Ã Â¹â‚¬Ã Â¸â€”Ã Â¸ÂµÃ Â¹Ë†Ã Â¸Â¢Ã Â¸â€¡/,isPM:function(a){return"Ã Â¸Â«Ã Â¸Â¥Ã Â¸Â±Ã Â¸â€¡Ã Â¹â‚¬Ã Â¸â€”Ã Â¸ÂµÃ Â¹Ë†Ã Â¸Â¢Ã Â¸â€¡"===a},meridiem:function(a,b,c){return 12>a?"Ã Â¸ÂÃ Â¹Ë†Ã Â¸Â­Ã Â¸â„¢Ã Â¹â‚¬Ã Â¸â€”Ã Â¸ÂµÃ Â¹Ë†Ã Â¸Â¢Ã Â¸â€¡":"Ã Â¸Â«Ã Â¸Â¥Ã Â¸Â±Ã Â¸â€¡Ã Â¹â‚¬Ã Â¸â€”Ã Â¸ÂµÃ Â¹Ë†Ã Â¸Â¢Ã Â¸â€¡"},calendar:{sameDay:"[Ã Â¸Â§Ã Â¸Â±Ã Â¸â„¢Ã Â¸â„¢Ã Â¸ÂµÃ Â¹â€° Ã Â¹â‚¬Ã Â¸Â§Ã Â¸Â¥Ã Â¸Â²] LT",nextDay:"[Ã Â¸Å¾Ã Â¸Â£Ã Â¸Â¸Ã Â¹Ë†Ã Â¸â€¡Ã Â¸â„¢Ã Â¸ÂµÃ Â¹â€° Ã Â¹â‚¬Ã Â¸Â§Ã Â¸Â¥Ã Â¸Â²] LT",nextWeek:"dddd[Ã Â¸Â«Ã Â¸â„¢Ã Â¹â€°Ã Â¸Â² Ã Â¹â‚¬Ã Â¸Â§Ã Â¸Â¥Ã Â¸Â²] LT",lastDay:"[Ã Â¹â‚¬Ã Â¸Â¡Ã Â¸Â·Ã Â¹Ë†Ã Â¸Â­Ã Â¸Â§Ã Â¸Â²Ã Â¸â„¢Ã Â¸â„¢Ã Â¸ÂµÃ Â¹â€° Ã Â¹â‚¬Ã Â¸Â§Ã Â¸Â¥Ã Â¸Â²] LT",lastWeek:"[Ã Â¸Â§Ã Â¸Â±Ã Â¸â„¢]dddd[Ã Â¸â€”Ã Â¸ÂµÃ Â¹Ë†Ã Â¹ÂÃ Â¸Â¥Ã Â¹â€°Ã Â¸Â§ Ã Â¹â‚¬Ã Â¸Â§Ã Â¸Â¥Ã Â¸Â²] LT",sameElse:"L"},relativeTime:{future:"Ã Â¸Â­Ã Â¸ÂµÃ Â¸Â %s",past:"%sÃ Â¸â€”Ã Â¸ÂµÃ Â¹Ë†Ã Â¹ÂÃ Â¸Â¥Ã Â¹â€°Ã Â¸Â§",s:"Ã Â¹â€žÃ Â¸Â¡Ã Â¹Ë†Ã Â¸ÂÃ Â¸ÂµÃ Â¹Ë†Ã Â¸Â§Ã Â¸Â´Ã Â¸â„¢Ã Â¸Â²Ã Â¸â€”Ã Â¸Âµ",m:"1 Ã Â¸â„¢Ã Â¸Â²Ã Â¸â€”Ã Â¸Âµ",mm:"%d Ã Â¸â„¢Ã Â¸Â²Ã Â¸â€”Ã Â¸Âµ",h:"1 Ã Â¸Å Ã Â¸Â±Ã Â¹Ë†Ã Â¸Â§Ã Â¹â€šÃ Â¸Â¡Ã Â¸â€¡",hh:"%d Ã Â¸Å Ã Â¸Â±Ã Â¹Ë†Ã Â¸Â§Ã Â¹â€šÃ Â¸Â¡Ã Â¸â€¡",d:"1 Ã Â¸Â§Ã Â¸Â±Ã Â¸â„¢",dd:"%d Ã Â¸Â§Ã Â¸Â±Ã Â¸â„¢",M:"1 Ã Â¹â‚¬Ã Â¸â€Ã Â¸Â·Ã Â¸Â­Ã Â¸â„¢",MM:"%d Ã Â¹â‚¬Ã Â¸â€Ã Â¸Â·Ã Â¸Â­Ã Â¸â„¢",y:"1 Ã Â¸â€ºÃ Â¸Âµ",yy:"%d Ã Â¸â€ºÃ Â¸Âµ"}}),kg.defineLocale("tl-ph",{months:"Enero_Pebrero_Marso_Abril_Mayo_Hunyo_Hulyo_Agosto_Setyembre_Oktubre_Nobyembre_Disyembre".split("_"),monthsShort:"Ene_Peb_Mar_Abr_May_Hun_Hul_Ago_Set_Okt_Nob_Dis".split("_"),weekdays:"Linggo_Lunes_Martes_Miyerkules_Huwebes_Biyernes_Sabado".split("_"),weekdaysShort:"Lin_Lun_Mar_Miy_Huw_Biy_Sab".split("_"),weekdaysMin:"Li_Lu_Ma_Mi_Hu_Bi_Sab".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"MM/D/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY HH:mm",LLLL:"dddd, MMMM DD, YYYY HH:mm"},calendar:{sameDay:"[Ngayon sa] LT",nextDay:"[Bukas sa] LT",nextWeek:"dddd [sa] LT",lastDay:"[Kahapon sa] LT",lastWeek:"dddd [huling linggo] LT",sameElse:"L"},relativeTime:{future:"sa loob ng %s",past:"%s ang nakalipas",s:"ilang segundo",m:"isang minuto",mm:"%d minuto",h:"isang oras",hh:"%d oras",d:"isang araw",dd:"%d araw",M:"isang buwan",MM:"%d buwan",y:"isang taon",yy:"%d taon"},ordinalParse:/\d{1,2}/,ordinal:function(a){return a},week:{dow:1,// Monday is the first day of the week.
doy:4}}),"pagh_waÃ¢â‚¬â„¢_chaÃ¢â‚¬â„¢_wej_loS_vagh_jav_Soch_chorgh_Hut".split("_")),rh=(kg.defineLocale("tlh",{months:"teraÃ¢â‚¬â„¢ jar waÃ¢â‚¬â„¢_teraÃ¢â‚¬â„¢ jar chaÃ¢â‚¬â„¢_teraÃ¢â‚¬â„¢ jar wej_teraÃ¢â‚¬â„¢ jar loS_teraÃ¢â‚¬â„¢ jar vagh_teraÃ¢â‚¬â„¢ jar jav_teraÃ¢â‚¬â„¢ jar Soch_teraÃ¢â‚¬â„¢ jar chorgh_teraÃ¢â‚¬â„¢ jar Hut_teraÃ¢â‚¬â„¢ jar waÃ¢â‚¬â„¢maH_teraÃ¢â‚¬â„¢ jar waÃ¢â‚¬â„¢maH waÃ¢â‚¬â„¢_teraÃ¢â‚¬â„¢ jar waÃ¢â‚¬â„¢maH chaÃ¢â‚¬â„¢".split("_"),monthsShort:"jar waÃ¢â‚¬â„¢_jar chaÃ¢â‚¬â„¢_jar wej_jar loS_jar vagh_jar jav_jar Soch_jar chorgh_jar Hut_jar waÃ¢â‚¬â„¢maH_jar waÃ¢â‚¬â„¢maH waÃ¢â‚¬â„¢_jar waÃ¢â‚¬â„¢maH chaÃ¢â‚¬â„¢".split("_"),monthsParseExact:!0,weekdays:"lojmItjaj_DaSjaj_povjaj_ghItlhjaj_loghjaj_buqjaj_ghInjaj".split("_"),weekdaysShort:"lojmItjaj_DaSjaj_povjaj_ghItlhjaj_loghjaj_buqjaj_ghInjaj".split("_"),weekdaysMin:"lojmItjaj_DaSjaj_povjaj_ghItlhjaj_loghjaj_buqjaj_ghInjaj".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[DaHjaj] LT",nextDay:"[waÃ¢â‚¬â„¢leS] LT",nextWeek:"LLL",lastDay:"[waÃ¢â‚¬â„¢HuÃ¢â‚¬â„¢] LT",lastWeek:"LLL",sameElse:"L"},relativeTime:{future:ae,past:be,s:"puS lup",m:"waÃ¢â‚¬â„¢ tup",mm:ce,h:"waÃ¢â‚¬â„¢ rep",hh:ce,d:"waÃ¢â‚¬â„¢ jaj",dd:ce,M:"waÃ¢â‚¬â„¢ jar",MM:ce,y:"waÃ¢â‚¬â„¢ DIS",yy:ce},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),{1:"'inci",5:"'inci",8:"'inci",70:"'inci",80:"'inci",2:"'nci",7:"'nci",20:"'nci",50:"'nci",3:"'ÃƒÂ¼ncÃƒÂ¼",4:"'ÃƒÂ¼ncÃƒÂ¼",100:"'ÃƒÂ¼ncÃƒÂ¼",6:"'ncÃ„Â±",9:"'uncu",10:"'uncu",30:"'uncu",60:"'Ã„Â±ncÃ„Â±",90:"'Ã„Â±ncÃ„Â±"}),sh=(kg.defineLocale("tr",{months:"Ocak_Ã…Å¾ubat_Mart_Nisan_MayÃ„Â±s_Haziran_Temmuz_AÃ„Å¸ustos_EylÃƒÂ¼l_Ekim_KasÃ„Â±m_AralÃ„Â±k".split("_"),monthsShort:"Oca_Ã…Å¾ub_Mar_Nis_May_Haz_Tem_AÃ„Å¸u_Eyl_Eki_Kas_Ara".split("_"),weekdays:"Pazar_Pazartesi_SalÃ„Â±_Ãƒâ€¡arÃ…Å¸amba_PerÃ…Å¸embe_Cuma_Cumartesi".split("_"),weekdaysShort:"Paz_Pts_Sal_Ãƒâ€¡ar_Per_Cum_Cts".split("_"),weekdaysMin:"Pz_Pt_Sa_Ãƒâ€¡a_Pe_Cu_Ct".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[bugÃƒÂ¼n saat] LT",nextDay:"[yarÃ„Â±n saat] LT",nextWeek:"[haftaya] dddd [saat] LT",lastDay:"[dÃƒÂ¼n] LT",lastWeek:"[geÃƒÂ§en hafta] dddd [saat] LT",sameElse:"L"},relativeTime:{future:"%s sonra",past:"%s ÃƒÂ¶nce",s:"birkaÃƒÂ§ saniye",m:"bir dakika",mm:"%d dakika",h:"bir saat",hh:"%d saat",d:"bir gÃƒÂ¼n",dd:"%d gÃƒÂ¼n",M:"bir ay",MM:"%d ay",y:"bir yÃ„Â±l",yy:"%d yÃ„Â±l"},ordinalParse:/\d{1,2}'(inci|nci|ÃƒÂ¼ncÃƒÂ¼|ncÃ„Â±|uncu|Ã„Â±ncÃ„Â±)/,ordinal:function(a){if(0===a)// special case for zero
return a+"'Ã„Â±ncÃ„Â±";var b=a%10,c=a%100-b,d=a>=100?100:null;return a+(rh[b]||rh[c]||rh[d])},week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("tzl",{months:"Januar_Fevraglh_MarÃƒÂ§_AvrÃƒÂ¯u_Mai_GÃƒÂ¼n_Julia_Guscht_Setemvar_ListopÃƒÂ¤ts_Noemvar_Zecemvar".split("_"),monthsShort:"Jan_Fev_Mar_Avr_Mai_GÃƒÂ¼n_Jul_Gus_Set_Lis_Noe_Zec".split("_"),weekdays:"SÃƒÂºladi_LÃƒÂºneÃƒÂ§i_Maitzi_MÃƒÂ¡rcuri_XhÃƒÂºadi_ViÃƒÂ©nerÃƒÂ§i_SÃƒÂ¡turi".split("_"),weekdaysShort:"SÃƒÂºl_LÃƒÂºn_Mai_MÃƒÂ¡r_XhÃƒÂº_ViÃƒÂ©_SÃƒÂ¡t".split("_"),weekdaysMin:"SÃƒÂº_LÃƒÂº_Ma_MÃƒÂ¡_Xh_Vi_SÃƒÂ¡".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD.MM.YYYY",LL:"D. MMMM [dallas] YYYY",LLL:"D. MMMM [dallas] YYYY HH.mm",LLLL:"dddd, [li] D. MMMM [dallas] YYYY HH.mm"},meridiemParse:/d\'o|d\'a/i,isPM:function(a){return"d'o"===a.toLowerCase()},meridiem:function(a,b,c){return a>11?c?"d'o":"D'O":c?"d'a":"D'A"},calendar:{sameDay:"[oxhi Ãƒ ] LT",nextDay:"[demÃƒ  Ãƒ ] LT",nextWeek:"dddd [Ãƒ ] LT",lastDay:"[ieiri Ãƒ ] LT",lastWeek:"[sÃƒÂ¼r el] dddd [lasteu Ãƒ ] LT",sameElse:"L"},relativeTime:{future:"osprei %s",past:"ja%s",s:ee,m:ee,mm:ee,h:ee,hh:ee,d:ee,dd:ee,M:ee,MM:ee,y:ee,yy:ee},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("tzm-latn",{months:"innayr_brÃ‹Â¤ayrÃ‹Â¤_marÃ‹Â¤sÃ‹Â¤_ibrir_mayyw_ywnyw_ywlywz_Ã‰Â£wÃ…Â¡t_Ã…Â¡wtanbir_ktÃ‹Â¤wbrÃ‹Â¤_nwwanbir_dwjnbir".split("_"),monthsShort:"innayr_brÃ‹Â¤ayrÃ‹Â¤_marÃ‹Â¤sÃ‹Â¤_ibrir_mayyw_ywnyw_ywlywz_Ã‰Â£wÃ…Â¡t_Ã…Â¡wtanbir_ktÃ‹Â¤wbrÃ‹Â¤_nwwanbir_dwjnbir".split("_"),weekdays:"asamas_aynas_asinas_akras_akwas_asimwas_asiÃ¡Â¸Âyas".split("_"),weekdaysShort:"asamas_aynas_asinas_akras_akwas_asimwas_asiÃ¡Â¸Âyas".split("_"),weekdaysMin:"asamas_aynas_asinas_akras_akwas_asimwas_asiÃ¡Â¸Âyas".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[asdkh g] LT",nextDay:"[aska g] LT",nextWeek:"dddd [g] LT",lastDay:"[assant g] LT",lastWeek:"dddd [g] LT",sameElse:"L"},relativeTime:{future:"dadkh s yan %s",past:"yan %s",s:"imik",m:"minuÃ¡Â¸Â",mm:"%d minuÃ¡Â¸Â",h:"saÃ‰â€ºa",hh:"%d tassaÃ‰â€ºin",d:"ass",dd:"%d ossan",M:"ayowr",MM:"%d iyyirn",y:"asgas",yy:"%d isgasn"},week:{dow:6,// Saturday is the first day of the week.
doy:12}}),kg.defineLocale("tzm",{months:"Ã¢Âµâ€°Ã¢ÂµÂÃ¢ÂµÂÃ¢Â´Â°Ã¢ÂµÂ¢Ã¢Âµâ€_Ã¢Â´Â±Ã¢Âµâ€¢Ã¢Â´Â°Ã¢ÂµÂ¢Ã¢Âµâ€¢_Ã¢ÂµÅ½Ã¢Â´Â°Ã¢Âµâ€¢Ã¢ÂµÅ¡_Ã¢Âµâ€°Ã¢Â´Â±Ã¢Âµâ€Ã¢Âµâ€°Ã¢Âµâ€_Ã¢ÂµÅ½Ã¢Â´Â°Ã¢ÂµÂ¢Ã¢ÂµÂ¢Ã¢Âµâ€œ_Ã¢ÂµÂ¢Ã¢Âµâ€œÃ¢ÂµÂÃ¢ÂµÂ¢Ã¢Âµâ€œ_Ã¢ÂµÂ¢Ã¢Âµâ€œÃ¢ÂµÂÃ¢ÂµÂ¢Ã¢Âµâ€œÃ¢ÂµÂ£_Ã¢Âµâ€“Ã¢Âµâ€œÃ¢Âµâ€ºÃ¢ÂµÅ“_Ã¢Âµâ€ºÃ¢Âµâ€œÃ¢ÂµÅ“Ã¢Â´Â°Ã¢ÂµÂÃ¢Â´Â±Ã¢Âµâ€°Ã¢Âµâ€_Ã¢Â´Â½Ã¢ÂµÅ¸Ã¢Âµâ€œÃ¢Â´Â±Ã¢Âµâ€¢_Ã¢ÂµÂÃ¢Âµâ€œÃ¢ÂµÂ¡Ã¢Â´Â°Ã¢ÂµÂÃ¢Â´Â±Ã¢Âµâ€°Ã¢Âµâ€_Ã¢Â´Â·Ã¢Âµâ€œÃ¢ÂµÅ Ã¢ÂµÂÃ¢Â´Â±Ã¢Âµâ€°Ã¢Âµâ€".split("_"),monthsShort:"Ã¢Âµâ€°Ã¢ÂµÂÃ¢ÂµÂÃ¢Â´Â°Ã¢ÂµÂ¢Ã¢Âµâ€_Ã¢Â´Â±Ã¢Âµâ€¢Ã¢Â´Â°Ã¢ÂµÂ¢Ã¢Âµâ€¢_Ã¢ÂµÅ½Ã¢Â´Â°Ã¢Âµâ€¢Ã¢ÂµÅ¡_Ã¢Âµâ€°Ã¢Â´Â±Ã¢Âµâ€Ã¢Âµâ€°Ã¢Âµâ€_Ã¢ÂµÅ½Ã¢Â´Â°Ã¢ÂµÂ¢Ã¢ÂµÂ¢Ã¢Âµâ€œ_Ã¢ÂµÂ¢Ã¢Âµâ€œÃ¢ÂµÂÃ¢ÂµÂ¢Ã¢Âµâ€œ_Ã¢ÂµÂ¢Ã¢Âµâ€œÃ¢ÂµÂÃ¢ÂµÂ¢Ã¢Âµâ€œÃ¢ÂµÂ£_Ã¢Âµâ€“Ã¢Âµâ€œÃ¢Âµâ€ºÃ¢ÂµÅ“_Ã¢Âµâ€ºÃ¢Âµâ€œÃ¢ÂµÅ“Ã¢Â´Â°Ã¢ÂµÂÃ¢Â´Â±Ã¢Âµâ€°Ã¢Âµâ€_Ã¢Â´Â½Ã¢ÂµÅ¸Ã¢Âµâ€œÃ¢Â´Â±Ã¢Âµâ€¢_Ã¢ÂµÂÃ¢Âµâ€œÃ¢ÂµÂ¡Ã¢Â´Â°Ã¢ÂµÂÃ¢Â´Â±Ã¢Âµâ€°Ã¢Âµâ€_Ã¢Â´Â·Ã¢Âµâ€œÃ¢ÂµÅ Ã¢ÂµÂÃ¢Â´Â±Ã¢Âµâ€°Ã¢Âµâ€".split("_"),weekdays:"Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Â´Â°Ã¢ÂµÅ½Ã¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢ÂµÂ¢Ã¢ÂµÂÃ¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Âµâ€°Ã¢ÂµÂÃ¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢Â´Â½Ã¢Âµâ€Ã¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢Â´Â½Ã¢ÂµÂ¡Ã¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Âµâ€°Ã¢ÂµÅ½Ã¢ÂµÂ¡Ã¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Âµâ€°Ã¢Â´Â¹Ã¢ÂµÂ¢Ã¢Â´Â°Ã¢Âµâ„¢".split("_"),weekdaysShort:"Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Â´Â°Ã¢ÂµÅ½Ã¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢ÂµÂ¢Ã¢ÂµÂÃ¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Âµâ€°Ã¢ÂµÂÃ¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢Â´Â½Ã¢Âµâ€Ã¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢Â´Â½Ã¢ÂµÂ¡Ã¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Âµâ€°Ã¢ÂµÅ½Ã¢ÂµÂ¡Ã¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Âµâ€°Ã¢Â´Â¹Ã¢ÂµÂ¢Ã¢Â´Â°Ã¢Âµâ„¢".split("_"),weekdaysMin:"Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Â´Â°Ã¢ÂµÅ½Ã¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢ÂµÂ¢Ã¢ÂµÂÃ¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Âµâ€°Ã¢ÂµÂÃ¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢Â´Â½Ã¢Âµâ€Ã¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢Â´Â½Ã¢ÂµÂ¡Ã¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Âµâ€°Ã¢ÂµÅ½Ã¢ÂµÂ¡Ã¢Â´Â°Ã¢Âµâ„¢_Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Âµâ€°Ã¢Â´Â¹Ã¢ÂµÂ¢Ã¢Â´Â°Ã¢Âµâ„¢".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Â´Â·Ã¢Âµâ€¦ Ã¢Â´Â´] LT",nextDay:"[Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Â´Â½Ã¢Â´Â° Ã¢Â´Â´] LT",nextWeek:"dddd [Ã¢Â´Â´] LT",lastDay:"[Ã¢Â´Â°Ã¢ÂµÅ¡Ã¢Â´Â°Ã¢ÂµÂÃ¢ÂµÅ“ Ã¢Â´Â´] LT",lastWeek:"dddd [Ã¢Â´Â´] LT",sameElse:"L"},relativeTime:{future:"Ã¢Â´Â·Ã¢Â´Â°Ã¢Â´Â·Ã¢Âµâ€¦ Ã¢Âµâ„¢ Ã¢ÂµÂ¢Ã¢Â´Â°Ã¢ÂµÂ %s",past:"Ã¢ÂµÂ¢Ã¢Â´Â°Ã¢ÂµÂ %s",s:"Ã¢Âµâ€°Ã¢ÂµÅ½Ã¢Âµâ€°Ã¢Â´Â½",m:"Ã¢ÂµÅ½Ã¢Âµâ€°Ã¢ÂµÂÃ¢Âµâ€œÃ¢Â´Âº",mm:"%d Ã¢ÂµÅ½Ã¢Âµâ€°Ã¢ÂµÂÃ¢Âµâ€œÃ¢Â´Âº",h:"Ã¢Âµâ„¢Ã¢Â´Â°Ã¢Âµâ€žÃ¢Â´Â°",hh:"%d Ã¢ÂµÅ“Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Âµâ„¢Ã¢Â´Â°Ã¢Âµâ€žÃ¢Âµâ€°Ã¢ÂµÂ",d:"Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Âµâ„¢",dd:"%d oÃ¢Âµâ„¢Ã¢Âµâ„¢Ã¢Â´Â°Ã¢ÂµÂ",M:"Ã¢Â´Â°Ã¢ÂµÂ¢oÃ¢Âµâ€œÃ¢Âµâ€",MM:"%d Ã¢Âµâ€°Ã¢ÂµÂ¢Ã¢ÂµÂ¢Ã¢Âµâ€°Ã¢Âµâ€Ã¢ÂµÂ",y:"Ã¢Â´Â°Ã¢Âµâ„¢Ã¢Â´Â³Ã¢Â´Â°Ã¢Âµâ„¢",yy:"%d Ã¢Âµâ€°Ã¢Âµâ„¢Ã¢Â´Â³Ã¢Â´Â°Ã¢Âµâ„¢Ã¢ÂµÂ"},week:{dow:6,// Saturday is the first day of the week.
doy:12}}),kg.defineLocale("uk",{months:{format:"Ã‘ÂÃ‘â€“Ã‘â€¡ÃÂ½Ã‘Â_ÃÂ»Ã‘Å½Ã‘â€šÃÂ¾ÃÂ³ÃÂ¾_ÃÂ±ÃÂµÃ‘â‚¬ÃÂµÃÂ·ÃÂ½Ã‘Â_ÃÂºÃÂ²Ã‘â€“Ã‘â€šÃÂ½Ã‘Â_Ã‘â€šÃ‘â‚¬ÃÂ°ÃÂ²ÃÂ½Ã‘Â_Ã‘â€¡ÃÂµÃ‘â‚¬ÃÂ²ÃÂ½Ã‘Â_ÃÂ»ÃÂ¸ÃÂ¿ÃÂ½Ã‘Â_Ã‘ÂÃÂµÃ‘â‚¬ÃÂ¿ÃÂ½Ã‘Â_ÃÂ²ÃÂµÃ‘â‚¬ÃÂµÃ‘ÂÃÂ½Ã‘Â_ÃÂ¶ÃÂ¾ÃÂ²Ã‘â€šÃÂ½Ã‘Â_ÃÂ»ÃÂ¸Ã‘ÂÃ‘â€šÃÂ¾ÃÂ¿ÃÂ°ÃÂ´ÃÂ°_ÃÂ³Ã‘â‚¬Ã‘Æ’ÃÂ´ÃÂ½Ã‘Â".split("_"),standalone:"Ã‘ÂÃ‘â€“Ã‘â€¡ÃÂµÃÂ½Ã‘Å’_ÃÂ»Ã‘Å½Ã‘â€šÃÂ¸ÃÂ¹_ÃÂ±ÃÂµÃ‘â‚¬ÃÂµÃÂ·ÃÂµÃÂ½Ã‘Å’_ÃÂºÃÂ²Ã‘â€“Ã‘â€šÃÂµÃÂ½Ã‘Å’_Ã‘â€šÃ‘â‚¬ÃÂ°ÃÂ²ÃÂµÃÂ½Ã‘Å’_Ã‘â€¡ÃÂµÃ‘â‚¬ÃÂ²ÃÂµÃÂ½Ã‘Å’_ÃÂ»ÃÂ¸ÃÂ¿ÃÂµÃÂ½Ã‘Å’_Ã‘ÂÃÂµÃ‘â‚¬ÃÂ¿ÃÂµÃÂ½Ã‘Å’_ÃÂ²ÃÂµÃ‘â‚¬ÃÂµÃ‘ÂÃÂµÃÂ½Ã‘Å’_ÃÂ¶ÃÂ¾ÃÂ²Ã‘â€šÃÂµÃÂ½Ã‘Å’_ÃÂ»ÃÂ¸Ã‘ÂÃ‘â€šÃÂ¾ÃÂ¿ÃÂ°ÃÂ´_ÃÂ³Ã‘â‚¬Ã‘Æ’ÃÂ´ÃÂµÃÂ½Ã‘Å’".split("_")},monthsShort:"Ã‘ÂÃ‘â€“Ã‘â€¡_ÃÂ»Ã‘Å½Ã‘â€š_ÃÂ±ÃÂµÃ‘â‚¬_ÃÂºÃÂ²Ã‘â€“Ã‘â€š_Ã‘â€šÃ‘â‚¬ÃÂ°ÃÂ²_Ã‘â€¡ÃÂµÃ‘â‚¬ÃÂ²_ÃÂ»ÃÂ¸ÃÂ¿_Ã‘ÂÃÂµÃ‘â‚¬ÃÂ¿_ÃÂ²ÃÂµÃ‘â‚¬_ÃÂ¶ÃÂ¾ÃÂ²Ã‘â€š_ÃÂ»ÃÂ¸Ã‘ÂÃ‘â€š_ÃÂ³Ã‘â‚¬Ã‘Æ’ÃÂ´".split("_"),weekdays:he,weekdaysShort:"ÃÂ½ÃÂ´_ÃÂ¿ÃÂ½_ÃÂ²Ã‘â€š_Ã‘ÂÃ‘â‚¬_Ã‘â€¡Ã‘â€š_ÃÂ¿Ã‘â€š_Ã‘ÂÃÂ±".split("_"),weekdaysMin:"ÃÂ½ÃÂ´_ÃÂ¿ÃÂ½_ÃÂ²Ã‘â€š_Ã‘ÂÃ‘â‚¬_Ã‘â€¡Ã‘â€š_ÃÂ¿Ã‘â€š_Ã‘ÂÃÂ±".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY Ã‘â‚¬.",LLL:"D MMMM YYYY Ã‘â‚¬., HH:mm",LLLL:"dddd, D MMMM YYYY Ã‘â‚¬., HH:mm"},calendar:{sameDay:ie("[ÃÂ¡Ã‘Å’ÃÂ¾ÃÂ³ÃÂ¾ÃÂ´ÃÂ½Ã‘â€“ "),nextDay:ie("[Ãâ€”ÃÂ°ÃÂ²Ã‘â€šÃ‘â‚¬ÃÂ° "),lastDay:ie("[Ãâ€™Ã‘â€¡ÃÂ¾Ã‘â‚¬ÃÂ° "),nextWeek:ie("[ÃÂ£] dddd ["),lastWeek:function(){switch(this.day()){case 0:case 3:case 5:case 6:return ie("[ÃÅ“ÃÂ¸ÃÂ½Ã‘Æ’ÃÂ»ÃÂ¾Ã‘â€”] dddd [").call(this);case 1:case 2:case 4:return ie("[ÃÅ“ÃÂ¸ÃÂ½Ã‘Æ’ÃÂ»ÃÂ¾ÃÂ³ÃÂ¾] dddd [").call(this)}},sameElse:"L"},relativeTime:{future:"ÃÂ·ÃÂ° %s",past:"%s Ã‘â€šÃÂ¾ÃÂ¼Ã‘Æ’",s:"ÃÂ´ÃÂµÃÂºÃ‘â€“ÃÂ»Ã‘Å’ÃÂºÃÂ° Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´",m:ge,mm:ge,h:"ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’",hh:ge,d:"ÃÂ´ÃÂµÃÂ½Ã‘Å’",dd:ge,M:"ÃÂ¼Ã‘â€“Ã‘ÂÃ‘ÂÃ‘â€ Ã‘Å’",MM:ge,y:"Ã‘â‚¬Ã‘â€“ÃÂº",yy:ge},
// M. E.: those two are virtually unused but a user might want to implement them for his/her website for some reason
meridiemParse:/ÃÂ½ÃÂ¾Ã‘â€¡Ã‘â€“|Ã‘â‚¬ÃÂ°ÃÂ½ÃÂºÃ‘Æ’|ÃÂ´ÃÂ½Ã‘Â|ÃÂ²ÃÂµÃ‘â€¡ÃÂ¾Ã‘â‚¬ÃÂ°/,isPM:function(a){return/^(ÃÂ´ÃÂ½Ã‘Â|ÃÂ²ÃÂµÃ‘â€¡ÃÂ¾Ã‘â‚¬ÃÂ°)$/.test(a)},meridiem:function(a,b,c){return 4>a?"ÃÂ½ÃÂ¾Ã‘â€¡Ã‘â€“":12>a?"Ã‘â‚¬ÃÂ°ÃÂ½ÃÂºÃ‘Æ’":17>a?"ÃÂ´ÃÂ½Ã‘Â":"ÃÂ²ÃÂµÃ‘â€¡ÃÂ¾Ã‘â‚¬ÃÂ°"},ordinalParse:/\d{1,2}-(ÃÂ¹|ÃÂ³ÃÂ¾)/,ordinal:function(a,b){switch(b){case"M":case"d":case"DDD":case"w":case"W":return a+"-ÃÂ¹";case"D":return a+"-ÃÂ³ÃÂ¾";default:return a}},week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("uz",{months:"Ã‘ÂÃÂ½ÃÂ²ÃÂ°Ã‘â‚¬_Ã‘â€žÃÂµÃÂ²Ã‘â‚¬ÃÂ°ÃÂ»_ÃÂ¼ÃÂ°Ã‘â‚¬Ã‘â€š_ÃÂ°ÃÂ¿Ã‘â‚¬ÃÂµÃÂ»_ÃÂ¼ÃÂ°ÃÂ¹_ÃÂ¸Ã‘Å½ÃÂ½_ÃÂ¸Ã‘Å½ÃÂ»_ÃÂ°ÃÂ²ÃÂ³Ã‘Æ’Ã‘ÂÃ‘â€š_Ã‘ÂÃÂµÃÂ½Ã‘â€šÃ‘ÂÃÂ±Ã‘â‚¬_ÃÂ¾ÃÂºÃ‘â€šÃ‘ÂÃÂ±Ã‘â‚¬_ÃÂ½ÃÂ¾Ã‘ÂÃÂ±Ã‘â‚¬_ÃÂ´ÃÂµÃÂºÃÂ°ÃÂ±Ã‘â‚¬".split("_"),monthsShort:"Ã‘ÂÃÂ½ÃÂ²_Ã‘â€žÃÂµÃÂ²_ÃÂ¼ÃÂ°Ã‘â‚¬_ÃÂ°ÃÂ¿Ã‘â‚¬_ÃÂ¼ÃÂ°ÃÂ¹_ÃÂ¸Ã‘Å½ÃÂ½_ÃÂ¸Ã‘Å½ÃÂ»_ÃÂ°ÃÂ²ÃÂ³_Ã‘ÂÃÂµÃÂ½_ÃÂ¾ÃÂºÃ‘â€š_ÃÂ½ÃÂ¾Ã‘Â_ÃÂ´ÃÂµÃÂº".split("_"),weekdays:"ÃÂ¯ÃÂºÃ‘Ë†ÃÂ°ÃÂ½ÃÂ±ÃÂ°_Ãâ€Ã‘Æ’Ã‘Ë†ÃÂ°ÃÂ½ÃÂ±ÃÂ°_ÃÂ¡ÃÂµÃ‘Ë†ÃÂ°ÃÂ½ÃÂ±ÃÂ°_ÃÂ§ÃÂ¾Ã‘â‚¬Ã‘Ë†ÃÂ°ÃÂ½ÃÂ±ÃÂ°_ÃÅ¸ÃÂ°ÃÂ¹Ã‘Ë†ÃÂ°ÃÂ½ÃÂ±ÃÂ°_Ãâ€“Ã‘Æ’ÃÂ¼ÃÂ°_ÃÂ¨ÃÂ°ÃÂ½ÃÂ±ÃÂ°".split("_"),weekdaysShort:"ÃÂ¯ÃÂºÃ‘Ë†_Ãâ€Ã‘Æ’Ã‘Ë†_ÃÂ¡ÃÂµÃ‘Ë†_ÃÂ§ÃÂ¾Ã‘â‚¬_ÃÅ¸ÃÂ°ÃÂ¹_Ãâ€“Ã‘Æ’ÃÂ¼_ÃÂ¨ÃÂ°ÃÂ½".split("_"),weekdaysMin:"ÃÂ¯ÃÂº_Ãâ€Ã‘Æ’_ÃÂ¡ÃÂµ_ÃÂ§ÃÂ¾_ÃÅ¸ÃÂ°_Ãâ€“Ã‘Æ’_ÃÂ¨ÃÂ°".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"D MMMM YYYY, dddd HH:mm"},calendar:{sameDay:"[Ãâ€˜Ã‘Æ’ÃÂ³Ã‘Æ’ÃÂ½ Ã‘ÂÃÂ¾ÃÂ°Ã‘â€š] LT [ÃÂ´ÃÂ°]",nextDay:"[ÃÂ­Ã‘â‚¬Ã‘â€šÃÂ°ÃÂ³ÃÂ°] LT [ÃÂ´ÃÂ°]",nextWeek:"dddd [ÃÂºÃ‘Æ’ÃÂ½ÃÂ¸ Ã‘ÂÃÂ¾ÃÂ°Ã‘â€š] LT [ÃÂ´ÃÂ°]",lastDay:"[ÃÅ¡ÃÂµÃ‘â€¡ÃÂ° Ã‘ÂÃÂ¾ÃÂ°Ã‘â€š] LT [ÃÂ´ÃÂ°]",lastWeek:"[ÃÂ£Ã‘â€šÃÂ³ÃÂ°ÃÂ½] dddd [ÃÂºÃ‘Æ’ÃÂ½ÃÂ¸ Ã‘ÂÃÂ¾ÃÂ°Ã‘â€š] LT [ÃÂ´ÃÂ°]",sameElse:"L"},relativeTime:{future:"ÃÂ¯ÃÂºÃÂ¸ÃÂ½ %s ÃÂ¸Ã‘â€¡ÃÂ¸ÃÂ´ÃÂ°",past:"Ãâ€˜ÃÂ¸Ã‘â‚¬ ÃÂ½ÃÂµÃ‘â€¡ÃÂ° %s ÃÂ¾ÃÂ»ÃÂ´ÃÂ¸ÃÂ½",s:"Ã‘â€žÃ‘Æ’Ã‘â‚¬Ã‘ÂÃÂ°Ã‘â€š",m:"ÃÂ±ÃÂ¸Ã‘â‚¬ ÃÂ´ÃÂ°ÃÂºÃÂ¸ÃÂºÃÂ°",mm:"%d ÃÂ´ÃÂ°ÃÂºÃÂ¸ÃÂºÃÂ°",h:"ÃÂ±ÃÂ¸Ã‘â‚¬ Ã‘ÂÃÂ¾ÃÂ°Ã‘â€š",hh:"%d Ã‘ÂÃÂ¾ÃÂ°Ã‘â€š",d:"ÃÂ±ÃÂ¸Ã‘â‚¬ ÃÂºÃ‘Æ’ÃÂ½",dd:"%d ÃÂºÃ‘Æ’ÃÂ½",M:"ÃÂ±ÃÂ¸Ã‘â‚¬ ÃÂ¾ÃÂ¹",MM:"%d ÃÂ¾ÃÂ¹",y:"ÃÂ±ÃÂ¸Ã‘â‚¬ ÃÂ¹ÃÂ¸ÃÂ»",yy:"%d ÃÂ¹ÃÂ¸ÃÂ»"},week:{dow:1,// Monday is the first day of the week.
doy:7}}),kg.defineLocale("vi",{months:"thÃƒÂ¡ng 1_thÃƒÂ¡ng 2_thÃƒÂ¡ng 3_thÃƒÂ¡ng 4_thÃƒÂ¡ng 5_thÃƒÂ¡ng 6_thÃƒÂ¡ng 7_thÃƒÂ¡ng 8_thÃƒÂ¡ng 9_thÃƒÂ¡ng 10_thÃƒÂ¡ng 11_thÃƒÂ¡ng 12".split("_"),monthsShort:"Th01_Th02_Th03_Th04_Th05_Th06_Th07_Th08_Th09_Th10_Th11_Th12".split("_"),monthsParseExact:!0,weekdays:"chÃ¡Â»Â§ nhÃ¡ÂºÂ­t_thÃ¡Â»Â© hai_thÃ¡Â»Â© ba_thÃ¡Â»Â© tÃ†Â°_thÃ¡Â»Â© nÃ„Æ’m_thÃ¡Â»Â© sÃƒÂ¡u_thÃ¡Â»Â© bÃ¡ÂºÂ£y".split("_"),weekdaysShort:"CN_T2_T3_T4_T5_T6_T7".split("_"),weekdaysMin:"CN_T2_T3_T4_T5_T6_T7".split("_"),weekdaysParseExact:!0,meridiemParse:/sa|ch/i,isPM:function(a){return/^ch$/i.test(a)},meridiem:function(a,b,c){return 12>a?c?"sa":"SA":c?"ch":"CH"},longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM [nÃ„Æ’m] YYYY",LLL:"D MMMM [nÃ„Æ’m] YYYY HH:mm",LLLL:"dddd, D MMMM [nÃ„Æ’m] YYYY HH:mm",l:"DD/M/YYYY",ll:"D MMM YYYY",lll:"D MMM YYYY HH:mm",llll:"ddd, D MMM YYYY HH:mm"},calendar:{sameDay:"[HÃƒÂ´m nay lÃƒÂºc] LT",nextDay:"[NgÃƒ y mai lÃƒÂºc] LT",nextWeek:"dddd [tuÃ¡ÂºÂ§n tÃ¡Â»â€ºi lÃƒÂºc] LT",lastDay:"[HÃƒÂ´m qua lÃƒÂºc] LT",lastWeek:"dddd [tuÃ¡ÂºÂ§n rÃ¡Â»â€œi lÃƒÂºc] LT",sameElse:"L"},relativeTime:{future:"%s tÃ¡Â»â€ºi",past:"%s trÃ†Â°Ã¡Â»â€ºc",s:"vÃƒ i giÃƒÂ¢y",m:"mÃ¡Â»â„¢t phÃƒÂºt",mm:"%d phÃƒÂºt",h:"mÃ¡Â»â„¢t giÃ¡Â»Â",hh:"%d giÃ¡Â»Â",d:"mÃ¡Â»â„¢t ngÃƒ y",dd:"%d ngÃƒ y",M:"mÃ¡Â»â„¢t thÃƒÂ¡ng",MM:"%d thÃƒÂ¡ng",y:"mÃ¡Â»â„¢t nÃ„Æ’m",yy:"%d nÃ„Æ’m"},ordinalParse:/\d{1,2}/,ordinal:function(a){return a},week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("x-pseudo",{months:"J~ÃƒÂ¡ÃƒÂ±ÃƒÂºÃƒÂ¡~rÃƒÂ½_F~ÃƒÂ©brÃƒÂº~ÃƒÂ¡rÃƒÂ½_~MÃƒÂ¡rc~h_ÃƒÂp~rÃƒÂ­l_~MÃƒÂ¡ÃƒÂ½_~JÃƒÂºÃƒÂ±ÃƒÂ©~_JÃƒÂºl~ÃƒÂ½_ÃƒÂÃƒÂº~gÃƒÂºst~_SÃƒÂ©p~tÃƒÂ©mb~ÃƒÂ©r_Ãƒâ€œ~ctÃƒÂ³b~ÃƒÂ©r_Ãƒâ€˜~ÃƒÂ³vÃƒÂ©m~bÃƒÂ©r_~DÃƒÂ©cÃƒÂ©~mbÃƒÂ©r".split("_"),monthsShort:"J~ÃƒÂ¡ÃƒÂ±_~FÃƒÂ©b_~MÃƒÂ¡r_~ÃƒÂpr_~MÃƒÂ¡ÃƒÂ½_~JÃƒÂºÃƒÂ±_~JÃƒÂºl_~ÃƒÂÃƒÂºg_~SÃƒÂ©p_~Ãƒâ€œct_~Ãƒâ€˜ÃƒÂ³v_~DÃƒÂ©c".split("_"),monthsParseExact:!0,weekdays:"S~ÃƒÂºÃƒÂ±dÃƒÂ¡~ÃƒÂ½_MÃƒÂ³~ÃƒÂ±dÃƒÂ¡ÃƒÂ½~_TÃƒÂºÃƒÂ©~sdÃƒÂ¡ÃƒÂ½~_WÃƒÂ©d~ÃƒÂ±ÃƒÂ©sd~ÃƒÂ¡ÃƒÂ½_T~hÃƒÂºrs~dÃƒÂ¡ÃƒÂ½_~FrÃƒÂ­d~ÃƒÂ¡ÃƒÂ½_S~ÃƒÂ¡tÃƒÂºr~dÃƒÂ¡ÃƒÂ½".split("_"),weekdaysShort:"S~ÃƒÂºÃƒÂ±_~MÃƒÂ³ÃƒÂ±_~TÃƒÂºÃƒÂ©_~WÃƒÂ©d_~ThÃƒÂº_~FrÃƒÂ­_~SÃƒÂ¡t".split("_"),weekdaysMin:"S~ÃƒÂº_MÃƒÂ³~_TÃƒÂº_~WÃƒÂ©_T~h_Fr~_SÃƒÂ¡".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[T~ÃƒÂ³dÃƒÂ¡~ÃƒÂ½ ÃƒÂ¡t] LT",nextDay:"[T~ÃƒÂ³mÃƒÂ³~rrÃƒÂ³~w ÃƒÂ¡t] LT",nextWeek:"dddd [ÃƒÂ¡t] LT",lastDay:"[ÃƒÂ~ÃƒÂ©st~ÃƒÂ©rdÃƒÂ¡~ÃƒÂ½ ÃƒÂ¡t] LT",lastWeek:"[L~ÃƒÂ¡st] dddd [ÃƒÂ¡t] LT",sameElse:"L"},relativeTime:{future:"ÃƒÂ­~ÃƒÂ± %s",past:"%s ÃƒÂ¡~gÃƒÂ³",s:"ÃƒÂ¡ ~fÃƒÂ©w ~sÃƒÂ©cÃƒÂ³~ÃƒÂ±ds",m:"ÃƒÂ¡ ~mÃƒÂ­ÃƒÂ±~ÃƒÂºtÃƒÂ©",mm:"%d m~ÃƒÂ­ÃƒÂ±ÃƒÂº~tÃƒÂ©s",h:"ÃƒÂ¡~ÃƒÂ± hÃƒÂ³~ÃƒÂºr",hh:"%d h~ÃƒÂ³ÃƒÂºrs",d:"ÃƒÂ¡ ~dÃƒÂ¡ÃƒÂ½",dd:"%d d~ÃƒÂ¡ÃƒÂ½s",M:"ÃƒÂ¡ ~mÃƒÂ³ÃƒÂ±~th",MM:"%d m~ÃƒÂ³ÃƒÂ±t~hs",y:"ÃƒÂ¡ ~ÃƒÂ½ÃƒÂ©ÃƒÂ¡r",yy:"%d ÃƒÂ½~ÃƒÂ©ÃƒÂ¡rs"},ordinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(a){var b=a%10,c=1===~~(a%100/10)?"th":1===b?"st":2===b?"nd":3===b?"rd":"th";return a+c},week:{dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("zh-cn",{months:"Ã¤Â¸â‚¬Ã¦Å“Ë†_Ã¤ÂºÅ’Ã¦Å“Ë†_Ã¤Â¸â€°Ã¦Å“Ë†_Ã¥â€ºâ€ºÃ¦Å“Ë†_Ã¤Âºâ€Ã¦Å“Ë†_Ã¥â€¦Â­Ã¦Å“Ë†_Ã¤Â¸Æ’Ã¦Å“Ë†_Ã¥â€¦Â«Ã¦Å“Ë†_Ã¤Â¹ÂÃ¦Å“Ë†_Ã¥ÂÂÃ¦Å“Ë†_Ã¥ÂÂÃ¤Â¸â‚¬Ã¦Å“Ë†_Ã¥ÂÂÃ¤ÂºÅ’Ã¦Å“Ë†".split("_"),monthsShort:"1Ã¦Å“Ë†_2Ã¦Å“Ë†_3Ã¦Å“Ë†_4Ã¦Å“Ë†_5Ã¦Å“Ë†_6Ã¦Å“Ë†_7Ã¦Å“Ë†_8Ã¦Å“Ë†_9Ã¦Å“Ë†_10Ã¦Å“Ë†_11Ã¦Å“Ë†_12Ã¦Å“Ë†".split("_"),weekdays:"Ã¦ËœÅ¸Ã¦Å“Å¸Ã¦â€”Â¥_Ã¦ËœÅ¸Ã¦Å“Å¸Ã¤Â¸â‚¬_Ã¦ËœÅ¸Ã¦Å“Å¸Ã¤ÂºÅ’_Ã¦ËœÅ¸Ã¦Å“Å¸Ã¤Â¸â€°_Ã¦ËœÅ¸Ã¦Å“Å¸Ã¥â€ºâ€º_Ã¦ËœÅ¸Ã¦Å“Å¸Ã¤Âºâ€_Ã¦ËœÅ¸Ã¦Å“Å¸Ã¥â€¦Â­".split("_"),weekdaysShort:"Ã¥â€˜Â¨Ã¦â€”Â¥_Ã¥â€˜Â¨Ã¤Â¸â‚¬_Ã¥â€˜Â¨Ã¤ÂºÅ’_Ã¥â€˜Â¨Ã¤Â¸â€°_Ã¥â€˜Â¨Ã¥â€ºâ€º_Ã¥â€˜Â¨Ã¤Âºâ€_Ã¥â€˜Â¨Ã¥â€¦Â­".split("_"),weekdaysMin:"Ã¦â€”Â¥_Ã¤Â¸â‚¬_Ã¤ÂºÅ’_Ã¤Â¸â€°_Ã¥â€ºâ€º_Ã¤Âºâ€_Ã¥â€¦Â­".split("_"),longDateFormat:{LT:"AhÃ§â€šÂ¹mmÃ¥Ë†â€ ",LTS:"AhÃ§â€šÂ¹mÃ¥Ë†â€ sÃ§Â§â€™",L:"YYYY-MM-DD",LL:"YYYYÃ¥Â¹Â´MMMDÃ¦â€”Â¥",LLL:"YYYYÃ¥Â¹Â´MMMDÃ¦â€”Â¥AhÃ§â€šÂ¹mmÃ¥Ë†â€ ",LLLL:"YYYYÃ¥Â¹Â´MMMDÃ¦â€”Â¥ddddAhÃ§â€šÂ¹mmÃ¥Ë†â€ ",l:"YYYY-MM-DD",ll:"YYYYÃ¥Â¹Â´MMMDÃ¦â€”Â¥",lll:"YYYYÃ¥Â¹Â´MMMDÃ¦â€”Â¥AhÃ§â€šÂ¹mmÃ¥Ë†â€ ",llll:"YYYYÃ¥Â¹Â´MMMDÃ¦â€”Â¥ddddAhÃ§â€šÂ¹mmÃ¥Ë†â€ "},meridiemParse:/Ã¥â€¡Å’Ã¦â„¢Â¨|Ã¦â€”Â©Ã¤Â¸Å |Ã¤Â¸Å Ã¥ÂË†|Ã¤Â¸Â­Ã¥ÂË†|Ã¤Â¸â€¹Ã¥ÂË†|Ã¦â„¢Å¡Ã¤Â¸Å /,meridiemHour:function(a,b){return 12===a&&(a=0),"Ã¥â€¡Å’Ã¦â„¢Â¨"===b||"Ã¦â€”Â©Ã¤Â¸Å "===b||"Ã¤Â¸Å Ã¥ÂË†"===b?a:"Ã¤Â¸â€¹Ã¥ÂË†"===b||"Ã¦â„¢Å¡Ã¤Â¸Å "===b?a+12:a>=11?a:a+12},meridiem:function(a,b,c){var d=100*a+b;return 600>d?"Ã¥â€¡Å’Ã¦â„¢Â¨":900>d?"Ã¦â€”Â©Ã¤Â¸Å ":1130>d?"Ã¤Â¸Å Ã¥ÂË†":1230>d?"Ã¤Â¸Â­Ã¥ÂË†":1800>d?"Ã¤Â¸â€¹Ã¥ÂË†":"Ã¦â„¢Å¡Ã¤Â¸Å "},calendar:{sameDay:function(){return 0===this.minutes()?"[Ã¤Â»Å Ã¥Â¤Â©]Ah[Ã§â€šÂ¹Ã¦â€¢Â´]":"[Ã¤Â»Å Ã¥Â¤Â©]LT"},nextDay:function(){return 0===this.minutes()?"[Ã¦ËœÅ½Ã¥Â¤Â©]Ah[Ã§â€šÂ¹Ã¦â€¢Â´]":"[Ã¦ËœÅ½Ã¥Â¤Â©]LT"},lastDay:function(){return 0===this.minutes()?"[Ã¦ËœÂ¨Ã¥Â¤Â©]Ah[Ã§â€šÂ¹Ã¦â€¢Â´]":"[Ã¦ËœÂ¨Ã¥Â¤Â©]LT"},nextWeek:function(){var a,b;return a=kg().startOf("week"),b=this.diff(a,"days")>=7?"[Ã¤Â¸â€¹]":"[Ã¦Å“Â¬]",0===this.minutes()?b+"dddAhÃ§â€šÂ¹Ã¦â€¢Â´":b+"dddAhÃ§â€šÂ¹mm"},lastWeek:function(){var a,b;return a=kg().startOf("week"),b=this.unix()<a.unix()?"[Ã¤Â¸Å ]":"[Ã¦Å“Â¬]",0===this.minutes()?b+"dddAhÃ§â€šÂ¹Ã¦â€¢Â´":b+"dddAhÃ§â€šÂ¹mm"},sameElse:"LL"},ordinalParse:/\d{1,2}(Ã¦â€”Â¥|Ã¦Å“Ë†|Ã¥â€˜Â¨)/,ordinal:function(a,b){switch(b){case"d":case"D":case"DDD":return a+"Ã¦â€”Â¥";case"M":return a+"Ã¦Å“Ë†";case"w":case"W":return a+"Ã¥â€˜Â¨";default:return a}},relativeTime:{future:"%sÃ¥â€ â€¦",past:"%sÃ¥â€°Â",s:"Ã¥â€¡ Ã§Â§â€™",m:"1 Ã¥Ë†â€ Ã©â€™Å¸",mm:"%d Ã¥Ë†â€ Ã©â€™Å¸",h:"1 Ã¥Â°ÂÃ¦â€”Â¶",hh:"%d Ã¥Â°ÂÃ¦â€”Â¶",d:"1 Ã¥Â¤Â©",dd:"%d Ã¥Â¤Â©",M:"1 Ã¤Â¸ÂªÃ¦Å“Ë†",MM:"%d Ã¤Â¸ÂªÃ¦Å“Ë†",y:"1 Ã¥Â¹Â´",yy:"%d Ã¥Â¹Â´"},week:{
// GB/T 7408-1994Ã£â‚¬Å Ã¦â€¢Â°Ã¦ÂÂ®Ã¥â€¦Æ’Ã¥â€™Å’Ã¤ÂºÂ¤Ã¦ÂÂ¢Ã¦ Â¼Ã¥Â¼ÂÃ‚Â·Ã¤Â¿Â¡Ã¦ÂÂ¯Ã¤ÂºÂ¤Ã¦ÂÂ¢Ã‚Â·Ã¦â€”Â¥Ã¦Å“Å¸Ã¥â€™Å’Ã¦â€”Â¶Ã©â€”Â´Ã¨Â¡Â¨Ã§Â¤ÂºÃ¦Â³â€¢Ã£â‚¬â€¹Ã¤Â¸Å½ISO 8601:1988Ã§Â­â€°Ã¦â€¢Ë†
dow:1,// Monday is the first day of the week.
doy:4}}),kg.defineLocale("zh-tw",{months:"Ã¤Â¸â‚¬Ã¦Å“Ë†_Ã¤ÂºÅ’Ã¦Å“Ë†_Ã¤Â¸â€°Ã¦Å“Ë†_Ã¥â€ºâ€ºÃ¦Å“Ë†_Ã¤Âºâ€Ã¦Å“Ë†_Ã¥â€¦Â­Ã¦Å“Ë†_Ã¤Â¸Æ’Ã¦Å“Ë†_Ã¥â€¦Â«Ã¦Å“Ë†_Ã¤Â¹ÂÃ¦Å“Ë†_Ã¥ÂÂÃ¦Å“Ë†_Ã¥ÂÂÃ¤Â¸â‚¬Ã¦Å“Ë†_Ã¥ÂÂÃ¤ÂºÅ’Ã¦Å“Ë†".split("_"),monthsShort:"1Ã¦Å“Ë†_2Ã¦Å“Ë†_3Ã¦Å“Ë†_4Ã¦Å“Ë†_5Ã¦Å“Ë†_6Ã¦Å“Ë†_7Ã¦Å“Ë†_8Ã¦Å“Ë†_9Ã¦Å“Ë†_10Ã¦Å“Ë†_11Ã¦Å“Ë†_12Ã¦Å“Ë†".split("_"),weekdays:"Ã¦ËœÅ¸Ã¦Å“Å¸Ã¦â€”Â¥_Ã¦ËœÅ¸Ã¦Å“Å¸Ã¤Â¸â‚¬_Ã¦ËœÅ¸Ã¦Å“Å¸Ã¤ÂºÅ’_Ã¦ËœÅ¸Ã¦Å“Å¸Ã¤Â¸â€°_Ã¦ËœÅ¸Ã¦Å“Å¸Ã¥â€ºâ€º_Ã¦ËœÅ¸Ã¦Å“Å¸Ã¤Âºâ€_Ã¦ËœÅ¸Ã¦Å“Å¸Ã¥â€¦Â­".split("_"),weekdaysShort:"Ã©â‚¬Â±Ã¦â€”Â¥_Ã©â‚¬Â±Ã¤Â¸â‚¬_Ã©â‚¬Â±Ã¤ÂºÅ’_Ã©â‚¬Â±Ã¤Â¸â€°_Ã©â‚¬Â±Ã¥â€ºâ€º_Ã©â‚¬Â±Ã¤Âºâ€_Ã©â‚¬Â±Ã¥â€¦Â­".split("_"),weekdaysMin:"Ã¦â€”Â¥_Ã¤Â¸â‚¬_Ã¤ÂºÅ’_Ã¤Â¸â€°_Ã¥â€ºâ€º_Ã¤Âºâ€_Ã¥â€¦Â­".split("_"),longDateFormat:{LT:"AhÃ©Â»Å¾mmÃ¥Ë†â€ ",LTS:"AhÃ©Â»Å¾mÃ¥Ë†â€ sÃ§Â§â€™",L:"YYYYÃ¥Â¹Â´MMMDÃ¦â€”Â¥",LL:"YYYYÃ¥Â¹Â´MMMDÃ¦â€”Â¥",LLL:"YYYYÃ¥Â¹Â´MMMDÃ¦â€”Â¥AhÃ©Â»Å¾mmÃ¥Ë†â€ ",LLLL:"YYYYÃ¥Â¹Â´MMMDÃ¦â€”Â¥ddddAhÃ©Â»Å¾mmÃ¥Ë†â€ ",l:"YYYYÃ¥Â¹Â´MMMDÃ¦â€”Â¥",ll:"YYYYÃ¥Â¹Â´MMMDÃ¦â€”Â¥",lll:"YYYYÃ¥Â¹Â´MMMDÃ¦â€”Â¥AhÃ©Â»Å¾mmÃ¥Ë†â€ ",llll:"YYYYÃ¥Â¹Â´MMMDÃ¦â€”Â¥ddddAhÃ©Â»Å¾mmÃ¥Ë†â€ "},meridiemParse:/Ã¥â€¡Å’Ã¦â„¢Â¨|Ã¦â€”Â©Ã¤Â¸Å |Ã¤Â¸Å Ã¥ÂË†|Ã¤Â¸Â­Ã¥ÂË†|Ã¤Â¸â€¹Ã¥ÂË†|Ã¦â„¢Å¡Ã¤Â¸Å /,meridiemHour:function(a,b){return 12===a&&(a=0),"Ã¥â€¡Å’Ã¦â„¢Â¨"===b||"Ã¦â€”Â©Ã¤Â¸Å "===b||"Ã¤Â¸Å Ã¥ÂË†"===b?a:"Ã¤Â¸Â­Ã¥ÂË†"===b?a>=11?a:a+12:"Ã¤Â¸â€¹Ã¥ÂË†"===b||"Ã¦â„¢Å¡Ã¤Â¸Å "===b?a+12:void 0},meridiem:function(a,b,c){var d=100*a+b;return 600>d?"Ã¥â€¡Å’Ã¦â„¢Â¨":900>d?"Ã¦â€”Â©Ã¤Â¸Å ":1130>d?"Ã¤Â¸Å Ã¥ÂË†":1230>d?"Ã¤Â¸Â­Ã¥ÂË†":1800>d?"Ã¤Â¸â€¹Ã¥ÂË†":"Ã¦â„¢Å¡Ã¤Â¸Å "},calendar:{sameDay:"[Ã¤Â»Å Ã¥Â¤Â©]LT",nextDay:"[Ã¦ËœÅ½Ã¥Â¤Â©]LT",nextWeek:"[Ã¤Â¸â€¹]ddddLT",lastDay:"[Ã¦ËœÂ¨Ã¥Â¤Â©]LT",lastWeek:"[Ã¤Â¸Å ]ddddLT",sameElse:"L"},ordinalParse:/\d{1,2}(Ã¦â€”Â¥|Ã¦Å“Ë†|Ã©â‚¬Â±)/,ordinal:function(a,b){switch(b){case"d":case"D":case"DDD":return a+"Ã¦â€”Â¥";case"M":return a+"Ã¦Å“Ë†";case"w":case"W":return a+"Ã©â‚¬Â±";default:return a}},relativeTime:{future:"%sÃ¥â€¦Â§",past:"%sÃ¥â€°Â",s:"Ã¥Â¹Â¾Ã§Â§â€™",m:"1 Ã¥Ë†â€ Ã©ÂËœ",mm:"%d Ã¥Ë†â€ Ã©ÂËœ",h:"1 Ã¥Â°ÂÃ¦â„¢â€š",hh:"%d Ã¥Â°ÂÃ¦â„¢â€š",d:"1 Ã¥Â¤Â©",dd:"%d Ã¥Â¤Â©",M:"1 Ã¥â‚¬â€¹Ã¦Å“Ë†",MM:"%d Ã¥â‚¬â€¹Ã¦Å“Ë†",y:"1 Ã¥Â¹Â´",yy:"%d Ã¥Â¹Â´"}}),kg);return sh.locale("en"),sh});