
// Function to get query parameter by name
function getQueryParam(name) {
    const urlParams = new URLSearchParams(window.location.search);
    return urlParams.get(name);
}

// Get the optician_id from the current URL's query parameter
const opticianId = getQueryParam('OpticianId');
const shop = getQueryParam('Shop');

function generateValenderEvent(slot) {
    // Create a Date object from the given string
    var startDate = new Date(slot.date +' '+ slot.start_time+":00");
    // var startDate = new Date(slot.date);

    // Set the start time to 00:00:00
    // startDate.setHours(0, 0, 0, 0);

    // Create a copy of the start date for the end date
    var endDate = new Date(slot.date +' '+ slot.end_time+":00");
    // var endDate = new Date(startDate);
    // endDate.setDate(endDate.getDate() + 1);


    // Format the dates as strings
    var startFormatted = formatDate(startDate);
    var endFormatted = formatDate(endDate);
    // var startFormatted = startDate;
    // var endFormatted = endDate;

    // Return the result
    return {
        id:startFormatted,
        start: startFormatted,
        end: endFormatted,
        display: 'background',
        rendering:'background',
        // color: '#ff9f89',
        // backgroundColor: '#ff9f89',
        allDay: true,
    };
}

// Function to format a Date object as 'YYYY-MM-DDTHH:mm:ss'
function formatDate(date) {
    var year = date.getFullYear();
    var month = padZero(date.getMonth() + 1);
    var day = padZero(date.getDate());
    var hours = padZero(date.getHours());
    var minutes = padZero(date.getMinutes());
    var seconds = padZero(date.getSeconds());

    return `${year}-${month}-${day}T${hours}:${minutes}:${seconds}`;
}

// Function to pad a single-digit number with a leading zero
function padZero(num) {
    return num < 10 ? '0' + num : num;
}