<?php
require_once( __DIR__. '/../lib/nusoap.php');
require_once( __DIR__.'/SiteInfo.php');
require_once( __DIR__.'/AppointmentTypes.php');
require_once( __DIR__.'/ShopInfo.php');
require_once( __DIR__.'/PractitionerInfo.php');
require_once( __DIR__.'/AppointmentSlotDetails.php');
require_once( __DIR__.'/AppointmentDetails.php');

class MyOpticianWsdlService {

    private $soap_client;
    //http://87.127.13.154:899/DiaryWebService.svc
    //http://87.127.13.154:899/DiaryWebService.svc
    private $service_host;
    private $optician_id;

    public function __construct($service_host, $optician_id)
    {
        $this->service_host = $service_host;
        $this->soap_client = new nusoap_client($service_host,'wsdl');
	    $this->soap_client ->soap_defencoding = 'UTF-8';
        $this->optician_id = $optician_id;
    }

    public function getSiteInfo($optician_id, $password){
        $arg_params = array(
			'site'=>$optician_id,
			'password'=>$password
		);
		$result = $this->soap_client->call('GetSiteInfo',$arg_params);
        $siteInfo = new SiteInfo();
        $siteInfo->setAllFromStr($result['GetSiteInfoResult']);
        return $siteInfo;
    }

    public function getAppointmentTypes($site_id, $password){
        $arg_params = array(
			'site'=>$site_id,
			'password'=>$password
		);
		$result = $this->soap_client->call('GetAppointmentTypes',$arg_params);
        $typeInfo = explode('|',$result['GetAppointmentTypesResult']);
        $types = [];
        foreach ($typeInfo AS $type_name){
            if(empty($type_name))
                continue;
            $types[] = new AppointmentTypes($type_name);
        }
        
        return $types;
    }

    public function getShops($site_id, $password){
        $arg_params = array(
			'site'=>$site_id,
			'password'=>$password
		);
		$result = $this->soap_client->call('GetShops',$arg_params);
        $shopInfo = explode('|',$result['GetShopsResult']);
        $shops = [];
        foreach ($shopInfo AS $shop_details){
            if(empty($shop_details))
                continue;
            [$shop_name, $shop_address, $shop_phone] = explode(",", $shop_details);
            
            $shops[] = new ShopInfo($shop_name, $shop_address, $shop_phone);
        }
        return $shops;
    }

    public function getPractitioners($site_id, $password, $shop_name){
        $arg_params = array(
			'site'=>$site_id,
			'password'=>$password,
            'shop' => $shop_name
		);
		$result = $this->soap_client->call('GetPeople',$arg_params);
        $practitionerInfo = explode('|',$result['GetPeopleResult']);
        $practitioners = [];
        foreach ($practitionerInfo AS $name){
            if(empty($name))
                continue;
            $practitioners[] = new PractitionerInfo($name);
        }
        return $practitioners;

    }

    public function getAppointments($site_id, $password, $shop_name, $practitioner_name){
        $arg_params = array(
			'site'=>$site_id,
			'password'=>$password,
            'shop' => $shop_name,
            'practitioner' => $practitioner_name
		);
		$result = $this->soap_client->call('GetAppointments',$arg_params);
        $appointmentsSlotInfo = explode('|',$result['GetAppointmentsResult']);
        $appointmentSlots = [];
        foreach ($appointmentsSlotInfo AS $info){
            if(empty($info))
                continue;
            $appointmentSlot = new AppointmentSlotDetails();
            $appointmentSlot->setAllFromStr($info);
            $appointmentSlots[] = $appointmentSlot;
        }
        return $appointmentSlots;
    }

    public function postNewAppointment($site_id, $appointment_slot, AppointmentDetails $appointment, $shop_name){
        $arg_params = array(
			'site'=>$site_id,
			'appointment'=>$appointment_slot,
            'data' => $appointment->toString(),
            'shop' => $shop_name
        );
		$result = $this->soap_client->call('PostAppointment',$arg_params);
        error_log("Response of the Appointment booking: ". print_r($result, true));
        if(strtolower($result['PostAppointmentResult'])=='success')
            return true;
        else 
            return false;
    }
}
?>