<?php
require_once( __DIR__. '/common.php');
require_once(__DIR__."/my-optician-wsdl-service/MyOpticianWsdlService.php");
require_once(__DIR__."/my-optician-wsdl-service/GlobalLoader.php");
global $service_url, $optician_id, $shops, $opticianService, $siteInfo, $siteId, $practitioners, $slots;
if(!isset($opticianService)){
	$opticianService = new MyOpticianWsdlService($service_url, $optician_id);
}
if(!isset($optician_id)){
	$optician_id = $_GET['OpticianId'];
}
if(!isset($siteInfo)){
	$siteInfo = $opticianService->getSiteInfo($optician_id, $password);
	$siteId = $siteInfo->getSite();
	$password = $siteInfo->getPassword();
}
if(!isset($shops)){
	$shops = $opticianService->getShops($siteId, $password);
}
$shopName  = null;
if(isset($_GET['Shop'])){
	$shopName = $_GET['Shop'];
} else if(count($shops) == 1){
	$shopName = $shops[0]->getName();
} else {
	require_once 'error.php';
	exit(0);
}

$_POST['hidden_shop_name'] = $shopName;
$globalLoader = new GlobalLoader($optician_id);
$globalLoader->loadGlobalSelectedShop($siteInfo->getSite(), $siteInfo->getPassword());

if($shopName != null){
	$practitioners = $opticianService->getPractitioners($siteId, $password, $shopName);
	// $practitioners = [$practitioners[0]];
	if(count($practitioners) == 1){
		$slots = $opticianService->getAppointments($siteId, $password, $shopName, $practitioners[0]->getName());
	}
}



if($slots == null || count($slots) ==0){
	$slots = $opticianService->getAppointments($siteId, $password, $shopName , null);
}
$current_step = 2;
require_once __DIR__ . '/select-slots.php';
?>