<?php
global $service_url, $optician_id, $shops, $opticianService, $siteInfo, $siteId, $practitioners, $slots, $selected_shop;
require_once( __DIR__. '/common.php');
include_once(__DIR__."/my-optician-wsdl-service/MyOpticianWsdlService.php");
require_once(__DIR__."/my-optician-wsdl-service/GlobalLoader.php");

$current_step=3;
$appointment_slot = $_POST['hidden_appointment_slot'];

// Split the appointment details
list($date, $startTime, $endTime) = explode(" ", $appointment_slot);

$dateObj = DateTime::createFromFormat('d/m/Y', $date);
$startTimeObj = DateTime::createFromFormat('d/m/Y H:i', $date . ' ' . $startTime);
$endTimeObj = DateTime::createFromFormat('d/m/Y H:i', $date . ' ' . $endTime);

$optician_id = $_POST['hidden_optician_id'];
$shop = $_POST['hidden_shop_name'];
$prefered_staff = $_POST['hidden_preferred_staff'];
$practitioner_name = $_POST['hidden_practitioner_name'];

// print_r($_POST);

$opticianService = new MyOpticianWsdlService($service_url, $optician_id);
$siteInfo = $opticianService->getSiteInfo($optician_id, $password);
$globalLoader = new GlobalLoader($optician_id);
$globalLoader->loadGlobalSelectedShop($siteInfo->getSite(), $siteInfo->getPassword());

$appointment_types = $opticianService->getAppointmentTypes($siteInfo->getSite(), $siteInfo->getPassword());
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, maximum-scale=1, initial-scale=1, user-scalable=0">
    <meta name="keywords" content="">
    <meta name="description" content="">
    <meta name="author" content="">
    <title>myoptician</title>
    <!--Favicon -->
    <link rel="shortcut icon" type="image/png" href="images/favicon-icon.png" />
   
    <!--Main Stylesheet-->
    <link rel="stylesheet" type="text/css" href="css/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <link rel="stylesheet" type="text/css" href="css/responsive.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
</head>

<body>
<?php include_once(__DIR__ . '/header.php'); ?>

  <div class="thirdp">
    <div class="sitecontainer">
      <div class="thirdheading">
        <h5>Appointment Booking</h5>
        <div class="thirdinner">
          <div class="left">
            <div class="leftbox">              
              <form id="main-form" method="POST" action="appointment-submit.php">
              <input type="hidden" id="hidden_optician_id" name="hidden_optician_id" value="<?= $optician_id ?>"/>
              <input type="hidden" id="hidden_shop_name" name="hidden_shop_name" value="<?= $shop ?>"/>
              <input type="hidden" id="hidden_practitioner_name" name="hidden_practitioner_name" value="<?= $practitioner_name ?>"/>
              <input type="hidden" id="hidden_preferred_staff" name="hidden_preferred_staff" value="<?= $prefered_staff ?>"/>
              <input type="hidden" id="hidden_appointment_slot" name="hidden_appointment_slot" value="<?= $appointment_slot ?>"/>

                <div class="leftinner">
                  <div class="item">
                    <p>Personal Information</p>
                    <label for="appointment_type">Appointment Type*</label>
                    <select name="appointment_type" id="appointment_type" placeholder="Select an Appointment Type">
                      <option value="">Select an Appointment Type</option>
                      <?php
                      $count=0;
                      foreach($appointment_types AS $appointment_type){
                        $count++;
                        $type = $appointment_type->getName();
                        echo "<option value='$type'>$type</option>";
                      }
                      ?>
                    </select> 
                  </div>
                  <div class="item">
                    <label for="firstname">First Name*</label>
                    <input type="text" id="firstname" name="firstname" required />
                  </div>
                  <div class="item">
                    <label for="lastname">Last Name*</label>
                    <input type="text" id="lastname" name="lastname" required />
                  </div>
                  <div class="item">
                    <label for="email">Email Address*</label>
                    <input type="email" id="email" name="email" required email />
                  </div>
                  <div class="item">
                    <label for="mobile_number">Mobile Number</label>
                    <input type="text" id="mobile_number" name="mobile_number">
                  </div>
                  <div class="item">
                    <label for="dob">Date Of Birth</label>
                    <input type="date" id="dob" name="dob">
                  </div>
                  <div class="item">
                    <label for="postcode">Post Code</label>
                    <input type="text" id="postcode" name="postcode">
                  </div>
                  <div class="item1">
                    <label for="existing_patient">Existing Patient</label>
                    <input type="checkbox" id="existing_patient" name="existing_patient">
                  </div>
                  <div class="item">
                    <label for="comments">Comment</label>
                    <textarea rows="4" cols="50" maxlength="50" id="comments" name="comments"></textarea>
                  </div>
                </div>
                <input type="submit" style="display:none" />
              </form>
              
            </div>
          </div>
          <div class="right">            
            <div class="rightinner">
              <div class="box">
                <div class="itemlogo">
                  <img src="<?= $siteInfo->getOpticianLogo() ?>" alt="">
                </div>
                <div class="item">
                  <h6>Your Appomintment Details</h6>
                  <p><?= $dateObj->format('l, F j, Y') ?><br><span><?= $startTimeObj->format('g:i A') ?> - <?= $endTimeObj->format('g:i A') ?></span> </p>
                </div>
                <div class="item">
                  <h6><?= $selected_shop->getName() ?></h6>
                  <p><?= $selected_shop->getAddress() ?><br><span><?= $selected_shop->getPhone() ?></span></p>
                </div>
              </div>
              <div class="confirm">
                <a class="cbooking" href="javascript:void(0);" onclick="validateAndSubmit()">Confirm Booking</a>
              </div>
              <div class="backbtn">
                <a class="btnback" href="javascript:void(0);" onclick="history.back();">Back</a>
              </div>
            </div>
          </div>
          
        </div>
      </div>
    </div>
  </div>

  <script src="js/jquery-3.6.4.min.js"></script>
  <script src="js/jquery.validate-3.6.4.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
  <script>
    function validateAndSubmit(){
      console.log("Validating form");
      $("#main-form").submit();
    }
    $(document).ready(function () {
        $("#main-form").validate({
            rules: {
                appointment_type:{
                  required:true,
                },
                firstname: {
                    required: true,
                    // Add more validation rules as needed
                },
                lastname: {
                    required: true,
                    // Add more validation rules as needed
                },
                email: {
                    required: true,
                    email: true,
                },
                mobile_number: {
                    // Add validation rules for mobile number
                },
                dob: {
                    // Add validation rules for date of birth
                },
                postcode: {
                    // Add validation rules for postcode
                },
                // Add more rules for other form fields
            },
            messages: {
                appointment_type:{
                  required:"Please select valid appointment type",
                },
                firstname: {
                    required: "Please enter your first name",
                    // Add more custom messages as needed
                },
                lastname: {
                    required: "Please enter your last name",
                },
                email: {
                    required: "Please enter your email address",
                    email: "Please enter a valid email address",
                },
                mobile_number: {
                    // Add custom messages for mobile number
                },
                dob: {
                    // Add custom messages for date of birth
                },
                postcode: {
                    // Add custom messages for postcode
                },
                // Add more custom messages for other form fields
            },
        });
    });
</script>
<?php include_once(__DIR__ . '/footer.php'); ?>
</body>
</html>
